/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.stateproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import net.minecraft.world.level.levelgen.feature.stateproviders.NoiseBasedStateProvider;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class NoiseThresholdProvider
extends NoiseBasedStateProvider {
    public static final MapCodec<NoiseThresholdProvider> CODEC = RecordCodecBuilder.mapCodec(p_191486_ -> NoiseThresholdProvider.noiseCodec(p_191486_).and(p_191486_.group((App)Codec.floatRange((float)-1.0f, (float)1.0f).fieldOf("threshold").forGetter(p_191494_ -> Float.valueOf(p_191494_.threshold)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("high_chance").forGetter(p_191492_ -> Float.valueOf(p_191492_.highChance)), (App)BlockState.CODEC.fieldOf("default_state").forGetter(p_191490_ -> p_191490_.defaultState), (App)ExtraCodecs.nonEmptyList(BlockState.CODEC.listOf()).fieldOf("low_states").forGetter(p_191488_ -> p_191488_.lowStates), (App)ExtraCodecs.nonEmptyList(BlockState.CODEC.listOf()).fieldOf("high_states").forGetter(p_191481_ -> p_191481_.highStates))).apply((Applicative)p_191486_, NoiseThresholdProvider::new));
    private final float threshold;
    private final float highChance;
    private final BlockState defaultState;
    private final List<BlockState> lowStates;
    private final List<BlockState> highStates;

    public NoiseThresholdProvider(long p_191471_, NormalNoise.NoiseParameters p_191472_, float p_191473_, float p_191474_, float p_191475_, BlockState p_191476_, List<BlockState> p_191477_, List<BlockState> p_191478_) {
        super(p_191471_, p_191472_, p_191473_);
        this.threshold = p_191474_;
        this.highChance = p_191475_;
        this.defaultState = p_191476_;
        this.lowStates = p_191477_;
        this.highStates = p_191478_;
    }

    @Override
    protected BlockStateProviderType<?> type() {
        return BlockStateProviderType.NOISE_THRESHOLD_PROVIDER;
    }

    @Override
    public BlockState getState(RandomSource p_225916_, BlockPos p_225917_) {
        double $$2 = this.getNoiseValue(p_225917_, this.scale);
        if ($$2 < (double)this.threshold) {
            return Util.getRandom(this.lowStates, p_225916_);
        }
        if (p_225916_.nextFloat() < this.highChance) {
            return Util.getRandom(this.highStates, p_225916_);
        }
        return this.defaultState;
    }
}

