/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.util.CsvOutput;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.entity.ChunkEntities;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.entity.EntityLookup;
import net.minecraft.world.level.entity.EntityPersistentStorage;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.LevelEntityGetterAdapter;
import net.minecraft.world.level.entity.Visibility;
import org.slf4j.Logger;

public class PersistentEntitySectionManager<T extends EntityAccess>
implements AutoCloseable {
    static final Logger LOGGER = LogUtils.getLogger();
    final Set<UUID> knownUuids = Sets.newHashSet();
    final LevelCallback<T> callbacks;
    private final EntityPersistentStorage<T> permanentStorage;
    private final EntityLookup<T> visibleEntityStorage;
    final EntitySectionStorage<T> sectionStorage;
    private final LevelEntityGetter<T> entityGetter;
    private final Long2ObjectMap<Visibility> chunkVisibility = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<ChunkLoadStatus> chunkLoadStatuses = new Long2ObjectOpenHashMap();
    private final LongSet chunksToUnload = new LongOpenHashSet();
    private final Queue<ChunkEntities<T>> loadingInbox = Queues.newConcurrentLinkedQueue();

    public PersistentEntitySectionManager(Class<T> p_157503_, LevelCallback<T> p_157504_, EntityPersistentStorage<T> p_157505_) {
        this.visibleEntityStorage = new EntityLookup();
        this.sectionStorage = new EntitySectionStorage<T>(p_157503_, (Long2ObjectFunction<Visibility>)this.chunkVisibility);
        this.chunkVisibility.defaultReturnValue((Object)Visibility.HIDDEN);
        this.chunkLoadStatuses.defaultReturnValue((Object)ChunkLoadStatus.FRESH);
        this.callbacks = p_157504_;
        this.permanentStorage = p_157505_;
        this.entityGetter = new LevelEntityGetterAdapter<T>(this.visibleEntityStorage, this.sectionStorage);
    }

    void removeSectionIfEmpty(long p_157510_, EntitySection<T> p_157511_) {
        if (p_157511_.isEmpty()) {
            this.sectionStorage.remove(p_157510_);
        }
    }

    private boolean addEntityUuid(T p_157558_) {
        if (!this.knownUuids.add(p_157558_.getUUID())) {
            LOGGER.warn("UUID of added entity already exists: {}", p_157558_);
            return false;
        }
        return true;
    }

    public boolean addNewEntity(T p_157534_) {
        return this.addEntity(p_157534_, false);
    }

    private boolean addEntity(T p_157539_, boolean p_157540_) {
        Visibility $$4;
        if (!this.addEntityUuid(p_157539_)) {
            return false;
        }
        long $$2 = SectionPos.asLong(p_157539_.blockPosition());
        EntitySection<T> $$3 = this.sectionStorage.getOrCreateSection($$2);
        $$3.add(p_157539_);
        p_157539_.setLevelCallback(new Callback(this, p_157539_, $$2, $$3));
        if (!p_157540_) {
            this.callbacks.onCreated(p_157539_);
        }
        if (($$4 = PersistentEntitySectionManager.getEffectiveStatus(p_157539_, $$3.getStatus())).isAccessible()) {
            this.startTracking(p_157539_);
        }
        if ($$4.isTicking()) {
            this.startTicking(p_157539_);
        }
        return true;
    }

    static <T extends EntityAccess> Visibility getEffectiveStatus(T p_157536_, Visibility p_157537_) {
        return p_157536_.isAlwaysTicking() ? Visibility.TICKING : p_157537_;
    }

    public boolean isTicking(ChunkPos p_397122_) {
        return ((Visibility)((Object)this.chunkVisibility.get(p_397122_.toLong()))).isTicking();
    }

    public void addLegacyChunkEntities(Stream<T> p_157553_) {
        p_157553_.forEach(p_157607_ -> this.addEntity(p_157607_, true));
    }

    public void addWorldGenChunkEntities(Stream<T> p_157560_) {
        p_157560_.forEach(p_157605_ -> this.addEntity(p_157605_, false));
    }

    void startTicking(T p_157565_) {
        this.callbacks.onTickingStart(p_157565_);
    }

    void stopTicking(T p_157571_) {
        this.callbacks.onTickingEnd(p_157571_);
    }

    void startTracking(T p_157576_) {
        this.visibleEntityStorage.add(p_157576_);
        this.callbacks.onTrackingStart(p_157576_);
    }

    void stopTracking(T p_157581_) {
        this.callbacks.onTrackingEnd(p_157581_);
        this.visibleEntityStorage.remove(p_157581_);
    }

    public void updateChunkStatus(ChunkPos p_287590_, FullChunkStatus p_287623_) {
        Visibility $$2 = Visibility.fromFullChunkStatus(p_287623_);
        this.updateChunkStatus(p_287590_, $$2);
    }

    public void updateChunkStatus(ChunkPos p_157528_, Visibility p_157529_) {
        long $$2 = p_157528_.toLong();
        if (p_157529_ == Visibility.HIDDEN) {
            this.chunkVisibility.remove($$2);
            this.chunksToUnload.add($$2);
        } else {
            this.chunkVisibility.put($$2, (Object)p_157529_);
            this.chunksToUnload.remove($$2);
            this.ensureChunkQueuedForLoad($$2);
        }
        this.sectionStorage.getExistingSectionsInChunk($$2).forEach(p_157545_ -> {
            Visibility $$2 = p_157545_.updateChunkStatus(p_157529_);
            boolean $$3 = $$2.isAccessible();
            boolean $$4 = p_157529_.isAccessible();
            boolean $$5 = $$2.isTicking();
            boolean $$6 = p_157529_.isTicking();
            if ($$5 && !$$6) {
                p_157545_.getEntities().filter(p_157603_ -> !p_157603_.isAlwaysTicking()).forEach(this::stopTicking);
            }
            if ($$3 && !$$4) {
                p_157545_.getEntities().filter(p_157601_ -> !p_157601_.isAlwaysTicking()).forEach(this::stopTracking);
            } else if (!$$3 && $$4) {
                p_157545_.getEntities().filter(p_157599_ -> !p_157599_.isAlwaysTicking()).forEach(this::startTracking);
            }
            if (!$$5 && $$6) {
                p_157545_.getEntities().filter(p_157597_ -> !p_157597_.isAlwaysTicking()).forEach(this::startTicking);
            }
        });
    }

    private void ensureChunkQueuedForLoad(long p_157556_) {
        ChunkLoadStatus $$1 = (ChunkLoadStatus)((Object)this.chunkLoadStatuses.get(p_157556_));
        if ($$1 == ChunkLoadStatus.FRESH) {
            this.requestChunkLoad(p_157556_);
        }
    }

    private boolean storeChunkSections(long p_157513_, Consumer<T> p_157514_) {
        ChunkLoadStatus $$2 = (ChunkLoadStatus)((Object)this.chunkLoadStatuses.get(p_157513_));
        if ($$2 == ChunkLoadStatus.PENDING) {
            return false;
        }
        List<T> $$3 = this.sectionStorage.getExistingSectionsInChunk(p_157513_).flatMap(p_157542_ -> p_157542_.getEntities().filter(EntityAccess::shouldBeSaved)).collect(Collectors.toList());
        if ($$3.isEmpty()) {
            if ($$2 == ChunkLoadStatus.LOADED) {
                this.permanentStorage.storeEntities(new ChunkEntities(new ChunkPos(p_157513_), ImmutableList.of()));
            }
            return true;
        }
        if ($$2 == ChunkLoadStatus.FRESH) {
            this.requestChunkLoad(p_157513_);
            return false;
        }
        this.permanentStorage.storeEntities(new ChunkEntities(new ChunkPos(p_157513_), $$3));
        $$3.forEach(p_157514_);
        return true;
    }

    private void requestChunkLoad(long p_157563_) {
        this.chunkLoadStatuses.put(p_157563_, (Object)ChunkLoadStatus.PENDING);
        ChunkPos $$1 = new ChunkPos(p_157563_);
        ((CompletableFuture)this.permanentStorage.loadEntities($$1).thenAccept(this.loadingInbox::add)).exceptionally(p_157532_ -> {
            LOGGER.error("Failed to read chunk {}", (Object)$$1, p_157532_);
            return null;
        });
    }

    private boolean processChunkUnload(long p_157569_) {
        boolean $$1 = this.storeChunkSections(p_157569_, p_157595_ -> p_157595_.getPassengersAndSelf().forEach(this::unloadEntity));
        if (!$$1) {
            return false;
        }
        this.chunkLoadStatuses.remove(p_157569_);
        return true;
    }

    private void unloadEntity(EntityAccess p_157586_) {
        p_157586_.setRemoved(Entity.RemovalReason.UNLOADED_TO_CHUNK);
        p_157586_.setLevelCallback(EntityInLevelCallback.NULL);
    }

    private void processUnloads() {
        this.chunksToUnload.removeIf(p_157584_ -> {
            if (this.chunkVisibility.get(p_157584_) != Visibility.HIDDEN) {
                return true;
            }
            return this.processChunkUnload(p_157584_);
        });
    }

    public void processPendingLoads() {
        ChunkEntities<T> $$0;
        while (($$0 = this.loadingInbox.poll()) != null) {
            $$0.getEntities().forEach(p_157593_ -> this.addEntity(p_157593_, true));
            this.chunkLoadStatuses.put($$0.getPos().toLong(), (Object)ChunkLoadStatus.LOADED);
        }
    }

    public void tick() {
        this.processPendingLoads();
        this.processUnloads();
    }

    private LongSet getAllChunksToSave() {
        LongSet $$0 = this.sectionStorage.getAllChunksWithExistingSections();
        for (Long2ObjectMap.Entry $$1 : Long2ObjectMaps.fastIterable(this.chunkLoadStatuses)) {
            if ($$1.getValue() != ChunkLoadStatus.LOADED) continue;
            $$0.add($$1.getLongKey());
        }
        return $$0;
    }

    public void autoSave() {
        this.getAllChunksToSave().forEach(p_157579_ -> {
            boolean $$1;
            boolean bl = $$1 = this.chunkVisibility.get(p_157579_) == Visibility.HIDDEN;
            if ($$1) {
                this.processChunkUnload(p_157579_);
            } else {
                this.storeChunkSections(p_157579_, p_157591_ -> {});
            }
        });
    }

    public void saveAll() {
        LongSet $$0 = this.getAllChunksToSave();
        while (!$$0.isEmpty()) {
            this.permanentStorage.flush(false);
            this.processPendingLoads();
            $$0.removeIf(p_157574_ -> {
                boolean $$1 = this.chunkVisibility.get(p_157574_) == Visibility.HIDDEN;
                return $$1 ? this.processChunkUnload(p_157574_) : this.storeChunkSections(p_157574_, p_157589_ -> {});
            });
        }
        this.permanentStorage.flush(true);
    }

    @Override
    public void close() throws IOException {
        this.saveAll();
        this.permanentStorage.close();
    }

    public boolean isLoaded(UUID p_157551_) {
        return this.knownUuids.contains(p_157551_);
    }

    public LevelEntityGetter<T> getEntityGetter() {
        return this.entityGetter;
    }

    public boolean canPositionTick(BlockPos p_202168_) {
        return ((Visibility)((Object)this.chunkVisibility.get(ChunkPos.asLong(p_202168_)))).isTicking();
    }

    public boolean canPositionTick(ChunkPos p_202166_) {
        return ((Visibility)((Object)this.chunkVisibility.get(p_202166_.toLong()))).isTicking();
    }

    public boolean areEntitiesLoaded(long p_157508_) {
        return this.chunkLoadStatuses.get(p_157508_) == ChunkLoadStatus.LOADED;
    }

    public void dumpSections(Writer p_157549_) throws IOException {
        CsvOutput $$1 = CsvOutput.builder().addColumn("x").addColumn("y").addColumn("z").addColumn("visibility").addColumn("load_status").addColumn("entity_count").build(p_157549_);
        this.sectionStorage.getAllChunksWithExistingSections().forEach(p_157517_ -> {
            ChunkLoadStatus $$2 = (ChunkLoadStatus)((Object)((Object)this.chunkLoadStatuses.get(p_157517_)));
            this.sectionStorage.getExistingSectionPositionsInChunk(p_157517_).forEach(p_157521_ -> {
                EntitySection<T> $$3 = this.sectionStorage.getSection(p_157521_);
                if ($$3 != null) {
                    try {
                        $$1.writeRow(new Object[]{SectionPos.x(p_157521_), SectionPos.y(p_157521_), SectionPos.z(p_157521_), $$3.getStatus(), $$2, $$3.size()});
                    }
                    catch (IOException $$4) {
                        throw new UncheckedIOException($$4);
                    }
                }
            });
        });
    }

    @VisibleForDebug
    public String gatherStats() {
        return this.knownUuids.size() + "," + this.visibleEntityStorage.count() + "," + this.sectionStorage.count() + "," + this.chunkLoadStatuses.size() + "," + this.chunkVisibility.size() + "," + this.loadingInbox.size() + "," + this.chunksToUnload.size();
    }

    @VisibleForDebug
    public int count() {
        return this.visibleEntityStorage.count();
    }

    static enum ChunkLoadStatus {
        FRESH,
        PENDING,
        LOADED;

    }

    class Callback
    implements EntityInLevelCallback {
        private final T entity;
        private long currentSectionKey;
        private EntitySection<T> currentSection;
        final /* synthetic */ PersistentEntitySectionManager this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        Callback(T t, long p_157616_, EntitySection<T> entitySection) {
            void var3_3;
            void p_157614_;
            this.this$0 = (PersistentEntitySectionManager)l;
            this.entity = p_157614_;
            this.currentSectionKey = var3_3;
            this.currentSection = (EntitySection)p_157616_;
        }

        @Override
        public void onMove() {
            BlockPos $$0 = this.entity.blockPosition();
            long $$1 = SectionPos.asLong($$0);
            if ($$1 != this.currentSectionKey) {
                Visibility $$2 = this.currentSection.getStatus();
                if (!this.currentSection.remove(this.entity)) {
                    LOGGER.warn("Entity {} wasn't found in section {} (moving to {})", new Object[]{this.entity, SectionPos.of(this.currentSectionKey), $$1});
                }
                this.this$0.removeSectionIfEmpty(this.currentSectionKey, this.currentSection);
                EntitySection $$3 = this.this$0.sectionStorage.getOrCreateSection($$1);
                $$3.add(this.entity);
                this.currentSection = $$3;
                this.currentSectionKey = $$1;
                this.updateStatus($$2, $$3.getStatus());
            }
        }

        private void updateStatus(Visibility p_157621_, Visibility p_157622_) {
            Visibility $$3;
            Visibility $$2 = PersistentEntitySectionManager.getEffectiveStatus(this.entity, p_157621_);
            if ($$2 == ($$3 = PersistentEntitySectionManager.getEffectiveStatus(this.entity, p_157622_))) {
                if ($$3.isAccessible()) {
                    this.this$0.callbacks.onSectionChange(this.entity);
                }
                return;
            }
            boolean $$4 = $$2.isAccessible();
            boolean $$5 = $$3.isAccessible();
            if ($$4 && !$$5) {
                this.this$0.stopTracking(this.entity);
            } else if (!$$4 && $$5) {
                this.this$0.startTracking(this.entity);
            }
            boolean $$6 = $$2.isTicking();
            boolean $$7 = $$3.isTicking();
            if ($$6 && !$$7) {
                this.this$0.stopTicking(this.entity);
            } else if (!$$6 && $$7) {
                this.this$0.startTicking(this.entity);
            }
            if ($$5) {
                this.this$0.callbacks.onSectionChange(this.entity);
            }
        }

        @Override
        public void onRemove(Entity.RemovalReason p_157619_) {
            Visibility $$1;
            if (!this.currentSection.remove(this.entity)) {
                LOGGER.warn("Entity {} wasn't found in section {} (destroying due to {})", new Object[]{this.entity, SectionPos.of(this.currentSectionKey), p_157619_});
            }
            if (($$1 = PersistentEntitySectionManager.getEffectiveStatus(this.entity, this.currentSection.getStatus())).isTicking()) {
                this.this$0.stopTicking(this.entity);
            }
            if ($$1.isAccessible()) {
                this.this$0.stopTracking(this.entity);
            }
            if (p_157619_.shouldDestroy()) {
                this.this$0.callbacks.onDestroyed(this.entity);
            }
            this.this$0.knownUuids.remove(this.entity.getUUID());
            this.entity.setLevelCallback(NULL);
            this.this$0.removeSectionIfEmpty(this.currentSectionKey, this.currentSection);
        }
    }
}

