/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.thread.ConsecutiveExecutor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import net.minecraft.world.level.entity.ChunkEntities;
import net.minecraft.world.level.entity.EntityPersistentStorage;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import org.slf4j.Logger;

public class EntityStorage
implements EntityPersistentStorage<Entity> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String ENTITIES_TAG = "Entities";
    private static final String POSITION_TAG = "Position";
    private final ServerLevel level;
    private final SimpleRegionStorage simpleRegionStorage;
    private final LongSet emptyChunks = new LongOpenHashSet();
    private final ConsecutiveExecutor entityDeserializerQueue;

    public EntityStorage(SimpleRegionStorage p_321748_, ServerLevel p_196924_, Executor p_196928_) {
        this.simpleRegionStorage = p_321748_;
        this.level = p_196924_;
        this.entityDeserializerQueue = new ConsecutiveExecutor(p_196928_, "entity-deserializer");
    }

    @Override
    public CompletableFuture<ChunkEntities<Entity>> loadEntities(ChunkPos p_156551_) {
        if (this.emptyChunks.contains(p_156551_.toLong())) {
            return CompletableFuture.completedFuture(EntityStorage.emptyChunk(p_156551_));
        }
        CompletableFuture<Optional<CompoundTag>> $$1 = this.simpleRegionStorage.read(p_156551_);
        this.reportLoadFailureIfPresent($$1, p_156551_);
        return $$1.thenApplyAsync(p_421443_ -> {
            if (p_421443_.isEmpty()) {
                this.emptyChunks.add(p_156551_.toLong());
                return EntityStorage.emptyChunk(p_156551_);
            }
            try {
                ChunkPos $$2 = ((CompoundTag)p_421443_.get()).read(POSITION_TAG, ChunkPos.CODEC).orElseThrow();
                if (!Objects.equals(p_156551_, $$2)) {
                    LOGGER.error("Chunk file at {} is in the wrong location. (Expected {}, got {})", new Object[]{p_156551_, p_156551_, $$2});
                    this.level.getServer().reportMisplacedChunk($$2, p_156551_, this.simpleRegionStorage.storageInfo());
                }
            }
            catch (Exception $$3) {
                LOGGER.warn("Failed to parse chunk {} position info", (Object)p_156551_, (Object)$$3);
                this.level.getServer().reportChunkLoadFailure($$3, this.simpleRegionStorage.storageInfo(), p_156551_);
            }
            CompoundTag $$4 = this.simpleRegionStorage.upgradeChunkTag((CompoundTag)p_421443_.get(), -1);
            try (ProblemReporter.ScopedCollector $$5 = new ProblemReporter.ScopedCollector(ChunkAccess.problemPath(p_156551_), LOGGER);){
                ValueInput $$6 = TagValueInput.create((ProblemReporter)$$5, (HolderLookup.Provider)this.level.registryAccess(), $$4);
                ValueInput.ValueInputList $$7 = $$6.childrenListOrEmpty(ENTITIES_TAG);
                List<Entity> $$8 = EntityType.loadEntitiesRecursive($$7, this.level, EntitySpawnReason.LOAD).toList();
                ChunkEntities<Entity> chunkEntities = new ChunkEntities<Entity>(p_156551_, $$8);
                return chunkEntities;
            }
        }, this.entityDeserializerQueue::schedule);
    }

    private static ChunkEntities<Entity> emptyChunk(ChunkPos p_156569_) {
        return new ChunkEntities<Entity>(p_156569_, List.of());
    }

    @Override
    public void storeEntities(ChunkEntities<Entity> p_156559_) {
        ChunkPos $$1 = p_156559_.getPos();
        if (p_156559_.isEmpty()) {
            if (this.emptyChunks.add($$1.toLong())) {
                this.reportSaveFailureIfPresent(this.simpleRegionStorage.write($$1, null), $$1);
            }
            return;
        }
        try (ProblemReporter.ScopedCollector $$2 = new ProblemReporter.ScopedCollector(ChunkAccess.problemPath($$1), LOGGER);){
            ListTag $$3 = new ListTag();
            p_156559_.getEntities().forEach(p_421446_ -> {
                TagValueOutput $$3 = TagValueOutput.createWithContext($$2.forChild(p_421446_.problemPath()), p_421446_.registryAccess());
                if (p_421446_.save($$3)) {
                    CompoundTag $$4 = $$3.buildResult();
                    $$3.add($$4);
                }
            });
            CompoundTag $$4 = NbtUtils.addCurrentDataVersion(new CompoundTag());
            $$4.put(ENTITIES_TAG, $$3);
            $$4.store(POSITION_TAG, ChunkPos.CODEC, $$1);
            this.reportSaveFailureIfPresent(this.simpleRegionStorage.write($$1, $$4), $$1);
            this.emptyChunks.remove($$1.toLong());
        }
    }

    private void reportSaveFailureIfPresent(CompletableFuture<?> p_352240_, ChunkPos p_352077_) {
        p_352240_.exceptionally(p_351986_ -> {
            LOGGER.error("Failed to store entity chunk {}", (Object)p_352077_, p_351986_);
            this.level.getServer().reportChunkSaveFailure((Throwable)p_351986_, this.simpleRegionStorage.storageInfo(), p_352077_);
            return null;
        });
    }

    private void reportLoadFailureIfPresent(CompletableFuture<?> p_352123_, ChunkPos p_352328_) {
        p_352123_.exceptionally(p_351990_ -> {
            LOGGER.error("Failed to load entity chunk {}", (Object)p_352328_, p_351990_);
            this.level.getServer().reportChunkLoadFailure((Throwable)p_351990_, this.simpleRegionStorage.storageInfo(), p_352328_);
            return null;
        });
    }

    @Override
    public void flush(boolean p_182487_) {
        this.simpleRegionStorage.synchronize(p_182487_).join();
        this.entityDeserializerQueue.runAll();
    }

    @Override
    public void close() throws IOException {
        this.simpleRegionStorage.close();
    }
}

