/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.gameevent.EuclideanGameEventListenerRegistry;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.GameEventListenerRegistry;
import net.minecraft.world.level.levelgen.DebugLevelSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.LevelTicks;
import net.minecraft.world.ticks.TickContainerAccess;
import org.slf4j.Logger;

public class LevelChunk
extends ChunkAccess {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final TickingBlockEntity NULL_TICKER = new TickingBlockEntity(){

        @Override
        public void tick() {
        }

        @Override
        public boolean isRemoved() {
            return true;
        }

        @Override
        public BlockPos getPos() {
            return BlockPos.ZERO;
        }

        @Override
        public String getType() {
            return "<null>";
        }
    };
    private final Map<BlockPos, RebindableTickingBlockEntityWrapper> tickersInLevel = Maps.newHashMap();
    private boolean loaded;
    final Level level;
    @Nullable
    private Supplier<FullChunkStatus> fullStatus;
    @Nullable
    private PostLoadProcessor postLoad;
    private final Int2ObjectMap<GameEventListenerRegistry> gameEventListenerRegistrySections;
    private final LevelChunkTicks<Block> blockTicks;
    private final LevelChunkTicks<Fluid> fluidTicks;
    private UnsavedListener unsavedListener = p_381697_ -> {};

    public LevelChunk(Level p_187945_, ChunkPos p_187946_) {
        this(p_187945_, p_187946_, UpgradeData.EMPTY, new LevelChunkTicks<Block>(), new LevelChunkTicks<Fluid>(), 0L, null, null, null);
    }

    public LevelChunk(Level p_196854_, ChunkPos p_196855_, UpgradeData p_196856_, LevelChunkTicks<Block> p_196857_, LevelChunkTicks<Fluid> p_196858_, long p_196859_, @Nullable LevelChunkSection[] p_196860_, @Nullable PostLoadProcessor p_196861_, @Nullable BlendingData p_196862_) {
        super(p_196855_, p_196856_, p_196854_, (Registry<Biome>)p_196854_.registryAccess().lookupOrThrow(Registries.BIOME), p_196859_, p_196860_, p_196862_);
        this.level = p_196854_;
        this.gameEventListenerRegistrySections = new Int2ObjectOpenHashMap();
        for (Heightmap.Types $$9 : Heightmap.Types.values()) {
            if (!ChunkStatus.FULL.heightmapsAfter().contains($$9)) continue;
            this.heightmaps.put($$9, new Heightmap(this, $$9));
        }
        this.postLoad = p_196861_;
        this.blockTicks = p_196857_;
        this.fluidTicks = p_196858_;
    }

    public LevelChunk(ServerLevel p_196850_, ProtoChunk p_196851_, @Nullable PostLoadProcessor p_196852_) {
        this(p_196850_, p_196851_.getPos(), p_196851_.getUpgradeData(), p_196851_.unpackBlockTicks(), p_196851_.unpackFluidTicks(), p_196851_.getInhabitedTime(), p_196851_.getSections(), p_196852_, p_196851_.getBlendingData());
        if (!Collections.disjoint(p_196851_.pendingBlockEntities.keySet(), p_196851_.blockEntities.keySet())) {
            LOGGER.error("Chunk at {} contains duplicated block entities", (Object)p_196851_.getPos());
        }
        for (BlockEntity $$3 : p_196851_.getBlockEntities().values()) {
            this.setBlockEntity($$3);
        }
        this.pendingBlockEntities.putAll(p_196851_.getBlockEntityNbts());
        for (int $$4 = 0; $$4 < p_196851_.getPostProcessing().length; ++$$4) {
            this.postProcessing[$$4] = p_196851_.getPostProcessing()[$$4];
        }
        this.setAllStarts(p_196851_.getAllStarts());
        this.setAllReferences(p_196851_.getAllReferences());
        for (Map.Entry<Heightmap.Types, Heightmap> $$5 : p_196851_.getHeightmaps()) {
            if (!ChunkStatus.FULL.heightmapsAfter().contains($$5.getKey())) continue;
            this.setHeightmap($$5.getKey(), $$5.getValue().getRawData());
        }
        this.skyLightSources = p_196851_.skyLightSources;
        this.setLightCorrect(p_196851_.isLightCorrect());
        this.markUnsaved();
    }

    public void setUnsavedListener(UnsavedListener p_381704_) {
        this.unsavedListener = p_381704_;
        if (this.isUnsaved()) {
            p_381704_.setUnsaved(this.chunkPos);
        }
    }

    @Override
    public void markUnsaved() {
        boolean $$0 = this.isUnsaved();
        super.markUnsaved();
        if (!$$0) {
            this.unsavedListener.setUnsaved(this.chunkPos);
        }
    }

    @Override
    public TickContainerAccess<Block> getBlockTicks() {
        return this.blockTicks;
    }

    @Override
    public TickContainerAccess<Fluid> getFluidTicks() {
        return this.fluidTicks;
    }

    @Override
    public ChunkAccess.PackedTicks getTicksForSerialization(long p_361545_) {
        return new ChunkAccess.PackedTicks(this.blockTicks.pack(p_361545_), this.fluidTicks.pack(p_361545_));
    }

    @Override
    public GameEventListenerRegistry getListenerRegistry(int p_251193_) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel $$1 = (ServerLevel)level;
            return (GameEventListenerRegistry)this.gameEventListenerRegistrySections.computeIfAbsent(p_251193_, p_281221_ -> new EuclideanGameEventListenerRegistry($$1, p_251193_, this::removeGameEventListenerRegistry));
        }
        return super.getListenerRegistry(p_251193_);
    }

    @Override
    public BlockState getBlockState(BlockPos p_62923_) {
        int $$1 = p_62923_.getX();
        int $$2 = p_62923_.getY();
        int $$3 = p_62923_.getZ();
        if (this.level.isDebug()) {
            BlockState $$4 = null;
            if ($$2 == 60) {
                $$4 = Blocks.BARRIER.defaultBlockState();
            }
            if ($$2 == 70) {
                $$4 = DebugLevelSource.getBlockStateFor($$1, $$3);
            }
            return $$4 == null ? Blocks.AIR.defaultBlockState() : $$4;
        }
        try {
            LevelChunkSection $$6;
            int $$5 = this.getSectionIndex($$2);
            if ($$5 >= 0 && $$5 < this.sections.length && !($$6 = this.sections[$$5]).hasOnlyAir()) {
                return $$6.getBlockState($$1 & 0xF, $$2 & 0xF, $$3 & 0xF);
            }
            return Blocks.AIR.defaultBlockState();
        }
        catch (Throwable $$7) {
            CrashReport $$8 = CrashReport.forThrowable($$7, "Getting block state");
            CrashReportCategory $$9 = $$8.addCategory("Block being got");
            $$9.setDetail("Location", () -> CrashReportCategory.formatLocation((LevelHeightAccessor)this, $$1, $$2, $$3));
            throw new ReportedException($$8);
        }
    }

    @Override
    public FluidState getFluidState(BlockPos p_62895_) {
        return this.getFluidState(p_62895_.getX(), p_62895_.getY(), p_62895_.getZ());
    }

    public FluidState getFluidState(int p_62815_, int p_62816_, int p_62817_) {
        try {
            LevelChunkSection $$4;
            int $$3 = this.getSectionIndex(p_62816_);
            if ($$3 >= 0 && $$3 < this.sections.length && !($$4 = this.sections[$$3]).hasOnlyAir()) {
                return $$4.getFluidState(p_62815_ & 0xF, p_62816_ & 0xF, p_62817_ & 0xF);
            }
            return Fluids.EMPTY.defaultFluidState();
        }
        catch (Throwable $$5) {
            CrashReport $$6 = CrashReport.forThrowable($$5, "Getting fluid state");
            CrashReportCategory $$7 = $$6.addCategory("Block being got");
            $$7.setDetail("Location", () -> CrashReportCategory.formatLocation((LevelHeightAccessor)this, p_62815_, p_62816_, p_62817_));
            throw new ReportedException($$6);
        }
    }

    @Override
    @Nullable
    public BlockState setBlockState(BlockPos p_62865_, BlockState p_62866_, int p_393859_) {
        Level level;
        boolean $$15;
        int $$8;
        int $$7;
        int $$3 = p_62865_.getY();
        LevelChunkSection $$4 = this.getSection(this.getSectionIndex($$3));
        boolean $$5 = $$4.hasOnlyAir();
        if ($$5 && p_62866_.isAir()) {
            return null;
        }
        int $$6 = p_62865_.getX() & 0xF;
        BlockState $$9 = $$4.setBlockState($$6, $$7 = $$3 & 0xF, $$8 = p_62865_.getZ() & 0xF, p_62866_);
        if ($$9 == p_62866_) {
            return null;
        }
        Block $$10 = p_62866_.getBlock();
        ((Heightmap)this.heightmaps.get(Heightmap.Types.MOTION_BLOCKING)).update($$6, $$3, $$8, p_62866_);
        ((Heightmap)this.heightmaps.get(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES)).update($$6, $$3, $$8, p_62866_);
        ((Heightmap)this.heightmaps.get(Heightmap.Types.OCEAN_FLOOR)).update($$6, $$3, $$8, p_62866_);
        ((Heightmap)this.heightmaps.get(Heightmap.Types.WORLD_SURFACE)).update($$6, $$3, $$8, p_62866_);
        boolean $$11 = $$4.hasOnlyAir();
        if ($$5 != $$11) {
            this.level.getChunkSource().getLightEngine().updateSectionStatus(p_62865_, $$11);
            this.level.getChunkSource().onSectionEmptinessChanged(this.chunkPos.x, SectionPos.blockToSectionCoord($$3), this.chunkPos.z, $$11);
        }
        if (LightEngine.hasDifferentLightProperties($$9, p_62866_)) {
            ProfilerFiller $$12 = Profiler.get();
            $$12.push("updateSkyLightSources");
            this.skyLightSources.update(this, $$6, $$3, $$8);
            $$12.popPush("queueCheckLight");
            this.level.getChunkSource().getLightEngine().checkBlock(p_62865_);
            $$12.pop();
        }
        boolean $$13 = !$$9.is($$10);
        boolean $$14 = (p_393859_ & 0x40) != 0;
        boolean bl = $$15 = (p_393859_ & 0x100) == 0;
        if ($$13 && $$9.hasBlockEntity()) {
            BlockEntity $$16;
            if (!this.level.isClientSide && $$15 && ($$16 = this.level.getBlockEntity(p_62865_)) != null) {
                $$16.preRemoveSideEffects(p_62865_, $$9);
            }
            this.removeBlockEntity(p_62865_);
        }
        if (($$13 || $$10 instanceof BaseRailBlock) && (level = this.level) instanceof ServerLevel) {
            ServerLevel $$17 = (ServerLevel)level;
            if ((p_393859_ & 1) != 0 || $$14) {
                $$9.affectNeighborsAfterRemoval($$17, p_62865_, $$14);
            }
        }
        if (!$$4.getBlockState($$6, $$7, $$8).is($$10)) {
            return null;
        }
        if (!this.level.isClientSide && (p_393859_ & 0x200) == 0) {
            p_62866_.onPlace(this.level, p_62865_, $$9, $$14);
        }
        if (p_62866_.hasBlockEntity()) {
            BlockEntity $$18 = this.getBlockEntity(p_62865_, EntityCreationType.CHECK);
            if ($$18 != null && !$$18.isValidBlockState(p_62866_)) {
                LOGGER.warn("Found mismatched block entity @ {}: type = {}, state = {}", new Object[]{p_62865_, $$18.getType().builtInRegistryHolder().key().location(), p_62866_});
                this.removeBlockEntity(p_62865_);
                $$18 = null;
            }
            if ($$18 == null) {
                $$18 = ((EntityBlock)((Object)$$10)).newBlockEntity(p_62865_, p_62866_);
                if ($$18 != null) {
                    this.addAndRegisterBlockEntity($$18);
                }
            } else {
                $$18.setBlockState(p_62866_);
                this.updateBlockEntityTicker($$18);
            }
        }
        this.markUnsaved();
        return $$9;
    }

    @Override
    @Deprecated
    public void addEntity(Entity p_62826_) {
    }

    @Nullable
    private BlockEntity createBlockEntity(BlockPos p_62935_) {
        BlockState $$1 = this.getBlockState(p_62935_);
        if (!$$1.hasBlockEntity()) {
            return null;
        }
        return ((EntityBlock)((Object)$$1.getBlock())).newBlockEntity(p_62935_, $$1);
    }

    @Override
    @Nullable
    public BlockEntity getBlockEntity(BlockPos p_62912_) {
        return this.getBlockEntity(p_62912_, EntityCreationType.CHECK);
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos p_62868_, EntityCreationType p_62869_) {
        BlockEntity $$4;
        CompoundTag $$3;
        BlockEntity $$2 = (BlockEntity)this.blockEntities.get(p_62868_);
        if ($$2 == null && ($$3 = (CompoundTag)this.pendingBlockEntities.remove(p_62868_)) != null && ($$4 = this.promotePendingBlockEntity(p_62868_, $$3)) != null) {
            return $$4;
        }
        if ($$2 == null) {
            if (p_62869_ == EntityCreationType.IMMEDIATE && ($$2 = this.createBlockEntity(p_62868_)) != null) {
                this.addAndRegisterBlockEntity($$2);
            }
        } else if ($$2.isRemoved()) {
            this.blockEntities.remove(p_62868_);
            return null;
        }
        return $$2;
    }

    public void addAndRegisterBlockEntity(BlockEntity p_156391_) {
        this.setBlockEntity(p_156391_);
        if (this.isInLevel()) {
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel $$1 = (ServerLevel)level;
                this.addGameEventListener(p_156391_, $$1);
            }
            this.level.onBlockEntityAdded(p_156391_);
            this.updateBlockEntityTicker(p_156391_);
        }
    }

    private boolean isInLevel() {
        return this.loaded || this.level.isClientSide();
    }

    boolean isTicking(BlockPos p_156411_) {
        if (!this.level.getWorldBorder().isWithinBounds(p_156411_)) {
            return false;
        }
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel $$1 = (ServerLevel)level;
            return this.getFullStatus().isOrAfter(FullChunkStatus.BLOCK_TICKING) && $$1.areEntitiesLoaded(ChunkPos.asLong(p_156411_));
        }
        return true;
    }

    @Override
    public void setBlockEntity(BlockEntity p_156374_) {
        BlockPos $$1 = p_156374_.getBlockPos();
        BlockState $$2 = this.getBlockState($$1);
        if (!$$2.hasBlockEntity()) {
            LOGGER.warn("Trying to set block entity {} at position {}, but state {} does not allow it", new Object[]{p_156374_, $$1, $$2});
            return;
        }
        BlockState $$3 = p_156374_.getBlockState();
        if ($$2 != $$3) {
            if (!p_156374_.getType().isValid($$2)) {
                LOGGER.warn("Trying to set block entity {} at position {}, but state {} does not allow it", new Object[]{p_156374_, $$1, $$2});
                return;
            }
            if ($$2.getBlock() != $$3.getBlock()) {
                LOGGER.warn("Block state mismatch on block entity {} in position {}, {} != {}, updating", new Object[]{p_156374_, $$1, $$2, $$3});
            }
            p_156374_.setBlockState($$2);
        }
        p_156374_.setLevel(this.level);
        p_156374_.clearRemoved();
        BlockEntity $$4 = this.blockEntities.put($$1.immutable(), p_156374_);
        if ($$4 != null && $$4 != p_156374_) {
            $$4.setRemoved();
        }
    }

    @Override
    @Nullable
    public CompoundTag getBlockEntityNbtForSaving(BlockPos p_62932_, HolderLookup.Provider p_323699_) {
        BlockEntity $$2 = this.getBlockEntity(p_62932_);
        if ($$2 != null && !$$2.isRemoved()) {
            CompoundTag $$3 = $$2.saveWithFullMetadata(this.level.registryAccess());
            $$3.putBoolean("keepPacked", false);
            return $$3;
        }
        CompoundTag $$4 = (CompoundTag)this.pendingBlockEntities.get(p_62932_);
        if ($$4 != null) {
            $$4 = $$4.copy();
            $$4.putBoolean("keepPacked", true);
        }
        return $$4;
    }

    @Override
    public void removeBlockEntity(BlockPos p_62919_) {
        BlockEntity $$1;
        if (this.isInLevel() && ($$1 = (BlockEntity)this.blockEntities.remove(p_62919_)) != null) {
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel $$2 = (ServerLevel)level;
                this.removeGameEventListener($$1, $$2);
            }
            $$1.setRemoved();
        }
        this.removeBlockEntityTicker(p_62919_);
    }

    private <T extends BlockEntity> void removeGameEventListener(T p_223413_, ServerLevel p_223414_) {
        GameEventListener $$3;
        Block $$2 = p_223413_.getBlockState().getBlock();
        if ($$2 instanceof EntityBlock && ($$3 = ((EntityBlock)((Object)$$2)).getListener(p_223414_, p_223413_)) != null) {
            int $$4 = SectionPos.blockToSectionCoord(p_223413_.getBlockPos().getY());
            GameEventListenerRegistry $$5 = this.getListenerRegistry($$4);
            $$5.unregister($$3);
        }
    }

    private void removeGameEventListenerRegistry(int p_283355_) {
        this.gameEventListenerRegistrySections.remove(p_283355_);
    }

    private void removeBlockEntityTicker(BlockPos p_156413_) {
        RebindableTickingBlockEntityWrapper $$1 = this.tickersInLevel.remove(p_156413_);
        if ($$1 != null) {
            $$1.rebind(NULL_TICKER);
        }
    }

    public void runPostLoad() {
        if (this.postLoad != null) {
            this.postLoad.run(this);
            this.postLoad = null;
        }
    }

    public boolean isEmpty() {
        return false;
    }

    public void replaceWithPacketData(FriendlyByteBuf p_187972_, Map<Heightmap.Types, long[]> p_404796_, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> p_187974_) {
        this.clearAllBlockEntities();
        for (LevelChunkSection $$3 : this.sections) {
            $$3.read(p_187972_);
        }
        p_404796_.forEach(this::setHeightmap);
        this.initializeLightSources();
        try (ProblemReporter.ScopedCollector $$4 = new ProblemReporter.ScopedCollector(this.problemPath(), LOGGER);){
            p_187974_.accept((p_421432_, p_421433_, p_421434_) -> {
                BlockEntity $$4 = this.getBlockEntity(p_421432_, EntityCreationType.IMMEDIATE);
                if ($$4 != null && p_421434_ != null && $$4.getType() == p_421433_) {
                    $$4.loadWithComponents(TagValueInput.create($$4.forChild($$4.problemPath()), (HolderLookup.Provider)this.level.registryAccess(), p_421434_));
                }
            });
        }
    }

    public void replaceBiomes(FriendlyByteBuf p_275574_) {
        for (LevelChunkSection $$1 : this.sections) {
            $$1.readBiomes(p_275574_);
        }
    }

    public void setLoaded(boolean p_62914_) {
        this.loaded = p_62914_;
    }

    public Level getLevel() {
        return this.level;
    }

    public Map<BlockPos, BlockEntity> getBlockEntities() {
        return this.blockEntities;
    }

    public void postProcessGeneration(ServerLevel p_376244_) {
        ChunkPos $$1 = this.getPos();
        for (int $$2 = 0; $$2 < this.postProcessing.length; ++$$2) {
            if (this.postProcessing[$$2] == null) continue;
            for (Short $$3 : this.postProcessing[$$2]) {
                BlockState $$7;
                BlockPos $$4 = ProtoChunk.unpackOffsetCoordinates($$3, this.getSectionYFromSectionIndex($$2), $$1);
                BlockState $$5 = this.getBlockState($$4);
                FluidState $$6 = $$5.getFluidState();
                if (!$$6.isEmpty()) {
                    $$6.tick(p_376244_, $$4, $$5);
                }
                if ($$5.getBlock() instanceof LiquidBlock || ($$7 = Block.updateFromNeighbourShapes($$5, p_376244_, $$4)) == $$5) continue;
                p_376244_.setBlock($$4, $$7, 276);
            }
            this.postProcessing[$$2].clear();
        }
        for (BlockPos $$8 : ImmutableList.copyOf(this.pendingBlockEntities.keySet())) {
            this.getBlockEntity($$8);
        }
        this.pendingBlockEntities.clear();
        this.upgradeData.upgrade(this);
    }

    @Nullable
    private BlockEntity promotePendingBlockEntity(BlockPos p_62871_, CompoundTag p_62872_) {
        BlockEntity $$5;
        BlockState $$2 = this.getBlockState(p_62871_);
        if ("DUMMY".equals(p_62872_.getStringOr("id", ""))) {
            if ($$2.hasBlockEntity()) {
                BlockEntity $$3 = ((EntityBlock)((Object)$$2.getBlock())).newBlockEntity(p_62871_, $$2);
            } else {
                Object $$4 = null;
                LOGGER.warn("Tried to load a DUMMY block entity @ {} but found not block entity block {} at location", (Object)p_62871_, (Object)$$2);
            }
        } else {
            $$5 = BlockEntity.loadStatic(p_62871_, $$2, p_62872_, this.level.registryAccess());
        }
        if ($$5 != null) {
            $$5.setLevel(this.level);
            this.addAndRegisterBlockEntity($$5);
        } else {
            LOGGER.warn("Tried to load a block entity for block {} but failed at location {}", (Object)$$2, (Object)p_62871_);
        }
        return $$5;
    }

    public void unpackTicks(long p_187986_) {
        this.blockTicks.unpack(p_187986_);
        this.fluidTicks.unpack(p_187986_);
    }

    public void registerTickContainerInLevel(ServerLevel p_187959_) {
        ((LevelTicks)p_187959_.getBlockTicks()).addContainer(this.chunkPos, this.blockTicks);
        ((LevelTicks)p_187959_.getFluidTicks()).addContainer(this.chunkPos, this.fluidTicks);
    }

    public void unregisterTickContainerFromLevel(ServerLevel p_187980_) {
        ((LevelTicks)p_187980_.getBlockTicks()).removeContainer(this.chunkPos);
        ((LevelTicks)p_187980_.getFluidTicks()).removeContainer(this.chunkPos);
    }

    @Override
    public ChunkStatus getPersistedStatus() {
        return ChunkStatus.FULL;
    }

    public FullChunkStatus getFullStatus() {
        if (this.fullStatus == null) {
            return FullChunkStatus.FULL;
        }
        return this.fullStatus.get();
    }

    public void setFullStatus(Supplier<FullChunkStatus> p_62880_) {
        this.fullStatus = p_62880_;
    }

    public void clearAllBlockEntities() {
        this.blockEntities.values().forEach(BlockEntity::setRemoved);
        this.blockEntities.clear();
        this.tickersInLevel.values().forEach(p_187966_ -> p_187966_.rebind(NULL_TICKER));
        this.tickersInLevel.clear();
    }

    public void registerAllBlockEntitiesAfterLevelLoad() {
        this.blockEntities.values().forEach(p_427220_ -> {
            Level $$1 = this.level;
            if ($$1 instanceof ServerLevel) {
                ServerLevel $$2 = (ServerLevel)$$1;
                this.addGameEventListener(p_427220_, $$2);
            }
            this.level.onBlockEntityAdded((BlockEntity)p_427220_);
            this.updateBlockEntityTicker(p_427220_);
        });
    }

    private <T extends BlockEntity> void addGameEventListener(T p_223416_, ServerLevel p_223417_) {
        GameEventListener $$3;
        Block $$2 = p_223416_.getBlockState().getBlock();
        if ($$2 instanceof EntityBlock && ($$3 = ((EntityBlock)((Object)$$2)).getListener(p_223417_, p_223416_)) != null) {
            this.getListenerRegistry(SectionPos.blockToSectionCoord(p_223416_.getBlockPos().getY())).register($$3);
        }
    }

    private <T extends BlockEntity> void updateBlockEntityTicker(T p_156407_) {
        BlockState $$1 = p_156407_.getBlockState();
        BlockEntityTicker<?> $$2 = $$1.getTicker(this.level, p_156407_.getType());
        if ($$2 == null) {
            this.removeBlockEntityTicker(p_156407_.getBlockPos());
        } else {
            this.tickersInLevel.compute(p_156407_.getBlockPos(), (p_386425_, p_386426_) -> {
                TickingBlockEntity $$4 = this.createTicker(p_156407_, $$2);
                if (p_386426_ != null) {
                    p_386426_.rebind($$4);
                    return p_386426_;
                }
                if (this.isInLevel()) {
                    RebindableTickingBlockEntityWrapper $$5 = new RebindableTickingBlockEntityWrapper($$4);
                    this.level.addBlockEntityTicker($$5);
                    return $$5;
                }
                return null;
            });
        }
    }

    private <T extends BlockEntity> TickingBlockEntity createTicker(T p_156376_, BlockEntityTicker<T> p_156377_) {
        return new BoundTickingBlockEntity(this, p_156376_, p_156377_);
    }

    @FunctionalInterface
    public static interface PostLoadProcessor {
        public void run(LevelChunk var1);
    }

    @FunctionalInterface
    public static interface UnsavedListener {
        public void setUnsaved(ChunkPos var1);
    }

    public static enum EntityCreationType {
        IMMEDIATE,
        QUEUED,
        CHECK;

    }

    static class RebindableTickingBlockEntityWrapper
    implements TickingBlockEntity {
        private TickingBlockEntity ticker;

        RebindableTickingBlockEntityWrapper(TickingBlockEntity p_156447_) {
            this.ticker = p_156447_;
        }

        void rebind(TickingBlockEntity p_156450_) {
            this.ticker = p_156450_;
        }

        @Override
        public void tick() {
            this.ticker.tick();
        }

        @Override
        public boolean isRemoved() {
            return this.ticker.isRemoved();
        }

        @Override
        public BlockPos getPos() {
            return this.ticker.getPos();
        }

        @Override
        public String getType() {
            return this.ticker.getType();
        }

        public String toString() {
            return String.valueOf(this.ticker) + " <wrapped>";
        }
    }

    static class BoundTickingBlockEntity<T extends BlockEntity>
    implements TickingBlockEntity {
        private final T blockEntity;
        private final BlockEntityTicker<T> ticker;
        private boolean loggedInvalidBlockState;
        final /* synthetic */ LevelChunk this$0;

        BoundTickingBlockEntity(T p_156433_, BlockEntityTicker<T> p_156434_) {
            this.this$0 = var1_1;
            this.blockEntity = p_156433_;
            this.ticker = p_156434_;
        }

        @Override
        public void tick() {
            BlockPos $$0;
            if (!((BlockEntity)this.blockEntity).isRemoved() && ((BlockEntity)this.blockEntity).hasLevel() && this.this$0.isTicking($$0 = ((BlockEntity)this.blockEntity).getBlockPos())) {
                try {
                    ProfilerFiller $$1 = Profiler.get();
                    $$1.push(this::getType);
                    BlockState $$2 = this.this$0.getBlockState($$0);
                    if (((BlockEntity)this.blockEntity).getType().isValid($$2)) {
                        this.ticker.tick(this.this$0.level, ((BlockEntity)this.blockEntity).getBlockPos(), $$2, this.blockEntity);
                        this.loggedInvalidBlockState = false;
                    } else if (!this.loggedInvalidBlockState) {
                        this.loggedInvalidBlockState = true;
                        LOGGER.warn("Block entity {} @ {} state {} invalid for ticking:", new Object[]{LogUtils.defer(this::getType), LogUtils.defer(this::getPos), $$2});
                    }
                    $$1.pop();
                }
                catch (Throwable $$3) {
                    CrashReport $$4 = CrashReport.forThrowable($$3, "Ticking block entity");
                    CrashReportCategory $$5 = $$4.addCategory("Block entity being ticked");
                    ((BlockEntity)this.blockEntity).fillCrashReportCategory($$5);
                    throw new ReportedException($$4);
                }
            }
        }

        @Override
        public boolean isRemoved() {
            return ((BlockEntity)this.blockEntity).isRemoved();
        }

        @Override
        public BlockPos getPos() {
            return ((BlockEntity)this.blockEntity).getBlockPos();
        }

        @Override
        public String getType() {
            return BlockEntityType.getKey(((BlockEntity)this.blockEntity).getType()).toString();
        }

        public String toString() {
            return "Level ticker for " + this.getType() + "@" + String.valueOf(this.getPos());
        }
    }
}

