/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.properties;

import it.unimi.dsi.fastutil.ints.IntImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.world.level.block.state.properties.Property;

public final class IntegerProperty
extends Property<Integer> {
    private final IntImmutableList values;
    private final int min;
    private final int max;

    private IntegerProperty(String p_61623_, int p_61624_, int p_61625_) {
        super(p_61623_, Integer.class);
        if (p_61624_ < 0) {
            throw new IllegalArgumentException("Min value of " + p_61623_ + " must be 0 or greater");
        }
        if (p_61625_ <= p_61624_) {
            throw new IllegalArgumentException("Max value of " + p_61623_ + " must be greater than min (" + p_61624_ + ")");
        }
        this.min = p_61624_;
        this.max = p_61625_;
        this.values = IntImmutableList.toList((IntStream)IntStream.range(p_61624_, p_61625_ + 1));
    }

    @Override
    public List<Integer> getPossibleValues() {
        return this.values;
    }

    @Override
    public boolean equals(Object p_61639_) {
        if (this == p_61639_) {
            return true;
        }
        if (p_61639_ instanceof IntegerProperty) {
            IntegerProperty $$1 = (IntegerProperty)p_61639_;
            if (super.equals(p_61639_)) {
                return this.values.equals($$1.values);
            }
        }
        return false;
    }

    @Override
    public int generateHashCode() {
        return 31 * super.generateHashCode() + this.values.hashCode();
    }

    public static IntegerProperty create(String p_61632_, int p_61633_, int p_61634_) {
        return new IntegerProperty(p_61632_, p_61633_, p_61634_);
    }

    @Override
    public Optional<Integer> getValue(String p_61637_) {
        try {
            int $$1 = Integer.parseInt(p_61637_);
            return $$1 >= this.min && $$1 <= this.max ? Optional.of($$1) : Optional.empty();
        }
        catch (NumberFormatException $$2) {
            return Optional.empty();
        }
    }

    @Override
    public String getName(Integer p_61630_) {
        return p_61630_.toString();
    }

    @Override
    public int getInternalIndex(Integer p_372977_) {
        if (p_372977_ <= this.max) {
            return p_372977_ - this.min;
        }
        return -1;
    }

    @Override
    public /* synthetic */ int getInternalIndex(Comparable comparable) {
        return this.getInternalIndex((Integer)comparable);
    }

    @Override
    public /* synthetic */ String getName(Comparable comparable) {
        return this.getName((Integer)comparable);
    }
}

