/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.TestBlockMode;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.slf4j.Logger;

public class TestBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String DEFAULT_MESSAGE = "";
    private static final boolean DEFAULT_POWERED = false;
    private TestBlockMode mode;
    private String message = "";
    private boolean powered = false;
    private boolean triggered;

    public TestBlockEntity(BlockPos p_397386_, BlockState p_397748_) {
        super(BlockEntityType.TEST_BLOCK, p_397386_, p_397748_);
        this.mode = p_397748_.getValue(TestBlock.MODE);
    }

    @Override
    protected void saveAdditional(ValueOutput p_421533_) {
        p_421533_.store("mode", TestBlockMode.CODEC, this.mode);
        p_421533_.putString("message", this.message);
        p_421533_.putBoolean("powered", this.powered);
    }

    @Override
    protected void loadAdditional(ValueInput p_422212_) {
        this.mode = p_422212_.read("mode", TestBlockMode.CODEC).orElse(TestBlockMode.FAIL);
        this.message = p_422212_.getStringOr("message", DEFAULT_MESSAGE);
        this.powered = p_422212_.getBooleanOr("powered", false);
    }

    private void updateBlockState() {
        if (this.level == null) {
            return;
        }
        BlockPos $$0 = this.getBlockPos();
        BlockState $$1 = this.level.getBlockState($$0);
        if ($$1.is(Blocks.TEST_BLOCK)) {
            this.level.setBlock($$0, (BlockState)$$1.setValue(TestBlock.MODE, this.mode), 2);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider p_397116_) {
        return this.saveCustomOnly(p_397116_);
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void setPowered(boolean p_397669_) {
        this.powered = p_397669_;
    }

    public TestBlockMode getMode() {
        return this.mode;
    }

    public void setMode(TestBlockMode p_397055_) {
        this.mode = p_397055_;
        this.updateBlockState();
    }

    private Block getBlockType() {
        return this.getBlockState().getBlock();
    }

    public void reset() {
        this.triggered = false;
        if (this.mode == TestBlockMode.START && this.level != null) {
            this.setPowered(false);
            this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockType());
        }
    }

    public void trigger() {
        if (this.mode == TestBlockMode.START && this.level != null) {
            this.setPowered(true);
            BlockPos $$0 = this.getBlockPos();
            this.level.updateNeighborsAt($$0, this.getBlockType());
            this.level.getBlockTicks().willTickThisTick($$0, this.getBlockType());
            this.log();
            return;
        }
        if (this.mode == TestBlockMode.LOG) {
            this.log();
        }
        this.triggered = true;
    }

    public void log() {
        if (!this.message.isBlank()) {
            LOGGER.info("Test {} (at {}): {}", new Object[]{this.mode.getSerializedName(), this.getBlockPos(), this.message});
        }
    }

    public boolean hasTriggered() {
        return this.triggered;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String p_398047_) {
        this.message = p_398047_;
    }

    @Nullable
    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

