/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.BoundingBoxRenderable;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class StructureBlockEntity
extends BlockEntity
implements BoundingBoxRenderable {
    private static final int SCAN_CORNER_BLOCKS_RANGE = 5;
    public static final int MAX_OFFSET_PER_AXIS = 48;
    public static final int MAX_SIZE_PER_AXIS = 48;
    public static final String AUTHOR_TAG = "author";
    private static final String DEFAULT_AUTHOR = "";
    private static final String DEFAULT_METADATA = "";
    private static final BlockPos DEFAULT_POS = new BlockPos(0, 1, 0);
    private static final Vec3i DEFAULT_SIZE = Vec3i.ZERO;
    private static final Rotation DEFAULT_ROTATION = Rotation.NONE;
    private static final Mirror DEFAULT_MIRROR = Mirror.NONE;
    private static final boolean DEFAULT_IGNORE_ENTITIES = true;
    private static final boolean DEFAULT_STRICT = false;
    private static final boolean DEFAULT_POWERED = false;
    private static final boolean DEFAULT_SHOW_AIR = false;
    private static final boolean DEFAULT_SHOW_BOUNDING_BOX = true;
    private static final float DEFAULT_INTEGRITY = 1.0f;
    private static final long DEFAULT_SEED = 0L;
    @Nullable
    private ResourceLocation structureName;
    private String author = "";
    private String metaData = "";
    private BlockPos structurePos = DEFAULT_POS;
    private Vec3i structureSize = DEFAULT_SIZE;
    private Mirror mirror = Mirror.NONE;
    private Rotation rotation = Rotation.NONE;
    private StructureMode mode;
    private boolean ignoreEntities = true;
    private boolean strict = false;
    private boolean powered = false;
    private boolean showAir = false;
    private boolean showBoundingBox = true;
    private float integrity = 1.0f;
    private long seed = 0L;

    public StructureBlockEntity(BlockPos p_155779_, BlockState p_155780_) {
        super(BlockEntityType.STRUCTURE_BLOCK, p_155779_, p_155780_);
        this.mode = p_155780_.getValue(StructureBlock.MODE);
    }

    @Override
    protected void saveAdditional(ValueOutput p_422197_) {
        super.saveAdditional(p_422197_);
        p_422197_.putString("name", this.getStructureName());
        p_422197_.putString(AUTHOR_TAG, this.author);
        p_422197_.putString("metadata", this.metaData);
        p_422197_.putInt("posX", this.structurePos.getX());
        p_422197_.putInt("posY", this.structurePos.getY());
        p_422197_.putInt("posZ", this.structurePos.getZ());
        p_422197_.putInt("sizeX", this.structureSize.getX());
        p_422197_.putInt("sizeY", this.structureSize.getY());
        p_422197_.putInt("sizeZ", this.structureSize.getZ());
        p_422197_.store("rotation", Rotation.LEGACY_CODEC, this.rotation);
        p_422197_.store("mirror", Mirror.LEGACY_CODEC, this.mirror);
        p_422197_.store("mode", StructureMode.LEGACY_CODEC, this.mode);
        p_422197_.putBoolean("ignoreEntities", this.ignoreEntities);
        p_422197_.putBoolean("strict", this.strict);
        p_422197_.putBoolean("powered", this.powered);
        p_422197_.putBoolean("showair", this.showAir);
        p_422197_.putBoolean("showboundingbox", this.showBoundingBox);
        p_422197_.putFloat("integrity", this.integrity);
        p_422197_.putLong("seed", this.seed);
    }

    @Override
    protected void loadAdditional(ValueInput p_422679_) {
        super.loadAdditional(p_422679_);
        this.setStructureName(p_422679_.getStringOr("name", ""));
        this.author = p_422679_.getStringOr(AUTHOR_TAG, "");
        this.metaData = p_422679_.getStringOr("metadata", "");
        int $$1 = Mth.clamp(p_422679_.getIntOr("posX", DEFAULT_POS.getX()), -48, 48);
        int $$2 = Mth.clamp(p_422679_.getIntOr("posY", DEFAULT_POS.getY()), -48, 48);
        int $$3 = Mth.clamp(p_422679_.getIntOr("posZ", DEFAULT_POS.getZ()), -48, 48);
        this.structurePos = new BlockPos($$1, $$2, $$3);
        int $$4 = Mth.clamp(p_422679_.getIntOr("sizeX", DEFAULT_SIZE.getX()), 0, 48);
        int $$5 = Mth.clamp(p_422679_.getIntOr("sizeY", DEFAULT_SIZE.getY()), 0, 48);
        int $$6 = Mth.clamp(p_422679_.getIntOr("sizeZ", DEFAULT_SIZE.getZ()), 0, 48);
        this.structureSize = new Vec3i($$4, $$5, $$6);
        this.rotation = p_422679_.read("rotation", Rotation.LEGACY_CODEC).orElse(DEFAULT_ROTATION);
        this.mirror = p_422679_.read("mirror", Mirror.LEGACY_CODEC).orElse(DEFAULT_MIRROR);
        this.mode = p_422679_.read("mode", StructureMode.LEGACY_CODEC).orElse(StructureMode.DATA);
        this.ignoreEntities = p_422679_.getBooleanOr("ignoreEntities", true);
        this.strict = p_422679_.getBooleanOr("strict", false);
        this.powered = p_422679_.getBooleanOr("powered", false);
        this.showAir = p_422679_.getBooleanOr("showair", false);
        this.showBoundingBox = p_422679_.getBooleanOr("showboundingbox", true);
        this.integrity = p_422679_.getFloatOr("integrity", 1.0f);
        this.seed = p_422679_.getLongOr("seed", 0L);
        this.updateBlockState();
    }

    private void updateBlockState() {
        if (this.level == null) {
            return;
        }
        BlockPos $$0 = this.getBlockPos();
        BlockState $$1 = this.level.getBlockState($$0);
        if ($$1.is(Blocks.STRUCTURE_BLOCK)) {
            this.level.setBlock($$0, (BlockState)$$1.setValue(StructureBlock.MODE, this.mode), 2);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider p_324257_) {
        return this.saveCustomOnly(p_324257_);
    }

    public boolean usedBy(Player p_59854_) {
        if (!p_59854_.canUseGameMasterBlocks()) {
            return false;
        }
        if (p_59854_.level().isClientSide) {
            p_59854_.openStructureBlock(this);
        }
        return true;
    }

    public String getStructureName() {
        return this.structureName == null ? "" : this.structureName.toString();
    }

    public boolean hasStructureName() {
        return this.structureName != null;
    }

    public void setStructureName(@Nullable String p_59869_) {
        this.setStructureName(StringUtil.isNullOrEmpty(p_59869_) ? null : ResourceLocation.tryParse(p_59869_));
    }

    public void setStructureName(@Nullable ResourceLocation p_59875_) {
        this.structureName = p_59875_;
    }

    public void createdBy(LivingEntity p_59852_) {
        this.author = p_59852_.getName().getString();
    }

    public BlockPos getStructurePos() {
        return this.structurePos;
    }

    public void setStructurePos(BlockPos p_59886_) {
        this.structurePos = p_59886_;
    }

    public Vec3i getStructureSize() {
        return this.structureSize;
    }

    public void setStructureSize(Vec3i p_155798_) {
        this.structureSize = p_155798_;
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    public void setMirror(Mirror p_59882_) {
        this.mirror = p_59882_;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public void setRotation(Rotation p_59884_) {
        this.rotation = p_59884_;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public void setMetaData(String p_59888_) {
        this.metaData = p_59888_;
    }

    public StructureMode getMode() {
        return this.mode;
    }

    public void setMode(StructureMode p_59861_) {
        this.mode = p_59861_;
        BlockState $$1 = this.level.getBlockState(this.getBlockPos());
        if ($$1.is(Blocks.STRUCTURE_BLOCK)) {
            this.level.setBlock(this.getBlockPos(), (BlockState)$$1.setValue(StructureBlock.MODE, p_59861_), 2);
        }
    }

    public boolean isIgnoreEntities() {
        return this.ignoreEntities;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setIgnoreEntities(boolean p_59877_) {
        this.ignoreEntities = p_59877_;
    }

    public void setStrict(boolean p_393555_) {
        this.strict = p_393555_;
    }

    public float getIntegrity() {
        return this.integrity;
    }

    public void setIntegrity(float p_59839_) {
        this.integrity = p_59839_;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long p_59841_) {
        this.seed = p_59841_;
    }

    public boolean detectSize() {
        if (this.mode != StructureMode.SAVE) {
            return false;
        }
        BlockPos $$0 = this.getBlockPos();
        int $$1 = 80;
        BlockPos $$2 = new BlockPos($$0.getX() - 80, this.level.getMinY(), $$0.getZ() - 80);
        BlockPos $$3 = new BlockPos($$0.getX() + 80, this.level.getMaxY(), $$0.getZ() + 80);
        Stream<BlockPos> $$4 = this.getRelatedCorners($$2, $$3);
        return StructureBlockEntity.calculateEnclosingBoundingBox($$0, $$4).filter(p_155790_ -> {
            int $$2 = p_155790_.maxX() - p_155790_.minX();
            int $$3 = p_155790_.maxY() - p_155790_.minY();
            int $$4 = p_155790_.maxZ() - p_155790_.minZ();
            if ($$2 > 1 && $$3 > 1 && $$4 > 1) {
                this.structurePos = new BlockPos(p_155790_.minX() - $$0.getX() + 1, p_155790_.minY() - $$0.getY() + 1, p_155790_.minZ() - $$0.getZ() + 1);
                this.structureSize = new Vec3i($$2 - 1, $$3 - 1, $$4 - 1);
                this.setChanged();
                BlockState $$5 = this.level.getBlockState($$0);
                this.level.sendBlockUpdated($$0, $$5, $$5, 3);
                return true;
            }
            return false;
        }).isPresent();
    }

    private Stream<BlockPos> getRelatedCorners(BlockPos p_155792_, BlockPos p_155793_) {
        return BlockPos.betweenClosedStream(p_155792_, p_155793_).filter(p_272561_ -> this.level.getBlockState((BlockPos)p_272561_).is(Blocks.STRUCTURE_BLOCK)).map(this.level::getBlockEntity).filter(p_155802_ -> p_155802_ instanceof StructureBlockEntity).map(p_155785_ -> (StructureBlockEntity)p_155785_).filter(p_155787_ -> p_155787_.mode == StructureMode.CORNER && Objects.equals(this.structureName, p_155787_.structureName)).map(BlockEntity::getBlockPos);
    }

    private static Optional<BoundingBox> calculateEnclosingBoundingBox(BlockPos p_155795_, Stream<BlockPos> p_155796_) {
        Iterator $$2 = p_155796_.iterator();
        if (!$$2.hasNext()) {
            return Optional.empty();
        }
        BlockPos $$3 = (BlockPos)$$2.next();
        BoundingBox $$4 = new BoundingBox($$3);
        if ($$2.hasNext()) {
            $$2.forEachRemaining($$4::encapsulate);
        } else {
            $$4.encapsulate(p_155795_);
        }
        return Optional.of($$4);
    }

    public boolean saveStructure() {
        if (this.mode != StructureMode.SAVE) {
            return false;
        }
        return this.saveStructure(true);
    }

    /*
     * WARNING - void declaration
     */
    public boolean saveStructure(boolean p_59890_) {
        void $$2;
        Level level;
        if (this.structureName == null || !((level = this.level) instanceof ServerLevel)) {
            return false;
        }
        ServerLevel $$1 = (ServerLevel)level;
        BlockPos $$3 = this.getBlockPos().offset(this.structurePos);
        return StructureBlockEntity.saveStructure((ServerLevel)$$2, this.structureName, $$3, this.structureSize, this.ignoreEntities, this.author, p_59890_, List.of());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean saveStructure(ServerLevel p_396983_, ResourceLocation p_397437_, BlockPos p_397750_, Vec3i p_397557_, boolean p_397306_, String p_397604_, boolean p_397822_, List<Block> p_428567_) {
        void $$11;
        StructureTemplateManager $$8 = p_396983_.getStructureManager();
        try {
            StructureTemplate $$9 = $$8.getOrCreate(p_397437_);
        }
        catch (ResourceLocationException $$10) {
            return false;
        }
        $$11.fillFromWorld(p_396983_, p_397750_, p_397557_, !p_397306_, Stream.concat(p_428567_.stream(), Stream.of(Blocks.STRUCTURE_VOID)).toList());
        $$11.setAuthor(p_397604_);
        if (p_397822_) {
            try {
                return $$8.save(p_397437_);
            }
            catch (ResourceLocationException $$12) {
                return false;
            }
        }
        return true;
    }

    public static RandomSource createRandom(long p_222889_) {
        if (p_222889_ == 0L) {
            return RandomSource.create(Util.getMillis());
        }
        return RandomSource.create(p_222889_);
    }

    public boolean placeStructureIfSameSize(ServerLevel p_309647_) {
        if (this.mode != StructureMode.LOAD || this.structureName == null) {
            return false;
        }
        StructureTemplate $$1 = p_309647_.getStructureManager().get(this.structureName).orElse(null);
        if ($$1 == null) {
            return false;
        }
        if ($$1.getSize().equals(this.structureSize)) {
            this.placeStructure(p_309647_, $$1);
            return true;
        }
        this.loadStructureInfo($$1);
        return false;
    }

    public boolean loadStructureInfo(ServerLevel p_309683_) {
        StructureTemplate $$1 = this.getStructureTemplate(p_309683_);
        if ($$1 == null) {
            return false;
        }
        this.loadStructureInfo($$1);
        return true;
    }

    private void loadStructureInfo(StructureTemplate p_309715_) {
        this.author = !StringUtil.isNullOrEmpty(p_309715_.getAuthor()) ? p_309715_.getAuthor() : "";
        this.structureSize = p_309715_.getSize();
        this.setChanged();
    }

    public void placeStructure(ServerLevel p_309543_) {
        StructureTemplate $$1 = this.getStructureTemplate(p_309543_);
        if ($$1 != null) {
            this.placeStructure(p_309543_, $$1);
        }
    }

    @Nullable
    private StructureTemplate getStructureTemplate(ServerLevel p_309601_) {
        if (this.structureName == null) {
            return null;
        }
        return p_309601_.getStructureManager().get(this.structureName).orElse(null);
    }

    private void placeStructure(ServerLevel p_309691_, StructureTemplate p_309550_) {
        this.loadStructureInfo(p_309550_);
        StructurePlaceSettings $$2 = new StructurePlaceSettings().setMirror(this.mirror).setRotation(this.rotation).setIgnoreEntities(this.ignoreEntities).setKnownShape(this.strict);
        if (this.integrity < 1.0f) {
            $$2.clearProcessors().addProcessor(new BlockRotProcessor(Mth.clamp(this.integrity, 0.0f, 1.0f))).setRandom(StructureBlockEntity.createRandom(this.seed));
        }
        BlockPos $$3 = this.getBlockPos().offset(this.structurePos);
        p_309550_.placeInWorld(p_309691_, $$3, $$3, $$2, StructureBlockEntity.createRandom(this.seed), 2 | (this.strict ? 816 : 0));
    }

    public void unloadStructure() {
        if (this.structureName == null) {
            return;
        }
        ServerLevel $$0 = (ServerLevel)this.level;
        StructureTemplateManager $$1 = $$0.getStructureManager();
        $$1.remove(this.structureName);
    }

    public boolean isStructureLoadable() {
        if (this.mode != StructureMode.LOAD || this.level.isClientSide || this.structureName == null) {
            return false;
        }
        ServerLevel $$0 = (ServerLevel)this.level;
        StructureTemplateManager $$1 = $$0.getStructureManager();
        try {
            return $$1.get(this.structureName).isPresent();
        }
        catch (ResourceLocationException $$2) {
            return false;
        }
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void setPowered(boolean p_59894_) {
        this.powered = p_59894_;
    }

    public boolean getShowAir() {
        return this.showAir;
    }

    public void setShowAir(boolean p_59897_) {
        this.showAir = p_59897_;
    }

    public boolean getShowBoundingBox() {
        return this.showBoundingBox;
    }

    public void setShowBoundingBox(boolean p_59899_) {
        this.showBoundingBox = p_59899_;
    }

    @Override
    public BoundingBoxRenderable.Mode renderMode() {
        if (this.mode != StructureMode.SAVE && this.mode != StructureMode.LOAD) {
            return BoundingBoxRenderable.Mode.NONE;
        }
        if (this.mode == StructureMode.SAVE && this.showAir) {
            return BoundingBoxRenderable.Mode.BOX_AND_INVISIBLE_BLOCKS;
        }
        if (this.mode == StructureMode.SAVE || this.showBoundingBox) {
            return BoundingBoxRenderable.Mode.BOX;
        }
        return BoundingBoxRenderable.Mode.NONE;
    }

    @Override
    public BoundingBoxRenderable.RenderableBox getRenderableBox() {
        int $$27;
        int $$26;
        int $$25;
        int $$24;
        int $$11;
        int $$10;
        BlockPos $$0 = this.getStructurePos();
        Vec3i $$1 = this.getStructureSize();
        int $$2 = $$0.getX();
        int $$3 = $$0.getZ();
        int $$4 = $$0.getY();
        int $$5 = $$4 + $$1.getY();
        switch (this.mirror) {
            case LEFT_RIGHT: {
                int $$6 = $$1.getX();
                int $$7 = -$$1.getZ();
                break;
            }
            case FRONT_BACK: {
                int $$8 = -$$1.getX();
                int $$9 = $$1.getZ();
                break;
            }
            default: {
                $$10 = $$1.getX();
                $$11 = $$1.getZ();
            }
        }
        switch (this.rotation) {
            case CLOCKWISE_90: {
                int $$12 = $$11 < 0 ? $$2 : $$2 + 1;
                int $$13 = $$10 < 0 ? $$3 + 1 : $$3;
                int $$14 = $$12 - $$11;
                int $$15 = $$13 + $$10;
                break;
            }
            case CLOCKWISE_180: {
                int $$16 = $$10 < 0 ? $$2 : $$2 + 1;
                int $$17 = $$11 < 0 ? $$3 : $$3 + 1;
                int $$18 = $$16 - $$10;
                int $$19 = $$17 - $$11;
                break;
            }
            case COUNTERCLOCKWISE_90: {
                int $$20 = $$11 < 0 ? $$2 + 1 : $$2;
                int $$21 = $$10 < 0 ? $$3 : $$3 + 1;
                int $$22 = $$20 + $$11;
                int $$23 = $$21 - $$10;
                break;
            }
            default: {
                $$24 = $$10 < 0 ? $$2 + 1 : $$2;
                $$25 = $$11 < 0 ? $$3 + 1 : $$3;
                $$26 = $$24 + $$10;
                $$27 = $$25 + $$11;
            }
        }
        return BoundingBoxRenderable.RenderableBox.fromCorners($$24, $$4, $$25, $$26, $$5, $$27);
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }

    private static /* synthetic */ void lambda$placeStructure$5(ServerLevel p_155782_, BlockPos p_155783_) {
        p_155782_.setBlock(p_155783_, Blocks.STRUCTURE_VOID.defaultBlockState(), 2);
    }

    public static enum UpdateType {
        UPDATE_DATA,
        SAVE_AREA,
        LOAD_AREA,
        SCAN_AREA;

    }
}

