/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;

public class SignText {
    private static final Codec<Component[]> LINES_CODEC = ComponentSerialization.CODEC.listOf().comapFlatMap(p_337999_ -> {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }, p_277460_ -> List.of(p_277460_[0], p_277460_[1], p_277460_[2], p_277460_[3]));
    public static final Codec<SignText> DIRECT_CODEC = RecordCodecBuilder.create(p_338000_ -> p_338000_.group((App)LINES_CODEC.fieldOf("messages").forGetter(p_277822_ -> p_277822_.messages), (App)LINES_CODEC.lenientOptionalFieldOf("filtered_messages").forGetter(SignText::filteredMessages), (App)DyeColor.CODEC.fieldOf("color").orElse((Object)DyeColor.BLACK).forGetter(p_277343_ -> p_277343_.color), (App)Codec.BOOL.fieldOf("has_glowing_text").orElse((Object)false).forGetter(p_277555_ -> p_277555_.hasGlowingText)).apply((Applicative)p_338000_, SignText::load));
    public static final int LINES = 4;
    private final Component[] messages;
    private final Component[] filteredMessages;
    private final DyeColor color;
    private final boolean hasGlowingText;
    @Nullable
    private FormattedCharSequence[] renderMessages;
    private boolean renderMessagedFiltered;

    public SignText() {
        this(SignText.emptyMessages(), SignText.emptyMessages(), DyeColor.BLACK, false);
    }

    public SignText(Component[] p_277506_, Component[] p_277908_, DyeColor p_277883_, boolean p_278091_) {
        this.messages = p_277506_;
        this.filteredMessages = p_277908_;
        this.color = p_277883_;
        this.hasGlowingText = p_278091_;
    }

    private static Component[] emptyMessages() {
        return new Component[]{CommonComponents.EMPTY, CommonComponents.EMPTY, CommonComponents.EMPTY, CommonComponents.EMPTY};
    }

    private static SignText load(Component[] p_277661_, Optional<Component[]> p_277768_, DyeColor p_277345_, boolean p_278008_) {
        return new SignText(p_277661_, p_277768_.orElse(Arrays.copyOf(p_277661_, p_277661_.length)), p_277345_, p_278008_);
    }

    public boolean hasGlowingText() {
        return this.hasGlowingText;
    }

    public SignText setHasGlowingText(boolean p_277953_) {
        if (p_277953_ == this.hasGlowingText) {
            return this;
        }
        return new SignText(this.messages, this.filteredMessages, this.color, p_277953_);
    }

    public DyeColor getColor() {
        return this.color;
    }

    public SignText setColor(DyeColor p_277507_) {
        if (p_277507_ == this.getColor()) {
            return this;
        }
        return new SignText(this.messages, this.filteredMessages, p_277507_, this.hasGlowingText);
    }

    public Component getMessage(int p_277404_, boolean p_278108_) {
        return this.getMessages(p_278108_)[p_277404_];
    }

    public SignText setMessage(int p_277878_, Component p_277360_) {
        return this.setMessage(p_277878_, p_277360_, p_277360_);
    }

    public SignText setMessage(int p_277690_, Component p_277852_, Component p_277564_) {
        Component[] $$3 = Arrays.copyOf(this.messages, this.messages.length);
        Component[] $$4 = Arrays.copyOf(this.filteredMessages, this.filteredMessages.length);
        $$3[p_277690_] = p_277852_;
        $$4[p_277690_] = p_277564_;
        return new SignText($$3, $$4, this.color, this.hasGlowingText);
    }

    public boolean hasMessage(Player p_277764_) {
        return Arrays.stream(this.getMessages(p_277764_.isTextFilteringEnabled())).anyMatch(p_277499_ -> !p_277499_.getString().isEmpty());
    }

    public Component[] getMessages(boolean p_277992_) {
        return p_277992_ ? this.filteredMessages : this.messages;
    }

    public FormattedCharSequence[] getRenderMessages(boolean p_277336_, Function<Component, FormattedCharSequence> p_277538_) {
        if (this.renderMessages == null || this.renderMessagedFiltered != p_277336_) {
            this.renderMessagedFiltered = p_277336_;
            this.renderMessages = new FormattedCharSequence[4];
            for (int $$2 = 0; $$2 < 4; ++$$2) {
                this.renderMessages[$$2] = p_277538_.apply(this.getMessage($$2, p_277336_));
            }
        }
        return this.renderMessages;
    }

    private Optional<Component[]> filteredMessages() {
        for (int $$0 = 0; $$0 < 4; ++$$0) {
            if (this.filteredMessages[$$0].equals(this.messages[$$0])) continue;
            return Optional.of(this.filteredMessages);
        }
        return Optional.empty();
    }

    public boolean hasAnyClickCommands(Player p_277865_) {
        for (Component $$1 : this.getMessages(p_277865_.isTextFilteringEnabled())) {
            Style $$2 = $$1.getStyle();
            ClickEvent $$3 = $$2.getClickEvent();
            if ($$3 == null || $$3.action() != ClickEvent.Action.RUN_COMMAND) continue;
            return true;
        }
        return false;
    }
}

