/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.slf4j.Logger;

public abstract class BlockEntity {
    private static final Codec<BlockEntityType<?>> TYPE_CODEC = BuiltInRegistries.BLOCK_ENTITY_TYPE.byNameCodec();
    private static final Logger LOGGER = LogUtils.getLogger();
    private final BlockEntityType<?> type;
    @Nullable
    protected Level level;
    protected final BlockPos worldPosition;
    protected boolean remove;
    private BlockState blockState;
    private DataComponentMap components = DataComponentMap.EMPTY;

    public BlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        this.type = p_155228_;
        this.worldPosition = p_155229_.immutable();
        this.validateBlockState(p_155230_);
        this.blockState = p_155230_;
    }

    private void validateBlockState(BlockState p_353132_) {
        if (!this.isValidBlockState(p_353132_)) {
            throw new IllegalStateException("Invalid block entity " + this.getNameForReporting() + " state at " + String.valueOf(this.worldPosition) + ", got " + String.valueOf(p_353132_));
        }
    }

    public boolean isValidBlockState(BlockState p_353131_) {
        return this.type.isValid(p_353131_);
    }

    public static BlockPos getPosFromTag(ChunkPos p_412201_, CompoundTag p_187473_) {
        int $$2 = p_187473_.getIntOr("x", 0);
        int $$3 = p_187473_.getIntOr("y", 0);
        int $$4 = p_187473_.getIntOr("z", 0);
        int $$5 = SectionPos.blockToSectionCoord($$2);
        int $$6 = SectionPos.blockToSectionCoord($$4);
        if ($$5 != p_412201_.x || $$6 != p_412201_.z) {
            LOGGER.warn("Block entity {} found in a wrong chunk, expected position from chunk {}", (Object)p_187473_, (Object)p_412201_);
            $$2 = p_412201_.getBlockX(SectionPos.sectionRelative($$2));
            $$4 = p_412201_.getBlockZ(SectionPos.sectionRelative($$4));
        }
        return new BlockPos($$2, $$3, $$4);
    }

    @Nullable
    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level p_155231_) {
        this.level = p_155231_;
    }

    public boolean hasLevel() {
        return this.level != null;
    }

    protected void loadAdditional(ValueInput p_422607_) {
    }

    public final void loadWithComponents(ValueInput p_422624_) {
        this.loadAdditional(p_422624_);
        this.components = p_422624_.read("components", DataComponentMap.CODEC).orElse(DataComponentMap.EMPTY);
    }

    public final void loadCustomOnly(ValueInput p_422425_) {
        this.loadAdditional(p_422425_);
    }

    protected void saveAdditional(ValueOutput p_422639_) {
    }

    public final CompoundTag saveWithFullMetadata(HolderLookup.Provider p_323767_) {
        try (ProblemReporter.ScopedCollector $$1 = new ProblemReporter.ScopedCollector(this.problemPath(), LOGGER);){
            TagValueOutput $$2 = TagValueOutput.createWithContext($$1, p_323767_);
            this.saveWithFullMetadata($$2);
            CompoundTag compoundTag = $$2.buildResult();
            return compoundTag;
        }
    }

    public void saveWithFullMetadata(ValueOutput p_422554_) {
        this.saveWithoutMetadata(p_422554_);
        this.saveMetadata(p_422554_);
    }

    public void saveWithId(ValueOutput p_421636_) {
        this.saveWithoutMetadata(p_421636_);
        this.saveId(p_421636_);
    }

    public final CompoundTag saveWithoutMetadata(HolderLookup.Provider p_324030_) {
        try (ProblemReporter.ScopedCollector $$1 = new ProblemReporter.ScopedCollector(this.problemPath(), LOGGER);){
            TagValueOutput $$2 = TagValueOutput.createWithContext($$1, p_324030_);
            this.saveWithoutMetadata($$2);
            CompoundTag compoundTag = $$2.buildResult();
            return compoundTag;
        }
    }

    public void saveWithoutMetadata(ValueOutput p_422668_) {
        this.saveAdditional(p_422668_);
        p_422668_.store("components", DataComponentMap.CODEC, this.components);
    }

    public final CompoundTag saveCustomOnly(HolderLookup.Provider p_338656_) {
        try (ProblemReporter.ScopedCollector $$1 = new ProblemReporter.ScopedCollector(this.problemPath(), LOGGER);){
            TagValueOutput $$2 = TagValueOutput.createWithContext($$1, p_338656_);
            this.saveCustomOnly($$2);
            CompoundTag compoundTag = $$2.buildResult();
            return compoundTag;
        }
    }

    public void saveCustomOnly(ValueOutput p_422286_) {
        this.saveAdditional(p_422286_);
    }

    private void saveId(ValueOutput p_422237_) {
        BlockEntity.addEntityType(p_422237_, this.getType());
    }

    public static void addEntityType(ValueOutput p_422078_, BlockEntityType<?> p_187470_) {
        p_422078_.store("id", TYPE_CODEC, p_187470_);
    }

    private void saveMetadata(ValueOutput p_422642_) {
        this.saveId(p_422642_);
        p_422642_.putInt("x", this.worldPosition.getX());
        p_422642_.putInt("y", this.worldPosition.getY());
        p_422642_.putInt("z", this.worldPosition.getZ());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static BlockEntity loadStatic(BlockPos p_155242_, BlockState p_155243_, CompoundTag p_155244_, HolderLookup.Provider p_323542_) {
        void $$7;
        BlockEntityType $$4 = p_155244_.read("id", TYPE_CODEC).orElse(null);
        if ($$4 == null) {
            LOGGER.error("Skipping block entity with invalid type: {}", (Object)p_155244_.get("id"));
            return null;
        }
        try {
            Object $$5 = $$4.create(p_155242_, p_155243_);
        }
        catch (Throwable $$6) {
            LOGGER.error("Failed to create block entity {} for block {} at position {} ", new Object[]{$$4, p_155242_, p_155243_, $$6});
            return null;
        }
        ProblemReporter.ScopedCollector $$8 = new ProblemReporter.ScopedCollector($$7.problemPath(), LOGGER);
        try {
            $$7.loadWithComponents(TagValueInput.create((ProblemReporter)$$8, p_323542_, p_155244_));
            void var7_9 = $$7;
            $$8.close();
            return var7_9;
        }
        catch (Throwable throwable) {
            try {
                try {
                    $$8.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable $$9) {
                LOGGER.error("Failed to load data for block entity {} for block {} at position {}", new Object[]{$$4, p_155242_, p_155243_, $$9});
                return null;
            }
        }
    }

    public void setChanged() {
        if (this.level != null) {
            BlockEntity.setChanged(this.level, this.worldPosition, this.blockState);
        }
    }

    protected static void setChanged(Level p_155233_, BlockPos p_155234_, BlockState p_155235_) {
        p_155233_.blockEntityChanged(p_155234_);
        if (!p_155235_.isAir()) {
            p_155233_.updateNeighbourForOutputSignal(p_155234_, p_155235_.getBlock());
        }
    }

    public BlockPos getBlockPos() {
        return this.worldPosition;
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return null;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider p_323910_) {
        return new CompoundTag();
    }

    public boolean isRemoved() {
        return this.remove;
    }

    public void setRemoved() {
        this.remove = true;
    }

    public void clearRemoved() {
        this.remove = false;
    }

    public void preRemoveSideEffects(BlockPos p_394577_, BlockState p_394161_) {
        BlockEntity blockEntity = this;
        if (blockEntity instanceof Container) {
            Container $$2 = (Container)((Object)blockEntity);
            if (this.level != null) {
                Containers.dropContents(this.level, p_394577_, $$2);
            }
        }
    }

    public boolean triggerEvent(int p_58889_, int p_58890_) {
        return false;
    }

    public void fillCrashReportCategory(CrashReportCategory p_58887_) {
        p_58887_.setDetail("Name", this::getNameForReporting);
        p_58887_.setDetail("Cached block", this.getBlockState()::toString);
        if (this.level == null) {
            p_58887_.setDetail("Block location", () -> String.valueOf(this.worldPosition) + " (world missing)");
        } else {
            p_58887_.setDetail("Actual block", this.level.getBlockState(this.worldPosition)::toString);
            CrashReportCategory.populateBlockLocationDetails(p_58887_, this.level, this.worldPosition);
        }
    }

    public String getNameForReporting() {
        return String.valueOf(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(this.getType())) + " // " + this.getClass().getCanonicalName();
    }

    public BlockEntityType<?> getType() {
        return this.type;
    }

    @Deprecated
    public void setBlockState(BlockState p_155251_) {
        this.validateBlockState(p_155251_);
        this.blockState = p_155251_;
    }

    protected void applyImplicitComponents(DataComponentGetter p_397929_) {
    }

    public final void applyComponentsFromItemStack(ItemStack p_338428_) {
        this.applyComponents(p_338428_.getPrototype(), p_338428_.getComponentsPatch());
    }

    public final void applyComponents(DataComponentMap p_330364_, DataComponentPatch p_338381_) {
        final HashSet<DataComponentType<Object>> $$2 = new HashSet<DataComponentType<Object>>();
        $$2.add(DataComponents.BLOCK_ENTITY_DATA);
        $$2.add(DataComponents.BLOCK_STATE);
        final PatchedDataComponentMap $$3 = PatchedDataComponentMap.fromPatch(p_330364_, p_338381_);
        this.applyImplicitComponents(new DataComponentGetter(){

            @Override
            @Nullable
            public <T> T get(DataComponentType<? extends T> p_338266_) {
                $$2.add(p_338266_);
                return $$3.get(p_338266_);
            }

            @Override
            public <T> T getOrDefault(DataComponentType<? extends T> p_338358_, T p_338352_) {
                $$2.add(p_338358_);
                return $$3.getOrDefault(p_338358_, p_338352_);
            }
        });
        DataComponentPatch $$4 = p_338381_.forget($$2::contains);
        this.components = $$4.split().added();
    }

    protected void collectImplicitComponents(DataComponentMap.Builder p_338210_) {
    }

    @Deprecated
    public void removeComponentsFromTag(ValueOutput p_422208_) {
    }

    public final DataComponentMap collectComponents() {
        DataComponentMap.Builder $$0 = DataComponentMap.builder();
        $$0.addAll(this.components);
        this.collectImplicitComponents($$0);
        return $$0.build();
    }

    public DataComponentMap components() {
        return this.components;
    }

    public void setComponents(DataComponentMap p_338529_) {
        this.components = p_338529_;
    }

    @Nullable
    public static Component parseCustomNameSafe(ValueInput p_422468_, String p_422388_) {
        return p_422468_.read(p_422388_, ComponentSerialization.CODEC).orElse(null);
    }

    public ProblemReporter.PathElement problemPath() {
        return new BlockEntityPathElement(this);
    }

    record BlockEntityPathElement(BlockEntity blockEntity) implements ProblemReporter.PathElement
    {
        @Override
        public String get() {
            return this.blockEntity.getNameForReporting() + "@" + String.valueOf(this.blockEntity.getBlockPos());
        }
    }
}

