/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TrapDoorBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<TrapDoorBlock> CODEC = RecordCodecBuilder.mapCodec(p_368443_ -> p_368443_.group((App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(p_304735_ -> p_304735_.type), TrapDoorBlock.propertiesCodec()).apply((Applicative)p_368443_, TrapDoorBlock::new));
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final Map<Direction, VoxelShape> SHAPES = Shapes.rotateAll(Block.boxZ(16.0, 13.0, 16.0));
    private final BlockSetType type;

    public MapCodec<? extends TrapDoorBlock> codec() {
        return CODEC;
    }

    protected TrapDoorBlock(BlockSetType p_272964_, BlockBehaviour.Properties p_273079_) {
        super(p_273079_.sound(p_272964_.soundType()));
        this.type = p_272964_;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(OPEN, false)).setValue(HALF, Half.BOTTOM)).setValue(POWERED, false)).setValue(WATERLOGGED, false));
    }

    @Override
    protected VoxelShape getShape(BlockState p_57563_, BlockGetter p_57564_, BlockPos p_57565_, CollisionContext p_57566_) {
        return SHAPES.get(p_57563_.getValue(OPEN) != false ? p_57563_.getValue(FACING) : (p_57563_.getValue(HALF) == Half.TOP ? Direction.DOWN : Direction.UP));
    }

    @Override
    protected boolean isPathfindable(BlockState p_57535_, PathComputationType p_57538_) {
        switch (p_57538_) {
            case LAND: {
                return p_57535_.getValue(OPEN);
            }
            case WATER: {
                return p_57535_.getValue(WATERLOGGED);
            }
            case AIR: {
                return p_57535_.getValue(OPEN);
            }
        }
        return false;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState p_57540_, Level p_57541_, BlockPos p_57542_, Player p_57543_, BlockHitResult p_57545_) {
        if (!this.type.canOpenByHand()) {
            return InteractionResult.PASS;
        }
        this.toggle(p_57540_, p_57541_, p_57542_, p_57543_);
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void onExplosionHit(BlockState p_312371_, ServerLevel p_360483_, BlockPos p_312879_, Explosion p_312330_, BiConsumer<ItemStack, BlockPos> p_312161_) {
        if (p_312330_.canTriggerBlocks() && this.type.canOpenByWindCharge() && !p_312371_.getValue(POWERED).booleanValue()) {
            this.toggle(p_312371_, p_360483_, p_312879_, null);
        }
        super.onExplosionHit(p_312371_, p_360483_, p_312879_, p_312330_, p_312161_);
    }

    private void toggle(BlockState p_312094_, Level p_312235_, BlockPos p_312619_, @Nullable Player p_312853_) {
        BlockState $$4 = (BlockState)p_312094_.cycle(OPEN);
        p_312235_.setBlock(p_312619_, $$4, 2);
        if ($$4.getValue(WATERLOGGED).booleanValue()) {
            p_312235_.scheduleTick(p_312619_, Fluids.WATER, Fluids.WATER.getTickDelay(p_312235_));
        }
        this.playSound(p_312853_, p_312235_, p_312619_, $$4.getValue(OPEN));
    }

    protected void playSound(@Nullable Player p_57528_, Level p_57529_, BlockPos p_57530_, boolean p_57531_) {
        p_57529_.playSound((Entity)p_57528_, p_57530_, p_57531_ ? this.type.trapdoorOpen() : this.type.trapdoorClose(), SoundSource.BLOCKS, 1.0f, p_57529_.getRandom().nextFloat() * 0.1f + 0.9f);
        p_57529_.gameEvent((Entity)p_57528_, p_57531_ ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, p_57530_);
    }

    @Override
    protected void neighborChanged(BlockState p_57547_, Level p_57548_, BlockPos p_57549_, Block p_57550_, @Nullable Orientation p_364404_, boolean p_57552_) {
        if (p_57548_.isClientSide) {
            return;
        }
        boolean $$6 = p_57548_.hasNeighborSignal(p_57549_);
        if ($$6 != p_57547_.getValue(POWERED)) {
            if (p_57547_.getValue(OPEN) != $$6) {
                p_57547_ = (BlockState)p_57547_.setValue(OPEN, $$6);
                this.playSound(null, p_57548_, p_57549_, $$6);
            }
            p_57548_.setBlock(p_57549_, (BlockState)p_57547_.setValue(POWERED, $$6), 2);
            if (p_57547_.getValue(WATERLOGGED).booleanValue()) {
                p_57548_.scheduleTick(p_57549_, Fluids.WATER, Fluids.WATER.getTickDelay(p_57548_));
            }
        }
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext p_57533_) {
        BlockState $$1 = this.defaultBlockState();
        FluidState $$2 = p_57533_.getLevel().getFluidState(p_57533_.getClickedPos());
        Direction $$3 = p_57533_.getClickedFace();
        $$1 = p_57533_.replacingClickedOnBlock() || !$$3.getAxis().isHorizontal() ? (BlockState)((BlockState)$$1.setValue(FACING, p_57533_.getHorizontalDirection().getOpposite())).setValue(HALF, $$3 == Direction.UP ? Half.BOTTOM : Half.TOP) : (BlockState)((BlockState)$$1.setValue(FACING, $$3)).setValue(HALF, p_57533_.getClickLocation().y - (double)p_57533_.getClickedPos().getY() > 0.5 ? Half.TOP : Half.BOTTOM);
        if (p_57533_.getLevel().hasNeighborSignal(p_57533_.getClickedPos())) {
            $$1 = (BlockState)((BlockState)$$1.setValue(OPEN, true)).setValue(POWERED, true);
        }
        return (BlockState)$$1.setValue(WATERLOGGED, $$2.getType() == Fluids.WATER);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_57561_) {
        p_57561_.add(FACING, OPEN, HALF, POWERED, WATERLOGGED);
    }

    @Override
    protected FluidState getFluidState(BlockState p_57568_) {
        if (p_57568_.getValue(WATERLOGGED).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(p_57568_);
    }

    @Override
    protected BlockState updateShape(BlockState p_57554_, LevelReader p_374386_, ScheduledTickAccess p_374038_, BlockPos p_57558_, Direction p_57555_, BlockPos p_57559_, BlockState p_57556_, RandomSource p_374093_) {
        if (p_57554_.getValue(WATERLOGGED).booleanValue()) {
            p_374038_.scheduleTick(p_57558_, Fluids.WATER, Fluids.WATER.getTickDelay(p_374386_));
        }
        return super.updateShape(p_57554_, p_374386_, p_374038_, p_57558_, p_57555_, p_57559_, p_57556_, p_374093_);
    }

    protected BlockSetType getType() {
        return this.type;
    }
}

