/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.redstone.Orientation;

public class SpongeBlock
extends Block {
    public static final MapCodec<SpongeBlock> CODEC = SpongeBlock.simpleCodec(SpongeBlock::new);
    public static final int MAX_DEPTH = 6;
    public static final int MAX_COUNT = 64;
    private static final Direction[] ALL_DIRECTIONS = Direction.values();

    public MapCodec<SpongeBlock> codec() {
        return CODEC;
    }

    protected SpongeBlock(BlockBehaviour.Properties p_56796_) {
        super(p_56796_);
    }

    @Override
    protected void onPlace(BlockState p_56811_, Level p_56812_, BlockPos p_56813_, BlockState p_56814_, boolean p_56815_) {
        if (p_56814_.is(p_56811_.getBlock())) {
            return;
        }
        this.tryAbsorbWater(p_56812_, p_56813_);
    }

    @Override
    protected void neighborChanged(BlockState p_56801_, Level p_56802_, BlockPos p_56803_, Block p_56804_, @Nullable Orientation p_364278_, boolean p_56806_) {
        this.tryAbsorbWater(p_56802_, p_56803_);
        super.neighborChanged(p_56801_, p_56802_, p_56803_, p_56804_, p_364278_, p_56806_);
    }

    protected void tryAbsorbWater(Level p_56798_, BlockPos p_56799_) {
        if (this.removeWaterBreadthFirstSearch(p_56798_, p_56799_)) {
            p_56798_.setBlock(p_56799_, Blocks.WET_SPONGE.defaultBlockState(), 2);
            p_56798_.playSound(null, p_56799_, SoundEvents.SPONGE_ABSORB, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private boolean removeWaterBreadthFirstSearch(Level p_56808_, BlockPos p_56809_) {
        return BlockPos.breadthFirstTraversal(p_56809_, 6, 65, (p_277519_, p_277492_) -> {
            for (Direction $$2 : ALL_DIRECTIONS) {
                p_277492_.accept(p_277519_.relative($$2));
            }
        }, p_294069_ -> {
            BucketPickup $$6;
            if (p_294069_.equals(p_56809_)) {
                return BlockPos.TraversalNodeStatus.ACCEPT;
            }
            BlockState $$3 = p_56808_.getBlockState((BlockPos)p_294069_);
            FluidState $$4 = p_56808_.getFluidState((BlockPos)p_294069_);
            if (!$$4.is(FluidTags.WATER)) {
                return BlockPos.TraversalNodeStatus.SKIP;
            }
            Block $$5 = $$3.getBlock();
            if ($$5 instanceof BucketPickup && !($$6 = (BucketPickup)((Object)$$5)).pickupBlock(null, p_56808_, (BlockPos)p_294069_, $$3).isEmpty()) {
                return BlockPos.TraversalNodeStatus.ACCEPT;
            }
            if ($$3.getBlock() instanceof LiquidBlock) {
                p_56808_.setBlock((BlockPos)p_294069_, Blocks.AIR.defaultBlockState(), 3);
            } else if ($$3.is(Blocks.KELP) || $$3.is(Blocks.KELP_PLANT) || $$3.is(Blocks.SEAGRASS) || $$3.is(Blocks.TALL_SEAGRASS)) {
                BlockEntity $$7 = $$3.hasBlockEntity() ? p_56808_.getBlockEntity((BlockPos)p_294069_) : null;
                SpongeBlock.dropResources($$3, p_56808_, p_294069_, $$7);
                p_56808_.setBlock((BlockPos)p_294069_, Blocks.AIR.defaultBlockState(), 3);
            } else {
                return BlockPos.TraversalNodeStatus.SKIP;
            }
            return BlockPos.TraversalNodeStatus.ACCEPT;
        }) > 1;
    }
}

