/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.phys.BlockHitResult;

public class RepeaterBlock
extends DiodeBlock {
    public static final MapCodec<RepeaterBlock> CODEC = RepeaterBlock.simpleCodec(RepeaterBlock::new);
    public static final BooleanProperty LOCKED = BlockStateProperties.LOCKED;
    public static final IntegerProperty DELAY = BlockStateProperties.DELAY;

    public MapCodec<RepeaterBlock> codec() {
        return CODEC;
    }

    protected RepeaterBlock(BlockBehaviour.Properties p_55801_) {
        super(p_55801_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(DELAY, 1)).setValue(LOCKED, false)).setValue(POWERED, false));
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState p_55809_, Level p_55810_, BlockPos p_55811_, Player p_55812_, BlockHitResult p_55814_) {
        if (!p_55812_.getAbilities().mayBuild) {
            return InteractionResult.PASS;
        }
        p_55810_.setBlock(p_55811_, (BlockState)p_55809_.cycle(DELAY), 3);
        return InteractionResult.SUCCESS;
    }

    @Override
    protected int getDelay(BlockState p_55830_) {
        return p_55830_.getValue(DELAY) * 2;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext p_55803_) {
        BlockState $$1 = super.getStateForPlacement(p_55803_);
        return (BlockState)$$1.setValue(LOCKED, this.isLocked(p_55803_.getLevel(), p_55803_.getClickedPos(), $$1));
    }

    @Override
    protected BlockState updateShape(BlockState p_55821_, LevelReader p_374255_, ScheduledTickAccess p_374035_, BlockPos p_55825_, Direction p_55822_, BlockPos p_55826_, BlockState p_55823_, RandomSource p_374140_) {
        if (p_55822_ == Direction.DOWN && !this.canSurviveOn(p_374255_, p_55826_, p_55823_)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (!p_374255_.isClientSide() && p_55822_.getAxis() != ((Direction)p_55821_.getValue(FACING)).getAxis()) {
            return (BlockState)p_55821_.setValue(LOCKED, this.isLocked(p_374255_, p_55825_, p_55821_));
        }
        return super.updateShape(p_55821_, p_374255_, p_374035_, p_55825_, p_55822_, p_55826_, p_55823_, p_374140_);
    }

    @Override
    public boolean isLocked(LevelReader p_55805_, BlockPos p_55806_, BlockState p_55807_) {
        return this.getAlternateSignal(p_55805_, p_55806_, p_55807_) > 0;
    }

    @Override
    protected boolean sideInputDiodesOnly() {
        return true;
    }

    @Override
    public void animateTick(BlockState p_221964_, Level p_221965_, BlockPos p_221966_, RandomSource p_221967_) {
        if (!p_221964_.getValue(POWERED).booleanValue()) {
            return;
        }
        Direction $$4 = (Direction)p_221964_.getValue(FACING);
        double $$5 = (double)p_221966_.getX() + 0.5 + (p_221967_.nextDouble() - 0.5) * 0.2;
        double $$6 = (double)p_221966_.getY() + 0.4 + (p_221967_.nextDouble() - 0.5) * 0.2;
        double $$7 = (double)p_221966_.getZ() + 0.5 + (p_221967_.nextDouble() - 0.5) * 0.2;
        float $$8 = -5.0f;
        if (p_221967_.nextBoolean()) {
            $$8 = p_221964_.getValue(DELAY) * 2 - 1;
        }
        double $$9 = ($$8 /= 16.0f) * (float)$$4.getStepX();
        double $$10 = $$8 * (float)$$4.getStepZ();
        p_221965_.addParticle(DustParticleOptions.REDSTONE, $$5 + $$9, $$6, $$7 + $$10, 0.0, 0.0, 0.0);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_55828_) {
        p_55828_.add(FACING, DELAY, LOCKED, POWERED);
    }
}

