/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.DropperBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;

public class DropperBlock
extends DispenserBlock {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<DropperBlock> CODEC = DropperBlock.simpleCodec(DropperBlock::new);
    private static final DispenseItemBehavior DISPENSE_BEHAVIOUR = new DefaultDispenseItemBehavior();

    public MapCodec<DropperBlock> codec() {
        return CODEC;
    }

    public DropperBlock(BlockBehaviour.Properties p_52942_) {
        super(p_52942_);
    }

    @Override
    protected DispenseItemBehavior getDispenseMethod(Level p_341227_, ItemStack p_52947_) {
        return DISPENSE_BEHAVIOUR;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos p_153179_, BlockState p_153180_) {
        return new DropperBlockEntity(p_153179_, p_153180_);
    }

    @Override
    protected void dispenseFrom(ServerLevel p_52944_, BlockState p_302455_, BlockPos p_52945_) {
        ItemStack $$10;
        DispenserBlockEntity $$3 = p_52944_.getBlockEntity(p_52945_, BlockEntityType.DROPPER).orElse(null);
        if ($$3 == null) {
            LOGGER.warn("Ignoring dispensing attempt for Dropper without matching block entity at {}", (Object)p_52945_);
            return;
        }
        BlockSource $$4 = new BlockSource(p_52944_, p_52945_, p_302455_, $$3);
        int $$5 = $$3.getRandomSlot(p_52944_.random);
        if ($$5 < 0) {
            p_52944_.levelEvent(1001, p_52945_, 0);
            return;
        }
        ItemStack $$6 = $$3.getItem($$5);
        if ($$6.isEmpty()) {
            return;
        }
        Direction $$7 = (Direction)p_52944_.getBlockState(p_52945_).getValue(FACING);
        Container $$8 = HopperBlockEntity.getContainerAt(p_52944_, p_52945_.relative($$7));
        if ($$8 == null) {
            ItemStack $$9 = DISPENSE_BEHAVIOUR.dispense($$4, $$6);
        } else {
            $$10 = HopperBlockEntity.addItem($$3, $$8, $$6.copyWithCount(1), $$7.getOpposite());
            if ($$10.isEmpty()) {
                $$10 = $$6.copy();
                $$10.shrink(1);
            } else {
                $$10 = $$6.copy();
            }
        }
        $$3.setItem($$5, $$10);
    }
}

