/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.logging.LogUtils;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public abstract class BaseSpawner {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String SPAWN_DATA_TAG = "SpawnData";
    private static final int EVENT_SPAWN = 1;
    private static final int DEFAULT_SPAWN_DELAY = 20;
    private static final int DEFAULT_MIN_SPAWN_DELAY = 200;
    private static final int DEFAULT_MAX_SPAWN_DELAY = 800;
    private static final int DEFAULT_SPAWN_COUNT = 4;
    private static final int DEFAULT_MAX_NEARBY_ENTITIES = 6;
    private static final int DEFAULT_REQUIRED_PLAYER_RANGE = 16;
    private static final int DEFAULT_SPAWN_RANGE = 4;
    private int spawnDelay = 20;
    private WeightedList<SpawnData> spawnPotentials = WeightedList.of();
    @Nullable
    private SpawnData nextSpawnData;
    private double spin;
    private double oSpin;
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 800;
    private int spawnCount = 4;
    @Nullable
    private Entity displayEntity;
    private int maxNearbyEntities = 6;
    private int requiredPlayerRange = 16;
    private int spawnRange = 4;

    public void setEntityId(EntityType<?> p_253682_, @Nullable Level p_254041_, RandomSource p_254221_, BlockPos p_254050_) {
        this.getOrCreateNextSpawnData(p_254041_, p_254221_, p_254050_).getEntityToSpawn().putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(p_253682_).toString());
    }

    private boolean isNearPlayer(Level p_151344_, BlockPos p_151345_) {
        return p_151344_.hasNearbyAlivePlayer((double)p_151345_.getX() + 0.5, (double)p_151345_.getY() + 0.5, (double)p_151345_.getZ() + 0.5, this.requiredPlayerRange);
    }

    public void clientTick(Level p_151320_, BlockPos p_151321_) {
        if (!this.isNearPlayer(p_151320_, p_151321_)) {
            this.oSpin = this.spin;
        } else if (this.displayEntity != null) {
            RandomSource $$2 = p_151320_.getRandom();
            double $$3 = (double)p_151321_.getX() + $$2.nextDouble();
            double $$4 = (double)p_151321_.getY() + $$2.nextDouble();
            double $$5 = (double)p_151321_.getZ() + $$2.nextDouble();
            p_151320_.addParticle(ParticleTypes.SMOKE, $$3, $$4, $$5, 0.0, 0.0, 0.0);
            p_151320_.addParticle(ParticleTypes.FLAME, $$3, $$4, $$5, 0.0, 0.0, 0.0);
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            }
            this.oSpin = this.spin;
            this.spin = (this.spin + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
        }
    }

    public void serverTick(ServerLevel p_151312_, BlockPos p_151313_) {
        if (!this.isNearPlayer(p_151312_, p_151313_)) {
            return;
        }
        if (this.spawnDelay == -1) {
            this.delay(p_151312_, p_151313_);
        }
        if (this.spawnDelay > 0) {
            --this.spawnDelay;
            return;
        }
        boolean $$2 = false;
        RandomSource $$3 = p_151312_.getRandom();
        SpawnData $$4 = this.getOrCreateNextSpawnData(p_151312_, $$3, p_151313_);
        for (int $$5 = 0; $$5 < this.spawnCount; ++$$5) {
            try (ProblemReporter.ScopedCollector $$6 = new ProblemReporter.ScopedCollector(this::toString, LOGGER);){
                ValueInput $$7 = TagValueInput.create((ProblemReporter)$$6, (HolderLookup.Provider)p_151312_.registryAccess(), $$4.getEntityToSpawn());
                Optional<EntityType<?>> $$8 = EntityType.by($$7);
                if ($$8.isEmpty()) {
                    this.delay(p_151312_, p_151313_);
                    return;
                }
                Vec3 $$9 = $$7.read("Pos", Vec3.CODEC).orElseGet(() -> new Vec3((double)p_151313_.getX() + ($$3.nextDouble() - $$3.nextDouble()) * (double)this.spawnRange + 0.5, p_151313_.getY() + $$3.nextInt(3) - 1, (double)p_151313_.getZ() + ($$3.nextDouble() - $$3.nextDouble()) * (double)this.spawnRange + 0.5));
                if (!p_151312_.noCollision($$8.get().getSpawnAABB($$9.x, $$9.y, $$9.z))) continue;
                BlockPos $$10 = BlockPos.containing($$9);
                if ($$4.getCustomSpawnRules().isPresent()) {
                    SpawnData.CustomSpawnRules $$11;
                    if (!$$8.get().getCategory().isFriendly() && p_151312_.getDifficulty() == Difficulty.PEACEFUL || !($$11 = $$4.getCustomSpawnRules().get()).isValidPosition($$10, p_151312_)) continue;
                } else if (!SpawnPlacements.checkSpawnRules($$8.get(), p_151312_, EntitySpawnReason.SPAWNER, $$10, p_151312_.getRandom())) continue;
                Entity $$12 = EntityType.loadEntityRecursive($$7, (Level)p_151312_, EntitySpawnReason.SPAWNER, p_404552_ -> {
                    p_404552_.snapTo(p_404551_.x, p_404551_.y, p_404551_.z, p_404552_.getYRot(), p_404552_.getXRot());
                    return p_404552_;
                });
                if ($$12 == null) {
                    this.delay(p_151312_, p_151313_);
                    return;
                }
                int $$13 = p_151312_.getEntities(EntityTypeTest.forExactClass($$12.getClass()), new AABB(p_151313_.getX(), p_151313_.getY(), p_151313_.getZ(), p_151313_.getX() + 1, p_151313_.getY() + 1, p_151313_.getZ() + 1).inflate(this.spawnRange), EntitySelector.NO_SPECTATORS).size();
                if ($$13 >= this.maxNearbyEntities) {
                    this.delay(p_151312_, p_151313_);
                    return;
                }
                $$12.snapTo($$12.getX(), $$12.getY(), $$12.getZ(), $$3.nextFloat() * 360.0f, 0.0f);
                if ($$12 instanceof Mob) {
                    boolean $$15;
                    Mob $$14 = (Mob)$$12;
                    if ($$4.getCustomSpawnRules().isEmpty() && !$$14.checkSpawnRules(p_151312_, EntitySpawnReason.SPAWNER) || !$$14.checkSpawnObstruction(p_151312_)) continue;
                    boolean bl = $$15 = $$4.getEntityToSpawn().size() == 1 && $$4.getEntityToSpawn().getString("id").isPresent();
                    if ($$15) {
                        ((Mob)$$12).finalizeSpawn(p_151312_, p_151312_.getCurrentDifficultyAt($$12.blockPosition()), EntitySpawnReason.SPAWNER, null);
                    }
                    $$4.getEquipment().ifPresent($$14::equip);
                }
                if (!p_151312_.tryAddFreshEntityWithPassengers($$12)) {
                    this.delay(p_151312_, p_151313_);
                    return;
                }
                p_151312_.levelEvent(2004, p_151313_, 0);
                p_151312_.gameEvent($$12, GameEvent.ENTITY_PLACE, $$10);
                if ($$12 instanceof Mob) {
                    ((Mob)$$12).spawnAnim();
                }
                $$2 = true;
                continue;
            }
        }
        if ($$2) {
            this.delay(p_151312_, p_151313_);
        }
    }

    private void delay(Level p_151351_, BlockPos p_151352_) {
        RandomSource $$2 = p_151351_.random;
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + $$2.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
        this.spawnPotentials.getRandom($$2).ifPresent(p_393311_ -> this.setNextSpawnData(p_151351_, p_151352_, (SpawnData)p_393311_));
        this.broadcastEvent(p_151351_, p_151352_, 1);
    }

    public void load(@Nullable Level p_151329_, BlockPos p_151330_, ValueInput p_421598_) {
        this.spawnDelay = p_421598_.getShortOr("Delay", (short)20);
        p_421598_.read(SPAWN_DATA_TAG, SpawnData.CODEC).ifPresent(p_400944_ -> this.setNextSpawnData(p_151329_, p_151330_, (SpawnData)p_400944_));
        this.spawnPotentials = p_421598_.read("SpawnPotentials", SpawnData.LIST_CODEC).orElseGet(() -> WeightedList.of(this.nextSpawnData != null ? this.nextSpawnData : new SpawnData()));
        this.minSpawnDelay = p_421598_.getIntOr("MinSpawnDelay", 200);
        this.maxSpawnDelay = p_421598_.getIntOr("MaxSpawnDelay", 800);
        this.spawnCount = p_421598_.getIntOr("SpawnCount", 4);
        this.maxNearbyEntities = p_421598_.getIntOr("MaxNearbyEntities", 6);
        this.requiredPlayerRange = p_421598_.getIntOr("RequiredPlayerRange", 16);
        this.spawnRange = p_421598_.getIntOr("SpawnRange", 4);
        this.displayEntity = null;
    }

    public void save(ValueOutput p_422002_) {
        p_422002_.putShort("Delay", (short)this.spawnDelay);
        p_422002_.putShort("MinSpawnDelay", (short)this.minSpawnDelay);
        p_422002_.putShort("MaxSpawnDelay", (short)this.maxSpawnDelay);
        p_422002_.putShort("SpawnCount", (short)this.spawnCount);
        p_422002_.putShort("MaxNearbyEntities", (short)this.maxNearbyEntities);
        p_422002_.putShort("RequiredPlayerRange", (short)this.requiredPlayerRange);
        p_422002_.putShort("SpawnRange", (short)this.spawnRange);
        p_422002_.storeNullable(SPAWN_DATA_TAG, SpawnData.CODEC, this.nextSpawnData);
        p_422002_.store("SpawnPotentials", SpawnData.LIST_CODEC, this.spawnPotentials);
    }

    @Nullable
    public Entity getOrCreateDisplayEntity(Level p_254323_, BlockPos p_254313_) {
        if (this.displayEntity == null) {
            CompoundTag $$2 = this.getOrCreateNextSpawnData(p_254323_, p_254323_.getRandom(), p_254313_).getEntityToSpawn();
            if ($$2.getString("id").isEmpty()) {
                return null;
            }
            this.displayEntity = EntityType.loadEntityRecursive($$2, p_254323_, EntitySpawnReason.SPAWNER, Function.identity());
            if ($$2.size() != 1 || this.displayEntity instanceof Mob) {
                // empty if block
            }
        }
        return this.displayEntity;
    }

    public boolean onEventTriggered(Level p_151317_, int p_151318_) {
        if (p_151318_ == 1) {
            if (p_151317_.isClientSide) {
                this.spawnDelay = this.minSpawnDelay;
            }
            return true;
        }
        return false;
    }

    protected void setNextSpawnData(@Nullable Level p_151325_, BlockPos p_151326_, SpawnData p_151327_) {
        this.nextSpawnData = p_151327_;
    }

    private SpawnData getOrCreateNextSpawnData(@Nullable Level p_254503_, RandomSource p_253892_, BlockPos p_254487_) {
        if (this.nextSpawnData != null) {
            return this.nextSpawnData;
        }
        this.setNextSpawnData(p_254503_, p_254487_, this.spawnPotentials.getRandom(p_253892_).orElseGet(SpawnData::new));
        return this.nextSpawnData;
    }

    public abstract void broadcastEvent(Level var1, BlockPos var2, int var3);

    public double getSpin() {
        return this.spin;
    }

    public double getoSpin() {
        return this.oSpin;
    }
}

