/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.consume_effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public record TeleportRandomlyConsumeEffect(float diameter) implements ConsumeEffect
{
    private static final float DEFAULT_DIAMETER = 16.0f;
    public static final MapCodec<TeleportRandomlyConsumeEffect> CODEC = RecordCodecBuilder.mapCodec(p_366612_ -> p_366612_.group((App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("diameter", (Object)Float.valueOf(16.0f)).forGetter(TeleportRandomlyConsumeEffect::diameter)).apply((Applicative)p_366612_, TeleportRandomlyConsumeEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TeleportRandomlyConsumeEffect> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.FLOAT, TeleportRandomlyConsumeEffect::diameter, TeleportRandomlyConsumeEffect::new);

    public TeleportRandomlyConsumeEffect() {
        this(16.0f);
    }

    public ConsumeEffect.Type<TeleportRandomlyConsumeEffect> getType() {
        return ConsumeEffect.Type.TELEPORT_RANDOMLY;
    }

    @Override
    public boolean apply(Level p_366648_, ItemStack p_366476_, LivingEntity p_366884_) {
        boolean $$3 = false;
        for (int $$4 = 0; $$4 < 16; ++$$4) {
            SoundSource $$12;
            SoundEvent $$11;
            double $$5 = p_366884_.getX() + (p_366884_.getRandom().nextDouble() - 0.5) * (double)this.diameter;
            double $$6 = Mth.clamp(p_366884_.getY() + (p_366884_.getRandom().nextDouble() - 0.5) * (double)this.diameter, (double)p_366648_.getMinY(), (double)(p_366648_.getMinY() + ((ServerLevel)p_366648_).getLogicalHeight() - 1));
            double $$7 = p_366884_.getZ() + (p_366884_.getRandom().nextDouble() - 0.5) * (double)this.diameter;
            if (p_366884_.isPassenger()) {
                p_366884_.stopRiding();
            }
            Vec3 $$8 = p_366884_.position();
            if (!p_366884_.randomTeleport($$5, $$6, $$7, true)) continue;
            p_366648_.gameEvent(GameEvent.TELEPORT, $$8, GameEvent.Context.of(p_366884_));
            if (p_366884_ instanceof Fox) {
                SoundEvent $$9 = SoundEvents.FOX_TELEPORT;
                SoundSource $$10 = SoundSource.NEUTRAL;
            } else {
                $$11 = SoundEvents.CHORUS_FRUIT_TELEPORT;
                $$12 = SoundSource.PLAYERS;
            }
            p_366648_.playSound(null, p_366884_.getX(), p_366884_.getY(), p_366884_.getZ(), $$11, $$12);
            p_366884_.resetFallDistance();
            $$3 = true;
            break;
        }
        if ($$3 && p_366884_ instanceof Player) {
            Player $$13 = (Player)p_366884_;
            $$13.resetCurrentImpulseContext();
        }
        return $$3;
    }
}

