/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.component.ConsumableListener;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.item.consume_effects.PlaySoundConsumeEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public record Consumable(float consumeSeconds, ItemUseAnimation animation, Holder<SoundEvent> sound, boolean hasConsumeParticles, List<ConsumeEffect> onConsumeEffects) {
    public static final float DEFAULT_CONSUME_SECONDS = 1.6f;
    private static final int CONSUME_EFFECTS_INTERVAL = 4;
    private static final float CONSUME_EFFECTS_START_FRACTION = 0.21875f;
    public static final Codec<Consumable> CODEC = RecordCodecBuilder.create(p_366542_ -> p_366542_.group((App)ExtraCodecs.NON_NEGATIVE_FLOAT.optionalFieldOf("consume_seconds", (Object)Float.valueOf(1.6f)).forGetter(Consumable::consumeSeconds), (App)ItemUseAnimation.CODEC.optionalFieldOf("animation", (Object)ItemUseAnimation.EAT).forGetter(Consumable::animation), (App)SoundEvent.CODEC.optionalFieldOf("sound", SoundEvents.GENERIC_EAT).forGetter(Consumable::sound), (App)Codec.BOOL.optionalFieldOf("has_consume_particles", (Object)true).forGetter(Consumable::hasConsumeParticles), (App)ConsumeEffect.CODEC.listOf().optionalFieldOf("on_consume_effects", List.of()).forGetter(Consumable::onConsumeEffects)).apply((Applicative)p_366542_, Consumable::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Consumable> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.FLOAT, Consumable::consumeSeconds, ItemUseAnimation.STREAM_CODEC, Consumable::animation, SoundEvent.STREAM_CODEC, Consumable::sound, ByteBufCodecs.BOOL, Consumable::hasConsumeParticles, ConsumeEffect.STREAM_CODEC.apply(ByteBufCodecs.list()), Consumable::onConsumeEffects, Consumable::new);

    public InteractionResult startConsuming(LivingEntity p_366412_, ItemStack p_366449_, InteractionHand p_366742_) {
        boolean $$3;
        if (!this.canConsume(p_366412_, p_366449_)) {
            return InteractionResult.FAIL;
        }
        boolean bl = $$3 = this.consumeTicks() > 0;
        if ($$3) {
            p_366412_.startUsingItem(p_366742_);
            return InteractionResult.CONSUME;
        }
        ItemStack $$4 = this.onConsume(p_366412_.level(), p_366412_, p_366449_);
        return InteractionResult.CONSUME.heldItemTransformedTo($$4);
    }

    public ItemStack onConsume(Level p_366638_, LivingEntity p_366573_, ItemStack p_366688_) {
        RandomSource $$3 = p_366573_.getRandom();
        this.emitParticlesAndSounds($$3, p_366573_, p_366688_, 16);
        if (p_366573_ instanceof ServerPlayer) {
            ServerPlayer $$4 = (ServerPlayer)p_366573_;
            $$4.awardStat(Stats.ITEM_USED.get(p_366688_.getItem()));
            CriteriaTriggers.CONSUME_ITEM.trigger($$4, p_366688_);
        }
        p_366688_.getAllOfType(ConsumableListener.class).forEach(p_366420_ -> p_366420_.onConsume(p_366638_, p_366573_, p_366688_, this));
        if (!p_366638_.isClientSide) {
            this.onConsumeEffects.forEach(p_366779_ -> p_366779_.apply(p_366638_, p_366688_, p_366573_));
        }
        p_366573_.gameEvent(this.animation == ItemUseAnimation.DRINK ? GameEvent.DRINK : GameEvent.EAT);
        p_366688_.consume(1, p_366573_);
        return p_366688_;
    }

    public boolean canConsume(LivingEntity p_366522_, ItemStack p_366908_) {
        FoodProperties $$2 = p_366908_.get(DataComponents.FOOD);
        if ($$2 != null && p_366522_ instanceof Player) {
            Player $$3 = (Player)p_366522_;
            return $$3.canEat($$2.canAlwaysEat());
        }
        return true;
    }

    public int consumeTicks() {
        return (int)(this.consumeSeconds * 20.0f);
    }

    public void emitParticlesAndSounds(RandomSource p_366511_, LivingEntity p_366794_, ItemStack p_366479_, int p_366619_) {
        SoundEvent soundEvent;
        float $$9;
        float $$4 = p_366511_.nextBoolean() ? 0.5f : 1.0f;
        float $$5 = p_366511_.triangle(1.0f, 0.2f);
        float $$6 = 0.5f;
        float $$7 = Mth.randomBetween(p_366511_, 0.9f, 1.0f);
        float $$8 = this.animation == ItemUseAnimation.DRINK ? 0.5f : $$4;
        float f = $$9 = this.animation == ItemUseAnimation.DRINK ? $$7 : $$5;
        if (this.hasConsumeParticles) {
            p_366794_.spawnItemParticles(p_366479_, p_366619_);
        }
        if (p_366794_ instanceof OverrideConsumeSound) {
            OverrideConsumeSound $$10 = (OverrideConsumeSound)((Object)p_366794_);
            soundEvent = $$10.getConsumeSound(p_366479_);
        } else {
            soundEvent = this.sound.value();
        }
        SoundEvent $$11 = soundEvent;
        p_366794_.playSound($$11, $$8, $$9);
    }

    public boolean shouldEmitParticlesAndSounds(int p_366816_) {
        int $$2;
        int $$1 = this.consumeTicks() - p_366816_;
        boolean $$3 = $$1 > ($$2 = (int)((float)this.consumeTicks() * 0.21875f));
        return $$3 && p_366816_ % 4 == 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static interface OverrideConsumeSound {
        public SoundEvent getConsumeSound(ItemStack var1);
    }

    public static class Builder {
        private float consumeSeconds = 1.6f;
        private ItemUseAnimation animation = ItemUseAnimation.EAT;
        private Holder<SoundEvent> sound = SoundEvents.GENERIC_EAT;
        private boolean hasConsumeParticles = true;
        private final List<ConsumeEffect> onConsumeEffects = new ArrayList<ConsumeEffect>();

        Builder() {
        }

        public Builder consumeSeconds(float p_366857_) {
            this.consumeSeconds = p_366857_;
            return this;
        }

        public Builder animation(ItemUseAnimation p_366491_) {
            this.animation = p_366491_;
            return this;
        }

        public Builder sound(Holder<SoundEvent> p_366867_) {
            this.sound = p_366867_;
            return this;
        }

        public Builder soundAfterConsume(Holder<SoundEvent> p_366752_) {
            return this.onConsume(new PlaySoundConsumeEffect(p_366752_));
        }

        public Builder hasConsumeParticles(boolean p_366715_) {
            this.hasConsumeParticles = p_366715_;
            return this;
        }

        public Builder onConsume(ConsumeEffect p_366518_) {
            this.onConsumeEffects.add(p_366518_);
            return this;
        }

        public Consumable build() {
            return new Consumable(this.consumeSeconds, this.animation, this.sound, this.hasConsumeParticles, this.onConsumeEffects);
        }
    }
}

