/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TridentItem
extends Item
implements ProjectileItem {
    public static final int THROW_THRESHOLD_TIME = 10;
    public static final float BASE_DAMAGE = 8.0f;
    public static final float PROJECTILE_SHOOT_POWER = 2.5f;

    public TridentItem(Item.Properties p_43381_) {
        super(p_43381_);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 8.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.9f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2, false);
    }

    @Override
    public ItemUseAnimation getUseAnimation(ItemStack p_43417_) {
        return ItemUseAnimation.SPEAR;
    }

    @Override
    public int getUseDuration(ItemStack p_43419_, LivingEntity p_345001_) {
        return 72000;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean releaseUsing(ItemStack p_43394_, Level p_43395_, LivingEntity p_43396_, int p_43397_) {
        void $$5;
        if (!(p_43396_ instanceof Player)) {
            return false;
        }
        Player $$4 = (Player)p_43396_;
        int $$6 = this.getUseDuration(p_43394_, p_43396_) - p_43397_;
        if ($$6 < 10) {
            return false;
        }
        float $$7 = EnchantmentHelper.getTridentSpinAttackStrength(p_43394_, (LivingEntity)$$5);
        if ($$7 > 0.0f && !$$5.isInWaterOrRain()) {
            return false;
        }
        if (p_43394_.nextDamageWillBreak()) {
            return false;
        }
        Holder<SoundEvent> $$8 = EnchantmentHelper.pickHighestLevel(p_43394_, EnchantmentEffectComponents.TRIDENT_SOUND).orElse(SoundEvents.TRIDENT_THROW);
        $$5.awardStat(Stats.ITEM_USED.get(this));
        if (p_43395_ instanceof ServerLevel) {
            ServerLevel $$9 = (ServerLevel)p_43395_;
            p_43394_.hurtWithoutBreaking(1, (Player)$$5);
            if ($$7 == 0.0f) {
                ItemStack $$10 = p_43394_.consumeAndReturn(1, (LivingEntity)$$5);
                ThrownTrident $$11 = Projectile.spawnProjectileFromRotation(ThrownTrident::new, $$9, $$10, (LivingEntity)$$5, 0.0f, 2.5f, 1.0f);
                if ($$5.hasInfiniteMaterials()) {
                    $$11.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
                p_43395_.playSound(null, $$11, $$8.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                return true;
            }
        }
        if ($$7 > 0.0f) {
            float $$12 = $$5.getYRot();
            float $$13 = $$5.getXRot();
            float $$14 = -Mth.sin($$12 * ((float)Math.PI / 180)) * Mth.cos($$13 * ((float)Math.PI / 180));
            float $$15 = -Mth.sin($$13 * ((float)Math.PI / 180));
            float $$16 = Mth.cos($$12 * ((float)Math.PI / 180)) * Mth.cos($$13 * ((float)Math.PI / 180));
            float $$17 = Mth.sqrt($$14 * $$14 + $$15 * $$15 + $$16 * $$16);
            $$5.push($$14 *= $$7 / $$17, $$15 *= $$7 / $$17, $$16 *= $$7 / $$17);
            $$5.startAutoSpinAttack(20, 8.0f, p_43394_);
            if ($$5.onGround()) {
                float $$18 = 1.1999999f;
                $$5.move(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
            }
            p_43395_.playSound(null, (Entity)$$5, $$8.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public InteractionResult use(Level p_43405_, Player p_43406_, InteractionHand p_43407_) {
        ItemStack $$3 = p_43406_.getItemInHand(p_43407_);
        if ($$3.nextDamageWillBreak()) {
            return InteractionResult.FAIL;
        }
        if (EnchantmentHelper.getTridentSpinAttackStrength($$3, p_43406_) > 0.0f && !p_43406_.isInWaterOrRain()) {
            return InteractionResult.FAIL;
        }
        p_43406_.startUsingItem(p_43407_);
        return InteractionResult.CONSUME;
    }

    @Override
    public Projectile asProjectile(Level p_338505_, Position p_338277_, ItemStack p_338353_, Direction p_338220_) {
        ThrownTrident $$4 = new ThrownTrident(p_338505_, p_338277_.x(), p_338277_.y(), p_338277_.z(), p_338353_.copyWithCount(1));
        $$4.pickup = AbstractArrow.Pickup.ALLOWED;
        return $$4;
    }
}

