/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;

public class StandingAndWallBlockItem
extends BlockItem {
    protected final Block wallBlock;
    private final Direction attachmentDirection;

    public StandingAndWallBlockItem(Block p_248873_, Block p_251044_, Direction p_250800_, Item.Properties p_249308_) {
        super(p_248873_, p_249308_);
        this.wallBlock = p_251044_;
        this.attachmentDirection = p_250800_;
    }

    protected boolean canPlace(LevelReader p_250350_, BlockState p_249311_, BlockPos p_250328_) {
        return p_249311_.canSurvive(p_250350_, p_250328_);
    }

    @Override
    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext p_43255_) {
        BlockState $$1 = this.wallBlock.getStateForPlacement(p_43255_);
        BlockState $$2 = null;
        Level $$3 = p_43255_.getLevel();
        BlockPos $$4 = p_43255_.getClickedPos();
        for (Direction $$5 : p_43255_.getNearestLookingDirections()) {
            BlockState $$6;
            if ($$5 == this.attachmentDirection.getOpposite()) continue;
            BlockState blockState = $$6 = $$5 == this.attachmentDirection ? this.getBlock().getStateForPlacement(p_43255_) : $$1;
            if ($$6 == null || !this.canPlace($$3, $$6, $$4)) continue;
            $$2 = $$6;
            break;
        }
        return $$2 != null && $$3.isUnobstructed($$2, $$4, CollisionContext.empty()) ? $$2 : null;
    }

    @Override
    public void registerBlocks(Map<Block, Item> p_43252_, Item p_43253_) {
        super.registerBlocks(p_43252_, p_43253_);
        p_43252_.put(this.wallBlock, p_43253_);
    }
}

