/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MaceItem
extends Item {
    private static final int DEFAULT_ATTACK_DAMAGE = 5;
    private static final float DEFAULT_ATTACK_SPEED = -3.4f;
    public static final float SMASH_ATTACK_FALL_THRESHOLD = 1.5f;
    private static final float SMASH_ATTACK_HEAVY_THRESHOLD = 5.0f;
    public static final float SMASH_ATTACK_KNOCKBACK_RADIUS = 3.5f;
    private static final float SMASH_ATTACK_KNOCKBACK_POWER = 0.7f;

    public MaceItem(Item.Properties p_333796_) {
        super(p_333796_);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 5.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -3.4f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2, false);
    }

    @Override
    public void hurtEnemy(ItemStack p_334046_, LivingEntity p_333712_, LivingEntity p_333812_) {
        if (MaceItem.canSmashAttack(p_333812_)) {
            ServerLevel $$3 = (ServerLevel)p_333812_.level();
            p_333812_.setDeltaMovement(p_333812_.getDeltaMovement().with(Direction.Axis.Y, 0.01f));
            if (p_333812_ instanceof ServerPlayer) {
                ServerPlayer $$4 = (ServerPlayer)p_333812_;
                $$4.currentImpulseImpactPos = this.calculateImpactPosition($$4);
                $$4.setIgnoreFallDamageFromCurrentImpulse(true);
                $$4.connection.send(new ClientboundSetEntityMotionPacket($$4));
            }
            if (p_333712_.onGround()) {
                if (p_333812_ instanceof ServerPlayer) {
                    ServerPlayer $$5 = (ServerPlayer)p_333812_;
                    $$5.setSpawnExtraParticlesOnFall(true);
                }
                SoundEvent $$6 = p_333812_.fallDistance > 5.0 ? SoundEvents.MACE_SMASH_GROUND_HEAVY : SoundEvents.MACE_SMASH_GROUND;
                $$3.playSound(null, p_333812_.getX(), p_333812_.getY(), p_333812_.getZ(), $$6, p_333812_.getSoundSource(), 1.0f, 1.0f);
            } else {
                $$3.playSound(null, p_333812_.getX(), p_333812_.getY(), p_333812_.getZ(), SoundEvents.MACE_SMASH_AIR, p_333812_.getSoundSource(), 1.0f, 1.0f);
            }
            MaceItem.knockback($$3, p_333812_, p_333712_);
        }
    }

    private Vec3 calculateImpactPosition(ServerPlayer p_365384_) {
        if (p_365384_.isIgnoringFallDamageFromCurrentImpulse() && p_365384_.currentImpulseImpactPos != null && p_365384_.currentImpulseImpactPos.y <= p_365384_.position().y) {
            return p_365384_.currentImpulseImpactPos;
        }
        return p_365384_.position();
    }

    @Override
    public void postHurtEnemy(ItemStack p_345716_, LivingEntity p_345817_, LivingEntity p_346003_) {
        if (MaceItem.canSmashAttack(p_346003_)) {
            p_346003_.resetFallDistance();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getAttackDamageBonus(Entity p_344900_, float p_335575_, DamageSource p_344972_) {
        double $$10;
        void $$4;
        Entity entity = p_344972_.getDirectEntity();
        if (!(entity instanceof LivingEntity)) {
            return 0.0f;
        }
        LivingEntity $$3 = (LivingEntity)entity;
        if (!MaceItem.canSmashAttack((LivingEntity)$$4)) {
            return 0.0f;
        }
        double $$5 = 3.0;
        double $$6 = 8.0;
        double $$7 = $$4.fallDistance;
        if ($$7 <= 3.0) {
            double $$8 = 4.0 * $$7;
        } else if ($$7 <= 8.0) {
            double $$9 = 12.0 + 2.0 * ($$7 - 3.0);
        } else {
            $$10 = 22.0 + $$7 - 8.0;
        }
        Level level = $$4.level();
        if (level instanceof ServerLevel) {
            ServerLevel $$11 = (ServerLevel)level;
            return (float)($$10 + (double)EnchantmentHelper.modifyFallBasedDamage($$11, $$4.getWeaponItem(), p_344900_, p_344972_, 0.0f) * $$7);
        }
        return (float)$$10;
    }

    private static void knockback(Level p_335716_, Entity p_335810_, Entity p_360964_) {
        p_335716_.levelEvent(2013, p_360964_.getOnPos(), 750);
        p_335716_.getEntitiesOfClass(LivingEntity.class, p_360964_.getBoundingBox().inflate(3.5), MaceItem.knockbackPredicate(p_335810_, p_360964_)).forEach(p_347296_ -> {
            Vec3 $$3 = p_347296_.position().subtract(p_360964_.position());
            double $$4 = MaceItem.getKnockbackPower(p_335810_, p_347296_, $$3);
            Vec3 $$5 = $$3.normalize().scale($$4);
            if ($$4 > 0.0) {
                p_347296_.push($$5.x, 0.7f, $$5.z);
                if (p_347296_ instanceof ServerPlayer) {
                    ServerPlayer $$6 = (ServerPlayer)p_347296_;
                    $$6.connection.send(new ClientboundSetEntityMotionPacket($$6));
                }
            }
        });
    }

    private static Predicate<LivingEntity> knockbackPredicate(Entity p_338698_, Entity p_361210_) {
        return arg_0 -> MaceItem.lambda$knockbackPredicate$1(p_338698_, p_361210_, arg_0);
    }

    private static double getKnockbackPower(Entity p_364341_, LivingEntity p_338630_, Vec3 p_338866_) {
        return (3.5 - p_338866_.length()) * (double)0.7f * (double)(p_364341_.fallDistance > 5.0 ? 2 : 1) * (1.0 - p_338630_.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
    }

    public static boolean canSmashAttack(LivingEntity p_344836_) {
        return p_344836_.fallDistance > 1.5 && !p_344836_.isFallFlying();
    }

    @Override
    @Nullable
    public DamageSource getDamageSource(LivingEntity p_372868_) {
        if (MaceItem.canSmashAttack(p_372868_)) {
            return p_372868_.damageSources().mace(p_372868_);
        }
        return super.getDamageSource(p_372868_);
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ boolean lambda$knockbackPredicate$1(Entity p_393276_, Entity p_393277_, LivingEntity p_393278_) {
        $$3 = p_393278_.isSpectator() == false;
        $$4 = p_393278_ != p_393276_ && p_393278_ != p_393277_;
        v0 = $$5 = p_393276_.isAlliedTo(p_393278_) == false;
        if (!(p_393278_ instanceof TamableAnimal)) ** GOTO lbl-1000
        $$6 = (TamableAnimal)p_393278_;
        if (!(p_393277_ instanceof LivingEntity)) ** GOTO lbl-1000
        $$7 = (LivingEntity)p_393277_;
        if ($$6.isTame() && $$6.isOwnedBy($$7)) {
            v1 = true;
        } else lbl-1000:
        // 3 sources

        {
            v1 = false;
        }
        $$8 = v1 == false;
        $$11 = p_393278_ instanceof ArmorStand == false || ($$9 = (ArmorStand)p_393278_).isMarker() == false;
        $$12 = p_393277_.distanceToSqr(p_393278_) <= Math.pow(3.5, 2.0);
        return $$3 != false && $$4 != false && $$5 != false && $$8 != false && $$11 != false && $$12 != false;
    }
}

