/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.NullOps;
import net.minecraft.util.StringUtil;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.DamageResistant;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.component.UseCooldown;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.Repairable;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import org.apache.commons.lang3.function.TriConsumer;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

public final class ItemStack
implements DataComponentHolder {
    private static final List<Component> OP_NBT_WARNING = List.of(Component.translatable("item.op_warning.line1").withStyle(ChatFormatting.RED, ChatFormatting.BOLD), Component.translatable("item.op_warning.line2").withStyle(ChatFormatting.RED), Component.translatable("item.op_warning.line3").withStyle(ChatFormatting.RED));
    private static final Component UNBREAKABLE_TOOLTIP = Component.translatable("item.unbreakable").withStyle(ChatFormatting.BLUE);
    public static final MapCodec<ItemStack> MAP_CODEC = MapCodec.recursive((String)"ItemStack", p_393271_ -> RecordCodecBuilder.mapCodec(p_381569_ -> p_381569_.group((App)Item.CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)ExtraCodecs.intRange(1, 99).fieldOf("count").orElse((Object)1).forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(p_330103_ -> p_330103_.components.asPatch())).apply((Applicative)p_381569_, ItemStack::new)));
    public static final Codec<ItemStack> CODEC = Codec.lazyInitialized(() -> MAP_CODEC.codec());
    public static final Codec<ItemStack> SINGLE_ITEM_CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(p_381570_ -> p_381570_.group((App)Item.CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(p_332616_ -> p_332616_.components.asPatch())).apply((Applicative)p_381570_, (p_332614_, p_332615_) -> new ItemStack((Holder<Item>)p_332614_, 1, (DataComponentPatch)p_332615_))));
    public static final Codec<ItemStack> STRICT_CODEC = CODEC.validate(ItemStack::validateStrict);
    public static final Codec<ItemStack> STRICT_SINGLE_ITEM_CODEC = SINGLE_ITEM_CODEC.validate(ItemStack::validateStrict);
    public static final Codec<ItemStack> OPTIONAL_CODEC = ExtraCodecs.optionalEmptyMap(CODEC).xmap(p_330099_ -> p_330099_.orElse(EMPTY), p_330101_ -> p_330101_.isEmpty() ? Optional.empty() : Optional.of(p_330101_));
    public static final Codec<ItemStack> SIMPLE_ITEM_CODEC = Item.CODEC.xmap(ItemStack::new, ItemStack::getItemHolder);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> OPTIONAL_STREAM_CODEC = ItemStack.createOptionalStreamCodec(DataComponentPatch.STREAM_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> OPTIONAL_UNTRUSTED_STREAM_CODEC = ItemStack.createOptionalStreamCodec(DataComponentPatch.DELIMITED_STREAM_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

        @Override
        public ItemStack decode(RegistryFriendlyByteBuf p_330597_) {
            ItemStack $$1 = (ItemStack)OPTIONAL_STREAM_CODEC.decode(p_330597_);
            if ($$1.isEmpty()) {
                throw new DecoderException("Empty ItemStack not allowed");
            }
            return $$1;
        }

        @Override
        public void encode(RegistryFriendlyByteBuf p_331762_, ItemStack p_331138_) {
            if (p_331138_.isEmpty()) {
                throw new EncoderException("Empty ItemStack not allowed");
            }
            OPTIONAL_STREAM_CODEC.encode(p_331762_, p_331138_);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((RegistryFriendlyByteBuf)((Object)object), (ItemStack)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((RegistryFriendlyByteBuf)((Object)object));
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, List<ItemStack>> OPTIONAL_LIST_STREAM_CODEC = OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity));
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ItemStack EMPTY = new ItemStack((Void)null);
    private static final Component DISABLED_ITEM_TOOLTIP = Component.translatable("item.disabled").withStyle(ChatFormatting.RED);
    private int count;
    private int popTime;
    @Deprecated
    @Nullable
    private final Item item;
    final PatchedDataComponentMap components;
    @Nullable
    private Entity entityRepresentation;

    public static DataResult<ItemStack> validateStrict(ItemStack p_340966_) {
        DataResult<Unit> $$1 = ItemStack.validateComponents(p_340966_.getComponents());
        if ($$1.isError()) {
            return $$1.map(p_340777_ -> p_340966_);
        }
        if (p_340966_.getCount() > p_340966_.getMaxStackSize()) {
            return DataResult.error(() -> "Item stack with stack size of " + p_340966_.getCount() + " was larger than maximum: " + p_340966_.getMaxStackSize());
        }
        return DataResult.success((Object)p_340966_);
    }

    private static StreamCodec<RegistryFriendlyByteBuf, ItemStack> createOptionalStreamCodec(final StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch> p_412358_) {
        return new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

            @Override
            public ItemStack decode(RegistryFriendlyByteBuf p_320491_) {
                int $$1 = p_320491_.readVarInt();
                if ($$1 <= 0) {
                    return EMPTY;
                }
                Holder $$2 = (Holder)Item.STREAM_CODEC.decode(p_320491_);
                DataComponentPatch $$3 = (DataComponentPatch)p_412358_.decode(p_320491_);
                return new ItemStack($$2, $$1, $$3);
            }

            @Override
            public void encode(RegistryFriendlyByteBuf p_320527_, ItemStack p_320873_) {
                if (p_320873_.isEmpty()) {
                    p_320527_.writeVarInt(0);
                    return;
                }
                p_320527_.writeVarInt(p_320873_.getCount());
                Item.STREAM_CODEC.encode(p_320527_, p_320873_.getItemHolder());
                p_412358_.encode(p_320527_, p_320873_.components.asPatch());
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((RegistryFriendlyByteBuf)((Object)object), (ItemStack)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((RegistryFriendlyByteBuf)((Object)object));
            }
        };
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ItemStack> validatedStreamCodec(final StreamCodec<RegistryFriendlyByteBuf, ItemStack> p_340962_) {
        return new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

            @Override
            public ItemStack decode(RegistryFriendlyByteBuf p_341238_) {
                ItemStack $$1 = (ItemStack)p_340962_.decode(p_341238_);
                if (!$$1.isEmpty()) {
                    RegistryOps<Unit> $$2 = p_341238_.registryAccess().createSerializationContext(NullOps.INSTANCE);
                    CODEC.encodeStart($$2, (Object)$$1).getOrThrow(DecoderException::new);
                }
                return $$1;
            }

            @Override
            public void encode(RegistryFriendlyByteBuf p_341112_, ItemStack p_341358_) {
                p_340962_.encode(p_341112_, p_341358_);
            }

            @Override
            public /* synthetic */ void encode(Object object, Object object2) {
                this.encode((RegistryFriendlyByteBuf)((Object)object), (ItemStack)object2);
            }

            @Override
            public /* synthetic */ Object decode(Object object) {
                return this.decode((RegistryFriendlyByteBuf)((Object)object));
            }
        };
    }

    public Optional<TooltipComponent> getTooltipImage() {
        return this.getItem().getTooltipImage(this);
    }

    @Override
    public DataComponentMap getComponents() {
        return !this.isEmpty() ? this.components : DataComponentMap.EMPTY;
    }

    public DataComponentMap getPrototype() {
        return !this.isEmpty() ? this.getItem().components() : DataComponentMap.EMPTY;
    }

    public DataComponentPatch getComponentsPatch() {
        return !this.isEmpty() ? this.components.asPatch() : DataComponentPatch.EMPTY;
    }

    public DataComponentMap immutableComponents() {
        return !this.isEmpty() ? this.components.toImmutableMap() : DataComponentMap.EMPTY;
    }

    public boolean hasNonDefault(DataComponentType<?> p_389426_) {
        return !this.isEmpty() && this.components.hasNonDefault(p_389426_);
    }

    public ItemStack(ItemLike p_41599_) {
        this(p_41599_, 1);
    }

    public ItemStack(Holder<Item> p_204116_) {
        this(p_204116_.value(), 1);
    }

    public ItemStack(Holder<Item> p_312081_, int p_41605_, DataComponentPatch p_330362_) {
        this(p_312081_.value(), p_41605_, PatchedDataComponentMap.fromPatch(p_312081_.value().components(), p_330362_));
    }

    public ItemStack(Holder<Item> p_220155_, int p_220156_) {
        this(p_220155_.value(), p_220156_);
    }

    public ItemStack(ItemLike p_41601_, int p_41602_) {
        this(p_41601_, p_41602_, new PatchedDataComponentMap(p_41601_.asItem().components()));
    }

    private ItemStack(ItemLike p_330978_, int p_330639_, PatchedDataComponentMap p_330546_) {
        this.item = p_330978_.asItem();
        this.count = p_330639_;
        this.components = p_330546_;
        this.getItem().verifyComponentsAfterLoad(this);
    }

    private ItemStack(@Nullable Void p_282703_) {
        this.item = null;
        this.components = new PatchedDataComponentMap(DataComponentMap.EMPTY);
    }

    public static DataResult<Unit> validateComponents(DataComponentMap p_341201_) {
        if (p_341201_.has(DataComponents.MAX_DAMAGE) && p_341201_.getOrDefault(DataComponents.MAX_STACK_SIZE, 1) > 1) {
            return DataResult.error(() -> "Item cannot be both damageable and stackable");
        }
        ItemContainerContents $$1 = p_341201_.getOrDefault(DataComponents.CONTAINER, ItemContainerContents.EMPTY);
        for (ItemStack $$2 : $$1.nonEmptyItems()) {
            int $$4;
            int $$3 = $$2.getCount();
            if ($$3 <= ($$4 = $$2.getMaxStackSize())) continue;
            return DataResult.error(() -> "Item stack with count of " + $$3 + " was larger than maximum: " + $$4);
        }
        return DataResult.success((Object)((Object)Unit.INSTANCE));
    }

    public boolean isEmpty() {
        return this == EMPTY || this.item == Items.AIR || this.count <= 0;
    }

    public boolean isItemEnabled(FeatureFlagSet p_250869_) {
        return this.isEmpty() || this.getItem().isEnabled(p_250869_);
    }

    public ItemStack split(int p_41621_) {
        int $$1 = Math.min(p_41621_, this.getCount());
        ItemStack $$2 = this.copyWithCount($$1);
        this.shrink($$1);
        return $$2;
    }

    public ItemStack copyAndClear() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        ItemStack $$0 = this.copy();
        this.setCount(0);
        return $$0;
    }

    public Item getItem() {
        return this.isEmpty() ? Items.AIR : this.item;
    }

    public Holder<Item> getItemHolder() {
        return this.getItem().builtInRegistryHolder();
    }

    public boolean is(TagKey<Item> p_204118_) {
        return this.getItem().builtInRegistryHolder().is(p_204118_);
    }

    public boolean is(Item p_150931_) {
        return this.getItem() == p_150931_;
    }

    public boolean is(Predicate<Holder<Item>> p_220168_) {
        return p_220168_.test(this.getItem().builtInRegistryHolder());
    }

    public boolean is(Holder<Item> p_220166_) {
        return this.getItem().builtInRegistryHolder() == p_220166_;
    }

    public boolean is(HolderSet<Item> p_298683_) {
        return p_298683_.contains(this.getItemHolder());
    }

    public Stream<TagKey<Item>> getTags() {
        return this.getItem().builtInRegistryHolder().tags();
    }

    public InteractionResult useOn(UseOnContext p_41662_) {
        InteractionResult.Success $$5;
        Player $$1 = p_41662_.getPlayer();
        BlockPos $$2 = p_41662_.getClickedPos();
        if ($$1 != null && !$$1.getAbilities().mayBuild && !this.canPlaceOnBlockInAdventureMode(new BlockInWorld(p_41662_.getLevel(), $$2, false))) {
            return InteractionResult.PASS;
        }
        Item $$3 = this.getItem();
        InteractionResult $$4 = $$3.useOn(p_41662_);
        if ($$1 != null && $$4 instanceof InteractionResult.Success && ($$5 = (InteractionResult.Success)$$4).wasItemInteraction()) {
            $$1.awardStat(Stats.ITEM_USED.get($$3));
        }
        return $$4;
    }

    public float getDestroySpeed(BlockState p_41692_) {
        return this.getItem().getDestroySpeed(this, p_41692_);
    }

    public InteractionResult use(Level p_41683_, Player p_41684_, InteractionHand p_41685_) {
        ItemStack $$3 = this.copy();
        boolean $$4 = this.getUseDuration(p_41684_) <= 0;
        InteractionResult $$5 = this.getItem().use(p_41683_, p_41684_, p_41685_);
        if ($$4 && $$5 instanceof InteractionResult.Success) {
            InteractionResult.Success $$6;
            return $$6.heldItemTransformedTo(($$6 = (InteractionResult.Success)$$5).heldItemTransformedTo() == null ? this.applyAfterUseComponentSideEffects(p_41684_, $$3) : $$6.heldItemTransformedTo().applyAfterUseComponentSideEffects(p_41684_, $$3));
        }
        return $$5;
    }

    public ItemStack finishUsingItem(Level p_41672_, LivingEntity p_41673_) {
        ItemStack $$2 = this.copy();
        ItemStack $$3 = this.getItem().finishUsingItem(this, p_41672_, p_41673_);
        return $$3.applyAfterUseComponentSideEffects(p_41673_, $$2);
    }

    private ItemStack applyAfterUseComponentSideEffects(LivingEntity p_366464_, ItemStack p_366810_) {
        UseRemainder $$2 = p_366810_.get(DataComponents.USE_REMAINDER);
        UseCooldown $$3 = p_366810_.get(DataComponents.USE_COOLDOWN);
        int $$4 = p_366810_.getCount();
        ItemStack $$5 = this;
        if ($$2 != null) {
            $$5 = $$2.convertIntoRemainder($$5, $$4, p_366464_.hasInfiniteMaterials(), p_366464_::handleExtraItemsCreatedOnUse);
        }
        if ($$3 != null) {
            $$3.apply(p_366810_, p_366464_);
        }
        return $$5;
    }

    public int getMaxStackSize() {
        return this.getOrDefault(DataComponents.MAX_STACK_SIZE, 1);
    }

    public boolean isStackable() {
        return this.getMaxStackSize() > 1 && (!this.isDamageableItem() || !this.isDamaged());
    }

    public boolean isDamageableItem() {
        return this.has(DataComponents.MAX_DAMAGE) && !this.has(DataComponents.UNBREAKABLE) && this.has(DataComponents.DAMAGE);
    }

    public boolean isDamaged() {
        return this.isDamageableItem() && this.getDamageValue() > 0;
    }

    public int getDamageValue() {
        return Mth.clamp(this.getOrDefault(DataComponents.DAMAGE, 0), 0, this.getMaxDamage());
    }

    public void setDamageValue(int p_41722_) {
        this.set(DataComponents.DAMAGE, Mth.clamp(p_41722_, 0, this.getMaxDamage()));
    }

    public int getMaxDamage() {
        return this.getOrDefault(DataComponents.MAX_DAMAGE, 0);
    }

    public boolean isBroken() {
        return this.isDamageableItem() && this.getDamageValue() >= this.getMaxDamage();
    }

    public boolean nextDamageWillBreak() {
        return this.isDamageableItem() && this.getDamageValue() >= this.getMaxDamage() - 1;
    }

    public void hurtAndBreak(int p_220158_, ServerLevel p_346256_, @Nullable ServerPlayer p_220160_, Consumer<Item> p_348596_) {
        int $$4 = this.processDurabilityChange(p_220158_, p_346256_, p_220160_);
        if ($$4 != 0) {
            this.applyDamage(this.getDamageValue() + $$4, p_220160_, p_348596_);
        }
    }

    private int processDurabilityChange(int p_361290_, ServerLevel p_361409_, @Nullable ServerPlayer p_364940_) {
        if (!this.isDamageableItem()) {
            return 0;
        }
        if (p_364940_ != null && p_364940_.hasInfiniteMaterials()) {
            return 0;
        }
        if (p_361290_ > 0) {
            return EnchantmentHelper.processDurabilityChange(p_361409_, this, p_361290_);
        }
        return p_361290_;
    }

    private void applyDamage(int p_361754_, @Nullable ServerPlayer p_364853_, Consumer<Item> p_360895_) {
        if (p_364853_ != null) {
            CriteriaTriggers.ITEM_DURABILITY_CHANGED.trigger(p_364853_, this, p_361754_);
        }
        this.setDamageValue(p_361754_);
        if (this.isBroken()) {
            Item $$3 = this.getItem();
            this.shrink(1);
            p_360895_.accept($$3);
        }
    }

    public void hurtWithoutBreaking(int p_362924_, Player p_363410_) {
        if (p_363410_ instanceof ServerPlayer) {
            ServerPlayer $$2 = (ServerPlayer)p_363410_;
            int $$3 = this.processDurabilityChange(p_362924_, $$2.level(), $$2);
            if ($$3 == 0) {
                return;
            }
            int $$4 = Math.min(this.getDamageValue() + $$3, this.getMaxDamage() - 1);
            this.applyDamage($$4, $$2, p_360034_ -> {});
        }
    }

    public void hurtAndBreak(int p_418267_, LivingEntity p_418272_, InteractionHand p_418180_) {
        this.hurtAndBreak(p_418267_, p_418272_, LivingEntity.getSlotForHand(p_418180_));
    }

    public void hurtAndBreak(int p_41623_, LivingEntity p_41624_, EquipmentSlot p_319898_) {
        Level level = p_41624_.level();
        if (level instanceof ServerLevel) {
            ServerPlayer $$4;
            ServerLevel $$3 = (ServerLevel)level;
            this.hurtAndBreak(p_41623_, $$3, p_41624_ instanceof ServerPlayer ? ($$4 = (ServerPlayer)p_41624_) : null, p_348383_ -> p_41624_.onEquippedItemBroken((Item)p_348383_, p_319898_));
        }
    }

    public ItemStack hurtAndConvertOnBreak(int p_352405_, ItemLike p_352337_, LivingEntity p_352175_, EquipmentSlot p_352058_) {
        this.hurtAndBreak(p_352405_, p_352175_, p_352058_);
        if (this.isEmpty()) {
            ItemStack $$4 = this.transmuteCopyIgnoreEmpty(p_352337_, 1);
            if ($$4.isDamageableItem()) {
                $$4.setDamageValue(0);
            }
            return $$4;
        }
        return this;
    }

    public boolean isBarVisible() {
        return this.getItem().isBarVisible(this);
    }

    public int getBarWidth() {
        return this.getItem().getBarWidth(this);
    }

    public int getBarColor() {
        return this.getItem().getBarColor(this);
    }

    public boolean overrideStackedOnOther(Slot p_150927_, ClickAction p_150928_, Player p_150929_) {
        return this.getItem().overrideStackedOnOther(this, p_150927_, p_150928_, p_150929_);
    }

    public boolean overrideOtherStackedOnMe(ItemStack p_150933_, Slot p_150934_, ClickAction p_150935_, Player p_150936_, SlotAccess p_150937_) {
        return this.getItem().overrideOtherStackedOnMe(this, p_150933_, p_150934_, p_150935_, p_150936_, p_150937_);
    }

    public boolean hurtEnemy(LivingEntity p_41641_, LivingEntity p_364087_) {
        Item $$2 = this.getItem();
        $$2.hurtEnemy(this, p_41641_, p_364087_);
        if (this.has(DataComponents.WEAPON)) {
            if (p_364087_ instanceof Player) {
                Player $$3 = (Player)p_364087_;
                $$3.awardStat(Stats.ITEM_USED.get($$2));
            }
            return true;
        }
        return false;
    }

    public void postHurtEnemy(LivingEntity p_346409_, LivingEntity p_363649_) {
        this.getItem().postHurtEnemy(this, p_346409_, p_363649_);
        Weapon $$2 = this.get(DataComponents.WEAPON);
        if ($$2 != null) {
            this.hurtAndBreak($$2.itemDamagePerAttack(), p_363649_, EquipmentSlot.MAINHAND);
        }
    }

    public void mineBlock(Level p_41687_, BlockState p_41688_, BlockPos p_41689_, Player p_41690_) {
        Item $$4 = this.getItem();
        if ($$4.mineBlock(this, p_41687_, p_41688_, p_41689_, p_41690_)) {
            p_41690_.awardStat(Stats.ITEM_USED.get($$4));
        }
    }

    public boolean isCorrectToolForDrops(BlockState p_41736_) {
        return this.getItem().isCorrectToolForDrops(this, p_41736_);
    }

    public InteractionResult interactLivingEntity(Player p_41648_, LivingEntity p_41649_, InteractionHand p_41650_) {
        InteractionResult $$4;
        Equippable $$3 = this.get(DataComponents.EQUIPPABLE);
        if ($$3 != null && $$3.equipOnInteract() && ($$4 = $$3.equipOnTarget(p_41648_, p_41649_, this)) != InteractionResult.PASS) {
            return $$4;
        }
        return this.getItem().interactLivingEntity(this, p_41648_, p_41649_, p_41650_);
    }

    public ItemStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        ItemStack $$0 = new ItemStack(this.getItem(), this.count, this.components.copy());
        $$0.setPopTime(this.getPopTime());
        return $$0;
    }

    public ItemStack copyWithCount(int p_256354_) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        ItemStack $$1 = this.copy();
        $$1.setCount(p_256354_);
        return $$1;
    }

    public ItemStack transmuteCopy(ItemLike p_347550_) {
        return this.transmuteCopy(p_347550_, this.getCount());
    }

    public ItemStack transmuteCopy(ItemLike p_323864_, int p_323647_) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return this.transmuteCopyIgnoreEmpty(p_323864_, p_323647_);
    }

    private ItemStack transmuteCopyIgnoreEmpty(ItemLike p_323811_, int p_323856_) {
        return new ItemStack(p_323811_.asItem().builtInRegistryHolder(), p_323856_, this.components.asPatch());
    }

    public static boolean matches(ItemStack p_41729_, ItemStack p_41730_) {
        if (p_41729_ == p_41730_) {
            return true;
        }
        if (p_41729_.getCount() != p_41730_.getCount()) {
            return false;
        }
        return ItemStack.isSameItemSameComponents(p_41729_, p_41730_);
    }

    @Deprecated
    public static boolean listMatches(List<ItemStack> p_331725_, List<ItemStack> p_331113_) {
        if (p_331725_.size() != p_331113_.size()) {
            return false;
        }
        for (int $$2 = 0; $$2 < p_331725_.size(); ++$$2) {
            if (ItemStack.matches(p_331725_.get($$2), p_331113_.get($$2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isSameItem(ItemStack p_287761_, ItemStack p_287676_) {
        return p_287761_.is(p_287676_.getItem());
    }

    public static boolean isSameItemSameComponents(ItemStack p_150943_, ItemStack p_150944_) {
        if (!p_150943_.is(p_150944_.getItem())) {
            return false;
        }
        if (p_150943_.isEmpty() && p_150944_.isEmpty()) {
            return true;
        }
        return Objects.equals(p_150943_.components, p_150944_.components);
    }

    public static MapCodec<ItemStack> lenientOptionalFieldOf(String p_338501_) {
        return CODEC.lenientOptionalFieldOf(p_338501_).xmap(p_323389_ -> p_323389_.orElse(EMPTY), p_323388_ -> p_323388_.isEmpty() ? Optional.empty() : Optional.of(p_323388_));
    }

    public static int hashItemAndComponents(@Nullable ItemStack p_331961_) {
        if (p_331961_ != null) {
            int $$1 = 31 + p_331961_.getItem().hashCode();
            return 31 * $$1 + p_331961_.getComponents().hashCode();
        }
        return 0;
    }

    @Deprecated
    public static int hashStackList(List<ItemStack> p_332135_) {
        int $$1 = 0;
        for (ItemStack $$2 : p_332135_) {
            $$1 = $$1 * 31 + ItemStack.hashItemAndComponents($$2);
        }
        return $$1;
    }

    public String toString() {
        return this.getCount() + " " + String.valueOf(this.getItem());
    }

    public void inventoryTick(Level p_41667_, Entity p_41668_, @Nullable EquipmentSlot p_401778_) {
        if (this.popTime > 0) {
            --this.popTime;
        }
        if (p_41667_ instanceof ServerLevel) {
            ServerLevel $$3 = (ServerLevel)p_41667_;
            this.getItem().inventoryTick(this, $$3, p_41668_, p_401778_);
        }
    }

    public void onCraftedBy(Player p_41680_, int p_41681_) {
        p_41680_.awardStat(Stats.ITEM_CRAFTED.get(this.getItem()), p_41681_);
        this.getItem().onCraftedBy(this, p_41680_);
    }

    public void onCraftedBySystem(Level p_307669_) {
        this.getItem().onCraftedPostProcess(this, p_307669_);
    }

    public int getUseDuration(LivingEntity p_345724_) {
        return this.getItem().getUseDuration(this, p_345724_);
    }

    public ItemUseAnimation getUseAnimation() {
        return this.getItem().getUseAnimation(this);
    }

    public void releaseUsing(Level p_41675_, LivingEntity p_41676_, int p_41677_) {
        ItemStack $$4;
        ItemStack $$3 = this.copy();
        if (this.getItem().releaseUsing(this, p_41675_, p_41676_, p_41677_) && ($$4 = this.applyAfterUseComponentSideEffects(p_41676_, $$3)) != this) {
            p_41676_.setItemInHand(p_41676_.getUsedItemHand(), $$4);
        }
    }

    public boolean useOnRelease() {
        return this.getItem().useOnRelease(this);
    }

    @Nullable
    public <T> T set(DataComponentType<T> p_331064_, @Nullable T p_330775_) {
        return this.components.set(p_331064_, p_330775_);
    }

    public <T> void copyFrom(DataComponentType<T> p_397950_, DataComponentGetter p_397631_) {
        this.set(p_397950_, p_397631_.get(p_397950_));
    }

    @Nullable
    public <T, U> T update(DataComponentType<T> p_331083_, T p_331443_, U p_331049_, BiFunction<T, U, T> p_331846_) {
        return this.set(p_331083_, p_331846_.apply(this.getOrDefault(p_331083_, p_331443_), p_331049_));
    }

    @Nullable
    public <T> T update(DataComponentType<T> p_330921_, T p_331257_, UnaryOperator<T> p_331701_) {
        T $$3 = this.getOrDefault(p_330921_, p_331257_);
        return this.set(p_330921_, p_331701_.apply($$3));
    }

    @Nullable
    public <T> T remove(DataComponentType<? extends T> p_332139_) {
        return this.components.remove(p_332139_);
    }

    public void applyComponentsAndValidate(DataComponentPatch p_341407_) {
        DataComponentPatch $$1 = this.components.asPatch();
        this.components.applyPatch(p_341407_);
        Optional $$2 = ItemStack.validateStrict(this).error();
        if ($$2.isPresent()) {
            LOGGER.error("Failed to apply component patch '{}' to item: '{}'", (Object)p_341407_, (Object)((DataResult.Error)$$2.get()).message());
            this.components.restorePatch($$1);
            return;
        }
        this.getItem().verifyComponentsAfterLoad(this);
    }

    public void applyComponents(DataComponentPatch p_332097_) {
        this.components.applyPatch(p_332097_);
        this.getItem().verifyComponentsAfterLoad(this);
    }

    public void applyComponents(DataComponentMap p_330402_) {
        this.components.setAll(p_330402_);
        this.getItem().verifyComponentsAfterLoad(this);
    }

    public Component getHoverName() {
        Component $$0 = this.getCustomName();
        if ($$0 != null) {
            return $$0;
        }
        return this.getItemName();
    }

    @Nullable
    public Component getCustomName() {
        String $$2;
        Component $$0 = this.get(DataComponents.CUSTOM_NAME);
        if ($$0 != null) {
            return $$0;
        }
        WrittenBookContent $$1 = this.get(DataComponents.WRITTEN_BOOK_CONTENT);
        if ($$1 != null && !StringUtil.isBlank($$2 = $$1.title().raw())) {
            return Component.literal($$2);
        }
        return null;
    }

    public Component getItemName() {
        return this.getItem().getName(this);
    }

    public Component getStyledHoverName() {
        MutableComponent $$0 = Component.empty().append(this.getHoverName()).withStyle(this.getRarity().color());
        if (this.has(DataComponents.CUSTOM_NAME)) {
            $$0.withStyle(ChatFormatting.ITALIC);
        }
        return $$0;
    }

    public <T extends TooltipProvider> void addToTooltip(DataComponentType<T> p_331344_, Item.TooltipContext p_341231_, TooltipDisplay p_399720_, Consumer<Component> p_331885_, TooltipFlag p_331177_) {
        TooltipProvider $$5 = (TooltipProvider)this.get(p_331344_);
        if ($$5 != null && p_399720_.shows(p_331344_)) {
            $$5.addToTooltip(p_341231_, p_331885_, p_331177_, this.components);
        }
    }

    public List<Component> getTooltipLines(Item.TooltipContext p_339637_, @Nullable Player p_41652_, TooltipFlag p_41653_) {
        TooltipDisplay $$3 = this.getOrDefault(DataComponents.TOOLTIP_DISPLAY, TooltipDisplay.DEFAULT);
        if (!p_41653_.isCreative() && $$3.hideTooltip()) {
            boolean $$4 = this.getItem().shouldPrintOpWarning(this, p_41652_);
            return $$4 ? OP_NBT_WARNING : List.of();
        }
        ArrayList $$5 = Lists.newArrayList();
        $$5.add(this.getStyledHoverName());
        this.addDetailsToTooltip(p_339637_, $$3, p_41652_, p_41653_, $$5::add);
        return $$5;
    }

    public void addDetailsToTooltip(Item.TooltipContext p_400057_, TooltipDisplay p_400252_, @Nullable Player p_399628_, TooltipFlag p_400174_, Consumer<Component> p_399603_) {
        boolean $$9;
        AdventureModePredicate $$7;
        AdventureModePredicate $$6;
        this.getItem().appendHoverText(this, p_400057_, p_400252_, p_399603_, p_400174_);
        this.addToTooltip(DataComponents.TROPICAL_FISH_PATTERN, p_400057_, p_400252_, p_399603_, p_400174_);
        this.addToTooltip(DataComponents.INSTRUMENT, p_400057_, p_400252_, p_399603_, p_400174_);
        this.addToTooltip(DataComponents.MAP_ID, p_400057_, p_400252_, p_399603_, p_400174_);
        this.addToTooltip(DataComponents.BEES, p_400057_, p_400252_, p_399603_, p_400174_);
        this.addToTooltip(DataComponents.CONTAINER_LOOT, p_400057_, p_400252_, p_399603_, p_400174_);
        this.addToTooltip(DataComponents.CONTAINER, p_400057_, p_400252_, p_399603_, p_400174_);
        this.addToTooltip(DataComponents.BANNER_PATTERNS, p_400057_, p_400252_, p_399603_, p_400174_);
        this.addToTooltip(DataComponents.POT_DECORATIONS, p_400057_, p_400252_, p_399603_, p_400174_);
        this.addToTooltip(DataComponents.WRITTEN_BOOK_CONTENT, p_400057_, p_400252_, p_399603_, p_400174_);
        this.addToTooltip(DataComponents.CHARGED_PROJECTILES, p_400057_, p_400252_, p_399603_, p_400174_);
        this.addToTooltip(DataComponents.FIREWORKS, p_400057_, p_400252_, p_399603_, p_400174_);
        this.addToTooltip(DataComponents.FIREWORK_EXPLOSION, p_400057_, p_400252_, p_399603_, p_400174_);
        this.addToTooltip(DataComponents.POTION_CONTENTS, p_400057_, p_400252_, p_399603_, p_400174_);
        this.addToTooltip(DataComponents.JUKEBOX_PLAYABLE, p_400057_, p_400252_, p_399603_, p_400174_);
        this.addToTooltip(DataComponents.TRIM, p_400057_, p_400252_, p_399603_, p_400174_);
        this.addToTooltip(DataComponents.STORED_ENCHANTMENTS, p_400057_, p_400252_, p_399603_, p_400174_);
        this.addToTooltip(DataComponents.ENCHANTMENTS, p_400057_, p_400252_, p_399603_, p_400174_);
        this.addToTooltip(DataComponents.DYED_COLOR, p_400057_, p_400252_, p_399603_, p_400174_);
        this.addToTooltip(DataComponents.LORE, p_400057_, p_400252_, p_399603_, p_400174_);
        this.addAttributeTooltips(p_399603_, p_400252_, p_399628_);
        if (this.has(DataComponents.UNBREAKABLE) && p_400252_.shows(DataComponents.UNBREAKABLE)) {
            p_399603_.accept(UNBREAKABLE_TOOLTIP);
        }
        this.addToTooltip(DataComponents.OMINOUS_BOTTLE_AMPLIFIER, p_400057_, p_400252_, p_399603_, p_400174_);
        this.addToTooltip(DataComponents.SUSPICIOUS_STEW_EFFECTS, p_400057_, p_400252_, p_399603_, p_400174_);
        this.addToTooltip(DataComponents.BLOCK_STATE, p_400057_, p_400252_, p_399603_, p_400174_);
        if ((this.is(Items.SPAWNER) || this.is(Items.TRIAL_SPAWNER)) && p_400252_.shows(DataComponents.BLOCK_ENTITY_DATA)) {
            CustomData $$5 = this.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, CustomData.EMPTY);
            Spawner.appendHoverText($$5, p_399603_, "SpawnData");
        }
        if (($$6 = this.get(DataComponents.CAN_BREAK)) != null && p_400252_.shows(DataComponents.CAN_BREAK)) {
            p_399603_.accept(CommonComponents.EMPTY);
            p_399603_.accept(AdventureModePredicate.CAN_BREAK_HEADER);
            $$6.addToTooltip(p_399603_);
        }
        if (($$7 = this.get(DataComponents.CAN_PLACE_ON)) != null && p_400252_.shows(DataComponents.CAN_PLACE_ON)) {
            p_399603_.accept(CommonComponents.EMPTY);
            p_399603_.accept(AdventureModePredicate.CAN_PLACE_HEADER);
            $$7.addToTooltip(p_399603_);
        }
        if (p_400174_.isAdvanced()) {
            if (this.isDamaged() && p_400252_.shows(DataComponents.DAMAGE)) {
                p_399603_.accept(Component.translatable("item.durability", this.getMaxDamage() - this.getDamageValue(), this.getMaxDamage()));
            }
            p_399603_.accept(Component.literal(BuiltInRegistries.ITEM.getKey(this.getItem()).toString()).withStyle(ChatFormatting.DARK_GRAY));
            int $$8 = this.components.size();
            if ($$8 > 0) {
                p_399603_.accept(Component.translatable("item.components", $$8).withStyle(ChatFormatting.DARK_GRAY));
            }
        }
        if (p_399628_ != null && !this.getItem().isEnabled(p_399628_.level().enabledFeatures())) {
            p_399603_.accept(DISABLED_ITEM_TOOLTIP);
        }
        if ($$9 = this.getItem().shouldPrintOpWarning(this, p_399628_)) {
            OP_NBT_WARNING.forEach(p_399603_);
        }
    }

    private void addAttributeTooltips(Consumer<Component> p_330796_, TooltipDisplay p_400175_, @Nullable Player p_330530_) {
        if (!p_400175_.shows(DataComponents.ATTRIBUTE_MODIFIERS)) {
            return;
        }
        for (EquipmentSlotGroup $$3 : EquipmentSlotGroup.values()) {
            MutableBoolean $$4 = new MutableBoolean(true);
            this.forEachModifier($$3, (TriConsumer<Holder<Attribute>, AttributeModifier, ItemAttributeModifiers.Display>)((TriConsumer)(p_415402_, p_415403_, p_415404_) -> {
                if (p_415404_ == ItemAttributeModifiers.Display.hidden()) {
                    return;
                }
                if ($$4.isTrue()) {
                    p_330796_.accept(CommonComponents.EMPTY);
                    p_330796_.accept(Component.translatable("item.modifiers." + $$3.getSerializedName()).withStyle(ChatFormatting.GRAY));
                    $$4.setFalse();
                }
                p_415404_.apply(p_330796_, p_330530_, (Holder<Attribute>)p_415402_, (AttributeModifier)p_415403_);
            }));
        }
    }

    public boolean hasFoil() {
        Boolean $$0 = this.get(DataComponents.ENCHANTMENT_GLINT_OVERRIDE);
        if ($$0 != null) {
            return $$0;
        }
        return this.getItem().isFoil(this);
    }

    public Rarity getRarity() {
        Rarity $$0 = this.getOrDefault(DataComponents.RARITY, Rarity.COMMON);
        if (!this.isEnchanted()) {
            return $$0;
        }
        return switch ($$0) {
            case Rarity.COMMON, Rarity.UNCOMMON -> Rarity.RARE;
            case Rarity.RARE -> Rarity.EPIC;
            default -> $$0;
        };
    }

    public boolean isEnchantable() {
        if (!this.has(DataComponents.ENCHANTABLE)) {
            return false;
        }
        ItemEnchantments $$0 = this.get(DataComponents.ENCHANTMENTS);
        return $$0 != null && $$0.isEmpty();
    }

    public void enchant(Holder<Enchantment> p_344751_, int p_41665_) {
        EnchantmentHelper.updateEnchantments(this, p_344404_ -> p_344404_.upgrade(p_344751_, p_41665_));
    }

    public boolean isEnchanted() {
        return !this.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY).isEmpty();
    }

    public ItemEnchantments getEnchantments() {
        return this.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
    }

    public boolean isFramed() {
        return this.entityRepresentation instanceof ItemFrame;
    }

    public void setEntityRepresentation(@Nullable Entity p_41637_) {
        if (!this.isEmpty()) {
            this.entityRepresentation = p_41637_;
        }
    }

    @Nullable
    public ItemFrame getFrame() {
        return this.entityRepresentation instanceof ItemFrame ? (ItemFrame)this.getEntityRepresentation() : null;
    }

    @Nullable
    public Entity getEntityRepresentation() {
        return !this.isEmpty() ? this.entityRepresentation : null;
    }

    public void forEachModifier(EquipmentSlotGroup p_348610_, TriConsumer<Holder<Attribute>, AttributeModifier, ItemAttributeModifiers.Display> p_415655_) {
        ItemAttributeModifiers $$2 = this.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY);
        $$2.forEach(p_348610_, p_415655_);
        EnchantmentHelper.forEachModifier(this, p_348610_, (p_415406_, p_415407_) -> p_415655_.accept(p_415406_, p_415407_, (Object)ItemAttributeModifiers.Display.attributeModifiers()));
    }

    public void forEachModifier(EquipmentSlot p_332001_, BiConsumer<Holder<Attribute>, AttributeModifier> p_330882_) {
        ItemAttributeModifiers $$2 = this.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY);
        $$2.forEach(p_332001_, p_330882_);
        EnchantmentHelper.forEachModifier(this, p_332001_, p_330882_);
    }

    public Component getDisplayName() {
        MutableComponent $$0 = Component.empty().append(this.getHoverName());
        if (this.has(DataComponents.CUSTOM_NAME)) {
            $$0.withStyle(ChatFormatting.ITALIC);
        }
        MutableComponent $$1 = ComponentUtils.wrapInSquareBrackets($$0);
        if (!this.isEmpty()) {
            $$1.withStyle(this.getRarity().color()).withStyle(p_393272_ -> p_393272_.withHoverEvent(new HoverEvent.ShowItem(this)));
        }
        return $$1;
    }

    public boolean canPlaceOnBlockInAdventureMode(BlockInWorld p_331419_) {
        AdventureModePredicate $$1 = this.get(DataComponents.CAN_PLACE_ON);
        return $$1 != null && $$1.test(p_331419_);
    }

    public boolean canBreakBlockInAdventureMode(BlockInWorld p_331592_) {
        AdventureModePredicate $$1 = this.get(DataComponents.CAN_BREAK);
        return $$1 != null && $$1.test(p_331592_);
    }

    public int getPopTime() {
        return this.popTime;
    }

    public void setPopTime(int p_41755_) {
        this.popTime = p_41755_;
    }

    public int getCount() {
        return this.isEmpty() ? 0 : this.count;
    }

    public void setCount(int p_41765_) {
        this.count = p_41765_;
    }

    public void limitSize(int p_335437_) {
        if (!this.isEmpty() && this.getCount() > p_335437_) {
            this.setCount(p_335437_);
        }
    }

    public void grow(int p_41770_) {
        this.setCount(this.getCount() + p_41770_);
    }

    public void shrink(int p_41775_) {
        this.grow(-p_41775_);
    }

    public void consume(int p_326311_, @Nullable LivingEntity p_326200_) {
        if (p_326200_ == null || !p_326200_.hasInfiniteMaterials()) {
            this.shrink(p_326311_);
        }
    }

    public ItemStack consumeAndReturn(int p_347624_, @Nullable LivingEntity p_347710_) {
        ItemStack $$2 = this.copyWithCount(p_347624_);
        this.consume(p_347624_, p_347710_);
        return $$2;
    }

    public void onUseTick(Level p_41732_, LivingEntity p_41733_, int p_41734_) {
        Consumable $$3 = this.get(DataComponents.CONSUMABLE);
        if ($$3 != null && $$3.shouldEmitParticlesAndSounds(p_41734_)) {
            $$3.emitParticlesAndSounds(p_41733_.getRandom(), p_41733_, this, 5);
        }
        this.getItem().onUseTick(p_41732_, p_41733_, this, p_41734_);
    }

    public void onDestroyed(ItemEntity p_150925_) {
        this.getItem().onDestroyed(p_150925_);
    }

    public boolean canBeHurtBy(DamageSource p_335431_) {
        DamageResistant $$1 = this.get(DataComponents.DAMAGE_RESISTANT);
        return $$1 == null || !$$1.isResistantTo(p_335431_);
    }

    public boolean isValidRepairItem(ItemStack p_362836_) {
        Repairable $$1 = this.get(DataComponents.REPAIRABLE);
        return $$1 != null && $$1.isValidRepairItem(p_362836_);
    }

    public boolean canDestroyBlock(BlockState p_394270_, Level p_393831_, BlockPos p_394075_, Player p_393908_) {
        return this.getItem().canDestroyBlock(this, p_394270_, p_393831_, p_394075_, p_393908_);
    }
}

