/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.component.InstrumentComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class InstrumentItem
extends Item {
    public InstrumentItem(Item.Properties p_220099_) {
        super(p_220099_);
    }

    public static ItemStack create(Item p_220108_, Holder<Instrument> p_220109_) {
        ItemStack $$2 = new ItemStack(p_220108_);
        $$2.set(DataComponents.INSTRUMENT, new InstrumentComponent(p_220109_));
        return $$2;
    }

    @Override
    public InteractionResult use(Level p_220123_, Player p_220124_, InteractionHand p_220125_) {
        ItemStack $$3 = p_220124_.getItemInHand(p_220125_);
        Optional<Holder<Instrument>> $$4 = this.getInstrument($$3, p_220124_.registryAccess());
        if ($$4.isPresent()) {
            Instrument $$5 = $$4.get().value();
            p_220124_.startUsingItem(p_220125_);
            InstrumentItem.play(p_220123_, p_220124_, $$5);
            p_220124_.getCooldowns().addCooldown($$3, Mth.floor($$5.useDuration() * 20.0f));
            p_220124_.awardStat(Stats.ITEM_USED.get(this));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public int getUseDuration(ItemStack p_220131_, LivingEntity p_345916_) {
        Optional<Holder<Instrument>> $$2 = this.getInstrument(p_220131_, p_345916_.registryAccess());
        return $$2.map(p_360033_ -> Mth.floor(((Instrument)p_360033_.value()).useDuration() * 20.0f)).orElse(0);
    }

    private Optional<Holder<Instrument>> getInstrument(ItemStack p_220135_, HolderLookup.Provider p_365136_) {
        InstrumentComponent $$2 = p_220135_.get(DataComponents.INSTRUMENT);
        return $$2 != null ? $$2.unwrap(p_365136_) : Optional.empty();
    }

    @Override
    public ItemUseAnimation getUseAnimation(ItemStack p_220133_) {
        return ItemUseAnimation.TOOT_HORN;
    }

    private static void play(Level p_220127_, Player p_220128_, Instrument p_220129_) {
        SoundEvent $$3 = p_220129_.soundEvent().value();
        float $$4 = p_220129_.range() / 16.0f;
        p_220127_.playSound((Entity)p_220128_, p_220128_, $$3, SoundSource.RECORDS, $$4, 1.0f);
        p_220127_.gameEvent(GameEvent.INSTRUMENT_PLAY, p_220128_.position(), GameEvent.Context.of(p_220128_));
    }
}

