/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class BucketItem
extends Item
implements DispensibleContainerItem {
    private final Fluid content;

    public BucketItem(Fluid p_40689_, Item.Properties p_40690_) {
        super(p_40690_);
        this.content = p_40689_;
    }

    @Override
    public InteractionResult use(Level p_40703_, Player p_40704_, InteractionHand p_40705_) {
        ItemStack $$3 = p_40704_.getItemInHand(p_40705_);
        BlockHitResult $$4 = BucketItem.getPlayerPOVHitResult(p_40703_, p_40704_, this.content == Fluids.EMPTY ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE);
        if ($$4.getType() == HitResult.Type.MISS) {
            return InteractionResult.PASS;
        }
        if ($$4.getType() == HitResult.Type.BLOCK) {
            BlockPos $$13;
            BlockPos $$5 = $$4.getBlockPos();
            Direction $$6 = $$4.getDirection();
            BlockPos $$7 = $$5.relative($$6);
            if (!p_40703_.mayInteract(p_40704_, $$5) || !p_40704_.mayUseItemAt($$7, $$6, $$3)) {
                return InteractionResult.FAIL;
            }
            if (this.content == Fluids.EMPTY) {
                BucketPickup $$9;
                ItemStack $$10;
                BlockState $$8 = p_40703_.getBlockState($$5);
                Block block = $$8.getBlock();
                if (block instanceof BucketPickup && !($$10 = ($$9 = (BucketPickup)((Object)block)).pickupBlock(p_40704_, p_40703_, $$5, $$8)).isEmpty()) {
                    p_40704_.awardStat(Stats.ITEM_USED.get(this));
                    $$9.getPickupSound().ifPresent(p_150709_ -> p_40704_.playSound((SoundEvent)p_150709_, 1.0f, 1.0f));
                    p_40703_.gameEvent((Entity)p_40704_, GameEvent.FLUID_PICKUP, $$5);
                    ItemStack $$11 = ItemUtils.createFilledResult($$3, p_40704_, $$10);
                    if (!p_40703_.isClientSide) {
                        CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)p_40704_, $$10);
                    }
                    return InteractionResult.SUCCESS.heldItemTransformedTo($$11);
                }
                return InteractionResult.FAIL;
            }
            BlockState $$12 = p_40703_.getBlockState($$5);
            BlockPos blockPos = $$13 = $$12.getBlock() instanceof LiquidBlockContainer && this.content == Fluids.WATER ? $$5 : $$7;
            if (this.emptyContents(p_40704_, p_40703_, $$13, $$4)) {
                this.checkExtraContent(p_40704_, p_40703_, $$3, $$13);
                if (p_40704_ instanceof ServerPlayer) {
                    CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)p_40704_, $$13, $$3);
                }
                p_40704_.awardStat(Stats.ITEM_USED.get(this));
                ItemStack $$14 = ItemUtils.createFilledResult($$3, p_40704_, BucketItem.getEmptySuccessItem($$3, p_40704_));
                return InteractionResult.SUCCESS.heldItemTransformedTo($$14);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public static ItemStack getEmptySuccessItem(ItemStack p_40700_, Player p_40701_) {
        if (!p_40701_.hasInfiniteMaterials()) {
            return new ItemStack(Items.BUCKET);
        }
        return p_40700_;
    }

    @Override
    public void checkExtraContent(@Nullable LivingEntity p_394527_, Level p_150712_, ItemStack p_150713_, BlockPos p_150714_) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean emptyContents(@Nullable LivingEntity p_394627_, Level p_150717_, BlockPos p_150718_, @Nullable BlockHitResult p_150719_) {
        LiquidBlockContainer $$9;
        boolean $$10;
        Fluid fluid = this.content;
        if (!(fluid instanceof FlowingFluid)) {
            return false;
        }
        FlowingFluid $$4 = (FlowingFluid)fluid;
        BlockState $$6 = p_150717_.getBlockState(p_150718_);
        Block $$7 = $$6.getBlock();
        boolean $$8 = $$6.canBeReplaced(this.content);
        boolean bl = $$10 = $$6.isAir() || $$8 || $$7 instanceof LiquidBlockContainer && ($$9 = (LiquidBlockContainer)((Object)$$7)).canPlaceLiquid(p_394627_, p_150717_, p_150718_, $$6, this.content);
        if (!$$10) {
            return p_150719_ != null && this.emptyContents(p_394627_, p_150717_, p_150719_.getBlockPos().relative(p_150719_.getDirection()), null);
        }
        if (p_150717_.dimensionType().ultraWarm() && this.content.is(FluidTags.WATER)) {
            int $$11 = p_150718_.getX();
            int $$12 = p_150718_.getY();
            int $$13 = p_150718_.getZ();
            p_150717_.playSound((Entity)p_394627_, p_150718_, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (p_150717_.random.nextFloat() - p_150717_.random.nextFloat()) * 0.8f);
            for (int $$14 = 0; $$14 < 8; ++$$14) {
                p_150717_.addParticle(ParticleTypes.LARGE_SMOKE, (double)$$11 + Math.random(), (double)$$12 + Math.random(), (double)$$13 + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if ($$7 instanceof LiquidBlockContainer) {
            LiquidBlockContainer $$15 = (LiquidBlockContainer)((Object)$$7);
            if (this.content == Fluids.WATER) {
                void $$5;
                $$15.placeLiquid(p_150717_, p_150718_, $$6, $$5.getSource(false));
                this.playEmptySound(p_394627_, p_150717_, p_150718_);
                return true;
            }
        }
        if (!p_150717_.isClientSide && $$8 && !$$6.liquid()) {
            p_150717_.destroyBlock(p_150718_, true);
        }
        if (p_150717_.setBlock(p_150718_, this.content.defaultFluidState().createLegacyBlock(), 11) || $$6.getFluidState().isSource()) {
            this.playEmptySound(p_394627_, p_150717_, p_150718_);
            return true;
        }
        return false;
    }

    protected void playEmptySound(@Nullable LivingEntity p_394061_, LevelAccessor p_40697_, BlockPos p_40698_) {
        SoundEvent $$3 = this.content.is(FluidTags.LAVA) ? SoundEvents.BUCKET_EMPTY_LAVA : SoundEvents.BUCKET_EMPTY;
        p_40697_.playSound(p_394061_, p_40698_, $$3, SoundSource.BLOCKS, 1.0f, 1.0f);
        p_40697_.gameEvent((Entity)p_394061_, GameEvent.FLUID_PLACE, p_40698_);
    }
}

