/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.storage.TagValueOutput;
import org.slf4j.Logger;

public class AdventureModePredicate {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<AdventureModePredicate> CODEC = ExtraCodecs.compactListCodec(BlockPredicate.CODEC, ExtraCodecs.nonEmptyList(BlockPredicate.CODEC.listOf())).xmap(AdventureModePredicate::new, p_331329_ -> p_331329_.predicates);
    public static final StreamCodec<RegistryFriendlyByteBuf, AdventureModePredicate> STREAM_CODEC = StreamCodec.composite(BlockPredicate.STREAM_CODEC.apply(ByteBufCodecs.list()), p_331439_ -> p_331439_.predicates, AdventureModePredicate::new);
    public static final Component CAN_BREAK_HEADER = Component.translatable("item.canBreak").withStyle(ChatFormatting.GRAY);
    public static final Component CAN_PLACE_HEADER = Component.translatable("item.canPlace").withStyle(ChatFormatting.GRAY);
    private static final Component UNKNOWN_USE = Component.translatable("item.canUse.unknown").withStyle(ChatFormatting.GRAY);
    private final List<BlockPredicate> predicates;
    @Nullable
    private List<Component> cachedTooltip;
    @Nullable
    private BlockInWorld lastCheckedBlock;
    private boolean lastResult;
    private boolean checksBlockEntity;

    public AdventureModePredicate(List<BlockPredicate> p_331906_) {
        this.predicates = p_331906_;
    }

    private static boolean areSameBlocks(BlockInWorld p_330901_, @Nullable BlockInWorld p_331435_, boolean p_332152_) {
        if (p_331435_ == null || p_330901_.getState() != p_331435_.getState()) {
            return false;
        }
        if (!p_332152_) {
            return true;
        }
        if (p_330901_.getEntity() == null && p_331435_.getEntity() == null) {
            return true;
        }
        if (p_330901_.getEntity() == null || p_331435_.getEntity() == null) {
            return false;
        }
        try (ProblemReporter.ScopedCollector $$3 = new ProblemReporter.ScopedCollector(LOGGER);){
            RegistryAccess $$4 = p_330901_.getLevel().registryAccess();
            CompoundTag $$5 = AdventureModePredicate.saveBlockEntity(p_330901_.getEntity(), $$4, $$3);
            CompoundTag $$6 = AdventureModePredicate.saveBlockEntity(p_331435_.getEntity(), $$4, $$3);
            boolean bl = Objects.equals($$5, $$6);
            return bl;
        }
    }

    private static CompoundTag saveBlockEntity(BlockEntity p_422309_, RegistryAccess p_422663_, ProblemReporter p_422210_) {
        TagValueOutput $$3 = TagValueOutput.createWithContext(p_422210_.forChild(p_422309_.problemPath()), p_422663_);
        p_422309_.saveWithId($$3);
        return $$3.buildResult();
    }

    public boolean test(BlockInWorld p_331911_) {
        if (AdventureModePredicate.areSameBlocks(p_331911_, this.lastCheckedBlock, this.checksBlockEntity)) {
            return this.lastResult;
        }
        this.lastCheckedBlock = p_331911_;
        this.checksBlockEntity = false;
        for (BlockPredicate $$1 : this.predicates) {
            if (!$$1.matches(p_331911_)) continue;
            this.checksBlockEntity |= $$1.requiresNbt();
            this.lastResult = true;
            return true;
        }
        this.lastResult = false;
        return false;
    }

    private List<Component> tooltip() {
        if (this.cachedTooltip == null) {
            this.cachedTooltip = AdventureModePredicate.computeTooltip(this.predicates);
        }
        return this.cachedTooltip;
    }

    public void addToTooltip(Consumer<Component> p_331792_) {
        this.tooltip().forEach(p_331792_);
    }

    private static List<Component> computeTooltip(List<BlockPredicate> p_332164_) {
        for (BlockPredicate $$1 : p_332164_) {
            if (!$$1.blocks().isEmpty()) continue;
            return List.of(UNKNOWN_USE);
        }
        return p_332164_.stream().flatMap(p_330395_ -> p_330395_.blocks().orElseThrow().stream()).distinct().map(p_331662_ -> ((Block)p_331662_.value()).getName().withStyle(ChatFormatting.DARK_GRAY)).toList();
    }

    public boolean equals(Object p_330844_) {
        if (this == p_330844_) {
            return true;
        }
        if (p_330844_ instanceof AdventureModePredicate) {
            AdventureModePredicate $$1 = (AdventureModePredicate)p_330844_;
            return this.predicates.equals($$1.predicates);
        }
        return false;
    }

    public int hashCode() {
        return this.predicates.hashCode();
    }

    public String toString() {
        return "AdventureModePredicate{predicates=" + String.valueOf(this.predicates) + "}";
    }
}

