/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class ResultSlot
extends Slot {
    private final CraftingContainer craftSlots;
    private final Player player;
    private int removeCount;

    public ResultSlot(Player p_40166_, CraftingContainer p_40167_, Container p_40168_, int p_40169_, int p_40170_, int p_40171_) {
        super(p_40168_, p_40169_, p_40170_, p_40171_);
        this.player = p_40166_;
        this.craftSlots = p_40167_;
    }

    @Override
    public boolean mayPlace(ItemStack p_40178_) {
        return false;
    }

    @Override
    public ItemStack remove(int p_40173_) {
        if (this.hasItem()) {
            this.removeCount += Math.min(p_40173_, this.getItem().getCount());
        }
        return super.remove(p_40173_);
    }

    @Override
    protected void onQuickCraft(ItemStack p_40180_, int p_40181_) {
        this.removeCount += p_40181_;
        this.checkTakeAchievements(p_40180_);
    }

    @Override
    protected void onSwapCraft(int p_40183_) {
        this.removeCount += p_40183_;
    }

    @Override
    protected void checkTakeAchievements(ItemStack p_40185_) {
        Container container;
        if (this.removeCount > 0) {
            p_40185_.onCraftedBy(this.player, this.removeCount);
        }
        if ((container = this.container) instanceof RecipeCraftingHolder) {
            RecipeCraftingHolder $$1 = (RecipeCraftingHolder)((Object)container);
            $$1.awardUsedRecipes(this.player, this.craftSlots.getItems());
        }
        this.removeCount = 0;
    }

    private static NonNullList<ItemStack> copyAllInputItems(CraftingInput p_379867_) {
        NonNullList<ItemStack> $$1 = NonNullList.withSize(p_379867_.size(), ItemStack.EMPTY);
        for (int $$2 = 0; $$2 < $$1.size(); ++$$2) {
            $$1.set($$2, p_379867_.getItem($$2));
        }
        return $$1;
    }

    private NonNullList<ItemStack> getRemainingItems(CraftingInput p_379501_, Level p_380183_) {
        if (p_380183_ instanceof ServerLevel) {
            ServerLevel $$2 = (ServerLevel)p_380183_;
            return $$2.recipeAccess().getRecipeFor(RecipeType.CRAFTING, p_379501_, $$2).map(p_380214_ -> ((CraftingRecipe)p_380214_.value()).getRemainingItems(p_379501_)).orElseGet(() -> ResultSlot.copyAllInputItems(p_379501_));
        }
        return CraftingRecipe.defaultCraftingReminder(p_379501_);
    }

    @Override
    public void onTake(Player p_150638_, ItemStack p_150639_) {
        this.checkTakeAchievements(p_150639_);
        CraftingInput.Positioned $$2 = this.craftSlots.asPositionedCraftInput();
        CraftingInput $$3 = $$2.input();
        int $$4 = $$2.left();
        int $$5 = $$2.top();
        NonNullList<ItemStack> $$6 = this.getRemainingItems($$3, p_150638_.level());
        for (int $$7 = 0; $$7 < $$3.height(); ++$$7) {
            for (int $$8 = 0; $$8 < $$3.width(); ++$$8) {
                int $$9 = $$8 + $$4 + ($$7 + $$5) * this.craftSlots.getWidth();
                ItemStack $$10 = this.craftSlots.getItem($$9);
                ItemStack $$11 = $$6.get($$8 + $$7 * $$3.width());
                if (!$$10.isEmpty()) {
                    this.craftSlots.removeItem($$9, 1);
                    $$10 = this.craftSlots.getItem($$9);
                }
                if ($$11.isEmpty()) continue;
                if ($$10.isEmpty()) {
                    this.craftSlots.setItem($$9, $$11);
                    continue;
                }
                if (ItemStack.isSameItemSameComponents($$10, $$11)) {
                    $$11.grow($$10.getCount());
                    this.craftSlots.setItem($$9, $$11);
                    continue;
                }
                if (this.player.getInventory().add($$11)) continue;
                this.player.drop($$11, false);
            }
        }
    }

    @Override
    public boolean isFake() {
        return true;
    }
}

