/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import javax.annotation.Nullable;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class PlayerEnderChestContainer
extends SimpleContainer {
    @Nullable
    private EnderChestBlockEntity activeChest;

    public PlayerEnderChestContainer() {
        super(27);
    }

    public void setActiveChest(EnderChestBlockEntity p_40106_) {
        this.activeChest = p_40106_;
    }

    public boolean isActiveChest(EnderChestBlockEntity p_150634_) {
        return this.activeChest == p_150634_;
    }

    public void fromSlots(ValueInput.TypedInputList<ItemStackWithSlot> p_421839_) {
        for (int $$1 = 0; $$1 < this.getContainerSize(); ++$$1) {
            this.setItem($$1, ItemStack.EMPTY);
        }
        for (ItemStackWithSlot $$2 : p_421839_) {
            if (!$$2.isValidInContainer(this.getContainerSize())) continue;
            this.setItem($$2.slot(), $$2.stack());
        }
    }

    public void storeAsSlots(ValueOutput.TypedOutputList<ItemStackWithSlot> p_421593_) {
        for (int $$1 = 0; $$1 < this.getContainerSize(); ++$$1) {
            ItemStack $$2 = this.getItem($$1);
            if ($$2.isEmpty()) continue;
            p_421593_.add(new ItemStackWithSlot($$1, $$2));
        }
    }

    @Override
    public boolean stillValid(Player p_40104_) {
        if (this.activeChest != null && !this.activeChest.stillValid(p_40104_)) {
            return false;
        }
        return super.stillValid(p_40104_);
    }

    @Override
    public void startOpen(Player p_40112_) {
        if (this.activeChest != null) {
            this.activeChest.startOpen(p_40112_);
        }
        super.startOpen(p_40112_);
    }

    @Override
    public void stopOpen(Player p_40110_) {
        if (this.activeChest != null) {
            this.activeChest.stopOpen(p_40110_);
        }
        super.stopOpen(p_40110_);
        this.activeChest = null;
    }
}

