/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class GrindstoneMenu
extends AbstractContainerMenu {
    public static final int MAX_NAME_LENGTH = 35;
    public static final int INPUT_SLOT = 0;
    public static final int ADDITIONAL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    private static final int INV_SLOT_START = 3;
    private static final int INV_SLOT_END = 30;
    private static final int USE_ROW_SLOT_START = 30;
    private static final int USE_ROW_SLOT_END = 39;
    private final Container resultSlots = new ResultContainer();
    final Container repairSlots = new SimpleContainer(2){

        @Override
        public void setChanged() {
            super.setChanged();
            GrindstoneMenu.this.slotsChanged(this);
        }
    };
    private final ContainerLevelAccess access;

    public GrindstoneMenu(int p_39563_, Inventory p_39564_) {
        this(p_39563_, p_39564_, ContainerLevelAccess.NULL);
    }

    public GrindstoneMenu(int p_39566_, Inventory p_39567_, final ContainerLevelAccess p_39568_) {
        super(MenuType.GRINDSTONE, p_39566_);
        this.access = p_39568_;
        this.addSlot(new Slot(this, this.repairSlots, 0, 49, 19){

            @Override
            public boolean mayPlace(ItemStack p_39607_) {
                return p_39607_.isDamageableItem() || EnchantmentHelper.hasAnyEnchantments(p_39607_);
            }
        });
        this.addSlot(new Slot(this, this.repairSlots, 1, 49, 40){

            @Override
            public boolean mayPlace(ItemStack p_39616_) {
                return p_39616_.isDamageableItem() || EnchantmentHelper.hasAnyEnchantments(p_39616_);
            }
        });
        this.addSlot(new Slot(this.resultSlots, 2, 129, 34){

            @Override
            public boolean mayPlace(ItemStack p_39630_) {
                return false;
            }

            @Override
            public void onTake(Player p_150574_, ItemStack p_150575_) {
                p_39568_.execute((p_39634_, p_39635_) -> {
                    if (p_39634_ instanceof ServerLevel) {
                        ExperienceOrb.award((ServerLevel)p_39634_, Vec3.atCenterOf(p_39635_), this.getExperienceAmount((Level)p_39634_));
                    }
                    p_39634_.levelEvent(1042, (BlockPos)p_39635_, 0);
                });
                GrindstoneMenu.this.repairSlots.setItem(0, ItemStack.EMPTY);
                GrindstoneMenu.this.repairSlots.setItem(1, ItemStack.EMPTY);
            }

            private int getExperienceAmount(Level p_39632_) {
                int $$1 = 0;
                $$1 += this.getExperienceFromItem(GrindstoneMenu.this.repairSlots.getItem(0));
                if (($$1 += this.getExperienceFromItem(GrindstoneMenu.this.repairSlots.getItem(1))) > 0) {
                    int $$2 = (int)Math.ceil((double)$$1 / 2.0);
                    return $$2 + p_39632_.random.nextInt($$2);
                }
                return 0;
            }

            private int getExperienceFromItem(ItemStack p_39637_) {
                int $$1 = 0;
                ItemEnchantments $$2 = EnchantmentHelper.getEnchantmentsForCrafting(p_39637_);
                for (Object2IntMap.Entry<Holder<Enchantment>> $$3 : $$2.entrySet()) {
                    Holder $$4 = (Holder)$$3.getKey();
                    int $$5 = $$3.getIntValue();
                    if ($$4.is(EnchantmentTags.CURSE)) continue;
                    $$1 += ((Enchantment)$$4.value()).getMinCost($$5);
                }
                return $$1;
            }
        });
        this.addStandardInventorySlots(p_39567_, 8, 84);
    }

    @Override
    public void slotsChanged(Container p_39570_) {
        super.slotsChanged(p_39570_);
        if (p_39570_ == this.repairSlots) {
            this.createResult();
        }
    }

    private void createResult() {
        this.resultSlots.setItem(0, this.computeResult(this.repairSlots.getItem(0), this.repairSlots.getItem(1)));
        this.broadcastChanges();
    }

    private ItemStack computeResult(ItemStack p_332654_, ItemStack p_332736_) {
        boolean $$3;
        boolean $$2;
        boolean bl = $$2 = !p_332654_.isEmpty() || !p_332736_.isEmpty();
        if (!$$2) {
            return ItemStack.EMPTY;
        }
        if (p_332654_.getCount() > 1 || p_332736_.getCount() > 1) {
            return ItemStack.EMPTY;
        }
        boolean bl2 = $$3 = !p_332654_.isEmpty() && !p_332736_.isEmpty();
        if (!$$3) {
            ItemStack $$4;
            ItemStack itemStack = $$4 = !p_332654_.isEmpty() ? p_332654_ : p_332736_;
            if (!EnchantmentHelper.hasAnyEnchantments($$4)) {
                return ItemStack.EMPTY;
            }
            return this.removeNonCursesFrom($$4.copy());
        }
        return this.mergeItems(p_332654_, p_332736_);
    }

    private ItemStack mergeItems(ItemStack p_332723_, ItemStack p_332686_) {
        ItemStack $$7;
        if (!p_332723_.is(p_332686_.getItem())) {
            return ItemStack.EMPTY;
        }
        int $$2 = Math.max(p_332723_.getMaxDamage(), p_332686_.getMaxDamage());
        int $$3 = p_332723_.getMaxDamage() - p_332723_.getDamageValue();
        int $$4 = p_332686_.getMaxDamage() - p_332686_.getDamageValue();
        int $$5 = $$3 + $$4 + $$2 * 5 / 100;
        int $$6 = 1;
        if (!p_332723_.isDamageableItem()) {
            if (p_332723_.getMaxStackSize() < 2 || !ItemStack.matches(p_332723_, p_332686_)) {
                return ItemStack.EMPTY;
            }
            $$6 = 2;
        }
        if (($$7 = p_332723_.copyWithCount($$6)).isDamageableItem()) {
            $$7.set(DataComponents.MAX_DAMAGE, $$2);
            $$7.setDamageValue(Math.max($$2 - $$5, 0));
        }
        this.mergeEnchantsFrom($$7, p_332686_);
        return this.removeNonCursesFrom($$7);
    }

    private void mergeEnchantsFrom(ItemStack p_332680_, ItemStack p_332800_) {
        EnchantmentHelper.updateEnchantments(p_332680_, p_344370_ -> {
            ItemEnchantments $$2 = EnchantmentHelper.getEnchantmentsForCrafting(p_332800_);
            for (Object2IntMap.Entry<Holder<Enchantment>> $$3 : $$2.entrySet()) {
                Holder $$4 = (Holder)$$3.getKey();
                if ($$4.is(EnchantmentTags.CURSE) && p_344370_.getLevel($$4) != 0) continue;
                p_344370_.upgrade($$4, $$3.getIntValue());
            }
        });
    }

    private ItemStack removeNonCursesFrom(ItemStack p_332709_) {
        ItemEnchantments $$1 = EnchantmentHelper.updateEnchantments(p_332709_, p_330066_ -> p_330066_.removeIf(p_344368_ -> !p_344368_.is(EnchantmentTags.CURSE)));
        if (p_332709_.is(Items.ENCHANTED_BOOK) && $$1.isEmpty()) {
            p_332709_ = p_332709_.transmuteCopy(Items.BOOK);
        }
        int $$2 = 0;
        for (int $$3 = 0; $$3 < $$1.size(); ++$$3) {
            $$2 = AnvilMenu.calculateIncreasedRepairCost($$2);
        }
        p_332709_.set(DataComponents.REPAIR_COST, $$2);
        return p_332709_;
    }

    @Override
    public void removed(Player p_39586_) {
        super.removed(p_39586_);
        this.access.execute((p_39575_, p_39576_) -> this.clearContainer(p_39586_, this.repairSlots));
    }

    @Override
    public boolean stillValid(Player p_39572_) {
        return GrindstoneMenu.stillValid(this.access, p_39572_, Blocks.GRINDSTONE);
    }

    @Override
    public ItemStack quickMoveStack(Player p_39588_, int p_39589_) {
        ItemStack $$2 = ItemStack.EMPTY;
        Slot $$3 = (Slot)this.slots.get(p_39589_);
        if ($$3 != null && $$3.hasItem()) {
            ItemStack $$4 = $$3.getItem();
            $$2 = $$4.copy();
            ItemStack $$5 = this.repairSlots.getItem(0);
            ItemStack $$6 = this.repairSlots.getItem(1);
            if (p_39589_ == 2) {
                if (!this.moveItemStackTo($$4, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                $$3.onQuickCraft($$4, $$2);
            } else if (p_39589_ == 0 || p_39589_ == 1 ? !this.moveItemStackTo($$4, 3, 39, false) : ($$5.isEmpty() || $$6.isEmpty() ? !this.moveItemStackTo($$4, 0, 2, false) : (p_39589_ >= 3 && p_39589_ < 30 ? !this.moveItemStackTo($$4, 30, 39, false) : p_39589_ >= 30 && p_39589_ < 39 && !this.moveItemStackTo($$4, 3, 30, false)))) {
                return ItemStack.EMPTY;
            }
            if ($$4.isEmpty()) {
                $$3.setByPlayer(ItemStack.EMPTY);
            } else {
                $$3.setChanged();
            }
            if ($$4.getCount() == $$2.getCount()) {
                return ItemStack.EMPTY;
            }
            $$3.onTake(p_39588_, $$4);
        }
        return $$2;
    }
}

