/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ShulkerBullet
extends Projectile {
    private static final double SPEED = 0.15;
    @Nullable
    private EntityReference<Entity> finalTarget;
    @Nullable
    private Direction currentMoveDirection;
    private int flightSteps;
    private double targetDeltaX;
    private double targetDeltaY;
    private double targetDeltaZ;

    public ShulkerBullet(EntityType<? extends ShulkerBullet> p_37319_, Level p_37320_) {
        super((EntityType<? extends Projectile>)p_37319_, p_37320_);
        this.noPhysics = true;
    }

    public ShulkerBullet(Level p_37330_, LivingEntity p_37331_, Entity p_37332_, Direction.Axis p_37333_) {
        this((EntityType<? extends ShulkerBullet>)EntityType.SHULKER_BULLET, p_37330_);
        this.setOwner(p_37331_);
        Vec3 $$4 = p_37331_.getBoundingBox().getCenter();
        this.snapTo($$4.x, $$4.y, $$4.z, this.getYRot(), this.getXRot());
        this.finalTarget = new EntityReference<Entity>(p_37332_);
        this.currentMoveDirection = Direction.UP;
        this.selectNextMoveDirection(p_37333_, p_37332_);
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput p_421638_) {
        super.addAdditionalSaveData(p_421638_);
        if (this.finalTarget != null) {
            p_421638_.store("Target", UUIDUtil.CODEC, this.finalTarget.getUUID());
        }
        p_421638_.storeNullable("Dir", Direction.LEGACY_ID_CODEC, this.currentMoveDirection);
        p_421638_.putInt("Steps", this.flightSteps);
        p_421638_.putDouble("TXD", this.targetDeltaX);
        p_421638_.putDouble("TYD", this.targetDeltaY);
        p_421638_.putDouble("TZD", this.targetDeltaZ);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput p_421868_) {
        super.readAdditionalSaveData(p_421868_);
        this.flightSteps = p_421868_.getIntOr("Steps", 0);
        this.targetDeltaX = p_421868_.getDoubleOr("TXD", 0.0);
        this.targetDeltaY = p_421868_.getDoubleOr("TYD", 0.0);
        this.targetDeltaZ = p_421868_.getDoubleOr("TZD", 0.0);
        this.currentMoveDirection = p_421868_.read("Dir", Direction.LEGACY_ID_CODEC).orElse(null);
        this.finalTarget = EntityReference.read(p_421868_, "Target");
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326398_) {
    }

    @Nullable
    private Direction getMoveDirection() {
        return this.currentMoveDirection;
    }

    private void setMoveDirection(@Nullable Direction p_37351_) {
        this.currentMoveDirection = p_37351_;
    }

    private void selectNextMoveDirection(@Nullable Direction.Axis p_37349_, @Nullable Entity p_423580_) {
        BlockPos $$4;
        double $$2 = 0.5;
        if (p_423580_ == null) {
            BlockPos $$3 = this.blockPosition().below();
        } else {
            $$2 = (double)p_423580_.getBbHeight() * 0.5;
            $$4 = BlockPos.containing(p_423580_.getX(), p_423580_.getY() + $$2, p_423580_.getZ());
        }
        double $$5 = (double)$$4.getX() + 0.5;
        double $$6 = (double)$$4.getY() + $$2;
        double $$7 = (double)$$4.getZ() + 0.5;
        Direction $$8 = null;
        if (!$$4.closerToCenterThan(this.position(), 2.0)) {
            BlockPos $$9 = this.blockPosition();
            ArrayList $$10 = Lists.newArrayList();
            if (p_37349_ != Direction.Axis.X) {
                if ($$9.getX() < $$4.getX() && this.level().isEmptyBlock($$9.east())) {
                    $$10.add(Direction.EAST);
                } else if ($$9.getX() > $$4.getX() && this.level().isEmptyBlock($$9.west())) {
                    $$10.add(Direction.WEST);
                }
            }
            if (p_37349_ != Direction.Axis.Y) {
                if ($$9.getY() < $$4.getY() && this.level().isEmptyBlock($$9.above())) {
                    $$10.add(Direction.UP);
                } else if ($$9.getY() > $$4.getY() && this.level().isEmptyBlock($$9.below())) {
                    $$10.add(Direction.DOWN);
                }
            }
            if (p_37349_ != Direction.Axis.Z) {
                if ($$9.getZ() < $$4.getZ() && this.level().isEmptyBlock($$9.south())) {
                    $$10.add(Direction.SOUTH);
                } else if ($$9.getZ() > $$4.getZ() && this.level().isEmptyBlock($$9.north())) {
                    $$10.add(Direction.NORTH);
                }
            }
            $$8 = Direction.getRandom(this.random);
            if ($$10.isEmpty()) {
                for (int $$11 = 5; !this.level().isEmptyBlock($$9.relative($$8)) && $$11 > 0; --$$11) {
                    $$8 = Direction.getRandom(this.random);
                }
            } else {
                $$8 = (Direction)$$10.get(this.random.nextInt($$10.size()));
            }
            $$5 = this.getX() + (double)$$8.getStepX();
            $$6 = this.getY() + (double)$$8.getStepY();
            $$7 = this.getZ() + (double)$$8.getStepZ();
        }
        this.setMoveDirection($$8);
        double $$12 = $$5 - this.getX();
        double $$13 = $$6 - this.getY();
        double $$14 = $$7 - this.getZ();
        double $$15 = Math.sqrt($$12 * $$12 + $$13 * $$13 + $$14 * $$14);
        if ($$15 == 0.0) {
            this.targetDeltaX = 0.0;
            this.targetDeltaY = 0.0;
            this.targetDeltaZ = 0.0;
        } else {
            this.targetDeltaX = $$12 / $$15 * 0.15;
            this.targetDeltaY = $$13 / $$15 * 0.15;
            this.targetDeltaZ = $$14 / $$15 * 0.15;
        }
        this.hasImpulse = true;
        this.flightSteps = 10 + this.random.nextInt(5) * 10;
    }

    @Override
    public void checkDespawn() {
        if (this.level().getDifficulty() == Difficulty.PEACEFUL) {
            this.discard();
        }
    }

    @Override
    protected double getDefaultGravity() {
        return 0.04;
    }

    @Override
    public void tick() {
        super.tick();
        Entity $$0 = !this.level().isClientSide() ? EntityReference.get(this.finalTarget, this.level(), Entity.class) : null;
        HitResult $$1 = null;
        if (!this.level().isClientSide) {
            if ($$0 == null) {
                this.finalTarget = null;
            }
            if (!($$0 == null || !$$0.isAlive() || $$0 instanceof Player && $$0.isSpectator())) {
                this.targetDeltaX = Mth.clamp(this.targetDeltaX * 1.025, -1.0, 1.0);
                this.targetDeltaY = Mth.clamp(this.targetDeltaY * 1.025, -1.0, 1.0);
                this.targetDeltaZ = Mth.clamp(this.targetDeltaZ * 1.025, -1.0, 1.0);
                Vec3 $$2 = this.getDeltaMovement();
                this.setDeltaMovement($$2.add((this.targetDeltaX - $$2.x) * 0.2, (this.targetDeltaY - $$2.y) * 0.2, (this.targetDeltaZ - $$2.z) * 0.2));
            } else {
                this.applyGravity();
            }
            $$1 = ProjectileUtil.getHitResultOnMoveVector(this, this::canHitEntity);
        }
        Vec3 $$3 = this.getDeltaMovement();
        this.setPos(this.position().add($$3));
        this.applyEffectsFromBlocks();
        if (this.portalProcess != null && this.portalProcess.isInsidePortalThisTick()) {
            this.handlePortal();
        }
        if ($$1 != null && this.isAlive() && $$1.getType() != HitResult.Type.MISS) {
            this.hitTargetOrDeflectSelf($$1);
        }
        ProjectileUtil.rotateTowardsMovement(this, 0.5f);
        if (this.level().isClientSide) {
            this.level().addParticle(ParticleTypes.END_ROD, this.getX() - $$3.x, this.getY() - $$3.y + 0.15, this.getZ() - $$3.z, 0.0, 0.0, 0.0);
        } else if ($$0 != null) {
            if (this.flightSteps > 0) {
                --this.flightSteps;
                if (this.flightSteps == 0) {
                    this.selectNextMoveDirection(this.currentMoveDirection == null ? null : this.currentMoveDirection.getAxis(), $$0);
                }
            }
            if (this.currentMoveDirection != null) {
                BlockPos $$4 = this.blockPosition();
                Direction.Axis $$5 = this.currentMoveDirection.getAxis();
                if (this.level().loadedAndEntityCanStandOn($$4.relative(this.currentMoveDirection), this)) {
                    this.selectNextMoveDirection($$5, $$0);
                } else {
                    BlockPos $$6 = $$0.blockPosition();
                    if ($$5 == Direction.Axis.X && $$4.getX() == $$6.getX() || $$5 == Direction.Axis.Z && $$4.getZ() == $$6.getZ() || $$5 == Direction.Axis.Y && $$4.getY() == $$6.getY()) {
                        this.selectNextMoveDirection($$5, $$0);
                    }
                }
            }
        }
    }

    @Override
    protected boolean isAffectedByBlocks() {
        return !this.isRemoved();
    }

    @Override
    protected boolean canHitEntity(Entity p_37341_) {
        return super.canHitEntity(p_37341_) && !p_37341_.noPhysics;
    }

    @Override
    public boolean isOnFire() {
        return false;
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double p_37336_) {
        return p_37336_ < 16384.0;
    }

    @Override
    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    @Override
    protected void onHitEntity(EntityHitResult p_37345_) {
        super.onHitEntity(p_37345_);
        Entity $$1 = p_37345_.getEntity();
        Entity $$2 = this.getOwner();
        LivingEntity $$3 = $$2 instanceof LivingEntity ? (LivingEntity)$$2 : null;
        DamageSource $$4 = this.damageSources().mobProjectile(this, $$3);
        boolean $$5 = $$1.hurtOrSimulate($$4, 4.0f);
        if ($$5) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel $$6 = (ServerLevel)level;
                EnchantmentHelper.doPostAttackEffects($$6, $$1, $$4);
            }
            if ($$1 instanceof LivingEntity) {
                LivingEntity $$7 = (LivingEntity)$$1;
                $$7.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 200), (Entity)MoreObjects.firstNonNull((Object)$$2, (Object)this));
            }
        }
    }

    @Override
    protected void onHitBlock(BlockHitResult p_37343_) {
        super.onHitBlock(p_37343_);
        ((ServerLevel)this.level()).sendParticles(ParticleTypes.EXPLOSION, this.getX(), this.getY(), this.getZ(), 2, 0.2, 0.2, 0.2, 0.0);
        this.playSound(SoundEvents.SHULKER_BULLET_HIT, 1.0f, 1.0f);
    }

    private void destroy() {
        this.discard();
        this.level().gameEvent(GameEvent.ENTITY_DAMAGE, this.position(), GameEvent.Context.of(this));
    }

    @Override
    protected void onHit(HitResult p_37347_) {
        super.onHit(p_37347_);
        this.destroy();
    }

    @Override
    public boolean isPickable() {
        return true;
    }

    @Override
    public boolean hurtClient(DamageSource p_376754_) {
        return true;
    }

    @Override
    public boolean hurtServer(ServerLevel p_376836_, DamageSource p_376419_, float p_376652_) {
        this.playSound(SoundEvents.SHULKER_BULLET_HURT, 1.0f, 1.0f);
        p_376836_.sendParticles(ParticleTypes.CRIT, this.getX(), this.getY(), this.getZ(), 15, 0.2, 0.2, 0.2, 0.0);
        this.destroy();
        return true;
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket p_150185_) {
        super.recreateFromPacket(p_150185_);
        double $$1 = p_150185_.getXa();
        double $$2 = p_150185_.getYa();
        double $$3 = p_150185_.getZa();
        this.setDeltaMovement($$1, $$2, $$3);
    }
}

