/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.collect.ImmutableSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public record VillagerProfession(Component name, Predicate<Holder<PoiType>> heldJobSite, Predicate<Holder<PoiType>> acquirableJobSite, ImmutableSet<Item> requestedItems, ImmutableSet<Block> secondaryPoi, @Nullable SoundEvent workSound) {
    public static final Predicate<Holder<PoiType>> ALL_ACQUIRABLE_JOBS = p_238239_ -> p_238239_.is(PoiTypeTags.ACQUIRABLE_JOB_SITE);
    public static final ResourceKey<VillagerProfession> NONE = VillagerProfession.createKey("none");
    public static final ResourceKey<VillagerProfession> ARMORER = VillagerProfession.createKey("armorer");
    public static final ResourceKey<VillagerProfession> BUTCHER = VillagerProfession.createKey("butcher");
    public static final ResourceKey<VillagerProfession> CARTOGRAPHER = VillagerProfession.createKey("cartographer");
    public static final ResourceKey<VillagerProfession> CLERIC = VillagerProfession.createKey("cleric");
    public static final ResourceKey<VillagerProfession> FARMER = VillagerProfession.createKey("farmer");
    public static final ResourceKey<VillagerProfession> FISHERMAN = VillagerProfession.createKey("fisherman");
    public static final ResourceKey<VillagerProfession> FLETCHER = VillagerProfession.createKey("fletcher");
    public static final ResourceKey<VillagerProfession> LEATHERWORKER = VillagerProfession.createKey("leatherworker");
    public static final ResourceKey<VillagerProfession> LIBRARIAN = VillagerProfession.createKey("librarian");
    public static final ResourceKey<VillagerProfession> MASON = VillagerProfession.createKey("mason");
    public static final ResourceKey<VillagerProfession> NITWIT = VillagerProfession.createKey("nitwit");
    public static final ResourceKey<VillagerProfession> SHEPHERD = VillagerProfession.createKey("shepherd");
    public static final ResourceKey<VillagerProfession> TOOLSMITH = VillagerProfession.createKey("toolsmith");
    public static final ResourceKey<VillagerProfession> WEAPONSMITH = VillagerProfession.createKey("weaponsmith");

    private static ResourceKey<VillagerProfession> createKey(String p_397640_) {
        return ResourceKey.create(Registries.VILLAGER_PROFESSION, ResourceLocation.withDefaultNamespace(p_397640_));
    }

    private static VillagerProfession register(Registry<VillagerProfession> p_397878_, ResourceKey<VillagerProfession> p_219649_, ResourceKey<PoiType> p_397999_, @Nullable SoundEvent p_219652_) {
        return VillagerProfession.register(p_397878_, p_219649_, p_219668_ -> p_219668_.is(p_397999_), p_219640_ -> p_219640_.is(p_397999_), p_219652_);
    }

    private static VillagerProfession register(Registry<VillagerProfession> p_397833_, ResourceKey<VillagerProfession> p_219645_, Predicate<Holder<PoiType>> p_397690_, Predicate<Holder<PoiType>> p_397703_, @Nullable SoundEvent p_219646_) {
        return VillagerProfession.register(p_397833_, p_219645_, p_397690_, p_397703_, (ImmutableSet<Item>)ImmutableSet.of(), (ImmutableSet<Block>)ImmutableSet.of(), p_219646_);
    }

    private static VillagerProfession register(Registry<VillagerProfession> p_397053_, ResourceKey<VillagerProfession> p_397031_, ResourceKey<PoiType> p_397291_, ImmutableSet<Item> p_396998_, ImmutableSet<Block> p_397508_, @Nullable SoundEvent p_219657_) {
        return VillagerProfession.register(p_397053_, p_397031_, p_238234_ -> p_238234_.is(p_397291_), p_238237_ -> p_238237_.is(p_397291_), p_396998_, p_397508_, p_219657_);
    }

    private static VillagerProfession register(Registry<VillagerProfession> p_397839_, ResourceKey<VillagerProfession> p_398003_, Predicate<Holder<PoiType>> p_219660_, Predicate<Holder<PoiType>> p_219661_, ImmutableSet<Item> p_219662_, ImmutableSet<Block> p_219663_, @Nullable SoundEvent p_219664_) {
        return Registry.register(p_397839_, p_398003_, new VillagerProfession(Component.translatable("entity." + p_398003_.location().getNamespace() + ".villager." + p_398003_.location().getPath()), p_219660_, p_219661_, p_219662_, p_219663_, p_219664_));
    }

    public static VillagerProfession bootstrap(Registry<VillagerProfession> p_398012_) {
        VillagerProfession.register(p_398012_, NONE, PoiType.NONE, ALL_ACQUIRABLE_JOBS, null);
        VillagerProfession.register(p_398012_, ARMORER, PoiTypes.ARMORER, SoundEvents.VILLAGER_WORK_ARMORER);
        VillagerProfession.register(p_398012_, BUTCHER, PoiTypes.BUTCHER, SoundEvents.VILLAGER_WORK_BUTCHER);
        VillagerProfession.register(p_398012_, CARTOGRAPHER, PoiTypes.CARTOGRAPHER, SoundEvents.VILLAGER_WORK_CARTOGRAPHER);
        VillagerProfession.register(p_398012_, CLERIC, PoiTypes.CLERIC, SoundEvents.VILLAGER_WORK_CLERIC);
        VillagerProfession.register(p_398012_, FARMER, PoiTypes.FARMER, (ImmutableSet<Item>)ImmutableSet.of((Object)Items.WHEAT, (Object)Items.WHEAT_SEEDS, (Object)Items.BEETROOT_SEEDS, (Object)Items.BONE_MEAL), (ImmutableSet<Block>)ImmutableSet.of((Object)Blocks.FARMLAND), SoundEvents.VILLAGER_WORK_FARMER);
        VillagerProfession.register(p_398012_, FISHERMAN, PoiTypes.FISHERMAN, SoundEvents.VILLAGER_WORK_FISHERMAN);
        VillagerProfession.register(p_398012_, FLETCHER, PoiTypes.FLETCHER, SoundEvents.VILLAGER_WORK_FLETCHER);
        VillagerProfession.register(p_398012_, LEATHERWORKER, PoiTypes.LEATHERWORKER, SoundEvents.VILLAGER_WORK_LEATHERWORKER);
        VillagerProfession.register(p_398012_, LIBRARIAN, PoiTypes.LIBRARIAN, SoundEvents.VILLAGER_WORK_LIBRARIAN);
        VillagerProfession.register(p_398012_, MASON, PoiTypes.MASON, SoundEvents.VILLAGER_WORK_MASON);
        VillagerProfession.register(p_398012_, NITWIT, PoiType.NONE, PoiType.NONE, null);
        VillagerProfession.register(p_398012_, SHEPHERD, PoiTypes.SHEPHERD, SoundEvents.VILLAGER_WORK_SHEPHERD);
        VillagerProfession.register(p_398012_, TOOLSMITH, PoiTypes.TOOLSMITH, SoundEvents.VILLAGER_WORK_TOOLSMITH);
        return VillagerProfession.register(p_398012_, WEAPONSMITH, PoiTypes.WEAPONSMITH, SoundEvents.VILLAGER_WORK_WEAPONSMITH);
    }
}

