/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Ghast
extends Mob
implements Enemy {
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGING = SynchedEntityData.defineId(Ghast.class, EntityDataSerializers.BOOLEAN);
    private static final byte DEFAULT_EXPLOSION_POWER = 1;
    private int explosionPower = 1;

    public Ghast(EntityType<? extends Ghast> p_32725_, Level p_32726_) {
        super((EntityType<? extends Mob>)p_32725_, p_32726_);
        this.xpReward = 5;
        this.moveControl = new GhastMoveControl(this, false, () -> false);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(5, new RandomFloatAroundGoal(this));
        this.goalSelector.addGoal(7, new GhastLookGoal(this));
        this.goalSelector.addGoal(7, new GhastShootFireballGoal(this));
        this.targetSelector.addGoal(1, new NearestAttackableTargetGoal<Player>(this, Player.class, 10, true, false, (p_427100_, p_427101_) -> Math.abs(p_427100_.getY() - this.getY()) <= 4.0));
    }

    public boolean isCharging() {
        return this.entityData.get(DATA_IS_CHARGING);
    }

    public void setCharging(boolean p_32759_) {
        this.entityData.set(DATA_IS_CHARGING, p_32759_);
    }

    public int getExplosionPower() {
        return this.explosionPower;
    }

    @Override
    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    private static boolean isReflectedFireball(DamageSource p_238408_) {
        return p_238408_.getDirectEntity() instanceof LargeFireball && p_238408_.getEntity() instanceof Player;
    }

    @Override
    public boolean isInvulnerableTo(ServerLevel p_376822_, DamageSource p_238289_) {
        return this.isInvulnerable() && !p_238289_.is(DamageTypeTags.BYPASSES_INVULNERABILITY) || !Ghast.isReflectedFireball(p_238289_) && super.isInvulnerableTo(p_376822_, p_238289_);
    }

    @Override
    protected void checkFallDamage(double p_416043_, boolean p_416735_, BlockState p_416029_, BlockPos p_415730_) {
    }

    @Override
    public boolean onClimbable() {
        return false;
    }

    @Override
    public void travel(Vec3 p_415638_) {
        this.travelFlying(p_415638_, 0.02f);
    }

    @Override
    public boolean hurtServer(ServerLevel p_376618_, DamageSource p_376819_, float p_376363_) {
        if (Ghast.isReflectedFireball(p_376819_)) {
            super.hurtServer(p_376618_, p_376819_, 1000.0f);
            return true;
        }
        if (this.isInvulnerableTo(p_376618_, p_376819_)) {
            return false;
        }
        return super.hurtServer(p_376618_, p_376819_, p_376363_);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326063_) {
        super.defineSynchedData(p_326063_);
        p_326063_.define(DATA_IS_CHARGING, false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.FOLLOW_RANGE, 100.0).add(Attributes.CAMERA_DISTANCE, 8.0).add(Attributes.FLYING_SPEED, 0.06);
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.GHAST_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource p_32750_) {
        return SoundEvents.GHAST_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.GHAST_DEATH;
    }

    @Override
    protected float getSoundVolume() {
        return 5.0f;
    }

    public static boolean checkGhastSpawnRules(EntityType<Ghast> p_218985_, LevelAccessor p_218986_, EntitySpawnReason p_360741_, BlockPos p_218988_, RandomSource p_218989_) {
        return p_218986_.getDifficulty() != Difficulty.PEACEFUL && p_218989_.nextInt(20) == 0 && Ghast.checkMobSpawnRules(p_218985_, p_218986_, p_360741_, p_218988_, p_218989_);
    }

    @Override
    public int getMaxSpawnClusterSize() {
        return 1;
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput p_422069_) {
        super.addAdditionalSaveData(p_422069_);
        p_422069_.putByte("ExplosionPower", (byte)this.explosionPower);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput p_421477_) {
        super.readAdditionalSaveData(p_421477_);
        this.explosionPower = p_421477_.getByteOr("ExplosionPower", (byte)1);
    }

    @Override
    public boolean supportQuadLeashAsHolder() {
        return true;
    }

    @Override
    public double leashElasticDistance() {
        return 10.0;
    }

    @Override
    public double leashSnapDistance() {
        return 16.0;
    }

    public static void faceMovementDirection(Mob p_416504_) {
        if (p_416504_.getTarget() == null) {
            Vec3 $$1 = p_416504_.getDeltaMovement();
            p_416504_.setYRot(-((float)Mth.atan2($$1.x, $$1.z)) * 57.295776f);
            p_416504_.yBodyRot = p_416504_.getYRot();
        } else {
            LivingEntity $$2 = p_416504_.getTarget();
            double $$3 = 64.0;
            if ($$2.distanceToSqr(p_416504_) < 4096.0) {
                double $$4 = $$2.getX() - p_416504_.getX();
                double $$5 = $$2.getZ() - p_416504_.getZ();
                p_416504_.setYRot(-((float)Mth.atan2($$4, $$5)) * 57.295776f);
                p_416504_.yBodyRot = p_416504_.getYRot();
            }
        }
    }

    public static class GhastMoveControl
    extends MoveControl {
        private final Mob ghast;
        private int floatDuration;
        private final boolean careful;
        private final BooleanSupplier shouldBeStopped;

        public GhastMoveControl(Mob p_416658_, boolean p_415882_, BooleanSupplier p_423656_) {
            super(p_416658_);
            this.ghast = p_416658_;
            this.careful = p_415882_;
            this.shouldBeStopped = p_423656_;
        }

        @Override
        public void tick() {
            if (this.shouldBeStopped.getAsBoolean()) {
                this.operation = MoveControl.Operation.WAIT;
                this.ghast.stopInPlace();
            }
            if (this.operation != MoveControl.Operation.MOVE_TO) {
                return;
            }
            if (this.floatDuration-- <= 0) {
                this.floatDuration += this.ghast.getRandom().nextInt(5) + 2;
                Vec3 $$0 = new Vec3(this.wantedX - this.ghast.getX(), this.wantedY - this.ghast.getY(), this.wantedZ - this.ghast.getZ());
                if (this.canReach($$0)) {
                    this.ghast.setDeltaMovement(this.ghast.getDeltaMovement().add($$0.normalize().scale(this.ghast.getAttributeValue(Attributes.FLYING_SPEED) * 5.0 / 3.0)));
                } else {
                    this.operation = MoveControl.Operation.WAIT;
                }
            }
        }

        private boolean canReach(Vec3 p_32771_) {
            AABB $$1 = this.ghast.getBoundingBox();
            AABB $$2 = $$1.move(p_32771_);
            if (this.careful) {
                for (BlockPos $$3 : BlockPos.betweenClosed($$2.inflate(1.0))) {
                    if (this.blockTraversalPossible(this.ghast.level(), null, null, $$3, false, false)) continue;
                    return false;
                }
            }
            boolean $$4 = this.ghast.isInWater();
            boolean $$5 = this.ghast.isInLava();
            Vec3 $$6 = this.ghast.position();
            Vec3 $$7 = $$6.add(p_32771_);
            return BlockGetter.forEachBlockIntersectedBetween($$6, $$7, $$2, (p_423335_, p_423336_) -> {
                if ($$1.intersects(p_423335_)) {
                    return true;
                }
                return this.blockTraversalPossible(this.ghast.level(), $$6, $$7, p_423335_, $$4, $$5);
            });
        }

        private boolean blockTraversalPossible(BlockGetter p_419713_, @Nullable Vec3 p_422066_, @Nullable Vec3 p_421561_, BlockPos p_419924_, boolean p_419936_, boolean p_419980_) {
            boolean $$8;
            boolean $$7;
            BlockState $$6 = p_419713_.getBlockState(p_419924_);
            if ($$6.isAir()) {
                return true;
            }
            boolean bl = $$7 = p_422066_ != null && p_421561_ != null;
            boolean bl2 = $$7 ? !this.ghast.collidedWithShapeMovingFrom(p_422066_, p_421561_, $$6.getCollisionShape(p_419713_, p_419924_).move(new Vec3(p_419924_)).toAabbs()) : ($$8 = $$6.getCollisionShape(p_419713_, p_419924_).isEmpty());
            if (!this.careful) {
                return $$8;
            }
            if ($$6.is(BlockTags.HAPPY_GHAST_AVOIDS)) {
                return false;
            }
            FluidState $$9 = p_419713_.getFluidState(p_419924_);
            if (!($$9.isEmpty() || $$7 && !this.ghast.collidedWithFluid($$9, p_419924_, p_422066_, p_421561_))) {
                if ($$9.is(FluidTags.WATER)) {
                    return p_419936_;
                }
                if ($$9.is(FluidTags.LAVA)) {
                    return p_419980_;
                }
            }
            return $$8;
        }
    }

    public static class RandomFloatAroundGoal
    extends Goal {
        private static final int MAX_ATTEMPTS = 64;
        private final Mob ghast;
        private final int distanceToBlocks;

        public RandomFloatAroundGoal(Mob p_416337_) {
            this(p_416337_, 0);
        }

        public RandomFloatAroundGoal(Mob p_415816_, int p_416473_) {
            this.ghast = p_415816_;
            this.distanceToBlocks = p_416473_;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean canUse() {
            double $$3;
            double $$2;
            MoveControl $$0 = this.ghast.getMoveControl();
            if (!$$0.hasWanted()) {
                return true;
            }
            double $$1 = $$0.getWantedX() - this.ghast.getX();
            double $$4 = $$1 * $$1 + ($$2 = $$0.getWantedY() - this.ghast.getY()) * $$2 + ($$3 = $$0.getWantedZ() - this.ghast.getZ()) * $$3;
            return $$4 < 1.0 || $$4 > 3600.0;
        }

        @Override
        public boolean canContinueToUse() {
            return false;
        }

        @Override
        public void start() {
            Vec3 $$0 = RandomFloatAroundGoal.getSuitableFlyToPosition(this.ghast, this.distanceToBlocks);
            this.ghast.getMoveControl().setWantedPosition($$0.x(), $$0.y(), $$0.z(), 1.0);
        }

        public static Vec3 getSuitableFlyToPosition(Mob p_415820_, int p_415837_) {
            BlockPos $$7;
            int $$8;
            Level $$2 = p_415820_.level();
            RandomSource $$3 = p_415820_.getRandom();
            Vec3 $$4 = p_415820_.position();
            Vec3 $$5 = null;
            for (int $$6 = 0; $$6 < 64; ++$$6) {
                $$5 = RandomFloatAroundGoal.chooseRandomPositionWithRestriction(p_415820_, $$4, $$3);
                if ($$5 == null || !RandomFloatAroundGoal.isGoodTarget($$2, $$5, p_415837_)) continue;
                return $$5;
            }
            if ($$5 == null) {
                $$5 = RandomFloatAroundGoal.chooseRandomPosition($$4, $$3);
            }
            if (($$8 = $$2.getHeight(Heightmap.Types.MOTION_BLOCKING, ($$7 = BlockPos.containing($$5)).getX(), $$7.getZ())) < $$7.getY() && $$8 > $$2.getMinY()) {
                $$5 = new Vec3($$5.x(), p_415820_.getY() - Math.abs(p_415820_.getY() - $$5.y()), $$5.z());
            }
            return $$5;
        }

        private static boolean isGoodTarget(Level p_415688_, Vec3 p_416409_, int p_415738_) {
            if (p_415738_ <= 0) {
                return true;
            }
            BlockPos $$3 = BlockPos.containing(p_416409_);
            if (!p_415688_.getBlockState($$3).isAir()) {
                return false;
            }
            for (Direction $$4 : Direction.values()) {
                for (int $$5 = 1; $$5 < p_415738_; ++$$5) {
                    BlockPos $$6 = $$3.relative($$4, $$5);
                    if (p_415688_.getBlockState($$6).isAir()) continue;
                    return true;
                }
            }
            return false;
        }

        private static Vec3 chooseRandomPosition(Vec3 p_416643_, RandomSource p_416184_) {
            double $$2 = p_416643_.x() + (double)((p_416184_.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double $$3 = p_416643_.y() + (double)((p_416184_.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double $$4 = p_416643_.z() + (double)((p_416184_.nextFloat() * 2.0f - 1.0f) * 16.0f);
            return new Vec3($$2, $$3, $$4);
        }

        @Nullable
        private static Vec3 chooseRandomPositionWithRestriction(Mob p_415643_, Vec3 p_415583_, RandomSource p_416214_) {
            Vec3 $$3 = RandomFloatAroundGoal.chooseRandomPosition(p_415583_, p_416214_);
            if (p_415643_.hasHome() && !p_415643_.isWithinHome($$3)) {
                return null;
            }
            return $$3;
        }
    }

    public static class GhastLookGoal
    extends Goal {
        private final Mob ghast;

        public GhastLookGoal(Mob p_416384_) {
            this.ghast = p_416384_;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        @Override
        public boolean canUse() {
            return true;
        }

        @Override
        public boolean requiresUpdateEveryTick() {
            return true;
        }

        @Override
        public void tick() {
            Ghast.faceMovementDirection(this.ghast);
        }
    }

    static class GhastShootFireballGoal
    extends Goal {
        private final Ghast ghast;
        public int chargeTime;

        public GhastShootFireballGoal(Ghast p_32776_) {
            this.ghast = p_32776_;
        }

        @Override
        public boolean canUse() {
            return this.ghast.getTarget() != null;
        }

        @Override
        public void start() {
            this.chargeTime = 0;
        }

        @Override
        public void stop() {
            this.ghast.setCharging(false);
        }

        @Override
        public boolean requiresUpdateEveryTick() {
            return true;
        }

        @Override
        public void tick() {
            LivingEntity $$0 = this.ghast.getTarget();
            if ($$0 == null) {
                return;
            }
            double $$1 = 64.0;
            if ($$0.distanceToSqr(this.ghast) < 4096.0 && this.ghast.hasLineOfSight($$0)) {
                Level $$2 = this.ghast.level();
                ++this.chargeTime;
                if (this.chargeTime == 10 && !this.ghast.isSilent()) {
                    $$2.levelEvent(null, 1015, this.ghast.blockPosition(), 0);
                }
                if (this.chargeTime == 20) {
                    double $$3 = 4.0;
                    Vec3 $$4 = this.ghast.getViewVector(1.0f);
                    double $$5 = $$0.getX() - (this.ghast.getX() + $$4.x * 4.0);
                    double $$6 = $$0.getY(0.5) - (0.5 + this.ghast.getY(0.5));
                    double $$7 = $$0.getZ() - (this.ghast.getZ() + $$4.z * 4.0);
                    Vec3 $$8 = new Vec3($$5, $$6, $$7);
                    if (!this.ghast.isSilent()) {
                        $$2.levelEvent(null, 1016, this.ghast.blockPosition(), 0);
                    }
                    LargeFireball $$9 = new LargeFireball($$2, (LivingEntity)this.ghast, $$8.normalize(), this.ghast.getExplosionPower());
                    $$9.setPos(this.ghast.getX() + $$4.x * 4.0, this.ghast.getY(0.5) + 0.5, $$9.getZ() + $$4.z * 4.0);
                    $$2.addFreshEntity($$9);
                    this.chargeTime = -40;
                }
            } else if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            this.ghast.setCharging(this.chargeTime > 10);
        }
    }
}

