/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.decoration.BlockAttachedEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class LeashFenceKnotEntity
extends BlockAttachedEntity {
    public static final double OFFSET_Y = 0.375;

    public LeashFenceKnotEntity(EntityType<? extends LeashFenceKnotEntity> p_31828_, Level p_31829_) {
        super((EntityType<? extends BlockAttachedEntity>)p_31828_, p_31829_);
    }

    public LeashFenceKnotEntity(Level p_31831_, BlockPos p_31832_) {
        super(EntityType.LEASH_KNOT, p_31831_, p_31832_);
        this.setPos(p_31832_.getX(), p_31832_.getY(), p_31832_.getZ());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_344730_) {
    }

    @Override
    protected void recalculateBoundingBox() {
        this.setPosRaw((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.375, (double)this.pos.getZ() + 0.5);
        double $$0 = (double)this.getType().getWidth() / 2.0;
        double $$1 = this.getType().getHeight();
        this.setBoundingBox(new AABB(this.getX() - $$0, this.getY(), this.getZ() - $$0, this.getX() + $$0, this.getY() + $$1, this.getZ() + $$0));
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double p_31835_) {
        return p_31835_ < 1024.0;
    }

    @Override
    public void dropItem(ServerLevel p_376541_, @Nullable Entity p_31837_) {
        this.playSound(SoundEvents.LEAD_UNTIED, 1.0f, 1.0f);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput p_422629_) {
    }

    @Override
    protected void readAdditionalSaveData(ValueInput p_422618_) {
    }

    @Override
    public InteractionResult interact(Player p_31842_, InteractionHand p_31843_) {
        InteractionResult.Success $$3;
        InteractionResult $$2;
        if (this.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (p_31842_.getItemInHand(p_31843_).is(Items.SHEARS) && ($$2 = super.interact(p_31842_, p_31843_)) instanceof InteractionResult.Success && ($$3 = (InteractionResult.Success)$$2).wasItemInteraction()) {
            return $$2;
        }
        boolean $$4 = false;
        List<Leashable> $$5 = Leashable.leashableLeashedTo(p_31842_);
        for (Leashable $$6 : $$5) {
            if (!$$6.canHaveALeashAttachedTo(this)) continue;
            $$6.setLeashedTo(this, true);
            $$4 = true;
        }
        boolean $$7 = false;
        if (!$$4 && !p_31842_.isSecondaryUseActive()) {
            List<Leashable> $$8 = Leashable.leashableLeashedTo(this);
            for (Leashable $$9 : $$8) {
                if (!$$9.canHaveALeashAttachedTo(p_31842_)) continue;
                $$9.setLeashedTo(p_31842_, true);
                $$7 = true;
            }
        }
        if ($$4 || $$7) {
            this.gameEvent(GameEvent.BLOCK_ATTACH, p_31842_);
            this.playSound(SoundEvents.LEAD_TIED);
            return InteractionResult.SUCCESS;
        }
        return super.interact(p_31842_, p_31843_);
    }

    @Override
    public void notifyLeasheeRemoved(Leashable p_418486_) {
        if (Leashable.leashableLeashedTo(this).isEmpty()) {
            this.discard();
        }
    }

    @Override
    public boolean survives() {
        return this.level().getBlockState(this.pos).is(BlockTags.FENCES);
    }

    public static LeashFenceKnotEntity getOrCreateKnot(Level p_31845_, BlockPos p_31846_) {
        int $$2 = p_31846_.getX();
        int $$3 = p_31846_.getY();
        int $$4 = p_31846_.getZ();
        List<LeashFenceKnotEntity> $$5 = p_31845_.getEntitiesOfClass(LeashFenceKnotEntity.class, new AABB((double)$$2 - 1.0, (double)$$3 - 1.0, (double)$$4 - 1.0, (double)$$2 + 1.0, (double)$$3 + 1.0, (double)$$4 + 1.0));
        for (LeashFenceKnotEntity $$6 : $$5) {
            if (!$$6.getPos().equals(p_31846_)) continue;
            return $$6;
        }
        LeashFenceKnotEntity $$7 = new LeashFenceKnotEntity(p_31845_, p_31846_);
        p_31845_.addFreshEntity($$7);
        return $$7;
    }

    public void playPlacementSound() {
        this.playSound(SoundEvents.LEAD_TIED, 1.0f, 1.0f);
    }

    @Override
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity p_352402_) {
        return new ClientboundAddEntityPacket((Entity)this, 0, this.getPos());
    }

    @Override
    public Vec3 getRopeHoldPosition(float p_31863_) {
        return this.getPosition(p_31863_).add(0.0, 0.2, 0.0);
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.LEAD);
    }
}

