/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;

public class ItemFrame
extends HangingEntity {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM = SynchedEntityData.defineId(ItemFrame.class, EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Integer> DATA_ROTATION = SynchedEntityData.defineId(ItemFrame.class, EntityDataSerializers.INT);
    public static final int NUM_ROTATIONS = 8;
    private static final float DEPTH = 0.0625f;
    private static final float WIDTH = 0.75f;
    private static final float HEIGHT = 0.75f;
    private static final byte DEFAULT_ROTATION = 0;
    private static final float DEFAULT_DROP_CHANCE = 1.0f;
    private static final boolean DEFAULT_INVISIBLE = false;
    private static final boolean DEFAULT_FIXED = false;
    private float dropChance = 1.0f;
    private boolean fixed = false;

    public ItemFrame(EntityType<? extends ItemFrame> p_31761_, Level p_31762_) {
        super((EntityType<? extends HangingEntity>)p_31761_, p_31762_);
        this.setInvisible(false);
    }

    public ItemFrame(Level p_31764_, BlockPos p_31765_, Direction p_31766_) {
        this(EntityType.ITEM_FRAME, p_31764_, p_31765_, p_31766_);
    }

    public ItemFrame(EntityType<? extends ItemFrame> p_149621_, Level p_149622_, BlockPos p_149623_, Direction p_149624_) {
        super((EntityType<? extends HangingEntity>)p_149621_, p_149622_, p_149623_);
        this.setDirection(p_149624_);
        this.setInvisible(false);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_325987_) {
        super.defineSynchedData(p_325987_);
        p_325987_.define(DATA_ITEM, ItemStack.EMPTY);
        p_325987_.define(DATA_ROTATION, 0);
    }

    @Override
    protected void setDirection(Direction p_31793_) {
        Validate.notNull((Object)p_31793_);
        super.setDirectionRaw(p_31793_);
        if (p_31793_.getAxis().isHorizontal()) {
            this.setXRot(0.0f);
            this.setYRot(p_31793_.get2DDataValue() * 90);
        } else {
            this.setXRot(-90 * p_31793_.getAxisDirection().getStep());
            this.setYRot(0.0f);
        }
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
        this.recalculateBoundingBox();
    }

    @Override
    protected final void recalculateBoundingBox() {
        super.recalculateBoundingBox();
        this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
    }

    @Override
    protected AABB calculateBoundingBox(BlockPos p_345363_, Direction p_344892_) {
        float $$2 = 0.46875f;
        Vec3 $$3 = Vec3.atCenterOf(p_345363_).relative(p_344892_, -0.46875);
        Direction.Axis $$4 = p_344892_.getAxis();
        double $$5 = $$4 == Direction.Axis.X ? 0.0625 : 0.75;
        double $$6 = $$4 == Direction.Axis.Y ? 0.0625 : 0.75;
        double $$7 = $$4 == Direction.Axis.Z ? 0.0625 : 0.75;
        return AABB.ofSize($$3, $$5, $$6, $$7);
    }

    @Override
    public boolean survives() {
        if (this.fixed) {
            return true;
        }
        if (!this.level().noCollision(this)) {
            return false;
        }
        BlockState $$0 = this.level().getBlockState(this.pos.relative(this.getDirection().getOpposite()));
        if (!($$0.isSolid() || this.getDirection().getAxis().isHorizontal() && DiodeBlock.isDiode($$0))) {
            return false;
        }
        return this.level().getEntities(this, this.getBoundingBox(), HANGING_ENTITY).isEmpty();
    }

    @Override
    public void move(MoverType p_31781_, Vec3 p_31782_) {
        if (!this.fixed) {
            super.move(p_31781_, p_31782_);
        }
    }

    @Override
    public void push(double p_31817_, double p_31818_, double p_31819_) {
        if (!this.fixed) {
            super.push(p_31817_, p_31818_, p_31819_);
        }
    }

    @Override
    public void kill(ServerLevel p_376265_) {
        this.removeFramedMap(this.getItem());
        super.kill(p_376265_);
    }

    private boolean shouldDamageDropItem(DamageSource p_376579_) {
        return !p_376579_.is(DamageTypeTags.IS_EXPLOSION) && !this.getItem().isEmpty();
    }

    private static boolean canHurtWhenFixed(DamageSource p_376501_) {
        return p_376501_.is(DamageTypeTags.BYPASSES_INVULNERABILITY) || p_376501_.isCreativePlayer();
    }

    @Override
    public boolean hurtClient(DamageSource p_376923_) {
        if (this.fixed && !ItemFrame.canHurtWhenFixed(p_376923_)) {
            return false;
        }
        return !this.isInvulnerableToBase(p_376923_);
    }

    @Override
    public boolean hurtServer(ServerLevel p_376559_, DamageSource p_376904_, float p_376420_) {
        if (this.fixed) {
            return ItemFrame.canHurtWhenFixed(p_376904_) && super.hurtServer(p_376559_, p_376904_, p_376420_);
        }
        if (this.isInvulnerableToBase(p_376904_)) {
            return false;
        }
        if (this.shouldDamageDropItem(p_376904_)) {
            this.dropItem(p_376559_, p_376904_.getEntity(), false);
            this.gameEvent(GameEvent.BLOCK_CHANGE, p_376904_.getEntity());
            this.playSound(this.getRemoveItemSound(), 1.0f, 1.0f);
            return true;
        }
        return super.hurtServer(p_376559_, p_376904_, p_376420_);
    }

    public SoundEvent getRemoveItemSound() {
        return SoundEvents.ITEM_FRAME_REMOVE_ITEM;
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double p_31769_) {
        double $$1 = 16.0;
        return p_31769_ < ($$1 *= 64.0 * ItemFrame.getViewScale()) * $$1;
    }

    @Override
    public void dropItem(ServerLevel p_376660_, @Nullable Entity p_31803_) {
        this.playSound(this.getBreakSound(), 1.0f, 1.0f);
        this.dropItem(p_376660_, p_31803_, true);
        this.gameEvent(GameEvent.BLOCK_CHANGE, p_31803_);
    }

    public SoundEvent getBreakSound() {
        return SoundEvents.ITEM_FRAME_BREAK;
    }

    @Override
    public void playPlacementSound() {
        this.playSound(this.getPlaceSound(), 1.0f, 1.0f);
    }

    public SoundEvent getPlaceSound() {
        return SoundEvents.ITEM_FRAME_PLACE;
    }

    private void dropItem(ServerLevel p_376284_, @Nullable Entity p_31779_, boolean p_376524_) {
        Player $$4;
        if (this.fixed) {
            return;
        }
        ItemStack $$3 = this.getItem();
        this.setItem(ItemStack.EMPTY);
        if (!p_376284_.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            if (p_31779_ == null) {
                this.removeFramedMap($$3);
            }
            return;
        }
        if (p_31779_ instanceof Player && ($$4 = (Player)p_31779_).hasInfiniteMaterials()) {
            this.removeFramedMap($$3);
            return;
        }
        if (p_376524_) {
            this.spawnAtLocation(p_376284_, this.getFrameItemStack());
        }
        if (!$$3.isEmpty()) {
            $$3 = $$3.copy();
            this.removeFramedMap($$3);
            if (this.random.nextFloat() < this.dropChance) {
                this.spawnAtLocation(p_376284_, $$3);
            }
        }
    }

    private void removeFramedMap(ItemStack p_31811_) {
        MapItemSavedData $$2;
        MapId $$1 = this.getFramedMapId(p_31811_);
        if ($$1 != null && ($$2 = MapItem.getSavedData($$1, this.level())) != null) {
            $$2.removedFromFrame(this.pos, this.getId());
        }
        p_31811_.setEntityRepresentation(null);
    }

    public ItemStack getItem() {
        return this.getEntityData().get(DATA_ITEM);
    }

    @Nullable
    public MapId getFramedMapId(ItemStack p_353029_) {
        return p_353029_.get(DataComponents.MAP_ID);
    }

    public boolean hasFramedMap() {
        return this.getItem().has(DataComponents.MAP_ID);
    }

    public void setItem(ItemStack p_31806_) {
        this.setItem(p_31806_, true);
    }

    public void setItem(ItemStack p_31790_, boolean p_31791_) {
        if (!p_31790_.isEmpty()) {
            p_31790_ = p_31790_.copyWithCount(1);
        }
        this.onItemChanged(p_31790_);
        this.getEntityData().set(DATA_ITEM, p_31790_);
        if (!p_31790_.isEmpty()) {
            this.playSound(this.getAddItemSound(), 1.0f, 1.0f);
        }
        if (p_31791_ && this.pos != null) {
            this.level().updateNeighbourForOutputSignal(this.pos, Blocks.AIR);
        }
    }

    public SoundEvent getAddItemSound() {
        return SoundEvents.ITEM_FRAME_ADD_ITEM;
    }

    @Override
    public SlotAccess getSlot(int p_149629_) {
        if (p_149629_ == 0) {
            return SlotAccess.of(this::getItem, this::setItem);
        }
        return super.getSlot(p_149629_);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> p_31797_) {
        super.onSyncedDataUpdated(p_31797_);
        if (p_31797_.equals(DATA_ITEM)) {
            this.onItemChanged(this.getItem());
        }
    }

    private void onItemChanged(ItemStack p_218866_) {
        if (!p_218866_.isEmpty() && p_218866_.getFrame() != this) {
            p_218866_.setEntityRepresentation(this);
        }
        this.recalculateBoundingBox();
    }

    public int getRotation() {
        return this.getEntityData().get(DATA_ROTATION);
    }

    public void setRotation(int p_31771_) {
        this.setRotation(p_31771_, true);
    }

    private void setRotation(int p_31773_, boolean p_31774_) {
        this.getEntityData().set(DATA_ROTATION, p_31773_ % 8);
        if (p_31774_ && this.pos != null) {
            this.level().updateNeighbourForOutputSignal(this.pos, Blocks.AIR);
        }
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput p_422684_) {
        super.addAdditionalSaveData(p_422684_);
        ItemStack $$1 = this.getItem();
        if (!$$1.isEmpty()) {
            p_422684_.store("Item", ItemStack.CODEC, $$1);
        }
        p_422684_.putByte("ItemRotation", (byte)this.getRotation());
        p_422684_.putFloat("ItemDropChance", this.dropChance);
        p_422684_.store("Facing", Direction.LEGACY_ID_CODEC, this.getDirection());
        p_422684_.putBoolean("Invisible", this.isInvisible());
        p_422684_.putBoolean("Fixed", this.fixed);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput p_421484_) {
        super.readAdditionalSaveData(p_421484_);
        ItemStack $$1 = p_421484_.read("Item", ItemStack.CODEC).orElse(ItemStack.EMPTY);
        ItemStack $$2 = this.getItem();
        if (!$$2.isEmpty() && !ItemStack.matches($$1, $$2)) {
            this.removeFramedMap($$2);
        }
        this.setItem($$1, false);
        this.setRotation(p_421484_.getByteOr("ItemRotation", (byte)0), false);
        this.dropChance = p_421484_.getFloatOr("ItemDropChance", 1.0f);
        this.setDirection(p_421484_.read("Facing", Direction.LEGACY_ID_CODEC).orElse(Direction.DOWN));
        this.setInvisible(p_421484_.getBooleanOr("Invisible", false));
        this.fixed = p_421484_.getBooleanOr("Fixed", false);
    }

    @Override
    public InteractionResult interact(Player p_31787_, InteractionHand p_31788_) {
        boolean $$4;
        ItemStack $$2 = p_31787_.getItemInHand(p_31788_);
        boolean $$3 = !this.getItem().isEmpty();
        boolean bl = $$4 = !$$2.isEmpty();
        if (this.fixed) {
            return InteractionResult.PASS;
        }
        if (p_31787_.level().isClientSide) {
            return $$3 || $$4 ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        if (!$$3) {
            if ($$4 && !this.isRemoved()) {
                MapItemSavedData $$5 = MapItem.getSavedData($$2, this.level());
                if ($$5 != null && $$5.isTrackedCountOverLimit(256)) {
                    return InteractionResult.FAIL;
                }
                this.setItem($$2);
                this.gameEvent(GameEvent.BLOCK_CHANGE, p_31787_);
                $$2.consume(1, p_31787_);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        this.playSound(this.getRotateItemSound(), 1.0f, 1.0f);
        this.setRotation(this.getRotation() + 1);
        this.gameEvent(GameEvent.BLOCK_CHANGE, p_31787_);
        return InteractionResult.SUCCESS;
    }

    public SoundEvent getRotateItemSound() {
        return SoundEvents.ITEM_FRAME_ROTATE_ITEM;
    }

    public int getAnalogOutput() {
        if (this.getItem().isEmpty()) {
            return 0;
        }
        return this.getRotation() % 8 + 1;
    }

    @Override
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity p_352300_) {
        return new ClientboundAddEntityPacket((Entity)this, this.getDirection().get3DDataValue(), this.getPos());
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket p_149626_) {
        super.recreateFromPacket(p_149626_);
        this.setDirection(Direction.from3DDataValue(p_149626_.getData()));
    }

    @Override
    public ItemStack getPickResult() {
        ItemStack $$0 = this.getItem();
        if ($$0.isEmpty()) {
            return this.getFrameItemStack();
        }
        return $$0.copy();
    }

    protected ItemStack getFrameItemStack() {
        return new ItemStack(Items.ITEM_FRAME);
    }

    @Override
    public float getVisualRotationYInDegrees() {
        Direction $$0 = this.getDirection();
        int $$1 = $$0.getAxis().isVertical() ? 90 * $$0.getAxisDirection().getStep() : 0;
        return Mth.wrapDegrees(180 + $$0.get2DDataValue() * 90 + this.getRotation() * 45 + $$1);
    }
}

