/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.wolf;

import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;

public class WolfSoundVariants {
    public static final ResourceKey<WolfSoundVariant> CLASSIC = WolfSoundVariants.createKey(SoundSet.CLASSIC);
    public static final ResourceKey<WolfSoundVariant> PUGLIN = WolfSoundVariants.createKey(SoundSet.PUGLIN);
    public static final ResourceKey<WolfSoundVariant> SAD = WolfSoundVariants.createKey(SoundSet.SAD);
    public static final ResourceKey<WolfSoundVariant> ANGRY = WolfSoundVariants.createKey(SoundSet.ANGRY);
    public static final ResourceKey<WolfSoundVariant> GRUMPY = WolfSoundVariants.createKey(SoundSet.GRUMPY);
    public static final ResourceKey<WolfSoundVariant> BIG = WolfSoundVariants.createKey(SoundSet.BIG);
    public static final ResourceKey<WolfSoundVariant> CUTE = WolfSoundVariants.createKey(SoundSet.CUTE);

    private static ResourceKey<WolfSoundVariant> createKey(SoundSet p_406298_) {
        return ResourceKey.create(Registries.WOLF_SOUND_VARIANT, ResourceLocation.withDefaultNamespace(p_406298_.getIdentifier()));
    }

    public static void bootstrap(BootstrapContext<WolfSoundVariant> p_406346_) {
        WolfSoundVariants.register(p_406346_, CLASSIC, SoundSet.CLASSIC);
        WolfSoundVariants.register(p_406346_, PUGLIN, SoundSet.PUGLIN);
        WolfSoundVariants.register(p_406346_, SAD, SoundSet.SAD);
        WolfSoundVariants.register(p_406346_, ANGRY, SoundSet.ANGRY);
        WolfSoundVariants.register(p_406346_, GRUMPY, SoundSet.GRUMPY);
        WolfSoundVariants.register(p_406346_, BIG, SoundSet.BIG);
        WolfSoundVariants.register(p_406346_, CUTE, SoundSet.CUTE);
    }

    private static void register(BootstrapContext<WolfSoundVariant> p_406289_, ResourceKey<WolfSoundVariant> p_406217_, SoundSet p_406296_) {
        p_406289_.register(p_406217_, SoundEvents.WOLF_SOUNDS.get((Object)p_406296_));
    }

    public static Holder<WolfSoundVariant> pickRandomSoundVariant(RegistryAccess p_406325_, RandomSource p_406279_) {
        return p_406325_.lookupOrThrow(Registries.WOLF_SOUND_VARIANT).getRandom(p_406279_).orElseThrow();
    }

    public static enum SoundSet {
        CLASSIC("classic", ""),
        PUGLIN("puglin", "_puglin"),
        SAD("sad", "_sad"),
        ANGRY("angry", "_angry"),
        GRUMPY("grumpy", "_grumpy"),
        BIG("big", "_big"),
        CUTE("cute", "_cute");

        private final String identifier;
        private final String soundEventSuffix;

        private SoundSet(String p_406367_, String p_406209_) {
            this.identifier = p_406367_;
            this.soundEventSuffix = p_406209_;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getSoundEventSuffix() {
            return this.soundEventSuffix;
        }
    }
}

