/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ItemBasedSteering;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.PigVariant;
import net.minecraft.world.entity.animal.PigVariants;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Pig
extends Animal
implements ItemSteerable {
    private static final EntityDataAccessor<Integer> DATA_BOOST_TIME = SynchedEntityData.defineId(Pig.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Holder<PigVariant>> DATA_VARIANT_ID = SynchedEntityData.defineId(Pig.class, EntityDataSerializers.PIG_VARIANT);
    private final ItemBasedSteering steering;

    public Pig(EntityType<? extends Pig> p_29462_, Level p_29463_) {
        super((EntityType<? extends Animal>)p_29462_, p_29463_);
        this.steering = new ItemBasedSteering(this.entityData, DATA_BOOST_TIME);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new FloatGoal(this));
        this.goalSelector.addGoal(1, new PanicGoal(this, 1.25));
        this.goalSelector.addGoal(3, new BreedGoal(this, 1.0));
        this.goalSelector.addGoal(4, new TemptGoal(this, 1.2, p_336182_ -> p_336182_.is(Items.CARROT_ON_A_STICK), false));
        this.goalSelector.addGoal(4, new TemptGoal(this, 1.2, p_335406_ -> p_335406_.is(ItemTags.PIG_FOOD), false));
        this.goalSelector.addGoal(5, new FollowParentGoal(this, 1.1));
        this.goalSelector.addGoal(6, new WaterAvoidingRandomStrollGoal(this, 1.0));
        this.goalSelector.addGoal(7, new LookAtPlayerGoal(this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, new RandomLookAroundGoal(this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    @Override
    @Nullable
    public LivingEntity getControllingPassenger() {
        Player $$0;
        Entity entity;
        if (this.isSaddled() && (entity = this.getFirstPassenger()) instanceof Player && ($$0 = (Player)entity).isHolding(Items.CARROT_ON_A_STICK)) {
            return $$0;
        }
        return super.getControllingPassenger();
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> p_29480_) {
        if (DATA_BOOST_TIME.equals(p_29480_) && this.level().isClientSide) {
            this.steering.onSynced();
        }
        super.onSyncedDataUpdated(p_29480_);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326097_) {
        super.defineSynchedData(p_326097_);
        p_326097_.define(DATA_BOOST_TIME, 0);
        p_326097_.define(DATA_VARIANT_ID, VariantUtils.getDefaultOrAny(this.registryAccess(), PigVariants.DEFAULT));
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput p_421731_) {
        super.addAdditionalSaveData(p_421731_);
        VariantUtils.writeVariant(p_421731_, this.getVariant());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput p_422591_) {
        super.readAdditionalSaveData(p_422591_);
        VariantUtils.readVariant(p_422591_, Registries.PIG_VARIANT).ifPresent(this::setVariant);
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.PIG_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource p_29502_) {
        return SoundEvents.PIG_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.PIG_DEATH;
    }

    @Override
    protected void playStepSound(BlockPos p_29492_, BlockState p_29493_) {
        this.playSound(SoundEvents.PIG_STEP, 0.15f, 1.0f);
    }

    @Override
    public InteractionResult mobInteract(Player p_29489_, InteractionHand p_29490_) {
        boolean $$2 = this.isFood(p_29489_.getItemInHand(p_29490_));
        if (!$$2 && this.isSaddled() && !this.isVehicle() && !p_29489_.isSecondaryUseActive()) {
            if (!this.level().isClientSide) {
                p_29489_.startRiding(this);
            }
            return InteractionResult.SUCCESS;
        }
        InteractionResult $$3 = super.mobInteract(p_29489_, p_29490_);
        if (!$$3.consumesAction()) {
            ItemStack $$4 = p_29489_.getItemInHand(p_29490_);
            if (this.isEquippableInSlot($$4, EquipmentSlot.SADDLE)) {
                return $$4.interactLivingEntity(p_29489_, this, p_29490_);
            }
            return InteractionResult.PASS;
        }
        return $$3;
    }

    @Override
    public boolean canUseSlot(EquipmentSlot p_397991_) {
        if (p_397991_ == EquipmentSlot.SADDLE) {
            return this.isAlive() && !this.isBaby();
        }
        return super.canUseSlot(p_397991_);
    }

    @Override
    protected boolean canDispenserEquipIntoSlot(EquipmentSlot p_397716_) {
        return p_397716_ == EquipmentSlot.SADDLE || super.canDispenserEquipIntoSlot(p_397716_);
    }

    @Override
    protected Holder<SoundEvent> getEquipSound(EquipmentSlot p_397377_, ItemStack p_397787_, Equippable p_397153_) {
        if (p_397377_ == EquipmentSlot.SADDLE) {
            return SoundEvents.PIG_SADDLE;
        }
        return super.getEquipSound(p_397377_, p_397787_, p_397153_);
    }

    @Override
    public Vec3 getDismountLocationForPassenger(LivingEntity p_29487_) {
        Direction $$1 = this.getMotionDirection();
        if ($$1.getAxis() == Direction.Axis.Y) {
            return super.getDismountLocationForPassenger(p_29487_);
        }
        int[][] $$2 = DismountHelper.offsetsForDirection($$1);
        BlockPos $$3 = this.blockPosition();
        BlockPos.MutableBlockPos $$4 = new BlockPos.MutableBlockPos();
        for (Pose $$5 : p_29487_.getDismountPoses()) {
            AABB $$6 = p_29487_.getLocalBoundsForPose($$5);
            for (int[] $$7 : $$2) {
                $$4.set($$3.getX() + $$7[0], $$3.getY(), $$3.getZ() + $$7[1]);
                double $$8 = this.level().getBlockFloorHeight($$4);
                if (!DismountHelper.isBlockFloorValid($$8)) continue;
                Vec3 $$9 = Vec3.upFromBottomCenterOf($$4, $$8);
                if (!DismountHelper.canDismountTo(this.level(), p_29487_, $$6.move($$9))) continue;
                p_29487_.setPose($$5);
                return $$9;
            }
        }
        return super.getDismountLocationForPassenger(p_29487_);
    }

    @Override
    public void thunderHit(ServerLevel p_29473_, LightningBolt p_29474_) {
        if (p_29473_.getDifficulty() != Difficulty.PEACEFUL) {
            ZombifiedPiglin $$2 = this.convertTo(EntityType.ZOMBIFIED_PIGLIN, ConversionParams.single(this, false, true), p_427079_ -> {
                if (this.getMainHandItem().isEmpty()) {
                    p_427079_.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack(Items.GOLDEN_SWORD));
                }
                p_427079_.setPersistenceRequired();
            });
            if ($$2 == null) {
                super.thunderHit(p_29473_, p_29474_);
            }
        } else {
            super.thunderHit(p_29473_, p_29474_);
        }
    }

    @Override
    protected void tickRidden(Player p_278330_, Vec3 p_278267_) {
        super.tickRidden(p_278330_, p_278267_);
        this.setRot(p_278330_.getYRot(), p_278330_.getXRot() * 0.5f);
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
        this.steering.tickBoost();
    }

    @Override
    protected Vec3 getRiddenInput(Player p_278309_, Vec3 p_275479_) {
        return new Vec3(0.0, 0.0, 1.0);
    }

    @Override
    protected float getRiddenSpeed(Player p_278258_) {
        return (float)(this.getAttributeValue(Attributes.MOVEMENT_SPEED) * 0.225 * (double)this.steering.boostFactor());
    }

    @Override
    public boolean boost() {
        return this.steering.boost(this.getRandom());
    }

    @Override
    @Nullable
    public Pig getBreedOffspring(ServerLevel p_149001_, AgeableMob p_149002_) {
        Pig $$2 = EntityType.PIG.create(p_149001_, EntitySpawnReason.BREEDING);
        if ($$2 != null && p_149002_ instanceof Pig) {
            Pig $$3 = (Pig)p_149002_;
            $$2.setVariant(this.random.nextBoolean() ? this.getVariant() : $$3.getVariant());
        }
        return $$2;
    }

    @Override
    public boolean isFood(ItemStack p_29508_) {
        return p_29508_.is(ItemTags.PIG_FOOD);
    }

    @Override
    public Vec3 getLeashOffset() {
        return new Vec3(0.0, 0.6f * this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    private void setVariant(Holder<PigVariant> p_394027_) {
        this.entityData.set(DATA_VARIANT_ID, p_394027_);
    }

    public Holder<PigVariant> getVariant() {
        return this.entityData.get(DATA_VARIANT_ID);
    }

    @Override
    @Nullable
    public <T> T get(DataComponentType<? extends T> p_397148_) {
        if (p_397148_ == DataComponents.PIG_VARIANT) {
            return Pig.castComponentValue(p_397148_, this.getVariant());
        }
        return super.get(p_397148_);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter p_397068_) {
        this.applyImplicitComponentIfPresent(p_397068_, DataComponents.PIG_VARIANT);
        super.applyImplicitComponents(p_397068_);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> p_397092_, T p_397408_) {
        if (p_397092_ == DataComponents.PIG_VARIANT) {
            this.setVariant(Pig.castComponentValue(DataComponents.PIG_VARIANT, p_397408_));
            return true;
        }
        return super.applyImplicitComponent(p_397092_, p_397408_);
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_394599_, DifficultyInstance p_393951_, EntitySpawnReason p_393505_, @Nullable SpawnGroupData p_394079_) {
        VariantUtils.selectVariantToSpawn(SpawnContext.create(p_394599_, this.blockPosition()), Registries.PIG_VARIANT).ifPresent(this::setVariant);
        return super.finalizeSpawn(p_394599_, p_393951_, p_393505_, p_394079_);
    }

    @Override
    @Nullable
    public /* synthetic */ AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return this.getBreedOffspring(serverLevel, ageableMob);
    }
}

