/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.animal.CowVariant;
import net.minecraft.world.entity.animal.TemperatureVariants;
import net.minecraft.world.entity.variant.BiomeCheck;
import net.minecraft.world.entity.variant.ModelAndTexture;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import net.minecraft.world.level.biome.Biome;

public class CowVariants {
    public static final ResourceKey<CowVariant> TEMPERATE = CowVariants.createKey(TemperatureVariants.TEMPERATE);
    public static final ResourceKey<CowVariant> WARM = CowVariants.createKey(TemperatureVariants.WARM);
    public static final ResourceKey<CowVariant> COLD = CowVariants.createKey(TemperatureVariants.COLD);
    public static final ResourceKey<CowVariant> DEFAULT = TEMPERATE;

    private static ResourceKey<CowVariant> createKey(ResourceLocation p_401195_) {
        return ResourceKey.create(Registries.COW_VARIANT, p_401195_);
    }

    public static void bootstrap(BootstrapContext<CowVariant> p_401025_) {
        CowVariants.register(p_401025_, TEMPERATE, CowVariant.ModelType.NORMAL, "temperate_cow", SpawnPrioritySelectors.fallback(0));
        CowVariants.register(p_401025_, WARM, CowVariant.ModelType.WARM, "warm_cow", BiomeTags.SPAWNS_WARM_VARIANT_FARM_ANIMALS);
        CowVariants.register(p_401025_, COLD, CowVariant.ModelType.COLD, "cold_cow", BiomeTags.SPAWNS_COLD_VARIANT_FARM_ANIMALS);
    }

    private static void register(BootstrapContext<CowVariant> p_401233_, ResourceKey<CowVariant> p_401326_, CowVariant.ModelType p_401177_, String p_401134_, TagKey<Biome> p_401160_) {
        HolderSet.Named<Biome> $$5 = p_401233_.lookup(Registries.BIOME).getOrThrow(p_401160_);
        CowVariants.register(p_401233_, p_401326_, p_401177_, p_401134_, SpawnPrioritySelectors.single(new BiomeCheck($$5), 1));
    }

    private static void register(BootstrapContext<CowVariant> p_401143_, ResourceKey<CowVariant> p_401412_, CowVariant.ModelType p_401209_, String p_401425_, SpawnPrioritySelectors p_401210_) {
        ResourceLocation $$5 = ResourceLocation.withDefaultNamespace("entity/cow/" + p_401425_);
        p_401143_.register(p_401412_, new CowVariant(new ModelAndTexture<CowVariant.ModelType>(p_401209_, $$5), p_401210_));
    }
}

