/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class Animal
extends AgeableMob {
    protected static final int PARENT_AGE_AFTER_BREEDING = 6000;
    private static final int DEFAULT_IN_LOVE_TIME = 0;
    private int inLove = 0;
    @Nullable
    private EntityReference<ServerPlayer> loveCause;

    protected Animal(EntityType<? extends Animal> p_27557_, Level p_27558_) {
        super((EntityType<? extends AgeableMob>)p_27557_, p_27558_);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 16.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
    }

    public static AttributeSupplier.Builder createAnimalAttributes() {
        return Mob.createMobAttributes().add(Attributes.TEMPT_RANGE, 10.0);
    }

    @Override
    protected void customServerAiStep(ServerLevel p_376777_) {
        if (this.getAge() != 0) {
            this.inLove = 0;
        }
        super.customServerAiStep(p_376777_);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.getAge() != 0) {
            this.inLove = 0;
        }
        if (this.inLove > 0) {
            --this.inLove;
            if (this.inLove % 10 == 0) {
                double $$0 = this.random.nextGaussian() * 0.02;
                double $$1 = this.random.nextGaussian() * 0.02;
                double $$2 = this.random.nextGaussian() * 0.02;
                this.level().addParticle(ParticleTypes.HEART, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), $$0, $$1, $$2);
            }
        }
    }

    @Override
    protected void actuallyHurt(ServerLevel p_376120_, DamageSource p_341676_, float p_341648_) {
        this.resetLove();
        super.actuallyHurt(p_376120_, p_341676_, p_341648_);
    }

    @Override
    public float getWalkTargetValue(BlockPos p_27573_, LevelReader p_27574_) {
        if (p_27574_.getBlockState(p_27573_.below()).is(Blocks.GRASS_BLOCK)) {
            return 10.0f;
        }
        return p_27574_.getPathfindingCostFromLightLevels(p_27573_);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput p_422575_) {
        super.addAdditionalSaveData(p_422575_);
        p_422575_.putInt("InLove", this.inLove);
        EntityReference.store(this.loveCause, p_422575_, "LoveCause");
    }

    @Override
    protected void readAdditionalSaveData(ValueInput p_422190_) {
        super.readAdditionalSaveData(p_422190_);
        this.inLove = p_422190_.getIntOr("InLove", 0);
        this.loveCause = EntityReference.read(p_422190_, "LoveCause");
    }

    public static boolean checkAnimalSpawnRules(EntityType<? extends Animal> p_218105_, LevelAccessor p_218106_, EntitySpawnReason p_360742_, BlockPos p_218108_, RandomSource p_218109_) {
        boolean $$5 = EntitySpawnReason.ignoresLightRequirements(p_360742_) || Animal.isBrightEnoughToSpawn(p_218106_, p_218108_);
        return p_218106_.getBlockState(p_218108_.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON) && $$5;
    }

    protected static boolean isBrightEnoughToSpawn(BlockAndTintGetter p_186210_, BlockPos p_186211_) {
        return p_186210_.getRawBrightness(p_186211_, 0) > 8;
    }

    @Override
    public int getAmbientSoundInterval() {
        return 120;
    }

    @Override
    public boolean removeWhenFarAway(double p_27598_) {
        return false;
    }

    @Override
    protected int getBaseExperienceReward(ServerLevel p_376688_) {
        return 1 + this.random.nextInt(3);
    }

    public abstract boolean isFood(ItemStack var1);

    @Override
    public InteractionResult mobInteract(Player p_27584_, InteractionHand p_27585_) {
        ItemStack $$2 = p_27584_.getItemInHand(p_27585_);
        if (this.isFood($$2)) {
            int $$3 = this.getAge();
            if (p_27584_ instanceof ServerPlayer) {
                ServerPlayer $$4 = (ServerPlayer)p_27584_;
                if ($$3 == 0 && this.canFallInLove()) {
                    this.usePlayerItem(p_27584_, p_27585_, $$2);
                    this.setInLove($$4);
                    this.playEatingSound();
                    return InteractionResult.SUCCESS_SERVER;
                }
            }
            if (this.isBaby()) {
                this.usePlayerItem(p_27584_, p_27585_, $$2);
                this.ageUp(Animal.getSpeedUpSecondsWhenFeeding(-$$3), true);
                this.playEatingSound();
                return InteractionResult.SUCCESS;
            }
            if (this.level().isClientSide) {
                return InteractionResult.CONSUME;
            }
        }
        return super.mobInteract(p_27584_, p_27585_);
    }

    protected void playEatingSound() {
    }

    protected void usePlayerItem(Player p_148715_, InteractionHand p_148716_, ItemStack p_148717_) {
        int $$3 = p_148717_.getCount();
        UseRemainder $$4 = p_148717_.get(DataComponents.USE_REMAINDER);
        p_148717_.consume(1, p_148715_);
        if ($$4 != null) {
            ItemStack $$5 = $$4.convertIntoRemainder(p_148717_, $$3, p_148715_.hasInfiniteMaterials(), p_148715_::handleExtraItemsCreatedOnUse);
            p_148715_.setItemInHand(p_148716_, $$5);
        }
    }

    public boolean canFallInLove() {
        return this.inLove <= 0;
    }

    public void setInLove(@Nullable Player p_27596_) {
        this.inLove = 600;
        if (p_27596_ instanceof ServerPlayer) {
            ServerPlayer $$1 = (ServerPlayer)p_27596_;
            this.loveCause = new EntityReference<ServerPlayer>($$1);
        }
        this.level().broadcastEntityEvent(this, (byte)18);
    }

    public void setInLoveTime(int p_27602_) {
        this.inLove = p_27602_;
    }

    public int getInLoveTime() {
        return this.inLove;
    }

    @Nullable
    public ServerPlayer getLoveCause() {
        return EntityReference.get(this.loveCause, this.level()::getPlayerByUUID, ServerPlayer.class);
    }

    public boolean isInLove() {
        return this.inLove > 0;
    }

    public void resetLove() {
        this.inLove = 0;
    }

    public boolean canMate(Animal p_27569_) {
        if (p_27569_ == this) {
            return false;
        }
        if (p_27569_.getClass() != this.getClass()) {
            return false;
        }
        return this.isInLove() && p_27569_.isInLove();
    }

    public void spawnChildFromBreeding(ServerLevel p_27564_, Animal p_27565_) {
        AgeableMob $$2 = this.getBreedOffspring(p_27564_, p_27565_);
        if ($$2 == null) {
            return;
        }
        $$2.setBaby(true);
        $$2.snapTo(this.getX(), this.getY(), this.getZ(), 0.0f, 0.0f);
        this.finalizeSpawnChildFromBreeding(p_27564_, p_27565_, $$2);
        p_27564_.addFreshEntityWithPassengers($$2);
    }

    public void finalizeSpawnChildFromBreeding(ServerLevel p_277963_, Animal p_277357_, @Nullable AgeableMob p_277516_) {
        Optional.ofNullable(this.getLoveCause()).or(() -> Optional.ofNullable(p_277357_.getLoveCause())).ifPresent(p_277486_ -> {
            p_277486_.awardStat(Stats.ANIMALS_BRED);
            CriteriaTriggers.BRED_ANIMALS.trigger((ServerPlayer)p_277486_, this, p_277357_, p_277516_);
        });
        this.setAge(6000);
        p_277357_.setAge(6000);
        this.resetLove();
        p_277357_.resetLove();
        p_277963_.broadcastEntityEvent(this, (byte)18);
        if (p_277963_.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            p_277963_.addFreshEntity(new ExperienceOrb(p_277963_, this.getX(), this.getY(), this.getZ(), this.getRandom().nextInt(7) + 1));
        }
    }

    @Override
    public void handleEntityEvent(byte p_27562_) {
        if (p_27562_ == 18) {
            for (int $$1 = 0; $$1 < 7; ++$$1) {
                double $$2 = this.random.nextGaussian() * 0.02;
                double $$3 = this.random.nextGaussian() * 0.02;
                double $$4 = this.random.nextGaussian() * 0.02;
                this.level().addParticle(ParticleTypes.HEART, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), $$2, $$3, $$4);
            }
        } else {
            super.handleEntityEvent(p_27562_);
        }
    }
}

