/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.village.poi;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.ai.village.poi.PoiType;

public class PoiRecord {
    private final BlockPos pos;
    private final Holder<PoiType> poiType;
    private int freeTickets;
    private final Runnable setDirty;

    PoiRecord(BlockPos p_218008_, Holder<PoiType> p_218009_, int p_218010_, Runnable p_218011_) {
        this.pos = p_218008_.immutable();
        this.poiType = p_218009_;
        this.freeTickets = p_218010_;
        this.setDirty = p_218011_;
    }

    public PoiRecord(BlockPos p_218013_, Holder<PoiType> p_218014_, Runnable p_218015_) {
        this(p_218013_, p_218014_, p_218014_.value().maxTickets(), p_218015_);
    }

    public Packed pack() {
        return new Packed(this.pos, this.poiType, this.freeTickets);
    }

    @Deprecated
    @VisibleForDebug
    public int getFreeTickets() {
        return this.freeTickets;
    }

    protected boolean acquireTicket() {
        if (this.freeTickets <= 0) {
            return false;
        }
        --this.freeTickets;
        this.setDirty.run();
        return true;
    }

    protected boolean releaseTicket() {
        if (this.freeTickets >= this.poiType.value().maxTickets()) {
            return false;
        }
        ++this.freeTickets;
        this.setDirty.run();
        return true;
    }

    public boolean hasSpace() {
        return this.freeTickets > 0;
    }

    public boolean isOccupied() {
        return this.freeTickets != this.poiType.value().maxTickets();
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Holder<PoiType> getPoiType() {
        return this.poiType;
    }

    public boolean equals(Object p_27256_) {
        if (this == p_27256_) {
            return true;
        }
        if (p_27256_ == null || this.getClass() != p_27256_.getClass()) {
            return false;
        }
        return Objects.equals(this.pos, ((PoiRecord)p_27256_).pos);
    }

    public int hashCode() {
        return this.pos.hashCode();
    }

    public record Packed(BlockPos pos, Holder<PoiType> poiType, int freeTickets) {
        public static final Codec<Packed> CODEC = RecordCodecBuilder.create(p_361073_ -> p_361073_.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(Packed::pos), (App)RegistryFixedCodec.create(Registries.POINT_OF_INTEREST_TYPE).fieldOf("type").forGetter(Packed::poiType), (App)Codec.INT.fieldOf("free_tickets").orElse((Object)0).forGetter(Packed::freeTickets)).apply((Applicative)p_361073_, Packed::new));

        public PoiRecord unpack(Runnable p_362526_) {
            return new PoiRecord(this.pos, this.poiType, this.freeTickets, p_362526_);
        }
    }
}

