/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class TemptingSensor
extends Sensor<PathfinderMob> {
    private static final TargetingConditions TEMPT_TARGETING = TargetingConditions.forNonCombat().ignoreLineOfSight();
    private final Predicate<ItemStack> temptations;

    public TemptingSensor(Predicate<ItemStack> p_335605_) {
        this.temptations = p_335605_;
    }

    @Override
    protected void doTick(ServerLevel p_148331_, PathfinderMob p_148332_) {
        Brain<?> $$2 = p_148332_.getBrain();
        TargetingConditions $$3 = TEMPT_TARGETING.copy().range((float)p_148332_.getAttributeValue(Attributes.TEMPT_RANGE));
        List $$4 = p_148331_.players().stream().filter(EntitySelector.NO_SPECTATORS).filter(p_375769_ -> $$3.test(p_148331_, p_148332_, (LivingEntity)p_375769_)).filter(this::playerHoldingTemptation).filter(p_423271_ -> !p_148332_.hasPassenger((Entity)p_423271_)).sorted(Comparator.comparingDouble(p_148332_::distanceToSqr)).collect(Collectors.toList());
        if (!$$4.isEmpty()) {
            Player $$5 = (Player)$$4.get(0);
            $$2.setMemory(MemoryModuleType.TEMPTING_PLAYER, $$5);
        } else {
            $$2.eraseMemory(MemoryModuleType.TEMPTING_PLAYER);
        }
    }

    private boolean playerHoldingTemptation(Player p_148337_) {
        return this.isTemptation(p_148337_.getMainHandItem()) || this.isTemptation(p_148337_.getOffhandItem());
    }

    private boolean isTemptation(ItemStack p_148339_) {
        return this.temptations.test(p_148339_);
    }

    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(MemoryModuleType.TEMPTING_PLAYER);
    }
}

