/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.phys.AABB;

public class NearestLivingEntitySensor<T extends LivingEntity>
extends Sensor<T> {
    @Override
    protected void doTick(ServerLevel p_26710_, T p_26711_) {
        double $$2 = ((LivingEntity)p_26711_).getAttributeValue(Attributes.FOLLOW_RANGE);
        AABB $$3 = ((Entity)p_26711_).getBoundingBox().inflate($$2, $$2, $$2);
        List<LivingEntity> $$4 = p_26710_.getEntitiesOfClass(LivingEntity.class, $$3, p_26717_ -> p_26717_ != p_26711_ && p_26717_.isAlive());
        $$4.sort(Comparator.comparingDouble(arg_0 -> p_26711_.distanceToSqr(arg_0)));
        Brain<?> $$5 = ((LivingEntity)p_26711_).getBrain();
        $$5.setMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES, $$4);
        $$5.setMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, new NearestVisibleLivingEntities(p_26710_, (LivingEntity)p_26711_, $$4));
    }

    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
    }
}

