/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.waypoints.ServerWaypointManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.ElytraAnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.component.DeathProtection;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HoneyBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.waypoints.Waypoint;
import net.minecraft.world.waypoints.WaypointTransmitter;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;

public abstract class LivingEntity
extends Entity
implements Attackable,
WaypointTransmitter {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_ACTIVE_EFFECTS = "active_effects";
    public static final String TAG_ATTRIBUTES = "attributes";
    public static final String TAG_SLEEPING_POS = "sleeping_pos";
    public static final String TAG_EQUIPMENT = "equipment";
    public static final String TAG_BRAIN = "Brain";
    public static final String TAG_FALL_FLYING = "FallFlying";
    public static final String TAG_HURT_TIME = "HurtTime";
    public static final String TAG_DEATH_TIME = "DeathTime";
    public static final String TAG_HURT_BY_TIMESTAMP = "HurtByTimestamp";
    public static final String TAG_HEALTH = "Health";
    private static final ResourceLocation SPEED_MODIFIER_POWDER_SNOW_ID = ResourceLocation.withDefaultNamespace("powder_snow");
    private static final ResourceLocation SPRINTING_MODIFIER_ID = ResourceLocation.withDefaultNamespace("sprinting");
    private static final AttributeModifier SPEED_MODIFIER_SPRINTING = new AttributeModifier(SPRINTING_MODIFIER_ID, 0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    public static final int EQUIPMENT_SLOT_OFFSET = 98;
    public static final int ARMOR_SLOT_OFFSET = 100;
    public static final int BODY_ARMOR_OFFSET = 105;
    public static final int SADDLE_OFFSET = 106;
    public static final int SWING_DURATION = 6;
    public static final int PLAYER_HURT_EXPERIENCE_TIME = 100;
    private static final int DAMAGE_SOURCE_TIMEOUT = 40;
    public static final double MIN_MOVEMENT_DISTANCE = 0.003;
    public static final double DEFAULT_BASE_GRAVITY = 0.08;
    public static final int DEATH_DURATION = 20;
    protected static final float INPUT_FRICTION = 0.98f;
    private static final int TICKS_PER_ELYTRA_FREE_FALL_EVENT = 10;
    private static final int FREE_FALL_EVENTS_PER_ELYTRA_BREAK = 2;
    public static final float BASE_JUMP_POWER = 0.42f;
    private static final double MAX_LINE_OF_SIGHT_TEST_RANGE = 128.0;
    protected static final int LIVING_ENTITY_FLAG_IS_USING = 1;
    protected static final int LIVING_ENTITY_FLAG_OFF_HAND = 2;
    protected static final int LIVING_ENTITY_FLAG_SPIN_ATTACK = 4;
    protected static final EntityDataAccessor<Byte> DATA_LIVING_ENTITY_FLAGS = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Float> DATA_HEALTH_ID = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<List<ParticleOptions>> DATA_EFFECT_PARTICLES = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.PARTICLES);
    private static final EntityDataAccessor<Boolean> DATA_EFFECT_AMBIENCE_ID = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_ARROW_COUNT_ID = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_STINGER_COUNT_ID = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<BlockPos>> SLEEPING_POS_ID = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final int PARTICLE_FREQUENCY_WHEN_INVISIBLE = 15;
    protected static final EntityDimensions SLEEPING_DIMENSIONS = EntityDimensions.fixed(0.2f, 0.2f).withEyeHeight(0.2f);
    public static final float EXTRA_RENDER_CULLING_SIZE_WITH_BIG_HAT = 0.5f;
    public static final float DEFAULT_BABY_SCALE = 0.5f;
    public static final Predicate<LivingEntity> PLAYER_NOT_WEARING_DISGUISE_ITEM = p_401735_ -> {
        void $$2;
        if (!(p_401735_ instanceof Player)) {
            return true;
        }
        Player $$1 = (Player)p_401735_;
        ItemStack $$3 = $$2.getItemBySlot(EquipmentSlot.HEAD);
        return !$$3.is(ItemTags.GAZE_DISGUISE_EQUIPMENT);
    };
    private static final Dynamic<?> EMPTY_BRAIN = new Dynamic((DynamicOps)JavaOps.INSTANCE, Map.of("memories", Map.of()));
    private final AttributeMap attributes;
    private final CombatTracker combatTracker = new CombatTracker(this);
    private final Map<Holder<MobEffect>, MobEffectInstance> activeEffects = Maps.newHashMap();
    private final Map<EquipmentSlot, ItemStack> lastEquipmentItems = Util.makeEnumMap(EquipmentSlot.class, p_396671_ -> ItemStack.EMPTY);
    public boolean swinging;
    private boolean discardFriction = false;
    public InteractionHand swingingArm;
    public int swingTime;
    public int removeArrowTime;
    public int removeStingerTime;
    public int hurtTime;
    public int hurtDuration;
    public int deathTime;
    public float oAttackAnim;
    public float attackAnim;
    protected int attackStrengthTicker;
    public final WalkAnimationState walkAnimation = new WalkAnimationState();
    public final int invulnerableDuration = 20;
    public float yBodyRot;
    public float yBodyRotO;
    public float yHeadRot;
    public float yHeadRotO;
    public final ElytraAnimationState elytraAnimationState = new ElytraAnimationState(this);
    @Nullable
    protected EntityReference<Player> lastHurtByPlayer;
    protected int lastHurtByPlayerMemoryTime;
    protected boolean dead;
    protected int noActionTime;
    protected float lastHurt;
    protected boolean jumping;
    public float xxa;
    public float yya;
    public float zza;
    protected InterpolationHandler interpolation = new InterpolationHandler(this);
    protected double lerpYHeadRot;
    protected int lerpHeadSteps;
    private boolean effectsDirty = true;
    @Nullable
    private EntityReference<LivingEntity> lastHurtByMob;
    private int lastHurtByMobTimestamp;
    @Nullable
    private LivingEntity lastHurtMob;
    private int lastHurtMobTimestamp;
    private float speed;
    private int noJumpDelay;
    private float absorptionAmount;
    protected ItemStack useItem = ItemStack.EMPTY;
    protected int useItemRemaining;
    protected int fallFlyTicks;
    private BlockPos lastPos;
    private Optional<BlockPos> lastClimbablePos = Optional.empty();
    @Nullable
    private DamageSource lastDamageSource;
    private long lastDamageStamp;
    protected int autoSpinAttackTicks;
    protected float autoSpinAttackDmg;
    @Nullable
    protected ItemStack autoSpinAttackItemStack;
    private float swimAmount;
    private float swimAmountO;
    protected Brain<?> brain;
    private boolean skipDropExperience;
    private final EnumMap<EquipmentSlot, Reference2ObjectMap<Enchantment, Set<EnchantmentLocationBasedEffect>>> activeLocationDependentEnchantments = new EnumMap(EquipmentSlot.class);
    protected final EntityEquipment equipment;
    private Waypoint.Icon locatorBarIcon = new Waypoint.Icon();

    protected LivingEntity(EntityType<? extends LivingEntity> p_20966_, Level p_20967_) {
        super(p_20966_, p_20967_);
        this.attributes = new AttributeMap(DefaultAttributes.getSupplier(p_20966_));
        this.setHealth(this.getMaxHealth());
        this.equipment = this.createEquipment();
        this.blocksBuilding = true;
        this.reapplyPosition();
        this.setYRot((float)(Math.random() * 6.2831854820251465));
        this.yHeadRot = this.getYRot();
        this.brain = this.makeBrain(EMPTY_BRAIN);
    }

    @Contract(pure=true)
    protected EntityEquipment createEquipment() {
        return new EntityEquipment();
    }

    public Brain<?> getBrain() {
        return this.brain;
    }

    protected Brain.Provider<?> brainProvider() {
        return Brain.provider(ImmutableList.of(), ImmutableList.of());
    }

    protected Brain<?> makeBrain(Dynamic<?> p_21069_) {
        return this.brainProvider().makeBrain(p_21069_);
    }

    @Override
    public void kill(ServerLevel p_376643_) {
        this.hurtServer(p_376643_, this.damageSources().genericKill(), Float.MAX_VALUE);
    }

    public boolean canAttackType(EntityType<?> p_21032_) {
        return true;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326178_) {
        p_326178_.define(DATA_LIVING_ENTITY_FLAGS, (byte)0);
        p_326178_.define(DATA_EFFECT_PARTICLES, List.of());
        p_326178_.define(DATA_EFFECT_AMBIENCE_ID, false);
        p_326178_.define(DATA_ARROW_COUNT_ID, 0);
        p_326178_.define(DATA_STINGER_COUNT_ID, 0);
        p_326178_.define(DATA_HEALTH_ID, Float.valueOf(1.0f));
        p_326178_.define(SLEEPING_POS_ID, Optional.empty());
    }

    public static AttributeSupplier.Builder createLivingAttributes() {
        return AttributeSupplier.builder().add(Attributes.MAX_HEALTH).add(Attributes.KNOCKBACK_RESISTANCE).add(Attributes.MOVEMENT_SPEED).add(Attributes.ARMOR).add(Attributes.ARMOR_TOUGHNESS).add(Attributes.MAX_ABSORPTION).add(Attributes.STEP_HEIGHT).add(Attributes.SCALE).add(Attributes.GRAVITY).add(Attributes.SAFE_FALL_DISTANCE).add(Attributes.FALL_DAMAGE_MULTIPLIER).add(Attributes.JUMP_STRENGTH).add(Attributes.OXYGEN_BONUS).add(Attributes.BURNING_TIME).add(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE).add(Attributes.WATER_MOVEMENT_EFFICIENCY).add(Attributes.MOVEMENT_EFFICIENCY).add(Attributes.ATTACK_KNOCKBACK).add(Attributes.CAMERA_DISTANCE).add(Attributes.WAYPOINT_TRANSMIT_RANGE);
    }

    @Override
    protected void checkFallDamage(double p_20990_, boolean p_20991_, BlockState p_20992_, BlockPos p_20993_) {
        Level level;
        if (!this.isInWater()) {
            this.updateInWaterStateAndDoWaterCurrentPushing();
        }
        if ((level = this.level()) instanceof ServerLevel) {
            ServerLevel $$4 = (ServerLevel)level;
            if (p_20991_ && this.fallDistance > 0.0) {
                this.onChangedBlock($$4, p_20993_);
                double $$5 = Math.max(0, Mth.floor(this.calculateFallPower(this.fallDistance)));
                if ($$5 > 0.0 && !p_20992_.isAir()) {
                    double $$6 = this.getX();
                    double $$7 = this.getY();
                    double $$8 = this.getZ();
                    BlockPos $$9 = this.blockPosition();
                    if (p_20993_.getX() != $$9.getX() || p_20993_.getZ() != $$9.getZ()) {
                        double $$10 = $$6 - (double)p_20993_.getX() - 0.5;
                        double $$11 = $$8 - (double)p_20993_.getZ() - 0.5;
                        double $$12 = Math.max(Math.abs($$10), Math.abs($$11));
                        $$6 = (double)p_20993_.getX() + 0.5 + $$10 / $$12 * 0.5;
                        $$8 = (double)p_20993_.getZ() + 0.5 + $$11 / $$12 * 0.5;
                    }
                    double $$13 = Math.min((double)0.2f + $$5 / 15.0, 2.5);
                    int $$14 = (int)(150.0 * $$13);
                    $$4.sendParticles(new BlockParticleOption(ParticleTypes.BLOCK, p_20992_), $$6, $$7, $$8, $$14, 0.0, 0.0, 0.0, 0.15f);
                }
            }
        }
        super.checkFallDamage(p_20990_, p_20991_, p_20992_, p_20993_);
        if (p_20991_) {
            this.lastClimbablePos = Optional.empty();
        }
    }

    public boolean canBreatheUnderwater() {
        return this.getType().is(EntityTypeTags.CAN_BREATHE_UNDER_WATER);
    }

    public float getSwimAmount(float p_20999_) {
        return Mth.lerp(p_20999_, this.swimAmountO, this.swimAmount);
    }

    public boolean hasLandedInLiquid() {
        return this.getDeltaMovement().y() < (double)1.0E-5f && this.isInLiquid();
    }

    @Override
    public void baseTick() {
        LivingEntity $$8;
        Level level;
        Level level2;
        this.oAttackAnim = this.attackAnim;
        if (this.firstTick) {
            this.getSleepingPos().ifPresent(this::setPosToBed);
        }
        if ((level2 = this.level()) instanceof ServerLevel) {
            ServerLevel $$0 = (ServerLevel)level2;
            EnchantmentHelper.tickEffects($$0, this);
        }
        super.baseTick();
        ProfilerFiller $$1 = Profiler.get();
        $$1.push("livingEntityBaseTick");
        if (this.fireImmune() || this.level().isClientSide) {
            this.clearFire();
        }
        if (this.isAlive() && (level = this.level()) instanceof ServerLevel) {
            double $$5;
            double $$4;
            ServerLevel $$2 = (ServerLevel)level;
            boolean $$3 = this instanceof Player;
            if (this.isInWall()) {
                this.hurtServer($$2, this.damageSources().inWall(), 1.0f);
            } else if ($$3 && !$$2.getWorldBorder().isWithinBounds(this.getBoundingBox()) && ($$4 = $$2.getWorldBorder().getDistanceToBorder(this) + $$2.getWorldBorder().getDamageSafeZone()) < 0.0 && ($$5 = $$2.getWorldBorder().getDamagePerBlock()) > 0.0) {
                this.hurtServer($$2, this.damageSources().outOfBorder(), Math.max(1, Mth.floor(-$$4 * $$5)));
            }
            if (this.isEyeInFluid(FluidTags.WATER) && !$$2.getBlockState(BlockPos.containing(this.getX(), this.getEyeY(), this.getZ())).is(Blocks.BUBBLE_COLUMN)) {
                boolean $$6;
                boolean bl = $$6 = !this.canBreatheUnderwater() && !MobEffectUtil.hasWaterBreathing(this) && (!$$3 || !((Player)this).getAbilities().invulnerable);
                if ($$6) {
                    this.setAirSupply(this.decreaseAirSupply(this.getAirSupply()));
                    if (this.getAirSupply() == -20) {
                        this.setAirSupply(0);
                        $$2.broadcastEntityEvent(this, (byte)67);
                        this.hurtServer($$2, this.damageSources().drown(), 2.0f);
                    }
                } else if (this.getAirSupply() < this.getMaxAirSupply()) {
                    this.setAirSupply(this.increaseAirSupply(this.getAirSupply()));
                }
                if (this.isPassenger() && this.getVehicle() != null && this.getVehicle().dismountsUnderwater()) {
                    this.stopRiding();
                }
            } else if (this.getAirSupply() < this.getMaxAirSupply()) {
                this.setAirSupply(this.increaseAirSupply(this.getAirSupply()));
            }
            BlockPos $$7 = this.blockPosition();
            if (!Objects.equal((Object)this.lastPos, (Object)$$7)) {
                this.lastPos = $$7;
                this.onChangedBlock($$2, $$7);
            }
        }
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (this.invulnerableTime > 0 && !(this instanceof ServerPlayer)) {
            --this.invulnerableTime;
        }
        if (this.isDeadOrDying() && this.level().shouldTickDeath(this)) {
            this.tickDeath();
        }
        if (this.lastHurtByPlayerMemoryTime > 0) {
            --this.lastHurtByPlayerMemoryTime;
        } else {
            this.lastHurtByPlayer = null;
        }
        if (this.lastHurtMob != null && !this.lastHurtMob.isAlive()) {
            this.lastHurtMob = null;
        }
        if (($$8 = this.getLastHurtByMob()) != null) {
            if (!$$8.isAlive()) {
                this.setLastHurtByMob(null);
            } else if (this.tickCount - this.lastHurtByMobTimestamp > 100) {
                this.setLastHurtByMob(null);
            }
        }
        this.tickEffects();
        this.yHeadRotO = this.yHeadRot;
        this.yBodyRotO = this.yBodyRot;
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        $$1.pop();
    }

    @Override
    protected float getBlockSpeedFactor() {
        return Mth.lerp((float)this.getAttributeValue(Attributes.MOVEMENT_EFFICIENCY), super.getBlockSpeedFactor(), 1.0f);
    }

    public float getLuck() {
        return 0.0f;
    }

    protected void removeFrost() {
        AttributeInstance $$0 = this.getAttribute(Attributes.MOVEMENT_SPEED);
        if ($$0 == null) {
            return;
        }
        if ($$0.getModifier(SPEED_MODIFIER_POWDER_SNOW_ID) != null) {
            $$0.removeModifier(SPEED_MODIFIER_POWDER_SNOW_ID);
        }
    }

    protected void tryAddFrost() {
        int $$0;
        if (!this.getBlockStateOnLegacy().isAir() && ($$0 = this.getTicksFrozen()) > 0) {
            AttributeInstance $$1 = this.getAttribute(Attributes.MOVEMENT_SPEED);
            if ($$1 == null) {
                return;
            }
            float $$2 = -0.05f * this.getPercentFrozen();
            $$1.addTransientModifier(new AttributeModifier(SPEED_MODIFIER_POWDER_SNOW_ID, $$2, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    protected void onChangedBlock(ServerLevel p_345126_, BlockPos p_21175_) {
        EnchantmentHelper.runLocationChangedEffects(p_345126_, this);
    }

    public boolean isBaby() {
        return false;
    }

    public float getAgeScale() {
        return this.isBaby() ? 0.5f : 1.0f;
    }

    public final float getScale() {
        AttributeMap $$0 = this.getAttributes();
        if ($$0 == null) {
            return 1.0f;
        }
        return this.sanitizeScale((float)$$0.getValue(Attributes.SCALE));
    }

    protected float sanitizeScale(float p_320290_) {
        return p_320290_;
    }

    public boolean isAffectedByFluids() {
        return true;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime >= 20 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().broadcastEntityEvent(this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public boolean shouldDropExperience() {
        return !this.isBaby();
    }

    protected boolean shouldDropLoot() {
        return !this.isBaby();
    }

    protected int decreaseAirSupply(int p_21303_) {
        double $$3;
        AttributeInstance $$1 = this.getAttribute(Attributes.OXYGEN_BONUS);
        if ($$1 != null) {
            double $$2 = $$1.getValue();
        } else {
            $$3 = 0.0;
        }
        if ($$3 > 0.0 && this.random.nextDouble() >= 1.0 / ($$3 + 1.0)) {
            return p_21303_;
        }
        return p_21303_ - 1;
    }

    protected int increaseAirSupply(int p_21307_) {
        return Math.min(p_21307_ + 4, this.getMaxAirSupply());
    }

    public final int getExperienceReward(ServerLevel p_345212_, @Nullable Entity p_345512_) {
        return EnchantmentHelper.processMobExperience(p_345212_, p_345512_, this, this.getBaseExperienceReward(p_345212_));
    }

    protected int getBaseExperienceReward(ServerLevel p_376478_) {
        return 0;
    }

    protected boolean isAlwaysExperienceDropper() {
        return false;
    }

    @Nullable
    public LivingEntity getLastHurtByMob() {
        return EntityReference.get(this.lastHurtByMob, this.level(), LivingEntity.class);
    }

    @Nullable
    public Player getLastHurtByPlayer() {
        return EntityReference.get(this.lastHurtByPlayer, this.level(), Player.class);
    }

    @Override
    public LivingEntity getLastAttacker() {
        return this.getLastHurtByMob();
    }

    public int getLastHurtByMobTimestamp() {
        return this.lastHurtByMobTimestamp;
    }

    public void setLastHurtByPlayer(Player p_394286_, int p_393829_) {
        this.setLastHurtByPlayer(new EntityReference<Player>(p_394286_), p_393829_);
    }

    public void setLastHurtByPlayer(UUID p_393630_, int p_394184_) {
        this.setLastHurtByPlayer(new EntityReference<Player>(p_393630_), p_394184_);
    }

    private void setLastHurtByPlayer(EntityReference<Player> p_394656_, int p_393942_) {
        this.lastHurtByPlayer = p_394656_;
        this.lastHurtByPlayerMemoryTime = p_393942_;
    }

    public void setLastHurtByMob(@Nullable LivingEntity p_21039_) {
        this.lastHurtByMob = p_21039_ != null ? new EntityReference<LivingEntity>(p_21039_) : null;
        this.lastHurtByMobTimestamp = this.tickCount;
    }

    @Nullable
    public LivingEntity getLastHurtMob() {
        return this.lastHurtMob;
    }

    public int getLastHurtMobTimestamp() {
        return this.lastHurtMobTimestamp;
    }

    public void setLastHurtMob(Entity p_21336_) {
        this.lastHurtMob = p_21336_ instanceof LivingEntity ? (LivingEntity)p_21336_ : null;
        this.lastHurtMobTimestamp = this.tickCount;
    }

    public int getNoActionTime() {
        return this.noActionTime;
    }

    public void setNoActionTime(int p_21311_) {
        this.noActionTime = p_21311_;
    }

    public boolean shouldDiscardFriction() {
        return this.discardFriction;
    }

    public void setDiscardFriction(boolean p_147245_) {
        this.discardFriction = p_147245_;
    }

    protected boolean doesEmitEquipEvent(EquipmentSlot p_217035_) {
        return true;
    }

    public void onEquipItem(EquipmentSlot p_238393_, ItemStack p_238394_, ItemStack p_238395_) {
        if (this.level().isClientSide() || this.isSpectator()) {
            return;
        }
        if (ItemStack.isSameItemSameComponents(p_238394_, p_238395_) || this.firstTick) {
            return;
        }
        Equippable $$3 = p_238395_.get(DataComponents.EQUIPPABLE);
        if (!this.isSilent() && $$3 != null && p_238393_ == $$3.slot()) {
            this.level().playSeededSound(null, this.getX(), this.getY(), this.getZ(), this.getEquipSound(p_238393_, p_238395_, $$3), this.getSoundSource(), 1.0f, 1.0f, this.random.nextLong());
        }
        if (this.doesEmitEquipEvent(p_238393_)) {
            this.gameEvent($$3 != null ? GameEvent.EQUIP : GameEvent.UNEQUIP);
        }
    }

    protected Holder<SoundEvent> getEquipSound(EquipmentSlot p_397727_, ItemStack p_397629_, Equippable p_397917_) {
        return p_397917_.equipSound();
    }

    @Override
    public void remove(Entity.RemovalReason p_276115_) {
        Level level;
        if ((p_276115_ == Entity.RemovalReason.KILLED || p_276115_ == Entity.RemovalReason.DISCARDED) && (level = this.level()) instanceof ServerLevel) {
            ServerLevel $$1 = (ServerLevel)level;
            this.triggerOnDeathMobEffects($$1, p_276115_);
        }
        super.remove(p_276115_);
        this.brain.clearMemories();
    }

    @Override
    public void onRemoval(Entity.RemovalReason p_415553_) {
        super.onRemoval(p_415553_);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel $$1 = (ServerLevel)level;
            $$1.getWaypointManager().untrackWaypoint(this);
        }
    }

    protected void triggerOnDeathMobEffects(ServerLevel p_376702_, Entity.RemovalReason p_350496_) {
        for (MobEffectInstance $$2 : this.getActiveEffects()) {
            $$2.onMobRemoved(p_376702_, this, p_350496_);
        }
        this.activeEffects.clear();
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput p_421587_) {
        p_421587_.putFloat(TAG_HEALTH, this.getHealth());
        p_421587_.putShort(TAG_HURT_TIME, (short)this.hurtTime);
        p_421587_.putInt(TAG_HURT_BY_TIMESTAMP, this.lastHurtByMobTimestamp);
        p_421587_.putShort(TAG_DEATH_TIME, (short)this.deathTime);
        p_421587_.putFloat("AbsorptionAmount", this.getAbsorptionAmount());
        p_421587_.store(TAG_ATTRIBUTES, AttributeInstance.Packed.LIST_CODEC, this.getAttributes().pack());
        if (!this.activeEffects.isEmpty()) {
            p_421587_.store(TAG_ACTIVE_EFFECTS, MobEffectInstance.CODEC.listOf(), List.copyOf(this.activeEffects.values()));
        }
        p_421587_.putBoolean(TAG_FALL_FLYING, this.isFallFlying());
        this.getSleepingPos().ifPresent(p_421363_ -> p_421587_.store(TAG_SLEEPING_POS, BlockPos.CODEC, p_421363_));
        DataResult $$1 = this.brain.serializeStart(NbtOps.INSTANCE).map(p_421361_ -> new Dynamic((DynamicOps)NbtOps.INSTANCE, p_421361_));
        $$1.resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_421360_ -> p_421587_.store(TAG_BRAIN, Codec.PASSTHROUGH, p_421360_));
        if (this.lastHurtByPlayer != null) {
            this.lastHurtByPlayer.store(p_421587_, "last_hurt_by_player");
            p_421587_.putInt("last_hurt_by_player_memory_time", this.lastHurtByPlayerMemoryTime);
        }
        if (this.lastHurtByMob != null) {
            this.lastHurtByMob.store(p_421587_, "last_hurt_by_mob");
            p_421587_.putInt("ticks_since_last_hurt_by_mob", this.tickCount - this.lastHurtByMobTimestamp);
        }
        if (!this.equipment.isEmpty()) {
            p_421587_.store(TAG_EQUIPMENT, EntityEquipment.CODEC, this.equipment);
        }
        if (this.locatorBarIcon.hasData()) {
            p_421587_.store("locator_bar_icon", Waypoint.Icon.CODEC, this.locatorBarIcon);
        }
    }

    @Nullable
    public ItemEntity drop(ItemStack p_401947_, boolean p_401861_, boolean p_401913_) {
        if (p_401947_.isEmpty()) {
            return null;
        }
        if (this.level().isClientSide) {
            this.swing(InteractionHand.MAIN_HAND);
            return null;
        }
        ItemEntity $$3 = this.createItemStackToDrop(p_401947_, p_401861_, p_401913_);
        if ($$3 != null) {
            this.level().addFreshEntity($$3);
        }
        return $$3;
    }

    @Override
    protected void readAdditionalSaveData(ValueInput p_422570_) {
        this.internalSetAbsorptionAmount(p_422570_.getFloatOr("AbsorptionAmount", 0.0f));
        if (this.level() != null && !this.level().isClientSide) {
            p_422570_.read(TAG_ATTRIBUTES, AttributeInstance.Packed.LIST_CODEC).ifPresent(this.getAttributes()::apply);
        }
        List $$1 = p_422570_.read(TAG_ACTIVE_EFFECTS, MobEffectInstance.CODEC.listOf()).orElse(List.of());
        this.activeEffects.clear();
        for (MobEffectInstance $$2 : $$1) {
            this.activeEffects.put($$2.getEffect(), $$2);
        }
        this.setHealth(p_422570_.getFloatOr(TAG_HEALTH, this.getMaxHealth()));
        this.hurtTime = p_422570_.getShortOr(TAG_HURT_TIME, (short)0);
        this.deathTime = p_422570_.getShortOr(TAG_DEATH_TIME, (short)0);
        this.lastHurtByMobTimestamp = p_422570_.getIntOr(TAG_HURT_BY_TIMESTAMP, 0);
        p_422570_.getString("Team").ifPresent(p_426978_ -> {
            boolean $$3;
            Scoreboard $$1 = this.level().getScoreboard();
            PlayerTeam $$2 = $$1.getPlayerTeam((String)p_426978_);
            boolean bl = $$3 = $$2 != null && $$1.addPlayerToTeam(this.getStringUUID(), $$2);
            if (!$$3) {
                LOGGER.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", p_426978_);
            }
        });
        this.setSharedFlag(7, p_422570_.getBooleanOr(TAG_FALL_FLYING, false));
        p_422570_.read(TAG_SLEEPING_POS, BlockPos.CODEC).ifPresentOrElse(p_404278_ -> {
            this.setSleepingPos((BlockPos)p_404278_);
            this.entityData.set(DATA_POSE, Pose.SLEEPING);
            if (!this.firstTick) {
                this.setPosToBed((BlockPos)p_404278_);
            }
        }, this::clearSleepingPos);
        p_422570_.read(TAG_BRAIN, Codec.PASSTHROUGH).ifPresent(p_421364_ -> {
            this.brain = this.makeBrain((Dynamic<?>)p_421364_);
        });
        this.lastHurtByPlayer = EntityReference.read(p_422570_, "last_hurt_by_player");
        this.lastHurtByPlayerMemoryTime = p_422570_.getIntOr("last_hurt_by_player_memory_time", 0);
        this.lastHurtByMob = EntityReference.read(p_422570_, "last_hurt_by_mob");
        this.lastHurtByMobTimestamp = p_422570_.getIntOr("ticks_since_last_hurt_by_mob", 0) + this.tickCount;
        this.equipment.setAll(p_422570_.read(TAG_EQUIPMENT, EntityEquipment.CODEC).orElseGet(EntityEquipment::new));
        this.locatorBarIcon = p_422570_.read("locator_bar_icon", Waypoint.Icon.CODEC).orElseGet(Waypoint.Icon::new);
    }

    protected void tickEffects() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel $$0 = (ServerLevel)level;
            Iterator<Object> $$1 = this.activeEffects.keySet().iterator();
            try {
                while ($$1.hasNext()) {
                    Holder $$2 = (Holder)$$1.next();
                    MobEffectInstance $$3 = this.activeEffects.get($$2);
                    if (!$$3.tickServer($$0, this, () -> this.onEffectUpdated($$3, true, null))) {
                        $$1.remove();
                        this.onEffectsRemoved(List.of($$3));
                        continue;
                    }
                    if ($$3.getDuration() % 600 != 0) continue;
                    this.onEffectUpdated($$3, false, null);
                }
            }
            catch (ConcurrentModificationException $$2) {
                // empty catch block
            }
            if (this.effectsDirty) {
                this.updateInvisibilityStatus();
                this.updateGlowingStatus();
                this.effectsDirty = false;
            }
        } else {
            for (MobEffectInstance $$4 : this.activeEffects.values()) {
                $$4.tickClient();
            }
            List<ParticleOptions> $$5 = this.entityData.get(DATA_EFFECT_PARTICLES);
            if (!$$5.isEmpty()) {
                int $$8;
                boolean $$6 = this.entityData.get(DATA_EFFECT_AMBIENCE_ID);
                int $$7 = this.isInvisible() ? 15 : 4;
                int n = $$8 = $$6 ? 5 : 1;
                if (this.random.nextInt($$7 * $$8) == 0) {
                    this.level().addParticle(Util.getRandom($$5, this.random), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 1.0, 1.0, 1.0);
                }
            }
        }
    }

    protected void updateInvisibilityStatus() {
        if (this.activeEffects.isEmpty()) {
            this.removeEffectParticles();
            this.setInvisible(false);
            return;
        }
        this.setInvisible(this.hasEffect(MobEffects.INVISIBILITY));
        this.updateSynchronizedMobEffectParticles();
    }

    private void updateSynchronizedMobEffectParticles() {
        List<ParticleOptions> $$0 = this.activeEffects.values().stream().filter(MobEffectInstance::isVisible).map(MobEffectInstance::getParticleOptions).toList();
        this.entityData.set(DATA_EFFECT_PARTICLES, $$0);
        this.entityData.set(DATA_EFFECT_AMBIENCE_ID, LivingEntity.areAllEffectsAmbient(this.activeEffects.values()));
    }

    private void updateGlowingStatus() {
        boolean $$0 = this.isCurrentlyGlowing();
        if (this.getSharedFlag(6) != $$0) {
            this.setSharedFlag(6, $$0);
        }
    }

    public double getVisibilityPercent(@Nullable Entity p_20969_) {
        double $$1 = 1.0;
        if (this.isDiscrete()) {
            $$1 *= 0.8;
        }
        if (this.isInvisible()) {
            float $$2 = this.getArmorCoverPercentage();
            if ($$2 < 0.1f) {
                $$2 = 0.1f;
            }
            $$1 *= 0.7 * (double)$$2;
        }
        if (p_20969_ != null) {
            ItemStack $$3 = this.getItemBySlot(EquipmentSlot.HEAD);
            EntityType<?> $$4 = p_20969_.getType();
            if ($$4 == EntityType.SKELETON && $$3.is(Items.SKELETON_SKULL) || $$4 == EntityType.ZOMBIE && $$3.is(Items.ZOMBIE_HEAD) || $$4 == EntityType.PIGLIN && $$3.is(Items.PIGLIN_HEAD) || $$4 == EntityType.PIGLIN_BRUTE && $$3.is(Items.PIGLIN_HEAD) || $$4 == EntityType.CREEPER && $$3.is(Items.CREEPER_HEAD)) {
                $$1 *= 0.5;
            }
        }
        return $$1;
    }

    public boolean canAttack(LivingEntity p_21171_) {
        if (p_21171_ instanceof Player && this.level().getDifficulty() == Difficulty.PEACEFUL) {
            return false;
        }
        return p_21171_.canBeSeenAsEnemy();
    }

    public boolean canBeSeenAsEnemy() {
        return !this.isInvulnerable() && this.canBeSeenByAnyone();
    }

    public boolean canBeSeenByAnyone() {
        return !this.isSpectator() && this.isAlive();
    }

    public static boolean areAllEffectsAmbient(Collection<MobEffectInstance> p_21180_) {
        for (MobEffectInstance $$1 : p_21180_) {
            if (!$$1.isVisible() || $$1.isAmbient()) continue;
            return false;
        }
        return true;
    }

    protected void removeEffectParticles() {
        this.entityData.set(DATA_EFFECT_PARTICLES, List.of());
    }

    public boolean removeAllEffects() {
        if (this.level().isClientSide) {
            return false;
        }
        if (this.activeEffects.isEmpty()) {
            return false;
        }
        HashMap $$0 = Maps.newHashMap(this.activeEffects);
        this.activeEffects.clear();
        this.onEffectsRemoved($$0.values());
        return true;
    }

    public Collection<MobEffectInstance> getActiveEffects() {
        return this.activeEffects.values();
    }

    public Map<Holder<MobEffect>, MobEffectInstance> getActiveEffectsMap() {
        return this.activeEffects;
    }

    public boolean hasEffect(Holder<MobEffect> p_316430_) {
        return this.activeEffects.containsKey(p_316430_);
    }

    @Nullable
    public MobEffectInstance getEffect(Holder<MobEffect> p_316375_) {
        return this.activeEffects.get(p_316375_);
    }

    public float getEffectBlendFactor(Holder<MobEffect> p_393806_, float p_393773_) {
        MobEffectInstance $$2 = this.getEffect(p_393806_);
        if ($$2 != null) {
            return $$2.getBlendFactor(this, p_393773_);
        }
        return 0.0f;
    }

    public final boolean addEffect(MobEffectInstance p_21165_) {
        return this.addEffect(p_21165_, null);
    }

    public boolean addEffect(MobEffectInstance p_147208_, @Nullable Entity p_147209_) {
        if (!this.canBeAffected(p_147208_)) {
            return false;
        }
        MobEffectInstance $$2 = this.activeEffects.get(p_147208_.getEffect());
        boolean $$3 = false;
        if ($$2 == null) {
            this.activeEffects.put(p_147208_.getEffect(), p_147208_);
            this.onEffectAdded(p_147208_, p_147209_);
            $$3 = true;
            p_147208_.onEffectAdded(this);
        } else if ($$2.update(p_147208_)) {
            this.onEffectUpdated($$2, true, p_147209_);
            $$3 = true;
        }
        p_147208_.onEffectStarted(this);
        return $$3;
    }

    public boolean canBeAffected(MobEffectInstance p_21197_) {
        if (this.getType().is(EntityTypeTags.IMMUNE_TO_INFESTED)) {
            return !p_21197_.is(MobEffects.INFESTED);
        }
        if (this.getType().is(EntityTypeTags.IMMUNE_TO_OOZING)) {
            return !p_21197_.is(MobEffects.OOZING);
        }
        if (this.getType().is(EntityTypeTags.IGNORES_POISON_AND_REGEN)) {
            return !p_21197_.is(MobEffects.REGENERATION) && !p_21197_.is(MobEffects.POISON);
        }
        return true;
    }

    public void forceAddEffect(MobEffectInstance p_147216_, @Nullable Entity p_147217_) {
        if (!this.canBeAffected(p_147216_)) {
            return;
        }
        MobEffectInstance $$2 = this.activeEffects.put(p_147216_.getEffect(), p_147216_);
        if ($$2 == null) {
            this.onEffectAdded(p_147216_, p_147217_);
        } else {
            p_147216_.copyBlendState($$2);
            this.onEffectUpdated(p_147216_, true, p_147217_);
        }
    }

    public boolean isInvertedHealAndHarm() {
        return this.getType().is(EntityTypeTags.INVERTED_HEALING_AND_HARM);
    }

    @Nullable
    public final MobEffectInstance removeEffectNoUpdate(Holder<MobEffect> p_316233_) {
        return this.activeEffects.remove(p_316233_);
    }

    public boolean removeEffect(Holder<MobEffect> p_316570_) {
        MobEffectInstance $$1 = this.removeEffectNoUpdate(p_316570_);
        if ($$1 != null) {
            this.onEffectsRemoved(List.of($$1));
            return true;
        }
        return false;
    }

    protected void onEffectAdded(MobEffectInstance p_147190_, @Nullable Entity p_147191_) {
        if (!this.level().isClientSide) {
            this.effectsDirty = true;
            p_147190_.getEffect().value().addAttributeModifiers(this.getAttributes(), p_147190_.getAmplifier());
            this.sendEffectToPassengers(p_147190_);
        }
    }

    public void sendEffectToPassengers(MobEffectInstance p_289695_) {
        for (Entity $$1 : this.getPassengers()) {
            if (!($$1 instanceof ServerPlayer)) continue;
            ServerPlayer $$2 = (ServerPlayer)$$1;
            $$2.connection.send(new ClientboundUpdateMobEffectPacket(this.getId(), p_289695_, false));
        }
    }

    protected void onEffectUpdated(MobEffectInstance p_147192_, boolean p_147193_, @Nullable Entity p_147194_) {
        if (this.level().isClientSide) {
            return;
        }
        this.effectsDirty = true;
        if (p_147193_) {
            MobEffect $$3 = p_147192_.getEffect().value();
            $$3.removeAttributeModifiers(this.getAttributes());
            $$3.addAttributeModifiers(this.getAttributes(), p_147192_.getAmplifier());
            this.refreshDirtyAttributes();
        }
        this.sendEffectToPassengers(p_147192_);
    }

    protected void onEffectsRemoved(Collection<MobEffectInstance> p_366501_) {
        if (this.level().isClientSide) {
            return;
        }
        this.effectsDirty = true;
        for (MobEffectInstance $$1 : p_366501_) {
            $$1.getEffect().value().removeAttributeModifiers(this.getAttributes());
            for (Entity $$2 : this.getPassengers()) {
                if (!($$2 instanceof ServerPlayer)) continue;
                ServerPlayer $$3 = (ServerPlayer)$$2;
                $$3.connection.send(new ClientboundRemoveMobEffectPacket(this.getId(), $$1.getEffect()));
            }
        }
        this.refreshDirtyAttributes();
    }

    private void refreshDirtyAttributes() {
        Set<AttributeInstance> $$0 = this.getAttributes().getAttributesToUpdate();
        for (AttributeInstance $$1 : $$0) {
            this.onAttributeUpdated($$1.getAttribute());
        }
        $$0.clear();
    }

    protected void onAttributeUpdated(Holder<Attribute> p_316778_) {
        Level level;
        if (p_316778_.is(Attributes.MAX_HEALTH)) {
            float $$1 = this.getMaxHealth();
            if (this.getHealth() > $$1) {
                this.setHealth($$1);
            }
        } else if (p_316778_.is(Attributes.MAX_ABSORPTION)) {
            float $$2 = this.getMaxAbsorption();
            if (this.getAbsorptionAmount() > $$2) {
                this.setAbsorptionAmount($$2);
            }
        } else if (p_316778_.is(Attributes.SCALE)) {
            this.refreshDimensions();
        } else if (p_316778_.is(Attributes.WAYPOINT_TRANSMIT_RANGE) && (level = this.level()) instanceof ServerLevel) {
            ServerLevel $$3 = (ServerLevel)level;
            ServerWaypointManager $$4 = $$3.getWaypointManager();
            if (this.attributes.getValue(p_316778_) > 0.0) {
                $$4.trackWaypoint(this);
            } else {
                $$4.untrackWaypoint(this);
            }
        }
    }

    public void heal(float p_21116_) {
        float $$1 = this.getHealth();
        if ($$1 > 0.0f) {
            this.setHealth($$1 + p_21116_);
        }
    }

    public float getHealth() {
        return this.entityData.get(DATA_HEALTH_ID).floatValue();
    }

    public void setHealth(float p_21154_) {
        this.entityData.set(DATA_HEALTH_ID, Float.valueOf(Mth.clamp(p_21154_, 0.0f, this.getMaxHealth())));
    }

    public boolean isDeadOrDying() {
        return this.getHealth() <= 0.0f;
    }

    @Override
    public boolean hurtServer(ServerLevel p_376221_, DamageSource p_376460_, float p_376610_) {
        Entity entity;
        boolean $$12;
        boolean $$5;
        if (this.isInvulnerableTo(p_376221_, p_376460_)) {
            return false;
        }
        if (this.isDeadOrDying()) {
            return false;
        }
        if (p_376460_.is(DamageTypeTags.IS_FIRE) && this.hasEffect(MobEffects.FIRE_RESISTANCE)) {
            return false;
        }
        if (this.isSleeping()) {
            this.stopSleeping();
        }
        this.noActionTime = 0;
        if (p_376610_ < 0.0f) {
            p_376610_ = 0.0f;
        }
        float $$3 = p_376610_;
        float $$4 = this.applyItemBlocking(p_376221_, p_376460_, p_376610_);
        p_376610_ -= $$4;
        boolean bl = $$5 = $$4 > 0.0f;
        if (p_376460_.is(DamageTypeTags.IS_FREEZING) && this.getType().is(EntityTypeTags.FREEZE_HURTS_EXTRA_TYPES)) {
            p_376610_ *= 5.0f;
        }
        if (p_376460_.is(DamageTypeTags.DAMAGES_HELMET) && !this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            this.hurtHelmet(p_376460_, p_376610_);
            p_376610_ *= 0.75f;
        }
        if (Float.isNaN(p_376610_) || Float.isInfinite(p_376610_)) {
            p_376610_ = Float.MAX_VALUE;
        }
        boolean $$6 = true;
        if ((float)this.invulnerableTime > 10.0f && !p_376460_.is(DamageTypeTags.BYPASSES_COOLDOWN)) {
            if (p_376610_ <= this.lastHurt) {
                return false;
            }
            this.actuallyHurt(p_376221_, p_376460_, p_376610_ - this.lastHurt);
            this.lastHurt = p_376610_;
            $$6 = false;
        } else {
            this.lastHurt = p_376610_;
            this.invulnerableTime = 20;
            this.actuallyHurt(p_376221_, p_376460_, p_376610_);
            this.hurtTime = this.hurtDuration = 10;
        }
        this.resolveMobResponsibleForDamage(p_376460_);
        this.resolvePlayerResponsibleForDamage(p_376460_);
        if ($$6) {
            BlocksAttacks $$7 = this.getUseItem().get(DataComponents.BLOCKS_ATTACKS);
            if ($$5 && $$7 != null) {
                $$7.onBlocked(p_376221_, this);
            } else {
                p_376221_.broadcastDamageEvent(this, p_376460_);
            }
            if (!(p_376460_.is(DamageTypeTags.NO_IMPACT) || $$5 && !(p_376610_ > 0.0f))) {
                this.markHurt();
            }
            if (!p_376460_.is(DamageTypeTags.NO_KNOCKBACK)) {
                double $$8 = 0.0;
                double $$9 = 0.0;
                Entity entity2 = p_376460_.getDirectEntity();
                if (entity2 instanceof Projectile) {
                    Projectile $$10 = (Projectile)entity2;
                    DoubleDoubleImmutablePair $$11 = $$10.calculateHorizontalHurtKnockbackDirection(this, p_376460_);
                    $$8 = -$$11.leftDouble();
                    $$9 = -$$11.rightDouble();
                } else if (p_376460_.getSourcePosition() != null) {
                    $$8 = p_376460_.getSourcePosition().x() - this.getX();
                    $$9 = p_376460_.getSourcePosition().z() - this.getZ();
                }
                this.knockback(0.4f, $$8, $$9);
                if (!$$5) {
                    this.indicateDamage($$8, $$9);
                }
            }
        }
        if (this.isDeadOrDying()) {
            if (!this.checkTotemDeathProtection(p_376460_)) {
                if ($$6) {
                    this.makeSound(this.getDeathSound());
                    this.playSecondaryHurtSound(p_376460_);
                }
                this.die(p_376460_);
            }
        } else if ($$6) {
            this.playHurtSound(p_376460_);
            this.playSecondaryHurtSound(p_376460_);
        }
        boolean bl2 = $$12 = !$$5 || p_376610_ > 0.0f;
        if ($$12) {
            this.lastDamageSource = p_376460_;
            this.lastDamageStamp = this.level().getGameTime();
            for (MobEffectInstance $$13 : this.getActiveEffects()) {
                $$13.onMobHurt(p_376221_, this, p_376460_, p_376610_);
            }
        }
        if ((entity = this) instanceof ServerPlayer) {
            ServerPlayer $$14 = (ServerPlayer)entity;
            CriteriaTriggers.ENTITY_HURT_PLAYER.trigger($$14, p_376460_, $$3, p_376610_, $$5);
            if ($$4 > 0.0f && $$4 < 3.4028235E37f) {
                $$14.awardStat(Stats.DAMAGE_BLOCKED_BY_SHIELD, Math.round($$4 * 10.0f));
            }
        }
        if ((entity = p_376460_.getEntity()) instanceof ServerPlayer) {
            ServerPlayer $$15 = (ServerPlayer)entity;
            CriteriaTriggers.PLAYER_HURT_ENTITY.trigger($$15, this, p_376460_, $$3, p_376610_, $$5);
        }
        return $$12;
    }

    public float applyItemBlocking(ServerLevel p_401171_, DamageSource p_401067_, float p_401377_) {
        Entity $$12;
        double $$10;
        AbstractArrow $$5;
        BlocksAttacks $$4;
        ItemStack $$3;
        block10: {
            block9: {
                if (p_401377_ <= 0.0f) {
                    return 0.0f;
                }
                $$3 = this.getItemBlockingWith();
                if ($$3 == null) {
                    return 0.0f;
                }
                $$4 = $$3.get(DataComponents.BLOCKS_ATTACKS);
                if ($$4 == null) break block9;
                if (!$$4.bypassedBy().map(p_401067_::is).orElse(false).booleanValue()) break block10;
            }
            return 0.0f;
        }
        Entity entity = p_401067_.getDirectEntity();
        if (entity instanceof AbstractArrow && ($$5 = (AbstractArrow)entity).getPierceLevel() > 0) {
            return 0.0f;
        }
        Vec3 $$6 = p_401067_.getSourcePosition();
        if ($$6 != null) {
            Vec3 $$7 = this.calculateViewVector(0.0f, this.getYHeadRot());
            Vec3 $$8 = $$6.subtract(this.position());
            $$8 = new Vec3($$8.x, 0.0, $$8.z).normalize();
            double $$9 = Math.acos($$8.dot($$7));
        } else {
            $$10 = 3.1415927410125732;
        }
        float $$11 = $$4.resolveBlockedDamage(p_401067_, p_401377_, $$10);
        $$4.hurtBlockingItem(this.level(), $$3, this, this.getUsedItemHand(), $$11);
        if (!p_401067_.is(DamageTypeTags.IS_PROJECTILE) && ($$12 = p_401067_.getDirectEntity()) instanceof LivingEntity) {
            LivingEntity $$13 = (LivingEntity)$$12;
            this.blockUsingItem(p_401171_, $$13);
        }
        return $$11;
    }

    private void playSecondaryHurtSound(DamageSource p_394182_) {
        if (p_394182_.is(DamageTypes.THORNS)) {
            SoundSource $$1 = this instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
            this.level().playSound(null, this.position().x, this.position().y, this.position().z, SoundEvents.THORNS_HIT, $$1);
        }
    }

    protected void resolveMobResponsibleForDamage(DamageSource p_387140_) {
        Entity entity = p_387140_.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity $$1 = (LivingEntity)entity;
            if (!(p_387140_.is(DamageTypeTags.NO_ANGER) || p_387140_.is(DamageTypes.WIND_CHARGE) && this.getType().is(EntityTypeTags.NO_ANGER_FROM_WIND_CHARGE))) {
                this.setLastHurtByMob($$1);
            }
        }
    }

    @Nullable
    protected Player resolvePlayerResponsibleForDamage(DamageSource p_388609_) {
        Wolf $$3;
        Entity $$1 = p_388609_.getEntity();
        if ($$1 instanceof Player) {
            Player $$2 = (Player)$$1;
            this.setLastHurtByPlayer($$2, 100);
        } else if ($$1 instanceof Wolf && ($$3 = (Wolf)$$1).isTame()) {
            if ($$3.getOwnerReference() != null) {
                this.setLastHurtByPlayer($$3.getOwnerReference().getUUID(), 100);
            } else {
                this.lastHurtByPlayer = null;
                this.lastHurtByPlayerMemoryTime = 0;
            }
        }
        return EntityReference.get(this.lastHurtByPlayer, this.level(), Player.class);
    }

    protected void blockUsingItem(ServerLevel p_399926_, LivingEntity p_399873_) {
        p_399873_.blockedByItem(this);
    }

    protected void blockedByItem(LivingEntity p_21246_) {
        p_21246_.knockback(0.5, p_21246_.getX() - this.getX(), p_21246_.getZ() - this.getZ());
    }

    private boolean checkTotemDeathProtection(DamageSource p_21263_) {
        if (p_21263_.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        ItemStack $$1 = null;
        DeathProtection $$2 = null;
        for (InteractionHand $$3 : InteractionHand.values()) {
            ItemStack $$4 = this.getItemInHand($$3);
            $$2 = $$4.get(DataComponents.DEATH_PROTECTION);
            if ($$2 == null) continue;
            $$1 = $$4.copy();
            $$4.shrink(1);
            break;
        }
        if ($$1 != null) {
            LivingEntity livingEntity = this;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer $$5 = (ServerPlayer)livingEntity;
                $$5.awardStat(Stats.ITEM_USED.get($$1.getItem()));
                CriteriaTriggers.USED_TOTEM.trigger($$5, $$1);
                this.gameEvent(GameEvent.ITEM_INTERACT_FINISH);
            }
            this.setHealth(1.0f);
            $$2.applyEffects($$1, this);
            this.level().broadcastEntityEvent(this, (byte)35);
        }
        return $$2 != null;
    }

    @Nullable
    public DamageSource getLastDamageSource() {
        if (this.level().getGameTime() - this.lastDamageStamp > 40L) {
            this.lastDamageSource = null;
        }
        return this.lastDamageSource;
    }

    protected void playHurtSound(DamageSource p_21160_) {
        this.makeSound(this.getHurtSound(p_21160_));
    }

    public void makeSound(@Nullable SoundEvent p_320810_) {
        if (p_320810_ != null) {
            this.playSound(p_320810_, this.getSoundVolume(), this.getVoicePitch());
        }
    }

    private void breakItem(ItemStack p_21279_) {
        if (!p_21279_.isEmpty()) {
            Holder<SoundEvent> $$1 = p_21279_.get(DataComponents.BREAK_SOUND);
            if ($$1 != null && !this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), $$1.value(), this.getSoundSource(), 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f, false);
            }
            this.spawnItemParticles(p_21279_, 5);
        }
    }

    public void die(DamageSource p_21014_) {
        if (this.isRemoved() || this.dead) {
            return;
        }
        Entity $$1 = p_21014_.getEntity();
        LivingEntity $$2 = this.getKillCredit();
        if ($$2 != null) {
            $$2.awardKillScore(this, p_21014_);
        }
        if (this.isSleeping()) {
            this.stopSleeping();
        }
        if (!this.level().isClientSide && this.hasCustomName()) {
            LOGGER.info("Named entity {} died: {}", (Object)this, (Object)this.getCombatTracker().getDeathMessage().getString());
        }
        this.dead = true;
        this.getCombatTracker().recheckStatus();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel $$3 = (ServerLevel)level;
            if ($$1 == null || $$1.killedEntity($$3, this)) {
                this.gameEvent(GameEvent.ENTITY_DIE);
                this.dropAllDeathLoot($$3, p_21014_);
                this.createWitherRose($$2);
            }
            this.level().broadcastEntityEvent(this, (byte)3);
        }
        this.setPose(Pose.DYING);
    }

    /*
     * WARNING - void declaration
     */
    protected void createWitherRose(@Nullable LivingEntity p_21269_) {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel $$1 = (ServerLevel)level;
        boolean $$3 = false;
        if (p_21269_ instanceof WitherBoss) {
            void $$2;
            if ($$2.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                BlockPos $$4 = this.blockPosition();
                BlockState $$5 = Blocks.WITHER_ROSE.defaultBlockState();
                if (this.level().getBlockState($$4).isAir() && $$5.canSurvive(this.level(), $$4)) {
                    this.level().setBlock($$4, $$5, 3);
                    $$3 = true;
                }
            }
            if (!$$3) {
                ItemEntity $$6 = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack(Items.WITHER_ROSE));
                this.level().addFreshEntity($$6);
            }
        }
    }

    protected void dropAllDeathLoot(ServerLevel p_348524_, DamageSource p_21192_) {
        boolean $$2;
        boolean bl = $$2 = this.lastHurtByPlayerMemoryTime > 0;
        if (this.shouldDropLoot() && p_348524_.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            this.dropFromLootTable(p_348524_, p_21192_, $$2);
            this.dropCustomDeathLoot(p_348524_, p_21192_, $$2);
        }
        this.dropEquipment(p_348524_);
        this.dropExperience(p_348524_, p_21192_.getEntity());
    }

    protected void dropEquipment(ServerLevel p_376330_) {
    }

    protected void dropExperience(ServerLevel p_376909_, @Nullable Entity p_345346_) {
        if (!this.wasExperienceConsumed() && (this.isAlwaysExperienceDropper() || this.lastHurtByPlayerMemoryTime > 0 && this.shouldDropExperience() && p_376909_.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT))) {
            ExperienceOrb.award(p_376909_, this.position(), this.getExperienceReward(p_376909_, p_345346_));
        }
    }

    protected void dropCustomDeathLoot(ServerLevel p_348639_, DamageSource p_21018_, boolean p_21020_) {
    }

    public long getLootTableSeed() {
        return 0L;
    }

    protected float getKnockback(Entity p_344813_, DamageSource p_344976_) {
        float $$2 = (float)this.getAttributeValue(Attributes.ATTACK_KNOCKBACK);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel $$3 = (ServerLevel)level;
            return EnchantmentHelper.modifyKnockback($$3, this.getWeaponItem(), p_344813_, p_344976_, $$2);
        }
        return $$2;
    }

    protected void dropFromLootTable(ServerLevel p_376223_, DamageSource p_21021_, boolean p_21022_) {
        Optional<ResourceKey<LootTable>> $$3 = this.getLootTable();
        if ($$3.isEmpty()) {
            return;
        }
        LootTable $$4 = p_376223_.getServer().reloadableRegistries().getLootTable($$3.get());
        LootParams.Builder $$5 = new LootParams.Builder(p_376223_).withParameter(LootContextParams.THIS_ENTITY, this).withParameter(LootContextParams.ORIGIN, this.position()).withParameter(LootContextParams.DAMAGE_SOURCE, p_21021_).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, p_21021_.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, p_21021_.getDirectEntity());
        Player $$6 = this.getLastHurtByPlayer();
        if (p_21022_ && $$6 != null) {
            $$5 = $$5.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, $$6).withLuck($$6.getLuck());
        }
        LootParams $$7 = $$5.create(LootContextParamSets.ENTITY);
        $$4.getRandomItems($$7, this.getLootTableSeed(), p_375574_ -> this.spawnAtLocation(p_376223_, (ItemStack)p_375574_));
    }

    public boolean dropFromGiftLootTable(ServerLevel p_376609_, ResourceKey<LootTable> p_373086_, BiConsumer<ServerLevel, ItemStack> p_376939_) {
        return this.dropFromLootTable(p_376609_, p_373086_, p_426981_ -> p_426981_.withParameter(LootContextParams.ORIGIN, this.position()).withParameter(LootContextParams.THIS_ENTITY, this).create(LootContextParamSets.GIFT), p_376939_);
    }

    protected void dropFromShearingLootTable(ServerLevel p_376282_, ResourceKey<LootTable> p_360865_, ItemStack p_373036_, BiConsumer<ServerLevel, ItemStack> p_376518_) {
        this.dropFromLootTable(p_376282_, p_360865_, p_426980_ -> p_426980_.withParameter(LootContextParams.ORIGIN, this.position()).withParameter(LootContextParams.THIS_ENTITY, this).withParameter(LootContextParams.TOOL, p_373036_).create(LootContextParamSets.SHEARING), p_376518_);
    }

    protected boolean dropFromLootTable(ServerLevel p_376815_, ResourceKey<LootTable> p_372918_, Function<LootParams.Builder, LootParams> p_372865_, BiConsumer<ServerLevel, ItemStack> p_376817_) {
        LootParams $$5;
        LootTable $$4 = p_376815_.getServer().reloadableRegistries().getLootTable(p_372918_);
        ObjectArrayList<ItemStack> $$6 = $$4.getRandomItems($$5 = p_372865_.apply(new LootParams.Builder(p_376815_)));
        if (!$$6.isEmpty()) {
            $$6.forEach(p_375572_ -> p_376817_.accept(p_376815_, (ItemStack)p_375572_));
            return true;
        }
        return false;
    }

    public void knockback(double p_147241_, double p_147242_, double p_147243_) {
        if ((p_147241_ *= 1.0 - this.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE)) <= 0.0) {
            return;
        }
        this.hasImpulse = true;
        Vec3 $$3 = this.getDeltaMovement();
        while (p_147242_ * p_147242_ + p_147243_ * p_147243_ < (double)1.0E-5f) {
            p_147242_ = (Math.random() - Math.random()) * 0.01;
            p_147243_ = (Math.random() - Math.random()) * 0.01;
        }
        Vec3 $$4 = new Vec3(p_147242_, 0.0, p_147243_).normalize().scale(p_147241_);
        this.setDeltaMovement($$3.x / 2.0 - $$4.x, this.onGround() ? Math.min(0.4, $$3.y / 2.0 + p_147241_) : $$3.y, $$3.z / 2.0 - $$4.z);
    }

    public void indicateDamage(double p_270514_, double p_270826_) {
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource p_21239_) {
        return SoundEvents.GENERIC_HURT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.GENERIC_DEATH;
    }

    private SoundEvent getFallDamageSound(int p_21313_) {
        return p_21313_ > 4 ? this.getFallSounds().big() : this.getFallSounds().small();
    }

    public void skipDropExperience() {
        this.skipDropExperience = true;
    }

    public boolean wasExperienceConsumed() {
        return this.skipDropExperience;
    }

    public float getHurtDir() {
        return 0.0f;
    }

    protected AABB getHitbox() {
        AABB $$0 = this.getBoundingBox();
        Entity $$1 = this.getVehicle();
        if ($$1 != null) {
            Vec3 $$2 = $$1.getPassengerRidingPosition(this);
            return $$0.setMinY(Math.max($$2.y, $$0.minY));
        }
        return $$0;
    }

    public Map<Enchantment, Set<EnchantmentLocationBasedEffect>> activeLocationDependentEnchantments(EquipmentSlot p_364521_) {
        return (Map)this.activeLocationDependentEnchantments.computeIfAbsent(p_364521_, p_359700_ -> new Reference2ObjectArrayMap());
    }

    public Fallsounds getFallSounds() {
        return new Fallsounds(SoundEvents.GENERIC_SMALL_FALL, SoundEvents.GENERIC_BIG_FALL);
    }

    public Optional<BlockPos> getLastClimbablePos() {
        return this.lastClimbablePos;
    }

    public boolean onClimbable() {
        if (this.isSpectator()) {
            return false;
        }
        BlockPos $$0 = this.blockPosition();
        BlockState $$1 = this.getInBlockState();
        if ($$1.is(BlockTags.CLIMBABLE)) {
            this.lastClimbablePos = Optional.of($$0);
            return true;
        }
        if ($$1.getBlock() instanceof TrapDoorBlock && this.trapdoorUsableAsLadder($$0, $$1)) {
            this.lastClimbablePos = Optional.of($$0);
            return true;
        }
        return false;
    }

    private boolean trapdoorUsableAsLadder(BlockPos p_21177_, BlockState p_21178_) {
        if (p_21178_.getValue(TrapDoorBlock.OPEN).booleanValue()) {
            BlockState $$2 = this.level().getBlockState(p_21177_.below());
            return $$2.is(Blocks.LADDER) && $$2.getValue(LadderBlock.FACING) == p_21178_.getValue(TrapDoorBlock.FACING);
        }
        return false;
    }

    @Override
    public boolean isAlive() {
        return !this.isRemoved() && this.getHealth() > 0.0f;
    }

    public boolean isLookingAtMe(LivingEntity p_379420_, double p_379671_, boolean p_380253_, boolean p_380067_, double ... p_383243_) {
        Vec3 $$5 = p_379420_.getViewVector(1.0f).normalize();
        for (double $$6 : p_383243_) {
            Vec3 $$7 = new Vec3(this.getX() - p_379420_.getX(), $$6 - p_379420_.getEyeY(), this.getZ() - p_379420_.getZ());
            double $$8 = $$7.length();
            $$7 = $$7.normalize();
            double $$9 = $$5.dot($$7);
            double d = p_380253_ ? $$8 : 1.0;
            if (!($$9 > 1.0 - p_379671_ / d) || !p_379420_.hasLineOfSight(this, p_380067_ ? ClipContext.Block.VISUAL : ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, $$6)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMaxFallDistance() {
        return this.getComfortableFallDistance(0.0f);
    }

    protected final int getComfortableFallDistance(float p_326294_) {
        return Mth.floor(p_326294_ + 3.0f);
    }

    @Override
    public boolean causeFallDamage(double p_397597_, float p_147187_, DamageSource p_147189_) {
        boolean $$3 = super.causeFallDamage(p_397597_, p_147187_, p_147189_);
        int $$4 = this.calculateFallDamage(p_397597_, p_147187_);
        if ($$4 > 0) {
            this.playSound(this.getFallDamageSound($$4), 1.0f, 1.0f);
            this.playBlockFallSound();
            this.hurt(p_147189_, $$4);
            return true;
        }
        return $$3;
    }

    protected int calculateFallDamage(double p_397300_, float p_21237_) {
        if (this.getType().is(EntityTypeTags.FALL_DAMAGE_IMMUNE)) {
            return 0;
        }
        double $$2 = this.calculateFallPower(p_397300_);
        return Mth.floor($$2 * (double)p_21237_ * this.getAttributeValue(Attributes.FALL_DAMAGE_MULTIPLIER));
    }

    private double calculateFallPower(double p_397663_) {
        return p_397663_ + 1.0E-6 - this.getAttributeValue(Attributes.SAFE_FALL_DISTANCE);
    }

    protected void playBlockFallSound() {
        if (this.isSilent()) {
            return;
        }
        int $$0 = Mth.floor(this.getX());
        int $$1 = Mth.floor(this.getY() - (double)0.2f);
        int $$2 = Mth.floor(this.getZ());
        BlockState $$3 = this.level().getBlockState(new BlockPos($$0, $$1, $$2));
        if (!$$3.isAir()) {
            SoundType $$4 = $$3.getSoundType();
            this.playSound($$4.getFallSound(), $$4.getVolume() * 0.5f, $$4.getPitch() * 0.75f);
        }
    }

    @Override
    public void animateHurt(float p_265265_) {
        this.hurtTime = this.hurtDuration = 10;
    }

    public int getArmorValue() {
        return Mth.floor(this.getAttributeValue(Attributes.ARMOR));
    }

    protected void hurtArmor(DamageSource p_21122_, float p_21123_) {
    }

    protected void hurtHelmet(DamageSource p_147213_, float p_147214_) {
    }

    protected void doHurtEquipment(DamageSource p_330843_, float p_330394_, EquipmentSlot ... p_331314_) {
        if (p_330394_ <= 0.0f) {
            return;
        }
        int $$3 = (int)Math.max(1.0f, p_330394_ / 4.0f);
        for (EquipmentSlot $$4 : p_331314_) {
            ItemStack $$5 = this.getItemBySlot($$4);
            Equippable $$6 = $$5.get(DataComponents.EQUIPPABLE);
            if ($$6 == null || !$$6.damageOnHurt() || !$$5.isDamageableItem() || !$$5.canBeHurtBy(p_330843_)) continue;
            $$5.hurtAndBreak($$3, this, $$4);
        }
    }

    protected float getDamageAfterArmorAbsorb(DamageSource p_21162_, float p_21163_) {
        if (!p_21162_.is(DamageTypeTags.BYPASSES_ARMOR)) {
            this.hurtArmor(p_21162_, p_21163_);
            p_21163_ = CombatRules.getDamageAfterAbsorb(this, p_21163_, p_21162_, this.getArmorValue(), (float)this.getAttributeValue(Attributes.ARMOR_TOUGHNESS));
        }
        return p_21163_;
    }

    protected float getDamageAfterMagicAbsorb(DamageSource p_21193_, float p_21194_) {
        float $$9;
        int $$2;
        int $$3;
        float $$4;
        float $$5;
        float $$6;
        if (p_21193_.is(DamageTypeTags.BYPASSES_EFFECTS)) {
            return p_21194_;
        }
        if (this.hasEffect(MobEffects.RESISTANCE) && !p_21193_.is(DamageTypeTags.BYPASSES_RESISTANCE) && ($$6 = ($$5 = p_21194_) - (p_21194_ = Math.max(($$4 = p_21194_ * (float)($$3 = 25 - ($$2 = (this.getEffect(MobEffects.RESISTANCE).getAmplifier() + 1) * 5))) / 25.0f, 0.0f))) > 0.0f && $$6 < 3.4028235E37f) {
            if (this instanceof ServerPlayer) {
                ((ServerPlayer)this).awardStat(Stats.DAMAGE_RESISTED, Math.round($$6 * 10.0f));
            } else if (p_21193_.getEntity() instanceof ServerPlayer) {
                ((ServerPlayer)p_21193_.getEntity()).awardStat(Stats.DAMAGE_DEALT_RESISTED, Math.round($$6 * 10.0f));
            }
        }
        if (p_21194_ <= 0.0f) {
            return 0.0f;
        }
        if (p_21193_.is(DamageTypeTags.BYPASSES_ENCHANTMENTS)) {
            return p_21194_;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel $$7 = (ServerLevel)level;
            float $$8 = EnchantmentHelper.getDamageProtection($$7, this, p_21193_);
        } else {
            $$9 = 0.0f;
        }
        if ($$9 > 0.0f) {
            p_21194_ = CombatRules.getDamageAfterMagicAbsorb(p_21194_, $$9);
        }
        return p_21194_;
    }

    protected void actuallyHurt(ServerLevel p_376745_, DamageSource p_21240_, float p_21241_) {
        Entity entity;
        if (this.isInvulnerableTo(p_376745_, p_21240_)) {
            return;
        }
        p_21241_ = this.getDamageAfterArmorAbsorb(p_21240_, p_21241_);
        float $$3 = p_21241_ = this.getDamageAfterMagicAbsorb(p_21240_, p_21241_);
        p_21241_ = Math.max(p_21241_ - this.getAbsorptionAmount(), 0.0f);
        this.setAbsorptionAmount(this.getAbsorptionAmount() - ($$3 - p_21241_));
        float $$4 = $$3 - p_21241_;
        if ($$4 > 0.0f && $$4 < 3.4028235E37f && (entity = p_21240_.getEntity()) instanceof ServerPlayer) {
            ServerPlayer $$5 = (ServerPlayer)entity;
            $$5.awardStat(Stats.DAMAGE_DEALT_ABSORBED, Math.round($$4 * 10.0f));
        }
        if (p_21241_ == 0.0f) {
            return;
        }
        this.getCombatTracker().recordDamage(p_21240_, p_21241_);
        this.setHealth(this.getHealth() - p_21241_);
        this.setAbsorptionAmount(this.getAbsorptionAmount() - p_21241_);
        this.gameEvent(GameEvent.ENTITY_DAMAGE);
    }

    public CombatTracker getCombatTracker() {
        return this.combatTracker;
    }

    @Nullable
    public LivingEntity getKillCredit() {
        if (this.lastHurtByPlayer != null) {
            return this.lastHurtByPlayer.getEntity(this.level(), Player.class);
        }
        if (this.lastHurtByMob != null) {
            return this.lastHurtByMob.getEntity(this.level(), LivingEntity.class);
        }
        return null;
    }

    public final float getMaxHealth() {
        return (float)this.getAttributeValue(Attributes.MAX_HEALTH);
    }

    public final float getMaxAbsorption() {
        return (float)this.getAttributeValue(Attributes.MAX_ABSORPTION);
    }

    public final int getArrowCount() {
        return this.entityData.get(DATA_ARROW_COUNT_ID);
    }

    public final void setArrowCount(int p_21318_) {
        this.entityData.set(DATA_ARROW_COUNT_ID, p_21318_);
    }

    public final int getStingerCount() {
        return this.entityData.get(DATA_STINGER_COUNT_ID);
    }

    public final void setStingerCount(int p_21322_) {
        this.entityData.set(DATA_STINGER_COUNT_ID, p_21322_);
    }

    private int getCurrentSwingDuration() {
        if (MobEffectUtil.hasDigSpeed(this)) {
            return 6 - (1 + MobEffectUtil.getDigSpeedAmplification(this));
        }
        if (this.hasEffect(MobEffects.MINING_FATIGUE)) {
            return 6 + (1 + this.getEffect(MobEffects.MINING_FATIGUE).getAmplifier()) * 2;
        }
        return 6;
    }

    public void swing(InteractionHand p_21007_) {
        this.swing(p_21007_, false);
    }

    public void swing(InteractionHand p_21012_, boolean p_21013_) {
        if (!this.swinging || this.swingTime >= this.getCurrentSwingDuration() / 2 || this.swingTime < 0) {
            this.swingTime = -1;
            this.swinging = true;
            this.swingingArm = p_21012_;
            if (this.level() instanceof ServerLevel) {
                ClientboundAnimatePacket $$2 = new ClientboundAnimatePacket(this, p_21012_ == InteractionHand.MAIN_HAND ? 0 : 3);
                ServerChunkCache $$3 = ((ServerLevel)this.level()).getChunkSource();
                if (p_21013_) {
                    $$3.broadcastAndSend(this, $$2);
                } else {
                    $$3.broadcast(this, $$2);
                }
            }
        }
    }

    @Override
    public void handleDamageEvent(DamageSource p_270229_) {
        this.walkAnimation.setSpeed(1.5f);
        this.invulnerableTime = 20;
        this.hurtTime = this.hurtDuration = 10;
        SoundEvent $$1 = this.getHurtSound(p_270229_);
        if ($$1 != null) {
            this.playSound($$1, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
        this.lastDamageSource = p_270229_;
        this.lastDamageStamp = this.level().getGameTime();
    }

    @Override
    public void handleEntityEvent(byte p_20975_) {
        switch (p_20975_) {
            case 3: {
                SoundEvent $$1 = this.getDeathSound();
                if ($$1 != null) {
                    this.playSound($$1, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                }
                if (this instanceof Player) break;
                this.setHealth(0.0f);
                this.die(this.damageSources().generic());
                break;
            }
            case 46: {
                int $$2 = 128;
                for (int $$3 = 0; $$3 < 128; ++$$3) {
                    double $$4 = (double)$$3 / 127.0;
                    float $$5 = (this.random.nextFloat() - 0.5f) * 0.2f;
                    float $$6 = (this.random.nextFloat() - 0.5f) * 0.2f;
                    float $$7 = (this.random.nextFloat() - 0.5f) * 0.2f;
                    double $$8 = Mth.lerp($$4, this.xo, this.getX()) + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth() * 2.0;
                    double $$9 = Mth.lerp($$4, this.yo, this.getY()) + this.random.nextDouble() * (double)this.getBbHeight();
                    double $$10 = Mth.lerp($$4, this.zo, this.getZ()) + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth() * 2.0;
                    this.level().addParticle(ParticleTypes.PORTAL, $$8, $$9, $$10, $$5, $$6, $$7);
                }
                break;
            }
            case 47: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.MAINHAND));
                break;
            }
            case 48: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.OFFHAND));
                break;
            }
            case 49: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.HEAD));
                break;
            }
            case 50: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.CHEST));
                break;
            }
            case 51: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.LEGS));
                break;
            }
            case 52: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.FEET));
                break;
            }
            case 65: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.BODY));
                break;
            }
            case 68: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.SADDLE));
                break;
            }
            case 54: {
                HoneyBlock.showJumpParticles(this);
                break;
            }
            case 55: {
                this.swapHandItems();
                break;
            }
            case 60: {
                this.makePoofParticles();
                break;
            }
            case 67: {
                this.makeDrownParticles();
                break;
            }
            default: {
                super.handleEntityEvent(p_20975_);
            }
        }
    }

    public void makePoofParticles() {
        for (int $$0 = 0; $$0 < 20; ++$$0) {
            double $$1 = this.random.nextGaussian() * 0.02;
            double $$2 = this.random.nextGaussian() * 0.02;
            double $$3 = this.random.nextGaussian() * 0.02;
            double $$4 = 10.0;
            this.level().addParticle(ParticleTypes.POOF, this.getRandomX(1.0) - $$1 * 10.0, this.getRandomY() - $$2 * 10.0, this.getRandomZ(1.0) - $$3 * 10.0, $$1, $$2, $$3);
        }
    }

    private void makeDrownParticles() {
        Vec3 $$0 = this.getDeltaMovement();
        for (int $$1 = 0; $$1 < 8; ++$$1) {
            double $$2 = this.random.triangle(0.0, 1.0);
            double $$3 = this.random.triangle(0.0, 1.0);
            double $$4 = this.random.triangle(0.0, 1.0);
            this.level().addParticle(ParticleTypes.BUBBLE, this.getX() + $$2, this.getY() + $$3, this.getZ() + $$4, $$0.x, $$0.y, $$0.z);
        }
    }

    private void swapHandItems() {
        ItemStack $$0 = this.getItemBySlot(EquipmentSlot.OFFHAND);
        this.setItemSlot(EquipmentSlot.OFFHAND, this.getItemBySlot(EquipmentSlot.MAINHAND));
        this.setItemSlot(EquipmentSlot.MAINHAND, $$0);
    }

    @Override
    protected void onBelowWorld() {
        this.hurt(this.damageSources().fellOutOfWorld(), 4.0f);
    }

    protected void updateSwingTime() {
        int $$0 = this.getCurrentSwingDuration();
        if (this.swinging) {
            ++this.swingTime;
            if (this.swingTime >= $$0) {
                this.swingTime = 0;
                this.swinging = false;
            }
        } else {
            this.swingTime = 0;
        }
        this.attackAnim = (float)this.swingTime / (float)$$0;
    }

    @Nullable
    public AttributeInstance getAttribute(Holder<Attribute> p_316333_) {
        return this.getAttributes().getInstance(p_316333_);
    }

    public double getAttributeValue(Holder<Attribute> p_251296_) {
        return this.getAttributes().getValue(p_251296_);
    }

    public double getAttributeBaseValue(Holder<Attribute> p_248605_) {
        return this.getAttributes().getBaseValue(p_248605_);
    }

    public AttributeMap getAttributes() {
        return this.attributes;
    }

    public ItemStack getMainHandItem() {
        return this.getItemBySlot(EquipmentSlot.MAINHAND);
    }

    public ItemStack getOffhandItem() {
        return this.getItemBySlot(EquipmentSlot.OFFHAND);
    }

    public ItemStack getItemHeldByArm(HumanoidArm p_362643_) {
        return this.getMainArm() == p_362643_ ? this.getMainHandItem() : this.getOffhandItem();
    }

    @Override
    @Nonnull
    public ItemStack getWeaponItem() {
        return this.getMainHandItem();
    }

    public boolean isHolding(Item p_21056_) {
        return this.isHolding((ItemStack p_147200_) -> p_147200_.is(p_21056_));
    }

    public boolean isHolding(Predicate<ItemStack> p_21094_) {
        return p_21094_.test(this.getMainHandItem()) || p_21094_.test(this.getOffhandItem());
    }

    public ItemStack getItemInHand(InteractionHand p_21121_) {
        if (p_21121_ == InteractionHand.MAIN_HAND) {
            return this.getItemBySlot(EquipmentSlot.MAINHAND);
        }
        if (p_21121_ == InteractionHand.OFF_HAND) {
            return this.getItemBySlot(EquipmentSlot.OFFHAND);
        }
        throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)p_21121_));
    }

    public void setItemInHand(InteractionHand p_21009_, ItemStack p_21010_) {
        if (p_21009_ == InteractionHand.MAIN_HAND) {
            this.setItemSlot(EquipmentSlot.MAINHAND, p_21010_);
        } else if (p_21009_ == InteractionHand.OFF_HAND) {
            this.setItemSlot(EquipmentSlot.OFFHAND, p_21010_);
        } else {
            throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)p_21009_));
        }
    }

    public boolean hasItemInSlot(EquipmentSlot p_21034_) {
        return !this.getItemBySlot(p_21034_).isEmpty();
    }

    public boolean canUseSlot(EquipmentSlot p_326058_) {
        return true;
    }

    public ItemStack getItemBySlot(EquipmentSlot p_21127_) {
        return this.equipment.get(p_21127_);
    }

    public void setItemSlot(EquipmentSlot p_21036_, ItemStack p_21037_) {
        this.onEquipItem(p_21036_, this.equipment.set(p_21036_, p_21037_), p_21037_);
    }

    public float getArmorCoverPercentage() {
        int $$0 = 0;
        int $$1 = 0;
        for (EquipmentSlot $$2 : EquipmentSlotGroup.ARMOR) {
            if ($$2.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
            ItemStack $$3 = this.getItemBySlot($$2);
            if (!$$3.isEmpty()) {
                ++$$1;
            }
            ++$$0;
        }
        return $$0 > 0 ? (float)$$1 / (float)$$0 : 0.0f;
    }

    @Override
    public void setSprinting(boolean p_21284_) {
        super.setSprinting(p_21284_);
        AttributeInstance $$1 = this.getAttribute(Attributes.MOVEMENT_SPEED);
        $$1.removeModifier(SPEED_MODIFIER_SPRINTING.id());
        if (p_21284_) {
            $$1.addTransientModifier(SPEED_MODIFIER_SPRINTING);
        }
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    public float getVoicePitch() {
        if (this.isBaby()) {
            return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.5f;
        }
        return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f;
    }

    protected boolean isImmobile() {
        return this.isDeadOrDying();
    }

    @Override
    public void push(Entity p_21294_) {
        if (!this.isSleeping()) {
            super.push(p_21294_);
        }
    }

    private void dismountVehicle(Entity p_21029_) {
        Vec3 $$8;
        if (this.isRemoved()) {
            Vec3 $$1 = this.position();
        } else if (p_21029_.isRemoved() || this.level().getBlockState(p_21029_.blockPosition()).is(BlockTags.PORTALS)) {
            boolean $$4;
            double $$2 = Math.max(this.getY(), p_21029_.getY());
            Vec3 $$3 = new Vec3(this.getX(), $$2, this.getZ());
            boolean bl = $$4 = this.getBbWidth() <= 4.0f && this.getBbHeight() <= 4.0f;
            if ($$4) {
                double $$5 = (double)this.getBbHeight() / 2.0;
                Vec3 $$6 = $$3.add(0.0, $$5, 0.0);
                VoxelShape $$7 = Shapes.create(AABB.ofSize($$6, this.getBbWidth(), this.getBbHeight(), this.getBbWidth()));
                $$3 = this.level().findFreePosition(this, $$7, $$6, this.getBbWidth(), this.getBbHeight(), this.getBbWidth()).map(p_359705_ -> p_359705_.add(0.0, -$$5, 0.0)).orElse($$3);
            }
        } else {
            $$8 = p_21029_.getDismountLocationForPassenger(this);
        }
        this.dismountTo($$8.x, $$8.y, $$8.z);
    }

    @Override
    public boolean shouldShowName() {
        return this.isCustomNameVisible();
    }

    protected float getJumpPower() {
        return this.getJumpPower(1.0f);
    }

    protected float getJumpPower(float p_326107_) {
        return (float)this.getAttributeValue(Attributes.JUMP_STRENGTH) * p_326107_ * this.getBlockJumpFactor() + this.getJumpBoostPower();
    }

    public float getJumpBoostPower() {
        return this.hasEffect(MobEffects.JUMP_BOOST) ? 0.1f * ((float)this.getEffect(MobEffects.JUMP_BOOST).getAmplifier() + 1.0f) : 0.0f;
    }

    @VisibleForTesting
    public void jumpFromGround() {
        float $$0 = this.getJumpPower();
        if ($$0 <= 1.0E-5f) {
            return;
        }
        Vec3 $$1 = this.getDeltaMovement();
        this.setDeltaMovement($$1.x, Math.max((double)$$0, $$1.y), $$1.z);
        if (this.isSprinting()) {
            float $$2 = this.getYRot() * ((float)Math.PI / 180);
            this.addDeltaMovement(new Vec3((double)(-Mth.sin($$2)) * 0.2, 0.0, (double)Mth.cos($$2) * 0.2));
        }
        this.hasImpulse = true;
    }

    protected void goDownInWater() {
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04f, 0.0));
    }

    protected void jumpInLiquid(TagKey<Fluid> p_204043_) {
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.04f, 0.0));
    }

    protected float getWaterSlowDown() {
        return 0.8f;
    }

    public boolean canStandOnFluid(FluidState p_204042_) {
        return false;
    }

    @Override
    protected double getDefaultGravity() {
        return this.getAttributeValue(Attributes.GRAVITY);
    }

    protected double getEffectiveGravity() {
        boolean $$0;
        boolean bl = $$0 = this.getDeltaMovement().y <= 0.0;
        if ($$0 && this.hasEffect(MobEffects.SLOW_FALLING)) {
            return Math.min(this.getGravity(), 0.01);
        }
        return this.getGravity();
    }

    public void travel(Vec3 p_21280_) {
        FluidState $$1 = this.level().getFluidState(this.blockPosition());
        if ((this.isInWater() || this.isInLava()) && this.isAffectedByFluids() && !this.canStandOnFluid($$1)) {
            this.travelInFluid(p_21280_);
        } else if (this.isFallFlying()) {
            this.travelFallFlying(p_21280_);
        } else {
            this.travelInAir(p_21280_);
        }
    }

    protected void travelFlying(Vec3 p_416255_, float p_416177_) {
        this.travelFlying(p_416255_, 0.02f, 0.02f, p_416177_);
    }

    protected void travelFlying(Vec3 p_415974_, float p_415975_, float p_416507_, float p_416219_) {
        if (this.isInWater()) {
            this.moveRelative(p_415975_, p_415974_);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.8f));
        } else if (this.isInLava()) {
            this.moveRelative(p_416507_, p_415974_);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
        } else {
            this.moveRelative(p_416219_, p_415974_);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.91f));
        }
    }

    private void travelInAir(Vec3 p_362457_) {
        BlockPos $$1 = this.getBlockPosBelowThatAffectsMyMovement();
        float $$2 = this.onGround() ? this.level().getBlockState($$1).getBlock().getFriction() : 1.0f;
        float $$3 = $$2 * 0.91f;
        Vec3 $$4 = this.handleRelativeFrictionAndCalculateMovement(p_362457_, $$2);
        double $$5 = $$4.y;
        MobEffectInstance $$6 = this.getEffect(MobEffects.LEVITATION);
        $$5 = $$6 != null ? ($$5 += (0.05 * (double)($$6.getAmplifier() + 1) - $$4.y) * 0.2) : (!this.level().isClientSide || this.level().hasChunkAt($$1) ? ($$5 -= this.getEffectiveGravity()) : (this.getY() > (double)this.level().getMinY() ? -0.1 : 0.0));
        if (this.shouldDiscardFriction()) {
            this.setDeltaMovement($$4.x, $$5, $$4.z);
        } else {
            float $$7 = this instanceof FlyingAnimal ? $$3 : 0.98f;
            this.setDeltaMovement($$4.x * (double)$$3, $$5 * (double)$$7, $$4.z * (double)$$3);
        }
    }

    private void travelInFluid(Vec3 p_365480_) {
        boolean $$1 = this.getDeltaMovement().y <= 0.0;
        double $$2 = this.getY();
        double $$3 = this.getEffectiveGravity();
        if (this.isInWater()) {
            float $$4 = this.isSprinting() ? 0.9f : this.getWaterSlowDown();
            float $$5 = 0.02f;
            float $$6 = (float)this.getAttributeValue(Attributes.WATER_MOVEMENT_EFFICIENCY);
            if (!this.onGround()) {
                $$6 *= 0.5f;
            }
            if ($$6 > 0.0f) {
                $$4 += (0.54600006f - $$4) * $$6;
                $$5 += (this.getSpeed() - $$5) * $$6;
            }
            if (this.hasEffect(MobEffects.DOLPHINS_GRACE)) {
                $$4 = 0.96f;
            }
            this.moveRelative($$5, p_365480_);
            this.move(MoverType.SELF, this.getDeltaMovement());
            Vec3 $$7 = this.getDeltaMovement();
            if (this.horizontalCollision && this.onClimbable()) {
                $$7 = new Vec3($$7.x, 0.2, $$7.z);
            }
            $$7 = $$7.multiply($$4, 0.8f, $$4);
            this.setDeltaMovement(this.getFluidFallingAdjustedMovement($$3, $$1, $$7));
        } else {
            this.moveRelative(0.02f, p_365480_);
            this.move(MoverType.SELF, this.getDeltaMovement());
            if (this.getFluidHeight(FluidTags.LAVA) <= this.getFluidJumpThreshold()) {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.5, 0.8f, 0.5));
                Vec3 $$8 = this.getFluidFallingAdjustedMovement($$3, $$1, this.getDeltaMovement());
                this.setDeltaMovement($$8);
            } else {
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
            }
            if ($$3 != 0.0) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -$$3 / 4.0, 0.0));
            }
        }
        Vec3 $$9 = this.getDeltaMovement();
        if (this.horizontalCollision && this.isFree($$9.x, $$9.y + (double)0.6f - this.getY() + $$2, $$9.z)) {
            this.setDeltaMovement($$9.x, 0.3f, $$9.z);
        }
    }

    private void travelFallFlying(Vec3 p_393496_) {
        if (this.onClimbable()) {
            this.travelInAir(p_393496_);
            this.stopFallFlying();
            return;
        }
        Vec3 $$1 = this.getDeltaMovement();
        double $$2 = $$1.horizontalDistance();
        this.setDeltaMovement(this.updateFallFlyingMovement($$1));
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (!this.level().isClientSide) {
            double $$3 = this.getDeltaMovement().horizontalDistance();
            this.handleFallFlyingCollisions($$2, $$3);
        }
    }

    public void stopFallFlying() {
        this.setSharedFlag(7, true);
        this.setSharedFlag(7, false);
    }

    private Vec3 updateFallFlyingMovement(Vec3 p_361725_) {
        Vec3 $$1 = this.getLookAngle();
        float $$2 = this.getXRot() * ((float)Math.PI / 180);
        double $$3 = Math.sqrt($$1.x * $$1.x + $$1.z * $$1.z);
        double $$4 = p_361725_.horizontalDistance();
        double $$5 = this.getEffectiveGravity();
        double $$6 = Mth.square(Math.cos($$2));
        p_361725_ = p_361725_.add(0.0, $$5 * (-1.0 + $$6 * 0.75), 0.0);
        if (p_361725_.y < 0.0 && $$3 > 0.0) {
            double $$7 = p_361725_.y * -0.1 * $$6;
            p_361725_ = p_361725_.add($$1.x * $$7 / $$3, $$7, $$1.z * $$7 / $$3);
        }
        if ($$2 < 0.0f && $$3 > 0.0) {
            double $$8 = $$4 * (double)(-Mth.sin($$2)) * 0.04;
            p_361725_ = p_361725_.add(-$$1.x * $$8 / $$3, $$8 * 3.2, -$$1.z * $$8 / $$3);
        }
        if ($$3 > 0.0) {
            p_361725_ = p_361725_.add(($$1.x / $$3 * $$4 - p_361725_.x) * 0.1, 0.0, ($$1.z / $$3 * $$4 - p_361725_.z) * 0.1);
        }
        return p_361725_.multiply(0.99f, 0.98f, 0.99f);
    }

    private void handleFallFlyingCollisions(double p_364700_, double p_365225_) {
        double $$2;
        float $$3;
        if (this.horizontalCollision && ($$3 = (float)(($$2 = p_364700_ - p_365225_) * 10.0 - 3.0)) > 0.0f) {
            this.playSound(this.getFallDamageSound((int)$$3), 1.0f, 1.0f);
            this.hurt(this.damageSources().flyIntoWall(), $$3);
        }
    }

    private void travelRidden(Player p_278244_, Vec3 p_278231_) {
        Vec3 $$2 = this.getRiddenInput(p_278244_, p_278231_);
        this.tickRidden(p_278244_, $$2);
        if (this.canSimulateMovement()) {
            this.setSpeed(this.getRiddenSpeed(p_278244_));
            this.travel($$2);
        } else {
            this.setDeltaMovement(Vec3.ZERO);
        }
    }

    protected void tickRidden(Player p_278262_, Vec3 p_275242_) {
    }

    protected Vec3 getRiddenInput(Player p_278326_, Vec3 p_275300_) {
        return p_275300_;
    }

    protected float getRiddenSpeed(Player p_278286_) {
        return this.getSpeed();
    }

    public void calculateEntityAnimation(boolean p_268129_) {
        float $$1 = (float)Mth.length(this.getX() - this.xo, p_268129_ ? this.getY() - this.yo : 0.0, this.getZ() - this.zo);
        if (this.isPassenger() || !this.isAlive()) {
            this.walkAnimation.stop();
        } else {
            this.updateWalkAnimation($$1);
        }
    }

    protected void updateWalkAnimation(float p_268283_) {
        float $$1 = Math.min(p_268283_ * 4.0f, 1.0f);
        this.walkAnimation.update($$1, 0.4f, this.isBaby() ? 3.0f : 1.0f);
    }

    private Vec3 handleRelativeFrictionAndCalculateMovement(Vec3 p_21075_, float p_21076_) {
        this.moveRelative(this.getFrictionInfluencedSpeed(p_21076_), p_21075_);
        this.setDeltaMovement(this.handleOnClimbable(this.getDeltaMovement()));
        this.move(MoverType.SELF, this.getDeltaMovement());
        Vec3 $$2 = this.getDeltaMovement();
        if ((this.horizontalCollision || this.jumping) && (this.onClimbable() || this.wasInPowderSnow && PowderSnowBlock.canEntityWalkOnPowderSnow(this))) {
            $$2 = new Vec3($$2.x, 0.2, $$2.z);
        }
        return $$2;
    }

    public Vec3 getFluidFallingAdjustedMovement(double p_20995_, boolean p_20996_, Vec3 p_20997_) {
        if (p_20995_ != 0.0 && !this.isSprinting()) {
            double $$4;
            if (p_20996_ && Math.abs(p_20997_.y - 0.005) >= 0.003 && Math.abs(p_20997_.y - p_20995_ / 16.0) < 0.003) {
                double $$3 = -0.003;
            } else {
                $$4 = p_20997_.y - p_20995_ / 16.0;
            }
            return new Vec3(p_20997_.x, $$4, p_20997_.z);
        }
        return p_20997_;
    }

    private Vec3 handleOnClimbable(Vec3 p_21298_) {
        if (this.onClimbable()) {
            this.resetFallDistance();
            float $$1 = 0.15f;
            double $$2 = Mth.clamp(p_21298_.x, (double)-0.15f, (double)0.15f);
            double $$3 = Mth.clamp(p_21298_.z, (double)-0.15f, (double)0.15f);
            double $$4 = Math.max(p_21298_.y, (double)-0.15f);
            if ($$4 < 0.0 && !this.getInBlockState().is(Blocks.SCAFFOLDING) && this.isSuppressingSlidingDownLadder() && this instanceof Player) {
                $$4 = 0.0;
            }
            p_21298_ = new Vec3($$2, $$4, $$3);
        }
        return p_21298_;
    }

    private float getFrictionInfluencedSpeed(float p_21331_) {
        if (this.onGround()) {
            return this.getSpeed() * (0.21600002f / (p_21331_ * p_21331_ * p_21331_));
        }
        return this.getFlyingSpeed();
    }

    protected float getFlyingSpeed() {
        return this.getControllingPassenger() instanceof Player ? this.getSpeed() * 0.1f : 0.02f;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float p_21320_) {
        this.speed = p_21320_;
    }

    public boolean doHurtTarget(ServerLevel p_376294_, Entity p_20970_) {
        this.setLastHurtMob(p_20970_);
        return false;
    }

    @Override
    public void tick() {
        super.tick();
        this.updatingUsingItem();
        this.updateSwimAmount();
        if (!this.level().isClientSide) {
            int $$1;
            int $$0 = this.getArrowCount();
            if ($$0 > 0) {
                if (this.removeArrowTime <= 0) {
                    this.removeArrowTime = 20 * (30 - $$0);
                }
                --this.removeArrowTime;
                if (this.removeArrowTime <= 0) {
                    this.setArrowCount($$0 - 1);
                }
            }
            if (($$1 = this.getStingerCount()) > 0) {
                if (this.removeStingerTime <= 0) {
                    this.removeStingerTime = 20 * (30 - $$1);
                }
                --this.removeStingerTime;
                if (this.removeStingerTime <= 0) {
                    this.setStingerCount($$1 - 1);
                }
            }
            this.detectEquipmentUpdates();
            if (this.tickCount % 20 == 0) {
                this.getCombatTracker().recheckStatus();
            }
            if (this.isSleeping() && !this.checkBedExists()) {
                this.stopSleeping();
            }
        }
        if (!this.isRemoved()) {
            this.aiStep();
        }
        double $$2 = this.getX() - this.xo;
        double $$3 = this.getZ() - this.zo;
        float $$4 = (float)($$2 * $$2 + $$3 * $$3);
        float $$5 = this.yBodyRot;
        if ($$4 > 0.0025000002f) {
            float $$6 = (float)Mth.atan2($$3, $$2) * 57.295776f - 90.0f;
            float $$7 = Mth.abs(Mth.wrapDegrees(this.getYRot()) - $$6);
            $$5 = 95.0f < $$7 && $$7 < 265.0f ? $$6 - 180.0f : $$6;
        }
        if (this.attackAnim > 0.0f) {
            $$5 = this.getYRot();
        }
        ProfilerFiller $$8 = Profiler.get();
        $$8.push("headTurn");
        this.tickHeadTurn($$5);
        $$8.pop();
        $$8.push("rangeChecks");
        while (this.getYRot() - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.getYRot() - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
        while (this.yBodyRot - this.yBodyRotO < -180.0f) {
            this.yBodyRotO -= 360.0f;
        }
        while (this.yBodyRot - this.yBodyRotO >= 180.0f) {
            this.yBodyRotO += 360.0f;
        }
        while (this.getXRot() - this.xRotO < -180.0f) {
            this.xRotO -= 360.0f;
        }
        while (this.getXRot() - this.xRotO >= 180.0f) {
            this.xRotO += 360.0f;
        }
        while (this.yHeadRot - this.yHeadRotO < -180.0f) {
            this.yHeadRotO -= 360.0f;
        }
        while (this.yHeadRot - this.yHeadRotO >= 180.0f) {
            this.yHeadRotO += 360.0f;
        }
        $$8.pop();
        this.fallFlyTicks = this.isFallFlying() ? ++this.fallFlyTicks : 0;
        if (this.isSleeping()) {
            this.setXRot(0.0f);
        }
        this.refreshDirtyAttributes();
        this.elytraAnimationState.tick();
    }

    private void detectEquipmentUpdates() {
        Map<EquipmentSlot, ItemStack> $$0 = this.collectEquipmentChanges();
        if ($$0 != null) {
            this.handleHandSwap($$0);
            if (!$$0.isEmpty()) {
                this.handleEquipmentChanges($$0);
            }
        }
    }

    @Nullable
    private Map<EquipmentSlot, ItemStack> collectEquipmentChanges() {
        Map $$0 = null;
        for (EquipmentSlot equipmentSlot : EquipmentSlot.VALUES) {
            ItemStack $$3;
            ItemStack $$2 = this.lastEquipmentItems.get(equipmentSlot);
            if (!this.equipmentHasChanged($$2, $$3 = this.getItemBySlot(equipmentSlot))) continue;
            if ($$0 == null) {
                $$0 = Maps.newEnumMap(EquipmentSlot.class);
            }
            $$0.put(equipmentSlot, $$3);
            AttributeMap $$4 = this.getAttributes();
            if ($$2.isEmpty()) continue;
            this.stopLocationBasedEffects($$2, equipmentSlot, $$4);
        }
        if ($$0 != null) {
            for (Map.Entry entry : $$0.entrySet()) {
                EquipmentSlot $$6 = (EquipmentSlot)entry.getKey();
                ItemStack $$7 = (ItemStack)entry.getValue();
                if ($$7.isEmpty() || $$7.isBroken()) continue;
                $$7.forEachModifier($$6, (p_359701_, p_359702_) -> {
                    AttributeInstance $$2 = this.attributes.getInstance((Holder<Attribute>)p_359701_);
                    if ($$2 != null) {
                        $$2.removeModifier(p_359702_.id());
                        $$2.addTransientModifier((AttributeModifier)p_359702_);
                    }
                });
                Level level = this.level();
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel $$8 = (ServerLevel)level;
                EnchantmentHelper.runLocationChangedEffects($$8, $$7, this, $$6);
            }
        }
        return $$0;
    }

    public boolean equipmentHasChanged(ItemStack p_252265_, ItemStack p_251043_) {
        return !ItemStack.matches(p_251043_, p_252265_);
    }

    private void handleHandSwap(Map<EquipmentSlot, ItemStack> p_21092_) {
        ItemStack $$1 = p_21092_.get(EquipmentSlot.MAINHAND);
        ItemStack $$2 = p_21092_.get(EquipmentSlot.OFFHAND);
        if ($$1 != null && $$2 != null && ItemStack.matches($$1, this.lastEquipmentItems.get(EquipmentSlot.OFFHAND)) && ItemStack.matches($$2, this.lastEquipmentItems.get(EquipmentSlot.MAINHAND))) {
            ((ServerLevel)this.level()).getChunkSource().broadcast(this, new ClientboundEntityEventPacket(this, 55));
            p_21092_.remove(EquipmentSlot.MAINHAND);
            p_21092_.remove(EquipmentSlot.OFFHAND);
            this.lastEquipmentItems.put(EquipmentSlot.MAINHAND, $$1.copy());
            this.lastEquipmentItems.put(EquipmentSlot.OFFHAND, $$2.copy());
        }
    }

    private void handleEquipmentChanges(Map<EquipmentSlot, ItemStack> p_21143_) {
        ArrayList $$1 = Lists.newArrayListWithCapacity((int)p_21143_.size());
        p_21143_.forEach((p_396675_, p_396676_) -> {
            ItemStack $$3 = p_396676_.copy();
            $$1.add(Pair.of((Object)p_396675_, (Object)$$3));
            this.lastEquipmentItems.put((EquipmentSlot)p_396675_, $$3);
        });
        ((ServerLevel)this.level()).getChunkSource().broadcast(this, new ClientboundSetEquipmentPacket(this.getId(), $$1));
    }

    protected void tickHeadTurn(float p_21260_) {
        float $$1 = Mth.wrapDegrees(p_21260_ - this.yBodyRot);
        this.yBodyRot += $$1 * 0.3f;
        float $$2 = Mth.wrapDegrees(this.getYRot() - this.yBodyRot);
        float $$3 = this.getMaxHeadRotationRelativeToBody();
        if (Math.abs($$2) > $$3) {
            this.yBodyRot += $$2 - (float)Mth.sign($$2) * $$3;
        }
    }

    protected float getMaxHeadRotationRelativeToBody() {
        return 50.0f;
    }

    /*
     * Unable to fully structure code
     */
    public void aiStep() {
        if (this.noJumpDelay > 0) {
            --this.noJumpDelay;
        }
        if (this.isInterpolating()) {
            this.getInterpolation().interpolate();
        } else if (!this.canSimulateMovement()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        }
        if (this.lerpHeadSteps > 0) {
            this.lerpHeadRotationStep(this.lerpHeadSteps, this.lerpYHeadRot);
            --this.lerpHeadSteps;
        }
        this.equipment.tick(this);
        $$0 = this.getDeltaMovement();
        $$1 = $$0.x;
        $$2 = $$0.y;
        $$3 = $$0.z;
        if (this.getType().equals(EntityType.PLAYER)) {
            if ($$0.horizontalDistanceSqr() < 9.0E-6) {
                $$1 = 0.0;
                $$3 = 0.0;
            }
        } else {
            if (Math.abs($$0.x) < 0.003) {
                $$1 = 0.0;
            }
            if (Math.abs($$0.z) < 0.003) {
                $$3 = 0.0;
            }
        }
        if (Math.abs($$0.y) < 0.003) {
            $$2 = 0.0;
        }
        this.setDeltaMovement($$1, $$2, $$3);
        $$4 = Profiler.get();
        $$4.push("ai");
        this.applyInput();
        if (this.isImmobile()) {
            this.jumping = false;
            this.xxa = 0.0f;
            this.zza = 0.0f;
        } else if (this.isEffectiveAi() && !this.level().isClientSide) {
            $$4.push("newAi");
            this.serverAiStep();
            $$4.pop();
        }
        $$4.pop();
        $$4.push("jump");
        if (this.jumping && this.isAffectedByFluids()) {
            if (this.isInLava()) {
                $$5 = this.getFluidHeight(FluidTags.LAVA);
            } else {
                $$6 = this.getFluidHeight(FluidTags.WATER);
            }
            $$7 = this.isInWater() != false && $$6 > 0.0;
            $$8 = this.getFluidJumpThreshold();
            if ($$7 && (!this.onGround() || $$6 > $$8)) {
                this.jumpInLiquid(FluidTags.WATER);
            } else if (this.isInLava() && (!this.onGround() || $$6 > $$8)) {
                this.jumpInLiquid(FluidTags.LAVA);
            } else if ((this.onGround() || $$7 && $$6 <= $$8) && this.noJumpDelay == 0) {
                this.jumpFromGround();
                this.noJumpDelay = 10;
            }
        } else {
            this.noJumpDelay = 0;
        }
        $$4.pop();
        $$4.push("travel");
        if (this.isFallFlying()) {
            this.updateFallFlying();
        }
        $$9 = this.getBoundingBox();
        $$10 = new Vec3(this.xxa, this.yya, this.zza);
        if (this.hasEffect(MobEffects.SLOW_FALLING) || this.hasEffect(MobEffects.LEVITATION)) {
            this.resetFallDistance();
        }
        if (!((var12_13 = this.getControllingPassenger()) instanceof Player)) ** GOTO lbl-1000
        $$11 = (Player)var12_13;
        if (this.isAlive()) {
            this.travelRidden($$11, $$10);
        } else if (this.canSimulateMovement() && this.isEffectiveAi()) {
            this.travel($$10);
        }
        if (!this.level().isClientSide() || this.isLocalInstanceAuthoritative()) {
            this.applyEffectsFromBlocks();
        }
        if (this.level().isClientSide()) {
            this.calculateEntityAnimation(this instanceof FlyingAnimal);
        }
        $$4.pop();
        var12_13 = this.level();
        if (var12_13 instanceof ServerLevel) {
            $$12 = (ServerLevel)var12_13;
            $$4.push("freezing");
            if (!this.isInPowderSnow || !this.canFreeze()) {
                this.setTicksFrozen(Math.max(0, this.getTicksFrozen() - 2));
            }
            this.removeFrost();
            this.tryAddFrost();
            if (this.tickCount % 40 == 0 && this.isFullyFrozen() && this.canFreeze()) {
                this.hurtServer($$12, this.damageSources().freeze(), 1.0f);
            }
            $$4.pop();
        }
        $$4.push("push");
        if (this.autoSpinAttackTicks > 0) {
            --this.autoSpinAttackTicks;
            this.checkAutoSpinAttack($$9, this.getBoundingBox());
        }
        this.pushEntities();
        $$4.pop();
        var12_13 = this.level();
        if (var12_13 instanceof ServerLevel) {
            $$13 = (ServerLevel)var12_13;
            if (this.isSensitiveToWater() && this.isInWaterOrRain()) {
                this.hurtServer($$13, this.damageSources().drown(), 1.0f);
            }
        }
    }

    protected void applyInput() {
        this.xxa *= 0.98f;
        this.zza *= 0.98f;
    }

    public boolean isSensitiveToWater() {
        return false;
    }

    public boolean isJumping() {
        return this.jumping;
    }

    protected void updateFallFlying() {
        this.checkFallDistanceAccumulation();
        if (!this.level().isClientSide) {
            if (!this.canGlide()) {
                this.setSharedFlag(7, false);
                return;
            }
            int $$0 = this.fallFlyTicks + 1;
            if ($$0 % 10 == 0) {
                int $$1 = $$0 / 10;
                if ($$1 % 2 == 0) {
                    List<EquipmentSlot> $$2 = EquipmentSlot.VALUES.stream().filter(p_370507_ -> LivingEntity.canGlideUsing(this.getItemBySlot((EquipmentSlot)p_370507_), p_370507_)).toList();
                    EquipmentSlot $$3 = Util.getRandom($$2, this.random);
                    this.getItemBySlot($$3).hurtAndBreak(1, this, $$3);
                }
                this.gameEvent(GameEvent.ELYTRA_GLIDE);
            }
        }
    }

    protected boolean canGlide() {
        if (this.onGround() || this.isPassenger() || this.hasEffect(MobEffects.LEVITATION)) {
            return false;
        }
        for (EquipmentSlot $$0 : EquipmentSlot.VALUES) {
            if (!LivingEntity.canGlideUsing(this.getItemBySlot($$0), $$0)) continue;
            return true;
        }
        return false;
    }

    protected void serverAiStep() {
    }

    protected void pushEntities() {
        ServerLevel $$1;
        int $$2;
        List<Entity> $$0 = this.level().getPushableEntities(this, this.getBoundingBox());
        if ($$0.isEmpty()) {
            return;
        }
        Level level = this.level();
        if (level instanceof ServerLevel && ($$2 = ($$1 = (ServerLevel)level).getGameRules().getInt(GameRules.RULE_MAX_ENTITY_CRAMMING)) > 0 && $$0.size() > $$2 - 1 && this.random.nextInt(4) == 0) {
            int $$3 = 0;
            for (Entity $$4 : $$0) {
                if ($$4.isPassenger()) continue;
                ++$$3;
            }
            if ($$3 > $$2 - 1) {
                this.hurtServer($$1, this.damageSources().cramming(), 6.0f);
            }
        }
        for (Entity $$5 : $$0) {
            this.doPush($$5);
        }
    }

    protected void checkAutoSpinAttack(AABB p_21072_, AABB p_21073_) {
        AABB $$2 = p_21072_.minmax(p_21073_);
        List<Entity> $$3 = this.level().getEntities(this, $$2);
        if (!$$3.isEmpty()) {
            for (Entity $$4 : $$3) {
                if (!($$4 instanceof LivingEntity)) continue;
                this.doAutoAttackOnTouch((LivingEntity)$$4);
                this.autoSpinAttackTicks = 0;
                this.setDeltaMovement(this.getDeltaMovement().scale(-0.2));
                break;
            }
        } else if (this.horizontalCollision) {
            this.autoSpinAttackTicks = 0;
        }
        if (!this.level().isClientSide && this.autoSpinAttackTicks <= 0) {
            this.setLivingEntityFlag(4, false);
            this.autoSpinAttackDmg = 0.0f;
            this.autoSpinAttackItemStack = null;
        }
    }

    protected void doPush(Entity p_20971_) {
        p_20971_.push(this);
    }

    protected void doAutoAttackOnTouch(LivingEntity p_21277_) {
    }

    public boolean isAutoSpinAttack() {
        return (this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 4) != 0;
    }

    @Override
    public void stopRiding() {
        Entity $$0 = this.getVehicle();
        super.stopRiding();
        if ($$0 != null && $$0 != this.getVehicle() && !this.level().isClientSide) {
            this.dismountVehicle($$0);
        }
    }

    @Override
    public void rideTick() {
        super.rideTick();
        this.resetFallDistance();
    }

    @Override
    public InterpolationHandler getInterpolation() {
        return this.interpolation;
    }

    @Override
    public void lerpHeadTo(float p_21005_, int p_21006_) {
        this.lerpYHeadRot = p_21005_;
        this.lerpHeadSteps = p_21006_;
    }

    public void setJumping(boolean p_21314_) {
        this.jumping = p_21314_;
    }

    public void onItemPickup(ItemEntity p_21054_) {
        Entity $$1 = p_21054_.getOwner();
        if ($$1 instanceof ServerPlayer) {
            CriteriaTriggers.THROWN_ITEM_PICKED_UP_BY_ENTITY.trigger((ServerPlayer)$$1, p_21054_.getItem(), this);
        }
    }

    public void take(Entity p_21030_, int p_21031_) {
        if (!p_21030_.isRemoved() && !this.level().isClientSide && (p_21030_ instanceof ItemEntity || p_21030_ instanceof AbstractArrow || p_21030_ instanceof ExperienceOrb)) {
            ((ServerLevel)this.level()).getChunkSource().broadcast(p_21030_, new ClientboundTakeItemEntityPacket(p_21030_.getId(), this.getId(), p_21031_));
        }
    }

    public boolean hasLineOfSight(Entity p_147185_) {
        return this.hasLineOfSight(p_147185_, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, p_147185_.getEyeY());
    }

    public boolean hasLineOfSight(Entity p_380044_, ClipContext.Block p_379804_, ClipContext.Fluid p_379360_, double p_382895_) {
        if (p_380044_.level() != this.level()) {
            return false;
        }
        Vec3 $$4 = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        Vec3 $$5 = new Vec3(p_380044_.getX(), p_382895_, p_380044_.getZ());
        if ($$5.distanceTo($$4) > 128.0) {
            return false;
        }
        return this.level().clip(new ClipContext($$4, $$5, p_379804_, p_379360_, this)).getType() == HitResult.Type.MISS;
    }

    @Override
    public float getViewYRot(float p_21286_) {
        if (p_21286_ == 1.0f) {
            return this.yHeadRot;
        }
        return Mth.rotLerp(p_21286_, this.yHeadRotO, this.yHeadRot);
    }

    public float getAttackAnim(float p_21325_) {
        float $$1 = this.attackAnim - this.oAttackAnim;
        if ($$1 < 0.0f) {
            $$1 += 1.0f;
        }
        return this.oAttackAnim + $$1 * p_21325_;
    }

    @Override
    public boolean isPickable() {
        return !this.isRemoved();
    }

    @Override
    public boolean isPushable() {
        return this.isAlive() && !this.isSpectator() && !this.onClimbable();
    }

    @Override
    public float getYHeadRot() {
        return this.yHeadRot;
    }

    @Override
    public void setYHeadRot(float p_21306_) {
        this.yHeadRot = p_21306_;
    }

    @Override
    public void setYBodyRot(float p_21309_) {
        this.yBodyRot = p_21309_;
    }

    @Override
    public Vec3 getRelativePortalPosition(Direction.Axis p_21085_, BlockUtil.FoundRectangle p_21086_) {
        return LivingEntity.resetForwardDirectionOfRelativePortalPosition(super.getRelativePortalPosition(p_21085_, p_21086_));
    }

    public static Vec3 resetForwardDirectionOfRelativePortalPosition(Vec3 p_21290_) {
        return new Vec3(p_21290_.x, p_21290_.y, 0.0);
    }

    public float getAbsorptionAmount() {
        return this.absorptionAmount;
    }

    public final void setAbsorptionAmount(float p_21328_) {
        this.internalSetAbsorptionAmount(Mth.clamp(p_21328_, 0.0f, this.getMaxAbsorption()));
    }

    protected void internalSetAbsorptionAmount(float p_295258_) {
        this.absorptionAmount = p_295258_;
    }

    public void onEnterCombat() {
    }

    public void onLeaveCombat() {
    }

    protected void updateEffectVisibility() {
        this.effectsDirty = true;
    }

    public abstract HumanoidArm getMainArm();

    public boolean isUsingItem() {
        return (this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 1) > 0;
    }

    public InteractionHand getUsedItemHand() {
        return (this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 2) > 0 ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    private void updatingUsingItem() {
        if (this.isUsingItem()) {
            if (ItemStack.isSameItem(this.getItemInHand(this.getUsedItemHand()), this.useItem)) {
                this.useItem = this.getItemInHand(this.getUsedItemHand());
                this.updateUsingItem(this.useItem);
            } else {
                this.stopUsingItem();
            }
        }
    }

    @Nullable
    private ItemEntity createItemStackToDrop(ItemStack p_401823_, boolean p_401912_, boolean p_401812_) {
        if (p_401823_.isEmpty()) {
            return null;
        }
        double $$3 = this.getEyeY() - (double)0.3f;
        ItemEntity $$4 = new ItemEntity(this.level(), this.getX(), $$3, this.getZ(), p_401823_);
        $$4.setPickUpDelay(40);
        if (p_401812_) {
            $$4.setThrower(this);
        }
        if (p_401912_) {
            float $$5 = this.random.nextFloat() * 0.5f;
            float $$6 = this.random.nextFloat() * ((float)Math.PI * 2);
            $$4.setDeltaMovement(-Mth.sin($$6) * $$5, 0.2f, Mth.cos($$6) * $$5);
        } else {
            float $$7 = 0.3f;
            float $$8 = Mth.sin(this.getXRot() * ((float)Math.PI / 180));
            float $$9 = Mth.cos(this.getXRot() * ((float)Math.PI / 180));
            float $$10 = Mth.sin(this.getYRot() * ((float)Math.PI / 180));
            float $$11 = Mth.cos(this.getYRot() * ((float)Math.PI / 180));
            float $$12 = this.random.nextFloat() * ((float)Math.PI * 2);
            float $$13 = 0.02f * this.random.nextFloat();
            $$4.setDeltaMovement((double)(-$$10 * $$9 * 0.3f) + Math.cos($$12) * (double)$$13, -$$8 * 0.3f + 0.1f + (this.random.nextFloat() - this.random.nextFloat()) * 0.1f, (double)($$11 * $$9 * 0.3f) + Math.sin($$12) * (double)$$13);
        }
        return $$4;
    }

    protected void updateUsingItem(ItemStack p_147201_) {
        p_147201_.onUseTick(this.level(), this, this.getUseItemRemainingTicks());
        if (--this.useItemRemaining == 0 && !this.level().isClientSide && !p_147201_.useOnRelease()) {
            this.completeUsingItem();
        }
    }

    private void updateSwimAmount() {
        this.swimAmountO = this.swimAmount;
        this.swimAmount = this.isVisuallySwimming() ? Math.min(1.0f, this.swimAmount + 0.09f) : Math.max(0.0f, this.swimAmount - 0.09f);
    }

    protected void setLivingEntityFlag(int p_21156_, boolean p_21157_) {
        int $$2 = this.entityData.get(DATA_LIVING_ENTITY_FLAGS).byteValue();
        $$2 = p_21157_ ? ($$2 |= p_21156_) : ($$2 &= ~p_21156_);
        this.entityData.set(DATA_LIVING_ENTITY_FLAGS, (byte)$$2);
    }

    public void startUsingItem(InteractionHand p_21159_) {
        ItemStack $$1 = this.getItemInHand(p_21159_);
        if ($$1.isEmpty() || this.isUsingItem()) {
            return;
        }
        this.useItem = $$1;
        this.useItemRemaining = $$1.getUseDuration(this);
        if (!this.level().isClientSide) {
            this.setLivingEntityFlag(1, true);
            this.setLivingEntityFlag(2, p_21159_ == InteractionHand.OFF_HAND);
            this.gameEvent(GameEvent.ITEM_INTERACT_START);
        }
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> p_21104_) {
        super.onSyncedDataUpdated(p_21104_);
        if (SLEEPING_POS_ID.equals(p_21104_)) {
            if (this.level().isClientSide) {
                this.getSleepingPos().ifPresent(this::setPosToBed);
            }
        } else if (DATA_LIVING_ENTITY_FLAGS.equals(p_21104_) && this.level().isClientSide) {
            if (this.isUsingItem() && this.useItem.isEmpty()) {
                this.useItem = this.getItemInHand(this.getUsedItemHand());
                if (!this.useItem.isEmpty()) {
                    this.useItemRemaining = this.useItem.getUseDuration(this);
                }
            } else if (!this.isUsingItem() && !this.useItem.isEmpty()) {
                this.useItem = ItemStack.EMPTY;
                this.useItemRemaining = 0;
            }
        }
    }

    @Override
    public void lookAt(EntityAnchorArgument.Anchor p_21078_, Vec3 p_21079_) {
        super.lookAt(p_21078_, p_21079_);
        this.yHeadRotO = this.yHeadRot;
        this.yBodyRotO = this.yBodyRot = this.yHeadRot;
    }

    @Override
    public float getPreciseBodyRotation(float p_352089_) {
        return Mth.lerp(p_352089_, this.yBodyRotO, this.yBodyRot);
    }

    public void spawnItemParticles(ItemStack p_21061_, int p_21062_) {
        for (int $$2 = 0; $$2 < p_21062_; ++$$2) {
            Vec3 $$3 = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            $$3 = $$3.xRot(-this.getXRot() * ((float)Math.PI / 180));
            $$3 = $$3.yRot(-this.getYRot() * ((float)Math.PI / 180));
            double $$4 = (double)(-this.random.nextFloat()) * 0.6 - 0.3;
            Vec3 $$5 = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.3, $$4, 0.6);
            $$5 = $$5.xRot(-this.getXRot() * ((float)Math.PI / 180));
            $$5 = $$5.yRot(-this.getYRot() * ((float)Math.PI / 180));
            $$5 = $$5.add(this.getX(), this.getEyeY(), this.getZ());
            this.level().addParticle(new ItemParticleOption(ParticleTypes.ITEM, p_21061_), $$5.x, $$5.y, $$5.z, $$3.x, $$3.y + 0.05, $$3.z);
        }
    }

    protected void completeUsingItem() {
        if (this.level().isClientSide && !this.isUsingItem()) {
            return;
        }
        InteractionHand $$0 = this.getUsedItemHand();
        if (!this.useItem.equals(this.getItemInHand($$0))) {
            this.releaseUsingItem();
            return;
        }
        if (!this.useItem.isEmpty() && this.isUsingItem()) {
            ItemStack $$1 = this.useItem.finishUsingItem(this.level(), this);
            if ($$1 != this.useItem) {
                this.setItemInHand($$0, $$1);
            }
            this.stopUsingItem();
        }
    }

    public void handleExtraItemsCreatedOnUse(ItemStack p_376248_) {
    }

    public ItemStack getUseItem() {
        return this.useItem;
    }

    public int getUseItemRemainingTicks() {
        return this.useItemRemaining;
    }

    public int getTicksUsingItem() {
        if (this.isUsingItem()) {
            return this.useItem.getUseDuration(this) - this.getUseItemRemainingTicks();
        }
        return 0;
    }

    public void releaseUsingItem() {
        ItemStack $$0 = this.getItemInHand(this.getUsedItemHand());
        if (!this.useItem.isEmpty() && ItemStack.isSameItem($$0, this.useItem)) {
            this.useItem = $$0;
            this.useItem.releaseUsing(this.level(), this, this.getUseItemRemainingTicks());
            if (this.useItem.useOnRelease()) {
                this.updatingUsingItem();
            }
        }
        this.stopUsingItem();
    }

    public void stopUsingItem() {
        if (!this.level().isClientSide) {
            boolean $$0 = this.isUsingItem();
            this.setLivingEntityFlag(1, false);
            if ($$0) {
                this.gameEvent(GameEvent.ITEM_INTERACT_FINISH);
            }
        }
        this.useItem = ItemStack.EMPTY;
        this.useItemRemaining = 0;
    }

    public boolean isBlocking() {
        return this.getItemBlockingWith() != null;
    }

    @Nullable
    public ItemStack getItemBlockingWith() {
        int $$1;
        if (!this.isUsingItem()) {
            return null;
        }
        BlocksAttacks $$0 = this.useItem.get(DataComponents.BLOCKS_ATTACKS);
        if ($$0 != null && ($$1 = this.useItem.getItem().getUseDuration(this.useItem, this) - this.useItemRemaining) >= $$0.blockDelayTicks()) {
            return this.useItem;
        }
        return null;
    }

    public boolean isSuppressingSlidingDownLadder() {
        return this.isShiftKeyDown();
    }

    public boolean isFallFlying() {
        return this.getSharedFlag(7);
    }

    @Override
    public boolean isVisuallySwimming() {
        return super.isVisuallySwimming() || !this.isFallFlying() && this.hasPose(Pose.FALL_FLYING);
    }

    public int getFallFlyingTicks() {
        return this.fallFlyTicks;
    }

    public boolean randomTeleport(double p_20985_, double p_20986_, double p_20987_, boolean p_20988_) {
        LivingEntity livingEntity;
        double $$4 = this.getX();
        double $$5 = this.getY();
        double $$6 = this.getZ();
        double $$7 = p_20986_;
        boolean $$8 = false;
        BlockPos $$9 = BlockPos.containing(p_20985_, $$7, p_20987_);
        Level $$10 = this.level();
        if ($$10.hasChunkAt($$9)) {
            boolean $$11 = false;
            while (!$$11 && $$9.getY() > $$10.getMinY()) {
                BlockPos $$12 = $$9.below();
                BlockState $$13 = $$10.getBlockState($$12);
                if ($$13.blocksMotion()) {
                    $$11 = true;
                    continue;
                }
                $$7 -= 1.0;
                $$9 = $$12;
            }
            if ($$11) {
                this.teleportTo(p_20985_, $$7, p_20987_);
                if ($$10.noCollision(this) && !$$10.containsAnyLiquid(this.getBoundingBox())) {
                    $$8 = true;
                }
            }
        }
        if (!$$8) {
            this.teleportTo($$4, $$5, $$6);
            return false;
        }
        if (p_20988_) {
            $$10.broadcastEntityEvent(this, (byte)46);
        }
        if ((livingEntity = this) instanceof PathfinderMob) {
            PathfinderMob $$14 = (PathfinderMob)livingEntity;
            $$14.getNavigation().stop();
        }
        return true;
    }

    public boolean isAffectedByPotions() {
        return !this.isDeadOrDying();
    }

    public boolean attackable() {
        return true;
    }

    public void setRecordPlayingNearby(BlockPos p_21082_, boolean p_21083_) {
    }

    public boolean canPickUpLoot() {
        return false;
    }

    @Override
    public final EntityDimensions getDimensions(Pose p_21047_) {
        return p_21047_ == Pose.SLEEPING ? SLEEPING_DIMENSIONS : this.getDefaultDimensions(p_21047_).scale(this.getScale());
    }

    protected EntityDimensions getDefaultDimensions(Pose p_316700_) {
        return this.getType().getDimensions().scale(this.getAgeScale());
    }

    public ImmutableList<Pose> getDismountPoses() {
        return ImmutableList.of((Object)((Object)Pose.STANDING));
    }

    public AABB getLocalBoundsForPose(Pose p_21271_) {
        EntityDimensions $$1 = this.getDimensions(p_21271_);
        return new AABB(-$$1.width() / 2.0f, 0.0, -$$1.width() / 2.0f, $$1.width() / 2.0f, $$1.height(), $$1.width() / 2.0f);
    }

    protected boolean wouldNotSuffocateAtTargetPose(Pose p_294977_) {
        AABB $$1 = this.getDimensions(p_294977_).makeBoundingBox(this.position());
        return this.level().noBlockCollision(this, $$1);
    }

    @Override
    public boolean canUsePortal(boolean p_352946_) {
        return super.canUsePortal(p_352946_) && !this.isSleeping();
    }

    public Optional<BlockPos> getSleepingPos() {
        return this.entityData.get(SLEEPING_POS_ID);
    }

    public void setSleepingPos(BlockPos p_21251_) {
        this.entityData.set(SLEEPING_POS_ID, Optional.of(p_21251_));
    }

    public void clearSleepingPos() {
        this.entityData.set(SLEEPING_POS_ID, Optional.empty());
    }

    public boolean isSleeping() {
        return this.getSleepingPos().isPresent();
    }

    public void startSleeping(BlockPos p_21141_) {
        BlockState $$1;
        if (this.isPassenger()) {
            this.stopRiding();
        }
        if (($$1 = this.level().getBlockState(p_21141_)).getBlock() instanceof BedBlock) {
            this.level().setBlock(p_21141_, (BlockState)$$1.setValue(BedBlock.OCCUPIED, true), 3);
        }
        this.setPose(Pose.SLEEPING);
        this.setPosToBed(p_21141_);
        this.setSleepingPos(p_21141_);
        this.setDeltaMovement(Vec3.ZERO);
        this.hasImpulse = true;
    }

    private void setPosToBed(BlockPos p_21081_) {
        this.setPos((double)p_21081_.getX() + 0.5, (double)p_21081_.getY() + 0.6875, (double)p_21081_.getZ() + 0.5);
    }

    private boolean checkBedExists() {
        return this.getSleepingPos().map(p_423228_ -> this.level().getBlockState((BlockPos)p_423228_).getBlock() instanceof BedBlock).orElse(false);
    }

    public void stopSleeping() {
        this.getSleepingPos().filter(this.level()::hasChunkAt).ifPresent(p_261435_ -> {
            BlockState $$1 = this.level().getBlockState((BlockPos)p_261435_);
            if ($$1.getBlock() instanceof BedBlock) {
                Direction $$2 = (Direction)$$1.getValue(BedBlock.FACING);
                this.level().setBlock((BlockPos)p_261435_, (BlockState)$$1.setValue(BedBlock.OCCUPIED, false), 3);
                Vec3 $$3 = BedBlock.findStandUpPosition(this.getType(), this.level(), p_261435_, $$2, this.getYRot()).orElseGet(() -> {
                    BlockPos $$1 = p_261435_.above();
                    return new Vec3((double)$$1.getX() + 0.5, (double)$$1.getY() + 0.1, (double)$$1.getZ() + 0.5);
                });
                Vec3 $$4 = Vec3.atBottomCenterOf(p_261435_).subtract($$3).normalize();
                float $$5 = (float)Mth.wrapDegrees(Mth.atan2($$4.z, $$4.x) * 57.2957763671875 - 90.0);
                this.setPos($$3.x, $$3.y, $$3.z);
                this.setYRot($$5);
                this.setXRot(0.0f);
            }
        });
        Vec3 $$0 = this.position();
        this.setPose(Pose.STANDING);
        this.setPos($$0.x, $$0.y, $$0.z);
        this.clearSleepingPos();
    }

    @Nullable
    public Direction getBedOrientation() {
        BlockPos $$0 = this.getSleepingPos().orElse(null);
        return $$0 != null ? BedBlock.getBedOrientation(this.level(), $$0) : null;
    }

    @Override
    public boolean isInWall() {
        return !this.isSleeping() && super.isInWall();
    }

    public ItemStack getProjectile(ItemStack p_21272_) {
        return ItemStack.EMPTY;
    }

    private static byte entityEventForEquipmentBreak(EquipmentSlot p_21267_) {
        return switch (p_21267_) {
            default -> throw new MatchException(null, null);
            case EquipmentSlot.MAINHAND -> 47;
            case EquipmentSlot.OFFHAND -> 48;
            case EquipmentSlot.HEAD -> 49;
            case EquipmentSlot.CHEST -> 50;
            case EquipmentSlot.FEET -> 52;
            case EquipmentSlot.LEGS -> 51;
            case EquipmentSlot.BODY -> 65;
            case EquipmentSlot.SADDLE -> 68;
        };
    }

    public void onEquippedItemBroken(Item p_348620_, EquipmentSlot p_348655_) {
        this.level().broadcastEntityEvent(this, LivingEntity.entityEventForEquipmentBreak(p_348655_));
        this.stopLocationBasedEffects(this.getItemBySlot(p_348655_), p_348655_, this.attributes);
    }

    private void stopLocationBasedEffects(ItemStack p_364246_, EquipmentSlot p_360503_, AttributeMap p_363426_) {
        p_364246_.forEachModifier(p_360503_, (p_359698_, p_359699_) -> {
            AttributeInstance $$3 = p_363426_.getInstance((Holder<Attribute>)p_359698_);
            if ($$3 != null) {
                $$3.removeModifier((AttributeModifier)p_359699_);
            }
        });
        EnchantmentHelper.stopLocationBasedEffects(p_364246_, this, p_360503_);
    }

    public static EquipmentSlot getSlotForHand(InteractionHand p_320526_) {
        return p_320526_ == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
    }

    public final boolean canEquipWithDispenser(ItemStack p_371334_) {
        if (!this.isAlive() || this.isSpectator()) {
            return false;
        }
        Equippable $$1 = p_371334_.get(DataComponents.EQUIPPABLE);
        if ($$1 == null || !$$1.dispensable()) {
            return false;
        }
        EquipmentSlot $$2 = $$1.slot();
        if (!this.canUseSlot($$2) || !$$1.canBeEquippedBy(this.getType())) {
            return false;
        }
        return this.getItemBySlot($$2).isEmpty() && this.canDispenserEquipIntoSlot($$2);
    }

    protected boolean canDispenserEquipIntoSlot(EquipmentSlot p_371337_) {
        return true;
    }

    public final EquipmentSlot getEquipmentSlotForItem(ItemStack p_147234_) {
        Equippable $$1 = p_147234_.get(DataComponents.EQUIPPABLE);
        if ($$1 != null && this.canUseSlot($$1.slot())) {
            return $$1.slot();
        }
        return EquipmentSlot.MAINHAND;
    }

    public final boolean isEquippableInSlot(ItemStack p_371603_, EquipmentSlot p_371841_) {
        Equippable $$2 = p_371603_.get(DataComponents.EQUIPPABLE);
        if ($$2 == null) {
            return p_371841_ == EquipmentSlot.MAINHAND && this.canUseSlot(EquipmentSlot.MAINHAND);
        }
        return p_371841_ == $$2.slot() && this.canUseSlot($$2.slot()) && $$2.canBeEquippedBy(this.getType());
    }

    private static SlotAccess createEquipmentSlotAccess(LivingEntity p_147196_, EquipmentSlot p_147197_) {
        if (p_147197_ == EquipmentSlot.HEAD || p_147197_ == EquipmentSlot.MAINHAND || p_147197_ == EquipmentSlot.OFFHAND) {
            return SlotAccess.forEquipmentSlot(p_147196_, p_147197_);
        }
        return SlotAccess.forEquipmentSlot(p_147196_, p_147197_, p_348156_ -> p_348156_.isEmpty() || p_147196_.getEquipmentSlotForItem((ItemStack)p_348156_) == p_147197_);
    }

    @Nullable
    private static EquipmentSlot getEquipmentSlot(int p_147212_) {
        if (p_147212_ == 100 + EquipmentSlot.HEAD.getIndex()) {
            return EquipmentSlot.HEAD;
        }
        if (p_147212_ == 100 + EquipmentSlot.CHEST.getIndex()) {
            return EquipmentSlot.CHEST;
        }
        if (p_147212_ == 100 + EquipmentSlot.LEGS.getIndex()) {
            return EquipmentSlot.LEGS;
        }
        if (p_147212_ == 100 + EquipmentSlot.FEET.getIndex()) {
            return EquipmentSlot.FEET;
        }
        if (p_147212_ == 98) {
            return EquipmentSlot.MAINHAND;
        }
        if (p_147212_ == 99) {
            return EquipmentSlot.OFFHAND;
        }
        if (p_147212_ == 105) {
            return EquipmentSlot.BODY;
        }
        if (p_147212_ == 106) {
            return EquipmentSlot.SADDLE;
        }
        return null;
    }

    @Override
    public SlotAccess getSlot(int p_147238_) {
        EquipmentSlot $$1 = LivingEntity.getEquipmentSlot(p_147238_);
        if ($$1 != null) {
            return LivingEntity.createEquipmentSlotAccess(this, $$1);
        }
        return super.getSlot(p_147238_);
    }

    @Override
    public boolean canFreeze() {
        if (this.isSpectator()) {
            return false;
        }
        for (EquipmentSlot $$0 : EquipmentSlotGroup.ARMOR) {
            if (!this.getItemBySlot($$0).is(ItemTags.FREEZE_IMMUNE_WEARABLES)) continue;
            return false;
        }
        return super.canFreeze();
    }

    @Override
    public boolean isCurrentlyGlowing() {
        return !this.level().isClientSide() && this.hasEffect(MobEffects.GLOWING) || super.isCurrentlyGlowing();
    }

    @Override
    public float getVisualRotationYInDegrees() {
        return this.yBodyRot;
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket p_217037_) {
        double $$1 = p_217037_.getX();
        double $$2 = p_217037_.getY();
        double $$3 = p_217037_.getZ();
        float $$4 = p_217037_.getYRot();
        float $$5 = p_217037_.getXRot();
        this.syncPacketPositionCodec($$1, $$2, $$3);
        this.yBodyRot = p_217037_.getYHeadRot();
        this.yHeadRot = p_217037_.getYHeadRot();
        this.yBodyRotO = this.yBodyRot;
        this.yHeadRotO = this.yHeadRot;
        this.setId(p_217037_.getId());
        this.setUUID(p_217037_.getUUID());
        this.absSnapTo($$1, $$2, $$3, $$4, $$5);
        this.setDeltaMovement(p_217037_.getXa(), p_217037_.getYa(), p_217037_.getZa());
    }

    public float getSecondsToDisableBlocking() {
        Weapon $$0 = this.getWeaponItem().get(DataComponents.WEAPON);
        return $$0 != null ? $$0.disableBlockingForSeconds() : 0.0f;
    }

    @Override
    public float maxUpStep() {
        float $$0 = (float)this.getAttributeValue(Attributes.STEP_HEIGHT);
        return this.getControllingPassenger() instanceof Player ? Math.max($$0, 1.0f) : $$0;
    }

    @Override
    public Vec3 getPassengerRidingPosition(Entity p_295664_) {
        return this.position().add(this.getPassengerAttachmentPoint(p_295664_, this.getDimensions(this.getPose()), this.getScale() * this.getAgeScale()));
    }

    protected void lerpHeadRotationStep(int p_296134_, double p_296397_) {
        this.yHeadRot = (float)Mth.rotLerp(1.0 / (double)p_296134_, (double)this.yHeadRot, p_296397_);
    }

    @Override
    public void igniteForTicks(int p_319861_) {
        super.igniteForTicks(Mth.ceil((double)p_319861_ * this.getAttributeValue(Attributes.BURNING_TIME)));
    }

    public boolean hasInfiniteMaterials() {
        return false;
    }

    public boolean isInvulnerableTo(ServerLevel p_376575_, DamageSource p_345073_) {
        return this.isInvulnerableToBase(p_345073_) || EnchantmentHelper.isImmuneToDamage(p_376575_, this, p_345073_);
    }

    public static boolean canGlideUsing(ItemStack p_371257_, EquipmentSlot p_371482_) {
        if (!p_371257_.has(DataComponents.GLIDER)) {
            return false;
        }
        Equippable $$2 = p_371257_.get(DataComponents.EQUIPPABLE);
        return $$2 != null && p_371482_ == $$2.slot() && !p_371257_.nextDamageWillBreak();
    }

    @VisibleForTesting
    public int getLastHurtByPlayerMemoryTime() {
        return this.lastHurtByPlayerMemoryTime;
    }

    @Override
    public boolean isTransmittingWaypoint() {
        return this.getAttributeValue(Attributes.WAYPOINT_TRANSMIT_RANGE) > 0.0;
    }

    @Override
    public Optional<WaypointTransmitter.Connection> makeWaypointConnectionWith(ServerPlayer p_416500_) {
        if (this.firstTick || p_416500_ == this) {
            return Optional.empty();
        }
        if (WaypointTransmitter.doesSourceIgnoreReceiver(this, p_416500_)) {
            return Optional.empty();
        }
        Waypoint.Icon $$1 = this.locatorBarIcon.cloneAndAssignStyle(this);
        if (WaypointTransmitter.isReallyFar(this, p_416500_)) {
            return Optional.of(new WaypointTransmitter.EntityAzimuthConnection(this, $$1, p_416500_));
        }
        if (!WaypointTransmitter.isChunkVisible(this.chunkPosition(), p_416500_)) {
            return Optional.of(new WaypointTransmitter.EntityChunkConnection(this, $$1, p_416500_));
        }
        return Optional.of(new WaypointTransmitter.EntityBlockConnection(this, $$1, p_416500_));
    }

    @Override
    public Waypoint.Icon waypointIcon() {
        return this.locatorBarIcon;
    }

    public record Fallsounds(SoundEvent small, SoundEvent big) {
    }
}

