/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class LightningBolt
extends Entity {
    private static final int START_LIFE = 2;
    private static final double DAMAGE_RADIUS = 3.0;
    private static final double DETECTION_RADIUS = 15.0;
    private int life = 2;
    public long seed;
    private int flashes;
    private boolean visualOnly;
    @Nullable
    private ServerPlayer cause;
    private final Set<Entity> hitEntities = Sets.newHashSet();
    private int blocksSetOnFire;

    public LightningBolt(EntityType<? extends LightningBolt> p_20865_, Level p_20866_) {
        super(p_20865_, p_20866_);
        this.seed = this.random.nextLong();
        this.flashes = this.random.nextInt(3) + 1;
    }

    public void setVisualOnly(boolean p_20875_) {
        this.visualOnly = p_20875_;
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.WEATHER;
    }

    @Nullable
    public ServerPlayer getCause() {
        return this.cause;
    }

    public void setCause(@Nullable ServerPlayer p_20880_) {
        this.cause = p_20880_;
    }

    private void powerLightningRod() {
        BlockPos $$0 = this.getStrikePosition();
        BlockState $$1 = this.level().getBlockState($$0);
        if ($$1.is(Blocks.LIGHTNING_ROD)) {
            ((LightningRodBlock)$$1.getBlock()).onLightningStrike($$1, this.level(), $$0);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.life == 2) {
            if (this.level().isClientSide()) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.WEATHER, 10000.0f, 0.8f + this.random.nextFloat() * 0.2f, false);
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.LIGHTNING_BOLT_IMPACT, SoundSource.WEATHER, 2.0f, 0.5f + this.random.nextFloat() * 0.2f, false);
            } else {
                Difficulty $$0 = this.level().getDifficulty();
                if ($$0 == Difficulty.NORMAL || $$0 == Difficulty.HARD) {
                    this.spawnFire(4);
                }
                this.powerLightningRod();
                LightningBolt.clearCopperOnLightningStrike(this.level(), this.getStrikePosition());
                this.gameEvent(GameEvent.LIGHTNING_STRIKE);
            }
        }
        --this.life;
        if (this.life < 0) {
            if (this.flashes == 0) {
                if (this.level() instanceof ServerLevel) {
                    List<Entity> $$1 = this.level().getEntities(this, new AABB(this.getX() - 15.0, this.getY() - 15.0, this.getZ() - 15.0, this.getX() + 15.0, this.getY() + 6.0 + 15.0, this.getZ() + 15.0), p_147140_ -> p_147140_.isAlive() && !this.hitEntities.contains(p_147140_));
                    for (ServerPlayer $$2 : ((ServerLevel)this.level()).getPlayers(p_325666_ -> p_325666_.distanceTo(this) < 256.0f)) {
                        CriteriaTriggers.LIGHTNING_STRIKE.trigger($$2, this, $$1);
                    }
                }
                this.discard();
            } else if (this.life < -this.random.nextInt(10)) {
                --this.flashes;
                this.life = 1;
                this.seed = this.random.nextLong();
                this.spawnFire(0);
            }
        }
        if (this.life >= 0) {
            if (!(this.level() instanceof ServerLevel)) {
                this.level().setSkyFlashTime(2);
            } else if (!this.visualOnly) {
                List<Entity> $$3 = this.level().getEntities(this, new AABB(this.getX() - 3.0, this.getY() - 3.0, this.getZ() - 3.0, this.getX() + 3.0, this.getY() + 6.0 + 3.0, this.getZ() + 3.0), Entity::isAlive);
                for (Entity $$4 : $$3) {
                    $$4.thunderHit((ServerLevel)this.level(), this);
                }
                this.hitEntities.addAll($$3);
                if (this.cause != null) {
                    CriteriaTriggers.CHANNELED_LIGHTNING.trigger(this.cause, $$3);
                }
            }
        }
    }

    private BlockPos getStrikePosition() {
        Vec3 $$0 = this.position();
        return BlockPos.containing($$0.x, $$0.y - 1.0E-6, $$0.z);
    }

    private void spawnFire(int p_20871_) {
        ServerLevel $$1;
        Level level;
        if (this.visualOnly || !((level = this.level()) instanceof ServerLevel) || !($$1 = (ServerLevel)level).getGameRules().getBoolean(GameRules.RULE_DOFIRETICK)) {
            return;
        }
        BlockPos $$3 = this.blockPosition();
        BlockState $$4 = BaseFireBlock.getState(this.level(), $$3);
        if (this.level().getBlockState($$3).isAir() && $$4.canSurvive(this.level(), $$3)) {
            this.level().setBlockAndUpdate($$3, $$4);
            ++this.blocksSetOnFire;
        }
        for (int $$5 = 0; $$5 < p_20871_; ++$$5) {
            BlockPos $$6 = $$3.offset(this.random.nextInt(3) - 1, this.random.nextInt(3) - 1, this.random.nextInt(3) - 1);
            $$4 = BaseFireBlock.getState(this.level(), $$6);
            if (!this.level().getBlockState($$6).isAir() || !$$4.canSurvive(this.level(), $$6)) continue;
            this.level().setBlockAndUpdate($$6, $$4);
            ++this.blocksSetOnFire;
        }
    }

    private static void clearCopperOnLightningStrike(Level p_147151_, BlockPos p_147152_) {
        BlockState $$6;
        BlockPos $$5;
        BlockState $$2 = p_147151_.getBlockState(p_147152_);
        if ($$2.is(Blocks.LIGHTNING_ROD)) {
            BlockPos $$3 = p_147152_.relative(((Direction)$$2.getValue(LightningRodBlock.FACING)).getOpposite());
            BlockState $$4 = p_147151_.getBlockState($$3);
        } else {
            $$5 = p_147152_;
            $$6 = $$2;
        }
        if (!($$6.getBlock() instanceof WeatheringCopper)) {
            return;
        }
        p_147151_.setBlockAndUpdate($$5, WeatheringCopper.getFirst(p_147151_.getBlockState($$5)));
        BlockPos.MutableBlockPos $$7 = p_147152_.mutable();
        int $$8 = p_147151_.random.nextInt(3) + 3;
        for (int $$9 = 0; $$9 < $$8; ++$$9) {
            int $$10 = p_147151_.random.nextInt(8) + 1;
            LightningBolt.randomWalkCleaningCopper(p_147151_, $$5, $$7, $$10);
        }
    }

    private static void randomWalkCleaningCopper(Level p_147146_, BlockPos p_147147_, BlockPos.MutableBlockPos p_147148_, int p_147149_) {
        Optional<BlockPos> $$5;
        p_147148_.set(p_147147_);
        for (int $$4 = 0; $$4 < p_147149_ && !($$5 = LightningBolt.randomStepCleaningCopper(p_147146_, p_147148_)).isEmpty(); ++$$4) {
            p_147148_.set($$5.get());
        }
    }

    private static Optional<BlockPos> randomStepCleaningCopper(Level p_147154_, BlockPos p_147155_) {
        for (BlockPos $$2 : BlockPos.randomInCube(p_147154_.random, 10, p_147155_, 1)) {
            BlockState $$3 = p_147154_.getBlockState($$2);
            if (!($$3.getBlock() instanceof WeatheringCopper)) continue;
            WeatheringCopper.getPrevious($$3).ifPresent(p_147144_ -> p_147154_.setBlockAndUpdate($$2, (BlockState)p_147144_));
            p_147154_.levelEvent(3002, $$2, -1);
            return Optional.of($$2);
        }
        return Optional.empty();
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double p_20869_) {
        double $$1 = 64.0 * LightningBolt.getViewScale();
        return p_20869_ < $$1 * $$1;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_325966_) {
    }

    @Override
    protected void readAdditionalSaveData(ValueInput p_422519_) {
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput p_422582_) {
    }

    public int getBlocksSetOnFire() {
        return this.blocksSetOnFire;
    }

    public Stream<Entity> getHitEntities() {
        return this.hitEntities.stream().filter(Entity::isAlive);
    }

    @Override
    public final boolean hurtServer(ServerLevel p_376929_, DamageSource p_376634_, float p_376543_) {
        return false;
    }
}

