/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public interface Leashable {
    public static final String LEASH_TAG = "leash";
    public static final double LEASH_TOO_FAR_DIST = 12.0;
    public static final double LEASH_ELASTIC_DIST = 6.0;
    public static final double MAXIMUM_ALLOWED_LEASHED_DIST = 16.0;
    public static final Vec3 AXIS_SPECIFIC_ELASTICITY = new Vec3(0.8, 0.2, 0.8);
    public static final float SPRING_DAMPENING = 0.7f;
    public static final double TORSIONAL_ELASTICITY = 10.0;
    public static final double STIFFNESS = 0.11;
    public static final List<Vec3> ENTITY_ATTACHMENT_POINT = ImmutableList.of((Object)new Vec3(0.0, 0.5, 0.5));
    public static final List<Vec3> LEASHER_ATTACHMENT_POINT = ImmutableList.of((Object)new Vec3(0.0, 0.5, 0.0));
    public static final List<Vec3> SHARED_QUAD_ATTACHMENT_POINTS = ImmutableList.of((Object)new Vec3(-0.5, 0.5, 0.5), (Object)new Vec3(-0.5, 0.5, -0.5), (Object)new Vec3(0.5, 0.5, -0.5), (Object)new Vec3(0.5, 0.5, 0.5));

    @Nullable
    public LeashData getLeashData();

    public void setLeashData(@Nullable LeashData var1);

    default public boolean isLeashed() {
        return this.getLeashData() != null && this.getLeashData().leashHolder != null;
    }

    default public boolean mayBeLeashed() {
        return this.getLeashData() != null;
    }

    default public boolean canHaveALeashAttachedTo(Entity p_418026_) {
        if (this == p_418026_) {
            return false;
        }
        if (this.leashDistanceTo(p_418026_) > this.leashSnapDistance()) {
            return false;
        }
        return this.canBeLeashed();
    }

    default public double leashDistanceTo(Entity p_418359_) {
        return p_418359_.getBoundingBox().getCenter().distanceTo(((Entity)((Object)this)).getBoundingBox().getCenter());
    }

    default public boolean canBeLeashed() {
        return true;
    }

    default public void setDelayedLeashHolderId(int p_352387_) {
        this.setLeashData(new LeashData(p_352387_));
        Leashable.dropLeash((Entity)((Object)this), false, false);
    }

    default public void readLeashData(ValueInput p_422278_) {
        LeashData $$1 = p_422278_.read(LEASH_TAG, LeashData.CODEC).orElse(null);
        if (this.getLeashData() != null && $$1 == null) {
            this.removeLeash();
        }
        this.setLeashData($$1);
    }

    default public void writeLeashData(ValueOutput p_422090_, @Nullable LeashData p_352363_) {
        p_422090_.storeNullable(LEASH_TAG, LeashData.CODEC, p_352363_);
    }

    private static <E extends Entity> void restoreLeashFromSave(E p_352354_, LeashData p_352106_) {
        Level level;
        if (p_352106_.delayedLeashInfo != null && (level = p_352354_.level()) instanceof ServerLevel) {
            ServerLevel $$2 = (ServerLevel)level;
            Optional $$3 = p_352106_.delayedLeashInfo.left();
            Optional $$4 = p_352106_.delayedLeashInfo.right();
            if ($$3.isPresent()) {
                Entity $$5 = $$2.getEntity((UUID)$$3.get());
                if ($$5 != null) {
                    Leashable.setLeashedTo(p_352354_, $$5, true);
                    return;
                }
            } else if ($$4.isPresent()) {
                Leashable.setLeashedTo(p_352354_, LeashFenceKnotEntity.getOrCreateKnot($$2, (BlockPos)$$4.get()), true);
                return;
            }
            if (p_352354_.tickCount > 100) {
                p_352354_.spawnAtLocation($$2, Items.LEAD);
                ((Leashable)((Object)p_352354_)).setLeashData(null);
            }
        }
    }

    default public void dropLeash() {
        Leashable.dropLeash((Entity)((Object)this), true, true);
    }

    default public void removeLeash() {
        Leashable.dropLeash((Entity)((Object)this), true, false);
    }

    default public void onLeashRemoved() {
    }

    private static <E extends Entity> void dropLeash(E p_352163_, boolean p_352286_, boolean p_352272_) {
        LeashData $$3 = ((Leashable)((Object)p_352163_)).getLeashData();
        if ($$3 != null && $$3.leashHolder != null) {
            ((Leashable)((Object)p_352163_)).setLeashData(null);
            ((Leashable)((Object)p_352163_)).onLeashRemoved();
            Level level = p_352163_.level();
            if (level instanceof ServerLevel) {
                ServerLevel $$4 = (ServerLevel)level;
                if (p_352272_) {
                    p_352163_.spawnAtLocation($$4, Items.LEAD);
                }
                if (p_352286_) {
                    $$4.getChunkSource().broadcast(p_352163_, new ClientboundSetEntityLinkPacket(p_352163_, null));
                }
                $$3.leashHolder.notifyLeasheeRemoved((Leashable)((Object)p_352163_));
            }
        }
    }

    public static <E extends Entity> void tickLeash(ServerLevel p_376374_, E p_352082_) {
        Entity $$3;
        LeashData $$2 = ((Leashable)((Object)p_352082_)).getLeashData();
        if ($$2 != null && $$2.delayedLeashInfo != null) {
            Leashable.restoreLeashFromSave(p_352082_, $$2);
        }
        if ($$2 == null || $$2.leashHolder == null) {
            return;
        }
        if (!p_352082_.isAlive() || !$$2.leashHolder.isAlive()) {
            if (p_376374_.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                ((Leashable)((Object)p_352082_)).dropLeash();
            } else {
                ((Leashable)((Object)p_352082_)).removeLeash();
            }
        }
        if (($$3 = ((Leashable)((Object)p_352082_)).getLeashHolder()) != null && $$3.level() == p_352082_.level()) {
            double $$4 = ((Leashable)((Object)p_352082_)).leashDistanceTo($$3);
            ((Leashable)((Object)p_352082_)).whenLeashedTo($$3);
            if ($$4 > ((Leashable)((Object)p_352082_)).leashSnapDistance()) {
                p_376374_.playSound(null, $$3.getX(), $$3.getY(), $$3.getZ(), SoundEvents.LEAD_BREAK, SoundSource.NEUTRAL, 1.0f, 1.0f);
                ((Leashable)((Object)p_352082_)).leashTooFarBehaviour();
            } else if ($$4 > ((Leashable)((Object)p_352082_)).leashElasticDistance() - (double)$$3.getBbWidth() - (double)p_352082_.getBbWidth() && ((Leashable)((Object)p_352082_)).checkElasticInteractions($$3, $$2)) {
                ((Leashable)((Object)p_352082_)).onElasticLeashPull();
            } else {
                ((Leashable)((Object)p_352082_)).closeRangeLeashBehaviour($$3);
            }
            p_352082_.setYRot((float)((double)p_352082_.getYRot() - $$2.angularMomentum));
            $$2.angularMomentum *= (double)Leashable.angularFriction(p_352082_);
        }
    }

    default public void onElasticLeashPull() {
        Entity $$0 = (Entity)((Object)this);
        $$0.checkFallDistanceAccumulation();
    }

    default public double leashSnapDistance() {
        return 12.0;
    }

    default public double leashElasticDistance() {
        return 6.0;
    }

    public static <E extends Entity> float angularFriction(E p_418015_) {
        if (p_418015_.onGround()) {
            return p_418015_.level().getBlockState(p_418015_.getBlockPosBelowThatAffectsMyMovement()).getBlock().getFriction() * 0.91f;
        }
        if (p_418015_.isInLiquid()) {
            return 0.8f;
        }
        return 0.91f;
    }

    default public void whenLeashedTo(Entity p_418473_) {
        p_418473_.notifyLeashHolder(this);
    }

    default public void leashTooFarBehaviour() {
        this.dropLeash();
    }

    default public void closeRangeLeashBehaviour(Entity p_352073_) {
    }

    default public boolean checkElasticInteractions(Entity p_418481_, LeashData p_418158_) {
        boolean $$2 = p_418481_.supportQuadLeashAsHolder() && this.supportQuadLeash();
        List<Wrench> $$3 = Leashable.computeElasticInteraction((Entity)((Object)this), p_418481_, $$2 ? SHARED_QUAD_ATTACHMENT_POINTS : ENTITY_ATTACHMENT_POINT, $$2 ? SHARED_QUAD_ATTACHMENT_POINTS : LEASHER_ATTACHMENT_POINT);
        if ($$3.isEmpty()) {
            return false;
        }
        Wrench $$4 = Wrench.accumulate($$3).scale($$2 ? 0.25 : 1.0);
        p_418158_.angularMomentum += 10.0 * $$4.torque();
        Vec3 $$5 = Leashable.getHolderMovement(p_418481_).subtract(((Entity)((Object)this)).getKnownMovement());
        ((Entity)((Object)this)).addDeltaMovement($$4.force().multiply(AXIS_SPECIFIC_ELASTICITY).add($$5.scale(0.11)));
        return true;
    }

    private static Vec3 getHolderMovement(Entity p_426117_) {
        Mob $$1;
        if (p_426117_ instanceof Mob && ($$1 = (Mob)p_426117_).isNoAi()) {
            return Vec3.ZERO;
        }
        return p_426117_.getKnownMovement();
    }

    private static <E extends Entity> List<Wrench> computeElasticInteraction(E p_418297_, Entity p_418456_, List<Vec3> p_418351_, List<Vec3> p_418397_) {
        double $$4 = ((Leashable)((Object)p_418297_)).leashElasticDistance();
        Vec3 $$5 = Leashable.getHolderMovement(p_418297_);
        float $$6 = p_418297_.getYRot() * ((float)Math.PI / 180);
        Vec3 $$7 = new Vec3(p_418297_.getBbWidth(), p_418297_.getBbHeight(), p_418297_.getBbWidth());
        float $$8 = p_418456_.getYRot() * ((float)Math.PI / 180);
        Vec3 $$9 = new Vec3(p_418456_.getBbWidth(), p_418456_.getBbHeight(), p_418456_.getBbWidth());
        ArrayList<Wrench> $$10 = new ArrayList<Wrench>();
        for (int $$11 = 0; $$11 < p_418351_.size(); ++$$11) {
            Vec3 $$12 = p_418351_.get($$11).multiply($$7).yRot(-$$6);
            Vec3 $$13 = p_418297_.position().add($$12);
            Vec3 $$14 = p_418397_.get($$11).multiply($$9).yRot(-$$8);
            Vec3 $$15 = p_418456_.position().add($$14);
            Leashable.computeDampenedSpringInteraction($$15, $$13, $$4, $$5, $$12).ifPresent($$10::add);
        }
        return $$10;
    }

    private static Optional<Wrench> computeDampenedSpringInteraction(Vec3 p_418217_, Vec3 p_418024_, double p_418081_, Vec3 p_418190_, Vec3 p_418069_) {
        boolean $$8;
        double $$5 = p_418024_.distanceTo(p_418217_);
        if ($$5 < p_418081_) {
            return Optional.empty();
        }
        Vec3 $$6 = p_418217_.subtract(p_418024_).normalize().scale($$5 - p_418081_);
        double $$7 = Wrench.torqueFromForce(p_418069_, $$6);
        boolean bl = $$8 = p_418190_.dot($$6) >= 0.0;
        if ($$8) {
            $$6 = $$6.scale(0.3f);
        }
        return Optional.of(new Wrench($$6, $$7));
    }

    default public boolean supportQuadLeash() {
        return false;
    }

    default public Vec3[] getQuadLeashOffsets() {
        return Leashable.createQuadLeashOffsets((Entity)((Object)this), 0.0, 0.5, 0.5, 0.5);
    }

    public static Vec3[] createQuadLeashOffsets(Entity p_418142_, double p_418244_, double p_418078_, double p_418298_, double p_418121_) {
        float $$5 = p_418142_.getBbWidth();
        double $$6 = p_418244_ * (double)$$5;
        double $$7 = p_418078_ * (double)$$5;
        double $$8 = p_418298_ * (double)$$5;
        double $$9 = p_418121_ * (double)p_418142_.getBbHeight();
        return new Vec3[]{new Vec3(-$$8, $$9, $$7 + $$6), new Vec3(-$$8, $$9, -$$7 + $$6), new Vec3($$8, $$9, -$$7 + $$6), new Vec3($$8, $$9, $$7 + $$6)};
    }

    default public Vec3 getLeashOffset(float p_418480_) {
        return this.getLeashOffset();
    }

    default public Vec3 getLeashOffset() {
        Entity $$0 = (Entity)((Object)this);
        return new Vec3(0.0, $$0.getEyeHeight(), $$0.getBbWidth() * 0.4f);
    }

    default public void setLeashedTo(Entity p_352411_, boolean p_352183_) {
        if (this == p_352411_) {
            return;
        }
        Leashable.setLeashedTo((Entity)((Object)this), p_352411_, p_352183_);
    }

    private static <E extends Entity> void setLeashedTo(E p_352280_, Entity p_352109_, boolean p_352239_) {
        Level level;
        LeashData $$3 = ((Leashable)((Object)p_352280_)).getLeashData();
        if ($$3 == null) {
            $$3 = new LeashData(p_352109_);
            ((Leashable)((Object)p_352280_)).setLeashData($$3);
        } else {
            Entity $$4 = $$3.leashHolder;
            $$3.setLeashHolder(p_352109_);
            if ($$4 != null && $$4 != p_352109_) {
                $$4.notifyLeasheeRemoved((Leashable)((Object)p_352280_));
            }
        }
        if (p_352239_ && (level = p_352280_.level()) instanceof ServerLevel) {
            ServerLevel $$5 = (ServerLevel)level;
            $$5.getChunkSource().broadcast(p_352280_, new ClientboundSetEntityLinkPacket(p_352280_, p_352109_));
        }
        if (p_352280_.isPassenger()) {
            p_352280_.stopRiding();
        }
    }

    @Nullable
    default public Entity getLeashHolder() {
        return Leashable.getLeashHolder((Entity)((Object)this));
    }

    @Nullable
    private static <E extends Entity> Entity getLeashHolder(E p_352466_) {
        Entity entity;
        LeashData $$1 = ((Leashable)((Object)p_352466_)).getLeashData();
        if ($$1 == null) {
            return null;
        }
        if ($$1.delayedLeashHolderId != 0 && p_352466_.level().isClientSide && (entity = p_352466_.level().getEntity($$1.delayedLeashHolderId)) instanceof Entity) {
            Entity $$2 = entity;
            $$1.setLeashHolder($$2);
        }
        return $$1.leashHolder;
    }

    public static List<Leashable> leashableLeashedTo(Entity p_418021_) {
        return Leashable.leashableInArea(p_418021_, p_418528_ -> p_418528_.getLeashHolder() == p_418021_);
    }

    public static List<Leashable> leashableInArea(Entity p_418133_, Predicate<Leashable> p_418334_) {
        return Leashable.leashableInArea(p_418133_.level(), p_418133_.getBoundingBox().getCenter(), p_418334_);
    }

    public static List<Leashable> leashableInArea(Level p_418478_, Vec3 p_418494_, Predicate<Leashable> p_418347_) {
        double $$3 = 32.0;
        AABB $$4 = AABB.ofSize(p_418494_, 32.0, 32.0, 32.0);
        return p_418478_.getEntitiesOfClass(Entity.class, $$4, p_418131_ -> {
            Leashable $$2;
            return p_418131_ instanceof Leashable && p_418347_.test($$2 = (Leashable)((Object)p_418131_));
        }).stream().map(Leashable.class::cast).toList();
    }

    public static final class LeashData {
        public static final Codec<LeashData> CODEC = Codec.xor((Codec)UUIDUtil.CODEC.fieldOf("UUID").codec(), BlockPos.CODEC).xmap(LeashData::new, p_412912_ -> {
            Entity $$1 = p_412912_.leashHolder;
            if ($$1 instanceof LeashFenceKnotEntity) {
                LeashFenceKnotEntity $$2 = (LeashFenceKnotEntity)$$1;
                return Either.right((Object)$$2.getPos());
            }
            if (p_412912_.leashHolder != null) {
                return Either.left((Object)p_412912_.leashHolder.getUUID());
            }
            return Objects.requireNonNull(p_412912_.delayedLeashInfo, "Invalid LeashData had no attachment");
        });
        int delayedLeashHolderId;
        @Nullable
        public Entity leashHolder;
        @Nullable
        public Either<UUID, BlockPos> delayedLeashInfo;
        public double angularMomentum;

        private LeashData(Either<UUID, BlockPos> p_352282_) {
            this.delayedLeashInfo = p_352282_;
        }

        LeashData(Entity p_352066_) {
            this.leashHolder = p_352066_;
        }

        LeashData(int p_352297_) {
            this.delayedLeashHolderId = p_352297_;
        }

        public void setLeashHolder(Entity p_352464_) {
            this.leashHolder = p_352464_;
            this.delayedLeashInfo = null;
            this.delayedLeashHolderId = 0;
        }
    }

    public record Wrench(Vec3 force, double torque) {
        static Wrench ZERO = new Wrench(Vec3.ZERO, 0.0);

        static double torqueFromForce(Vec3 p_418322_, Vec3 p_418094_) {
            return p_418322_.z * p_418094_.x - p_418322_.x * p_418094_.z;
        }

        static Wrench accumulate(List<Wrench> p_418210_) {
            if (p_418210_.isEmpty()) {
                return ZERO;
            }
            double $$1 = 0.0;
            double $$2 = 0.0;
            double $$3 = 0.0;
            double $$4 = 0.0;
            for (Wrench $$5 : p_418210_) {
                Vec3 $$6 = $$5.force;
                $$1 += $$6.x;
                $$2 += $$6.y;
                $$3 += $$6.z;
                $$4 += $$5.torque;
            }
            return new Wrench(new Vec3($$1, $$2, $$3), $$4);
        }

        public Wrench scale(double p_418466_) {
            return new Wrench(this.force.scale(p_418466_), this.torque * p_418466_);
        }
    }
}

