/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ExperienceOrb
extends Entity {
    protected static final EntityDataAccessor<Integer> DATA_VALUE = SynchedEntityData.defineId(ExperienceOrb.class, EntityDataSerializers.INT);
    private static final int LIFETIME = 6000;
    private static final int ENTITY_SCAN_PERIOD = 20;
    private static final int MAX_FOLLOW_DIST = 8;
    private static final int ORB_GROUPS_PER_AREA = 40;
    private static final double ORB_MERGE_DISTANCE = 0.5;
    private static final short DEFAULT_HEALTH = 5;
    private static final short DEFAULT_AGE = 0;
    private static final short DEFAULT_VALUE = 0;
    private static final int DEFAULT_COUNT = 1;
    private int age = 0;
    private int health = 5;
    private int count = 1;
    @Nullable
    private Player followingPlayer;
    private final InterpolationHandler interpolation = new InterpolationHandler(this);

    public ExperienceOrb(Level p_20776_, double p_20777_, double p_20778_, double p_20779_, int p_20780_) {
        this(p_20776_, new Vec3(p_20777_, p_20778_, p_20779_), Vec3.ZERO, p_20780_);
    }

    public ExperienceOrb(Level p_421802_, Vec3 p_421749_, Vec3 p_422564_, int p_421793_) {
        this((EntityType<? extends ExperienceOrb>)EntityType.EXPERIENCE_ORB, p_421802_);
        this.setPos(p_421749_);
        if (!p_421802_.isClientSide) {
            this.setYRot(this.random.nextFloat() * 360.0f);
            Vec3 $$4 = new Vec3((this.random.nextDouble() * 0.2 - 0.1) * 2.0, this.random.nextDouble() * 0.2 * 2.0, (this.random.nextDouble() * 0.2 - 0.1) * 2.0);
            if (p_422564_.lengthSqr() > 0.0 && p_422564_.dot($$4) < 0.0) {
                $$4 = $$4.scale(-1.0);
            }
            double $$5 = this.getBoundingBox().getSize();
            this.setPos(p_421749_.add(p_422564_.normalize().scale($$5 * 0.5)));
            this.setDeltaMovement($$4);
            if (!p_421802_.noCollision(this.getBoundingBox())) {
                this.unstuckIfPossible($$5);
            }
        }
        this.setValue(p_421793_);
    }

    public ExperienceOrb(EntityType<? extends ExperienceOrb> p_20773_, Level p_20774_) {
        super(p_20773_, p_20774_);
    }

    protected void unstuckIfPossible(double p_427341_) {
        Vec3 $$1 = this.position().add(0.0, (double)this.getBbHeight() / 2.0, 0.0);
        VoxelShape $$2 = Shapes.create(AABB.ofSize($$1, p_427341_, p_427341_, p_427341_));
        this.level().findFreePosition(this, $$2, $$1, this.getBbWidth(), this.getBbHeight(), this.getBbWidth()).ifPresent(p_426977_ -> this.setPos(p_426977_.add(0.0, (double)(-this.getBbHeight()) / 2.0, 0.0)));
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_325930_) {
        p_325930_.define(DATA_VALUE, 0);
    }

    @Override
    protected double getDefaultGravity() {
        return 0.03;
    }

    @Override
    public void tick() {
        boolean $$0;
        this.interpolation.interpolate();
        if (this.firstTick && this.level().isClientSide) {
            this.firstTick = false;
            return;
        }
        super.tick();
        boolean bl = $$0 = !this.level().noCollision(this.getBoundingBox());
        if (this.isEyeInFluid(FluidTags.WATER)) {
            this.setUnderwaterMovement();
        } else if (!$$0) {
            this.applyGravity();
        }
        if (this.level().getFluidState(this.blockPosition()).is(FluidTags.LAVA)) {
            this.setDeltaMovement((this.random.nextFloat() - this.random.nextFloat()) * 0.2f, 0.2f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
        if (this.tickCount % 20 == 1) {
            this.scanForMerges();
        }
        this.followNearbyPlayer();
        if (this.followingPlayer == null && !this.level().isClientSide && $$0) {
            boolean $$1;
            boolean bl2 = $$1 = !this.level().noCollision(this.getBoundingBox().move(this.getDeltaMovement()));
            if ($$1) {
                this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
                this.hasImpulse = true;
            }
        }
        double $$2 = this.getDeltaMovement().y;
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.applyEffectsFromBlocks();
        float $$3 = 0.98f;
        if (this.onGround()) {
            $$3 = this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getFriction() * 0.98f;
        }
        this.setDeltaMovement(this.getDeltaMovement().scale($$3));
        if (this.verticalCollisionBelow && $$2 < -this.getGravity()) {
            this.setDeltaMovement(new Vec3(this.getDeltaMovement().x, -$$2 * 0.4, this.getDeltaMovement().z));
        }
        ++this.age;
        if (this.age >= 6000) {
            this.discard();
        }
    }

    private void followNearbyPlayer() {
        if (this.followingPlayer == null || this.followingPlayer.isSpectator() || this.followingPlayer.distanceToSqr(this) > 64.0) {
            Player $$0 = this.level().getNearestPlayer(this, 8.0);
            this.followingPlayer = $$0 != null && !$$0.isSpectator() && !$$0.isDeadOrDying() ? $$0 : null;
        }
        if (this.followingPlayer != null) {
            Vec3 $$1 = new Vec3(this.followingPlayer.getX() - this.getX(), this.followingPlayer.getY() + (double)this.followingPlayer.getEyeHeight() / 2.0 - this.getY(), this.followingPlayer.getZ() - this.getZ());
            double $$2 = $$1.lengthSqr();
            double $$3 = 1.0 - Math.sqrt($$2) / 8.0;
            this.setDeltaMovement(this.getDeltaMovement().add($$1.normalize().scale($$3 * $$3 * 0.1)));
        }
    }

    @Override
    public BlockPos getBlockPosBelowThatAffectsMyMovement() {
        return this.getOnPos(0.999999f);
    }

    private void scanForMerges() {
        if (this.level() instanceof ServerLevel) {
            List<ExperienceOrb> $$0 = this.level().getEntities(EntityTypeTest.forClass(ExperienceOrb.class), this.getBoundingBox().inflate(0.5), this::canMerge);
            for (ExperienceOrb $$1 : $$0) {
                this.merge($$1);
            }
        }
    }

    public static void award(ServerLevel p_147083_, Vec3 p_147084_, int p_147085_) {
        ExperienceOrb.awardWithDirection(p_147083_, p_147084_, Vec3.ZERO, p_147085_);
    }

    public static void awardWithDirection(ServerLevel p_421908_, Vec3 p_421728_, Vec3 p_422695_, int p_422116_) {
        while (p_422116_ > 0) {
            int $$4 = ExperienceOrb.getExperienceValue(p_422116_);
            p_422116_ -= $$4;
            if (ExperienceOrb.tryMergeToExisting(p_421908_, p_421728_, $$4)) continue;
            p_421908_.addFreshEntity(new ExperienceOrb(p_421908_, p_421728_, p_422695_, $$4));
        }
    }

    private static boolean tryMergeToExisting(ServerLevel p_147097_, Vec3 p_147098_, int p_147099_) {
        AABB $$3 = AABB.ofSize(p_147098_, 1.0, 1.0, 1.0);
        int $$4 = p_147097_.getRandom().nextInt(40);
        List<ExperienceOrb> $$5 = p_147097_.getEntities(EntityTypeTest.forClass(ExperienceOrb.class), $$3, p_147081_ -> ExperienceOrb.canMerge(p_147081_, $$4, p_147099_));
        if (!$$5.isEmpty()) {
            ExperienceOrb $$6 = $$5.get(0);
            ++$$6.count;
            $$6.age = 0;
            return true;
        }
        return false;
    }

    private boolean canMerge(ExperienceOrb p_147087_) {
        return p_147087_ != this && ExperienceOrb.canMerge(p_147087_, this.getId(), this.getValue());
    }

    private static boolean canMerge(ExperienceOrb p_147089_, int p_147090_, int p_147091_) {
        return !p_147089_.isRemoved() && (p_147089_.getId() - p_147090_) % 40 == 0 && p_147089_.getValue() == p_147091_;
    }

    private void merge(ExperienceOrb p_147101_) {
        this.count += p_147101_.count;
        this.age = Math.min(this.age, p_147101_.age);
        p_147101_.discard();
    }

    private void setUnderwaterMovement() {
        Vec3 $$0 = this.getDeltaMovement();
        this.setDeltaMovement($$0.x * (double)0.99f, Math.min($$0.y + (double)5.0E-4f, (double)0.06f), $$0.z * (double)0.99f);
    }

    @Override
    protected void doWaterSplashEffect() {
    }

    @Override
    public final boolean hurtClient(DamageSource p_376512_) {
        return !this.isInvulnerableToBase(p_376512_);
    }

    @Override
    public final boolean hurtServer(ServerLevel p_376093_, DamageSource p_376744_, float p_376626_) {
        if (this.isInvulnerableToBase(p_376744_)) {
            return false;
        }
        this.markHurt();
        this.health = (int)((float)this.health - p_376626_);
        if (this.health <= 0) {
            this.discard();
        }
        return true;
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput p_421814_) {
        p_421814_.putShort("Health", (short)this.health);
        p_421814_.putShort("Age", (short)this.age);
        p_421814_.putShort("Value", (short)this.getValue());
        p_421814_.putInt("Count", this.count);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput p_422243_) {
        this.health = p_422243_.getShortOr("Health", (short)5);
        this.age = p_422243_.getShortOr("Age", (short)0);
        this.setValue(p_422243_.getShortOr("Value", (short)0));
        this.count = p_422243_.read("Count", ExtraCodecs.POSITIVE_INT).orElse(1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void playerTouch(Player p_20792_) {
        if (!(p_20792_ instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer $$1 = (ServerPlayer)p_20792_;
        if (p_20792_.takeXpDelay == 0) {
            void $$2;
            p_20792_.takeXpDelay = 2;
            p_20792_.take(this, 1);
            int $$3 = this.repairPlayerItems((ServerPlayer)$$2, this.getValue());
            if ($$3 > 0) {
                p_20792_.giveExperiencePoints($$3);
            }
            --this.count;
            if (this.count == 0) {
                this.discard();
            }
        }
    }

    private int repairPlayerItems(ServerPlayer p_344821_, int p_147094_) {
        Optional<EnchantedItemInUse> $$2 = EnchantmentHelper.getRandomItemWith(EnchantmentEffectComponents.REPAIR_WITH_XP, p_344821_, ItemStack::isDamaged);
        if ($$2.isPresent()) {
            int $$6;
            ItemStack $$3 = $$2.get().itemStack();
            int $$4 = EnchantmentHelper.modifyDurabilityToRepairFromXp(p_344821_.level(), $$3, p_147094_);
            int $$5 = Math.min($$4, $$3.getDamageValue());
            $$3.setDamageValue($$3.getDamageValue() - $$5);
            if ($$5 > 0 && ($$6 = p_147094_ - $$5 * p_147094_ / $$4) > 0) {
                return this.repairPlayerItems(p_344821_, $$6);
            }
            return 0;
        }
        return p_147094_;
    }

    public int getValue() {
        return this.entityData.get(DATA_VALUE);
    }

    private void setValue(int p_397993_) {
        this.entityData.set(DATA_VALUE, p_397993_);
    }

    public int getIcon() {
        int $$0 = this.getValue();
        if ($$0 >= 2477) {
            return 10;
        }
        if ($$0 >= 1237) {
            return 9;
        }
        if ($$0 >= 617) {
            return 8;
        }
        if ($$0 >= 307) {
            return 7;
        }
        if ($$0 >= 149) {
            return 6;
        }
        if ($$0 >= 73) {
            return 5;
        }
        if ($$0 >= 37) {
            return 4;
        }
        if ($$0 >= 17) {
            return 3;
        }
        if ($$0 >= 7) {
            return 2;
        }
        if ($$0 >= 3) {
            return 1;
        }
        return 0;
    }

    public static int getExperienceValue(int p_20783_) {
        if (p_20783_ >= 2477) {
            return 2477;
        }
        if (p_20783_ >= 1237) {
            return 1237;
        }
        if (p_20783_ >= 617) {
            return 617;
        }
        if (p_20783_ >= 307) {
            return 307;
        }
        if (p_20783_ >= 149) {
            return 149;
        }
        if (p_20783_ >= 73) {
            return 73;
        }
        if (p_20783_ >= 37) {
            return 37;
        }
        if (p_20783_ >= 17) {
            return 17;
        }
        if (p_20783_ >= 7) {
            return 7;
        }
        if (p_20783_ >= 3) {
            return 3;
        }
        return 1;
    }

    @Override
    public boolean isAttackable() {
        return false;
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.AMBIENT;
    }

    @Override
    public InterpolationHandler getInterpolation() {
        return this.interpolation;
    }
}

