/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;

public interface EquipmentUser {
    public void setItemSlot(EquipmentSlot var1, ItemStack var2);

    public ItemStack getItemBySlot(EquipmentSlot var1);

    public void setDropChance(EquipmentSlot var1, float var2);

    default public void equip(EquipmentTable p_340994_, LootParams p_338408_) {
        this.equip(p_340994_.lootTable(), p_338408_, p_340994_.slotDropChances());
    }

    default public void equip(ResourceKey<LootTable> p_341330_, LootParams p_340863_, Map<EquipmentSlot, Float> p_341011_) {
        this.equip(p_341330_, p_340863_, 0L, p_341011_);
    }

    default public void equip(ResourceKey<LootTable> p_340873_, LootParams p_338202_, long p_341024_, Map<EquipmentSlot, Float> p_341367_) {
        LootTable $$4 = p_338202_.getLevel().getServer().reloadableRegistries().getLootTable(p_340873_);
        if ($$4 == LootTable.EMPTY) {
            return;
        }
        ObjectArrayList<ItemStack> $$5 = $$4.getRandomItems(p_338202_, p_341024_);
        ArrayList<EquipmentSlot> $$6 = new ArrayList<EquipmentSlot>();
        for (ItemStack $$7 : $$5) {
            EquipmentSlot $$8 = this.resolveSlot($$7, $$6);
            if ($$8 == null) continue;
            ItemStack $$9 = $$8.limit($$7);
            this.setItemSlot($$8, $$9);
            Float $$10 = p_341367_.get($$8);
            if ($$10 != null) {
                this.setDropChance($$8, $$10.floatValue());
            }
            $$6.add($$8);
        }
    }

    @Nullable
    default public EquipmentSlot resolveSlot(ItemStack p_338225_, List<EquipmentSlot> p_338547_) {
        if (p_338225_.isEmpty()) {
            return null;
        }
        Equippable $$2 = p_338225_.get(DataComponents.EQUIPPABLE);
        if ($$2 != null) {
            EquipmentSlot $$3 = $$2.slot();
            if (!p_338547_.contains($$3)) {
                return $$3;
            }
        } else if (!p_338547_.contains(EquipmentSlot.MAINHAND)) {
            return EquipmentSlot.MAINHAND;
        }
        return null;
    }
}

