/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.level.storage.loot.LootTable;

public record EquipmentTable(ResourceKey<LootTable> lootTable, Map<EquipmentSlot, Float> slotDropChances) {
    public static final Codec<Map<EquipmentSlot, Float>> DROP_CHANCES_CODEC = Codec.either((Codec)Codec.FLOAT, (Codec)Codec.unboundedMap(EquipmentSlot.CODEC, (Codec)Codec.FLOAT)).xmap(p_341273_ -> (Map)p_341273_.map(EquipmentTable::createForAllSlots, Function.identity()), p_379073_ -> {
        boolean $$1 = p_379073_.values().stream().distinct().count() == 1L;
        boolean $$2 = p_379073_.keySet().containsAll(EquipmentSlot.VALUES);
        if ($$1 && $$2) {
            return Either.left((Object)p_379073_.values().stream().findFirst().orElse(Float.valueOf(0.0f)));
        }
        return Either.right((Object)p_379073_);
    });
    public static final Codec<EquipmentTable> CODEC = RecordCodecBuilder.create(p_404272_ -> p_404272_.group((App)LootTable.KEY_CODEC.fieldOf("loot_table").forGetter(EquipmentTable::lootTable), (App)DROP_CHANCES_CODEC.optionalFieldOf("slot_drop_chances", Map.of()).forGetter(EquipmentTable::slotDropChances)).apply((Applicative)p_404272_, EquipmentTable::new));

    public EquipmentTable(ResourceKey<LootTable> p_368531_, float p_368593_) {
        this(p_368531_, EquipmentTable.createForAllSlots(p_368593_));
    }

    private static Map<EquipmentSlot, Float> createForAllSlots(float p_340946_) {
        return EquipmentTable.createForAllSlots(List.of(EquipmentSlot.values()), p_340946_);
    }

    private static Map<EquipmentSlot, Float> createForAllSlots(List<EquipmentSlot> p_340910_, float p_341369_) {
        HashMap $$2 = Maps.newHashMap();
        for (EquipmentSlot $$3 : p_340910_) {
            $$2.put($$3, Float.valueOf(p_341369_));
        }
        return $$2;
    }
}

