/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public class RandomSequences
extends SavedData {
    public static final SavedDataType<RandomSequences> TYPE = new SavedDataType<RandomSequences>("random_sequences", p_400904_ -> new RandomSequences(p_400904_.worldSeed()), p_400907_ -> RandomSequences.codec(p_400907_.worldSeed()), DataFixTypes.SAVED_DATA_RANDOM_SEQUENCES);
    private final long worldSeed;
    private int salt;
    private boolean includeWorldSeed = true;
    private boolean includeSequenceId = true;
    private final Map<ResourceLocation, RandomSequence> sequences = new Object2ObjectOpenHashMap();

    public RandomSequences(long p_287622_) {
        this.worldSeed = p_287622_;
    }

    private RandomSequences(long p_401061_, int p_401155_, boolean p_401045_, boolean p_401271_, Map<ResourceLocation, RandomSequence> p_401273_) {
        this.worldSeed = p_401061_;
        this.salt = p_401155_;
        this.includeWorldSeed = p_401045_;
        this.includeSequenceId = p_401271_;
        this.sequences.putAll(p_401273_);
    }

    public static Codec<RandomSequences> codec(long p_401391_) {
        return RecordCodecBuilder.create(p_400903_ -> p_400903_.group((App)RecordCodecBuilder.point((Object)p_401391_), (App)Codec.INT.fieldOf("salt").forGetter(p_400908_ -> p_400908_.salt), (App)Codec.BOOL.optionalFieldOf("include_world_seed", (Object)true).forGetter(p_400909_ -> p_400909_.includeWorldSeed), (App)Codec.BOOL.optionalFieldOf("include_sequence_id", (Object)true).forGetter(p_400905_ -> p_400905_.includeSequenceId), (App)Codec.unboundedMap(ResourceLocation.CODEC, RandomSequence.CODEC).fieldOf("sequences").forGetter(p_400906_ -> p_400906_.sequences)).apply((Applicative)p_400903_, RandomSequences::new));
    }

    public RandomSource get(ResourceLocation p_287751_) {
        RandomSource $$1 = this.sequences.computeIfAbsent(p_287751_, this::createSequence).random();
        return new DirtyMarkingRandomSource($$1);
    }

    private RandomSequence createSequence(ResourceLocation p_295796_) {
        return this.createSequence(p_295796_, this.salt, this.includeWorldSeed, this.includeSequenceId);
    }

    private RandomSequence createSequence(ResourceLocation p_295614_, int p_296284_, boolean p_296271_, boolean p_295917_) {
        long $$4 = (p_296271_ ? this.worldSeed : 0L) ^ (long)p_296284_;
        return new RandomSequence($$4, p_295917_ ? Optional.of(p_295614_) : Optional.empty());
    }

    public void forAllSequences(BiConsumer<ResourceLocation, RandomSequence> p_294252_) {
        this.sequences.forEach(p_294252_);
    }

    public void setSeedDefaults(int p_294511_, boolean p_294255_, boolean p_295889_) {
        this.salt = p_294511_;
        this.includeWorldSeed = p_294255_;
        this.includeSequenceId = p_295889_;
    }

    public int clear() {
        int $$0 = this.sequences.size();
        this.sequences.clear();
        return $$0;
    }

    public void reset(ResourceLocation p_296099_) {
        this.sequences.put(p_296099_, this.createSequence(p_296099_));
    }

    public void reset(ResourceLocation p_294608_, int p_295700_, boolean p_296000_, boolean p_294735_) {
        this.sequences.put(p_294608_, this.createSequence(p_294608_, p_295700_, p_296000_, p_294735_));
    }

    class DirtyMarkingRandomSource
    implements RandomSource {
        private final RandomSource random;

        DirtyMarkingRandomSource(RandomSource p_295768_) {
            this.random = p_295768_;
        }

        @Override
        public RandomSource fork() {
            RandomSequences.this.setDirty();
            return this.random.fork();
        }

        @Override
        public PositionalRandomFactory forkPositional() {
            RandomSequences.this.setDirty();
            return this.random.forkPositional();
        }

        @Override
        public void setSeed(long p_295551_) {
            RandomSequences.this.setDirty();
            this.random.setSeed(p_295551_);
        }

        @Override
        public int nextInt() {
            RandomSequences.this.setDirty();
            return this.random.nextInt();
        }

        @Override
        public int nextInt(int p_294632_) {
            RandomSequences.this.setDirty();
            return this.random.nextInt(p_294632_);
        }

        @Override
        public long nextLong() {
            RandomSequences.this.setDirty();
            return this.random.nextLong();
        }

        @Override
        public boolean nextBoolean() {
            RandomSequences.this.setDirty();
            return this.random.nextBoolean();
        }

        @Override
        public float nextFloat() {
            RandomSequences.this.setDirty();
            return this.random.nextFloat();
        }

        @Override
        public double nextDouble() {
            RandomSequences.this.setDirty();
            return this.random.nextDouble();
        }

        @Override
        public double nextGaussian() {
            RandomSequences.this.setDirty();
            return this.random.nextGaussian();
        }

        public boolean equals(Object p_294463_) {
            if (this == p_294463_) {
                return true;
            }
            if (p_294463_ instanceof DirtyMarkingRandomSource) {
                DirtyMarkingRandomSource $$1 = (DirtyMarkingRandomSource)p_294463_;
                return this.random.equals($$1.random);
            }
            return false;
        }
    }
}

