/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class ContainerHelper {
    public static final String TAG_ITEMS = "Items";

    public static ItemStack removeItem(List<ItemStack> p_18970_, int p_18971_, int p_18972_) {
        if (p_18971_ < 0 || p_18971_ >= p_18970_.size() || p_18970_.get(p_18971_).isEmpty() || p_18972_ <= 0) {
            return ItemStack.EMPTY;
        }
        return p_18970_.get(p_18971_).split(p_18972_);
    }

    public static ItemStack takeItem(List<ItemStack> p_18967_, int p_18968_) {
        if (p_18968_ < 0 || p_18968_ >= p_18967_.size()) {
            return ItemStack.EMPTY;
        }
        return p_18967_.set(p_18968_, ItemStack.EMPTY);
    }

    public static void saveAllItems(ValueOutput p_422101_, NonNullList<ItemStack> p_18975_) {
        ContainerHelper.saveAllItems(p_422101_, p_18975_, true);
    }

    public static void saveAllItems(ValueOutput p_421921_, NonNullList<ItemStack> p_18978_, boolean p_18979_) {
        ValueOutput.TypedOutputList<ItemStackWithSlot> $$3 = p_421921_.list(TAG_ITEMS, ItemStackWithSlot.CODEC);
        for (int $$4 = 0; $$4 < p_18978_.size(); ++$$4) {
            ItemStack $$5 = p_18978_.get($$4);
            if ($$5.isEmpty()) continue;
            $$3.add(new ItemStackWithSlot($$4, $$5));
        }
        if ($$3.isEmpty() && !p_18979_) {
            p_421921_.discard(TAG_ITEMS);
        }
    }

    public static void loadAllItems(ValueInput p_422226_, NonNullList<ItemStack> p_18982_) {
        for (ItemStackWithSlot $$2 : p_422226_.listOrEmpty(TAG_ITEMS, ItemStackWithSlot.CODEC)) {
            if (!$$2.isValidInContainer(p_18982_.size())) continue;
            p_18982_.set($$2.slot(), $$2.stack());
        }
    }

    public static int clearOrCountMatchingItems(Container p_18957_, Predicate<ItemStack> p_18958_, int p_18959_, boolean p_18960_) {
        int $$4 = 0;
        for (int $$5 = 0; $$5 < p_18957_.getContainerSize(); ++$$5) {
            ItemStack $$6 = p_18957_.getItem($$5);
            int $$7 = ContainerHelper.clearOrCountMatchingItems($$6, p_18958_, p_18959_ - $$4, p_18960_);
            if ($$7 > 0 && !p_18960_ && $$6.isEmpty()) {
                p_18957_.setItem($$5, ItemStack.EMPTY);
            }
            $$4 += $$7;
        }
        return $$4;
    }

    public static int clearOrCountMatchingItems(ItemStack p_18962_, Predicate<ItemStack> p_18963_, int p_18964_, boolean p_18965_) {
        if (p_18962_.isEmpty() || !p_18963_.test(p_18962_)) {
            return 0;
        }
        if (p_18965_) {
            return p_18962_.getCount();
        }
        int $$4 = p_18964_ < 0 ? p_18962_.getCount() : Math.min(p_18964_, p_18962_.getCount());
        p_18962_.shrink($$4);
        return $$4;
    }
}

