/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.worldupdate;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Reference2FloatMap;
import it.unimi.dsi.fastutil.objects.Reference2FloatMaps;
import it.unimi.dsi.fastutil.objects.Reference2FloatOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.chunk.storage.RecreatingChunkStorage;
import net.minecraft.world.level.chunk.storage.RecreatingSimpleRegionStorage;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.WorldData;
import org.slf4j.Logger;

public class WorldUpgrader
implements AutoCloseable {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setDaemon(true).build();
    private static final String NEW_DIRECTORY_PREFIX = "new_";
    static final Component STATUS_UPGRADING_POI = Component.translatable("optimizeWorld.stage.upgrading.poi");
    static final Component STATUS_FINISHED_POI = Component.translatable("optimizeWorld.stage.finished.poi");
    static final Component STATUS_UPGRADING_ENTITIES = Component.translatable("optimizeWorld.stage.upgrading.entities");
    static final Component STATUS_FINISHED_ENTITIES = Component.translatable("optimizeWorld.stage.finished.entities");
    static final Component STATUS_UPGRADING_CHUNKS = Component.translatable("optimizeWorld.stage.upgrading.chunks");
    static final Component STATUS_FINISHED_CHUNKS = Component.translatable("optimizeWorld.stage.finished.chunks");
    final Registry<LevelStem> dimensions;
    final Set<ResourceKey<Level>> levels;
    final boolean eraseCache;
    final boolean recreateRegionFiles;
    final LevelStorageSource.LevelStorageAccess levelStorage;
    private final Thread thread;
    final DataFixer dataFixer;
    volatile boolean running = true;
    private volatile boolean finished;
    volatile float progress;
    volatile int totalChunks;
    volatile int totalFiles;
    volatile int converted;
    volatile int skipped;
    final Reference2FloatMap<ResourceKey<Level>> progressMap = Reference2FloatMaps.synchronize((Reference2FloatMap)new Reference2FloatOpenHashMap());
    volatile Component status = Component.translatable("optimizeWorld.stage.counting");
    static final Pattern REGEX = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
    final DimensionDataStorage overworldDataStorage;

    public WorldUpgrader(LevelStorageSource.LevelStorageAccess p_249922_, DataFixer p_250273_, WorldData p_401329_, RegistryAccess p_323645_, boolean p_250738_, boolean p_321700_) {
        this.dimensions = p_323645_.lookupOrThrow(Registries.LEVEL_STEM);
        this.levels = this.dimensions.registryKeySet().stream().map(Registries::levelStemToLevel).collect(Collectors.toUnmodifiableSet());
        this.eraseCache = p_250738_;
        this.dataFixer = p_250273_;
        this.levelStorage = p_249922_;
        SavedData.Context $$6 = new SavedData.Context(null, p_401329_.worldGenOptions().seed());
        this.overworldDataStorage = new DimensionDataStorage($$6, this.levelStorage.getDimensionPath(Level.OVERWORLD).resolve("data"), p_250273_, p_323645_);
        this.recreateRegionFiles = p_321700_;
        this.thread = THREAD_FACTORY.newThread(this::work);
        this.thread.setUncaughtExceptionHandler((p_18825_, p_18826_) -> {
            LOGGER.error("Error upgrading world", p_18826_);
            this.status = Component.translatable("optimizeWorld.stage.failed");
            this.finished = true;
        });
        this.thread.start();
    }

    public void cancel() {
        this.running = false;
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void work() {
        long $$0 = Util.getMillis();
        LOGGER.info("Upgrading entities");
        new EntityUpgrader(this).upgrade();
        LOGGER.info("Upgrading POIs");
        new PoiUpgrader(this).upgrade();
        LOGGER.info("Upgrading blocks");
        new ChunkUpgrader().upgrade();
        this.overworldDataStorage.saveAndJoin();
        $$0 = Util.getMillis() - $$0;
        LOGGER.info("World optimizaton finished after {} seconds", (Object)($$0 / 1000L));
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Set<ResourceKey<Level>> levels() {
        return this.levels;
    }

    public float dimensionProgress(ResourceKey<Level> p_18828_) {
        return this.progressMap.getFloat(p_18828_);
    }

    public float getProgress() {
        return this.progress;
    }

    public int getTotalChunks() {
        return this.totalChunks;
    }

    public int getConverted() {
        return this.converted;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public Component getStatus() {
        return this.status;
    }

    @Override
    public void close() {
        this.overworldDataStorage.close();
    }

    static Path resolveRecreateDirectory(Path p_326514_) {
        return p_326514_.resolveSibling(NEW_DIRECTORY_PREFIX + p_326514_.getFileName().toString());
    }

    class EntityUpgrader
    extends SimpleRegionStorageUpgrader {
        EntityUpgrader(WorldUpgrader worldUpgrader) {
            super(DataFixTypes.ENTITY_CHUNK, "entities", STATUS_UPGRADING_ENTITIES, STATUS_FINISHED_ENTITIES);
        }

        @Override
        protected CompoundTag upgradeTag(SimpleRegionStorage p_321667_, CompoundTag p_321776_) {
            return p_321667_.upgradeChunkTag(p_321776_, -1);
        }
    }

    class PoiUpgrader
    extends SimpleRegionStorageUpgrader {
        PoiUpgrader(WorldUpgrader worldUpgrader) {
            super(DataFixTypes.POI_CHUNK, "poi", STATUS_UPGRADING_POI, STATUS_FINISHED_POI);
        }

        @Override
        protected CompoundTag upgradeTag(SimpleRegionStorage p_321589_, CompoundTag p_321492_) {
            return p_321589_.upgradeChunkTag(p_321492_, 1945);
        }
    }

    class ChunkUpgrader
    extends AbstractUpgrader<ChunkStorage> {
        ChunkUpgrader() {
            super(DataFixTypes.CHUNK, "chunk", "region", STATUS_UPGRADING_CHUNKS, STATUS_FINISHED_CHUNKS);
        }

        @Override
        protected boolean tryProcessOnePosition(ChunkStorage p_321581_, ChunkPos p_321524_, ResourceKey<Level> p_321488_) {
            CompoundTag $$3 = p_321581_.read(p_321524_).join().orElse(null);
            if ($$3 != null) {
                boolean $$8;
                int $$4 = ChunkStorage.getVersion($$3);
                ChunkGenerator $$5 = WorldUpgrader.this.dimensions.getValueOrThrow(Registries.levelToLevelStem(p_321488_)).generator();
                CompoundTag $$6 = p_321581_.upgradeChunkTag(p_321488_, () -> WorldUpgrader.this.overworldDataStorage, $$3, $$5.getTypeNameForDataFixer());
                ChunkPos $$7 = new ChunkPos($$6.getIntOr("xPos", 0), $$6.getIntOr("zPos", 0));
                if (!$$7.equals(p_321524_)) {
                    LOGGER.warn("Chunk {} has invalid position {}", (Object)p_321524_, (Object)$$7);
                }
                boolean bl = $$8 = $$4 < SharedConstants.getCurrentVersion().dataVersion().version();
                if (WorldUpgrader.this.eraseCache) {
                    $$8 = $$8 || $$6.contains("Heightmaps");
                    $$6.remove("Heightmaps");
                    $$8 = $$8 || $$6.contains("isLightOn");
                    $$6.remove("isLightOn");
                    ListTag $$9 = $$6.getListOrEmpty("sections");
                    for (int $$10 = 0; $$10 < $$9.size(); ++$$10) {
                        Optional<CompoundTag> $$11 = $$9.getCompound($$10);
                        if ($$11.isEmpty()) continue;
                        CompoundTag $$12 = $$11.get();
                        $$8 = $$8 || $$12.contains("BlockLight");
                        $$12.remove("BlockLight");
                        $$8 = $$8 || $$12.contains("SkyLight");
                        $$12.remove("SkyLight");
                    }
                }
                if ($$8 || WorldUpgrader.this.recreateRegionFiles) {
                    if (this.previousWriteFuture != null) {
                        this.previousWriteFuture.join();
                    }
                    this.previousWriteFuture = p_321581_.write(p_321524_, () -> $$6);
                    return true;
                }
            }
            return false;
        }

        @Override
        protected ChunkStorage createStorage(RegionStorageInfo p_325989_, Path p_321746_) {
            return WorldUpgrader.this.recreateRegionFiles ? new RecreatingChunkStorage(p_325989_.withTypeSuffix("source"), p_321746_, p_325989_.withTypeSuffix("target"), WorldUpgrader.resolveRecreateDirectory(p_321746_), WorldUpgrader.this.dataFixer, true) : new ChunkStorage(p_325989_, p_321746_, WorldUpgrader.this.dataFixer, true);
        }

        @Override
        protected /* synthetic */ AutoCloseable createStorage(RegionStorageInfo regionStorageInfo, Path path) {
            return this.createStorage(regionStorageInfo, path);
        }
    }

    abstract class SimpleRegionStorageUpgrader
    extends AbstractUpgrader<SimpleRegionStorage> {
        SimpleRegionStorageUpgrader(DataFixTypes p_321688_, String p_321507_, Component p_361813_, Component p_363065_) {
            super(p_321688_, p_321507_, p_321507_, p_361813_, p_363065_);
        }

        @Override
        protected SimpleRegionStorage createStorage(RegionStorageInfo p_325941_, Path p_321595_) {
            return WorldUpgrader.this.recreateRegionFiles ? new RecreatingSimpleRegionStorage(p_325941_.withTypeSuffix("source"), p_321595_, p_325941_.withTypeSuffix("target"), WorldUpgrader.resolveRecreateDirectory(p_321595_), WorldUpgrader.this.dataFixer, true, this.dataFixType) : new SimpleRegionStorage(p_325941_, p_321595_, WorldUpgrader.this.dataFixer, true, this.dataFixType);
        }

        @Override
        protected boolean tryProcessOnePosition(SimpleRegionStorage p_321490_, ChunkPos p_321657_, ResourceKey<Level> p_321485_) {
            CompoundTag $$3 = p_321490_.read(p_321657_).join().orElse(null);
            if ($$3 != null) {
                boolean $$6;
                int $$4 = ChunkStorage.getVersion($$3);
                CompoundTag $$5 = this.upgradeTag(p_321490_, $$3);
                boolean bl = $$6 = $$4 < SharedConstants.getCurrentVersion().dataVersion().version();
                if ($$6 || WorldUpgrader.this.recreateRegionFiles) {
                    if (this.previousWriteFuture != null) {
                        this.previousWriteFuture.join();
                    }
                    this.previousWriteFuture = p_321490_.write(p_321657_, $$5);
                    return true;
                }
            }
            return false;
        }

        protected abstract CompoundTag upgradeTag(SimpleRegionStorage var1, CompoundTag var2);

        @Override
        protected /* synthetic */ AutoCloseable createStorage(RegionStorageInfo regionStorageInfo, Path path) {
            return this.createStorage(regionStorageInfo, path);
        }
    }

    abstract class AbstractUpgrader<T extends AutoCloseable> {
        private final Component upgradingStatus;
        private final Component finishedStatus;
        private final String type;
        private final String folderName;
        @Nullable
        protected CompletableFuture<Void> previousWriteFuture;
        protected final DataFixTypes dataFixType;

        AbstractUpgrader(DataFixTypes p_321854_, String p_321675_, String p_326131_, Component p_362854_, Component p_361110_) {
            this.dataFixType = p_321854_;
            this.type = p_321675_;
            this.folderName = p_326131_;
            this.upgradingStatus = p_362854_;
            this.finishedStatus = p_361110_;
        }

        public void upgrade() {
            WorldUpgrader.this.totalFiles = 0;
            WorldUpgrader.this.totalChunks = 0;
            WorldUpgrader.this.converted = 0;
            WorldUpgrader.this.skipped = 0;
            List<DimensionToUpgrade<T>> $$0 = this.getDimensionsToUpgrade();
            if (WorldUpgrader.this.totalChunks == 0) {
                return;
            }
            float $$1 = WorldUpgrader.this.totalFiles;
            WorldUpgrader.this.status = this.upgradingStatus;
            while (WorldUpgrader.this.running) {
                boolean $$2 = false;
                float $$3 = 0.0f;
                for (DimensionToUpgrade<T> $$4 : $$0) {
                    ResourceKey<Level> $$5 = $$4.dimensionKey;
                    ListIterator<FileToUpgrade> $$6 = $$4.files;
                    AutoCloseable $$7 = (AutoCloseable)$$4.storage;
                    if ($$6.hasNext()) {
                        FileToUpgrade $$8 = $$6.next();
                        boolean $$9 = true;
                        for (ChunkPos $$10 : $$8.chunksToUpgrade) {
                            $$9 = $$9 && this.processOnePosition($$5, $$7, $$10);
                            $$2 = true;
                        }
                        if (WorldUpgrader.this.recreateRegionFiles) {
                            if ($$9) {
                                this.onFileFinished($$8.file);
                            } else {
                                LOGGER.error("Failed to convert region file {}", (Object)$$8.file.getPath());
                            }
                        }
                    }
                    float $$11 = (float)$$6.nextIndex() / $$1;
                    WorldUpgrader.this.progressMap.put($$5, $$11);
                    $$3 += $$11;
                }
                WorldUpgrader.this.progress = $$3;
                if ($$2) continue;
                break;
            }
            WorldUpgrader.this.status = this.finishedStatus;
            for (DimensionToUpgrade<T> $$12 : $$0) {
                try {
                    ((AutoCloseable)$$12.storage).close();
                }
                catch (Exception $$13) {
                    LOGGER.error("Error upgrading chunk", (Throwable)$$13);
                }
            }
        }

        private List<DimensionToUpgrade<T>> getDimensionsToUpgrade() {
            ArrayList $$0 = Lists.newArrayList();
            for (ResourceKey<Level> $$1 : WorldUpgrader.this.levels) {
                RegionStorageInfo $$2 = new RegionStorageInfo(WorldUpgrader.this.levelStorage.getLevelId(), $$1, this.type);
                Path $$3 = WorldUpgrader.this.levelStorage.getDimensionPath($$1).resolve(this.folderName);
                T $$4 = this.createStorage($$2, $$3);
                ListIterator<FileToUpgrade> $$5 = this.getFilesToProcess($$2, $$3);
                $$0.add(new DimensionToUpgrade<T>($$1, $$4, $$5));
            }
            return $$0;
        }

        protected abstract T createStorage(RegionStorageInfo var1, Path var2);

        private ListIterator<FileToUpgrade> getFilesToProcess(RegionStorageInfo p_325920_, Path p_326489_) {
            List<FileToUpgrade> $$2 = AbstractUpgrader.getAllChunkPositions(p_325920_, p_326489_);
            WorldUpgrader.this.totalFiles += $$2.size();
            WorldUpgrader.this.totalChunks += $$2.stream().mapToInt(p_321550_ -> p_321550_.chunksToUpgrade.size()).sum();
            return $$2.listIterator();
        }

        private static List<FileToUpgrade> getAllChunkPositions(RegionStorageInfo p_326177_, Path p_326228_) {
            File[] $$2 = p_326228_.toFile().listFiles((p_321626_, p_321493_) -> p_321493_.endsWith(".mca"));
            if ($$2 == null) {
                return List.of();
            }
            ArrayList $$3 = Lists.newArrayList();
            for (File $$4 : $$2) {
                Matcher $$5 = REGEX.matcher($$4.getName());
                if (!$$5.matches()) continue;
                int $$6 = Integer.parseInt($$5.group(1)) << 5;
                int $$7 = Integer.parseInt($$5.group(2)) << 5;
                ArrayList $$8 = Lists.newArrayList();
                try (RegionFile $$9 = new RegionFile(p_326177_, $$4.toPath(), p_326228_, true);){
                    for (int $$10 = 0; $$10 < 32; ++$$10) {
                        for (int $$11 = 0; $$11 < 32; ++$$11) {
                            ChunkPos $$12 = new ChunkPos($$10 + $$6, $$11 + $$7);
                            if (!$$9.doesChunkExist($$12)) continue;
                            $$8.add($$12);
                        }
                    }
                    if ($$8.isEmpty()) continue;
                    $$3.add(new FileToUpgrade($$9, $$8));
                }
                catch (Throwable $$13) {
                    LOGGER.error("Failed to read chunks from region file {}", (Object)$$4.toPath(), (Object)$$13);
                }
            }
            return $$3;
        }

        private boolean processOnePosition(ResourceKey<Level> p_321757_, T p_321658_, ChunkPos p_321833_) {
            boolean $$3 = false;
            try {
                $$3 = this.tryProcessOnePosition(p_321658_, p_321833_, p_321757_);
            }
            catch (CompletionException | ReportedException $$4) {
                Throwable $$5 = $$4.getCause();
                if ($$5 instanceof IOException) {
                    LOGGER.error("Error upgrading chunk {}", (Object)p_321833_, (Object)$$5);
                }
                throw $$4;
            }
            if ($$3) {
                ++WorldUpgrader.this.converted;
            } else {
                ++WorldUpgrader.this.skipped;
            }
            return $$3;
        }

        protected abstract boolean tryProcessOnePosition(T var1, ChunkPos var2, ResourceKey<Level> var3);

        private void onFileFinished(RegionFile p_321800_) {
            if (!WorldUpgrader.this.recreateRegionFiles) {
                return;
            }
            if (this.previousWriteFuture != null) {
                this.previousWriteFuture.join();
            }
            Path $$1 = p_321800_.getPath();
            Path $$2 = $$1.getParent();
            Path $$3 = WorldUpgrader.resolveRecreateDirectory($$2).resolve($$1.getFileName().toString());
            try {
                if ($$3.toFile().exists()) {
                    Files.delete($$1);
                    Files.move($$3, $$1, new CopyOption[0]);
                } else {
                    LOGGER.error("Failed to replace an old region file. New file {} does not exist.", (Object)$$3);
                }
            }
            catch (IOException $$4) {
                LOGGER.error("Failed to replace an old region file", (Throwable)$$4);
            }
        }
    }

    record FileToUpgrade(RegionFile file, List<ChunkPos> chunksToUpgrade) {
    }

    record DimensionToUpgrade<T>(ResourceKey<Level> dimensionKey, T storage, ListIterator<FileToUpgrade> files) {
    }
}

