/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr.parse;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordingFile;
import net.minecraft.util.profiling.jfr.parse.JfrStatsResult;
import net.minecraft.util.profiling.jfr.stats.ChunkGenStat;
import net.minecraft.util.profiling.jfr.stats.ChunkIdentification;
import net.minecraft.util.profiling.jfr.stats.CpuLoadStat;
import net.minecraft.util.profiling.jfr.stats.FileIOStat;
import net.minecraft.util.profiling.jfr.stats.GcHeapStat;
import net.minecraft.util.profiling.jfr.stats.IoSummary;
import net.minecraft.util.profiling.jfr.stats.PacketIdentification;
import net.minecraft.util.profiling.jfr.stats.StructureGenStat;
import net.minecraft.util.profiling.jfr.stats.ThreadAllocationStat;
import net.minecraft.util.profiling.jfr.stats.TickTimeStat;

public class JfrStatsParser {
    private Instant recordingStarted = Instant.EPOCH;
    private Instant recordingEnded = Instant.EPOCH;
    private final List<ChunkGenStat> chunkGenStats = Lists.newArrayList();
    private final List<StructureGenStat> structureGenStats = Lists.newArrayList();
    private final List<CpuLoadStat> cpuLoadStat = Lists.newArrayList();
    private final Map<PacketIdentification, MutableCountAndSize> receivedPackets = Maps.newHashMap();
    private final Map<PacketIdentification, MutableCountAndSize> sentPackets = Maps.newHashMap();
    private final Map<ChunkIdentification, MutableCountAndSize> readChunks = Maps.newHashMap();
    private final Map<ChunkIdentification, MutableCountAndSize> writtenChunks = Maps.newHashMap();
    private final List<FileIOStat> fileWrites = Lists.newArrayList();
    private final List<FileIOStat> fileReads = Lists.newArrayList();
    private int garbageCollections;
    private Duration gcTotalDuration = Duration.ZERO;
    private final List<GcHeapStat> gcHeapStats = Lists.newArrayList();
    private final List<ThreadAllocationStat> threadAllocationStats = Lists.newArrayList();
    private final List<TickTimeStat> tickTimes = Lists.newArrayList();
    @Nullable
    private Duration worldCreationDuration = null;

    private JfrStatsParser(Stream<RecordedEvent> p_185443_) {
        this.capture(p_185443_);
    }

    public static JfrStatsResult parse(Path p_185448_) {
        JfrStatsResult jfrStatsResult;
        final RecordingFile $$1 = new RecordingFile(p_185448_);
        try {
            Iterator<RecordedEvent> $$2 = new Iterator<RecordedEvent>(){

                @Override
                public boolean hasNext() {
                    return $$1.hasMoreEvents();
                }

                @Override
                public RecordedEvent next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    try {
                        return $$1.readEvent();
                    }
                    catch (IOException $$0) {
                        throw new UncheckedIOException($$0);
                    }
                }

                @Override
                public /* synthetic */ Object next() {
                    return this.next();
                }
            };
            Stream<RecordedEvent> $$3 = StreamSupport.stream(Spliterators.spliteratorUnknownSize($$2, 1297), false);
            jfrStatsResult = new JfrStatsParser($$3).results();
        }
        catch (Throwable throwable) {
            try {
                try {
                    $$1.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException $$4) {
                throw new UncheckedIOException($$4);
            }
        }
        $$1.close();
        return jfrStatsResult;
    }

    private JfrStatsResult results() {
        Duration $$0 = Duration.between(this.recordingStarted, this.recordingEnded);
        return new JfrStatsResult(this.recordingStarted, this.recordingEnded, $$0, this.worldCreationDuration, this.tickTimes, this.cpuLoadStat, GcHeapStat.summary($$0, this.gcHeapStats, this.gcTotalDuration, this.garbageCollections), ThreadAllocationStat.summary(this.threadAllocationStats), JfrStatsParser.collectIoStats($$0, this.receivedPackets), JfrStatsParser.collectIoStats($$0, this.sentPackets), JfrStatsParser.collectIoStats($$0, this.writtenChunks), JfrStatsParser.collectIoStats($$0, this.readChunks), FileIOStat.summary($$0, this.fileWrites), FileIOStat.summary($$0, this.fileReads), this.chunkGenStats, this.structureGenStats);
    }

    private void capture(Stream<RecordedEvent> p_185455_) {
        p_185455_.forEach(p_382690_ -> {
            if (p_382690_.getEndTime().isAfter(this.recordingEnded) || this.recordingEnded.equals(Instant.EPOCH)) {
                this.recordingEnded = p_382690_.getEndTime();
            }
            if (p_382690_.getStartTime().isBefore(this.recordingStarted) || this.recordingStarted.equals(Instant.EPOCH)) {
                this.recordingStarted = p_382690_.getStartTime();
            }
            switch (p_382690_.getEventType().getName()) {
                case "minecraft.ChunkGeneration": {
                    this.chunkGenStats.add(ChunkGenStat.from(p_382690_));
                    break;
                }
                case "minecraft.StructureGeneration": {
                    this.structureGenStats.add(StructureGenStat.from(p_382690_));
                    break;
                }
                case "minecraft.LoadWorld": {
                    this.worldCreationDuration = p_382690_.getDuration();
                    break;
                }
                case "minecraft.ServerTickTime": {
                    this.tickTimes.add(TickTimeStat.from(p_382690_));
                    break;
                }
                case "minecraft.PacketReceived": {
                    this.incrementPacket((RecordedEvent)p_382690_, p_382690_.getInt("bytes"), this.receivedPackets);
                    break;
                }
                case "minecraft.PacketSent": {
                    this.incrementPacket((RecordedEvent)p_382690_, p_382690_.getInt("bytes"), this.sentPackets);
                    break;
                }
                case "minecraft.ChunkRegionRead": {
                    this.incrementChunk((RecordedEvent)p_382690_, p_382690_.getInt("bytes"), this.readChunks);
                    break;
                }
                case "minecraft.ChunkRegionWrite": {
                    this.incrementChunk((RecordedEvent)p_382690_, p_382690_.getInt("bytes"), this.writtenChunks);
                    break;
                }
                case "jdk.ThreadAllocationStatistics": {
                    this.threadAllocationStats.add(ThreadAllocationStat.from(p_382690_));
                    break;
                }
                case "jdk.GCHeapSummary": {
                    this.gcHeapStats.add(GcHeapStat.from(p_382690_));
                    break;
                }
                case "jdk.CPULoad": {
                    this.cpuLoadStat.add(CpuLoadStat.from(p_382690_));
                    break;
                }
                case "jdk.FileWrite": {
                    this.appendFileIO((RecordedEvent)p_382690_, this.fileWrites, "bytesWritten");
                    break;
                }
                case "jdk.FileRead": {
                    this.appendFileIO((RecordedEvent)p_382690_, this.fileReads, "bytesRead");
                    break;
                }
                case "jdk.GarbageCollection": {
                    ++this.garbageCollections;
                    this.gcTotalDuration = this.gcTotalDuration.plus(p_382690_.getDuration());
                    break;
                }
            }
        });
    }

    private void incrementPacket(RecordedEvent p_185459_, int p_185460_, Map<PacketIdentification, MutableCountAndSize> p_185461_) {
        p_185461_.computeIfAbsent(PacketIdentification.from(p_185459_), p_325660_ -> new MutableCountAndSize()).increment(p_185460_);
    }

    private void incrementChunk(RecordedEvent p_326116_, int p_326437_, Map<ChunkIdentification, MutableCountAndSize> p_326416_) {
        p_326416_.computeIfAbsent(ChunkIdentification.from(p_326116_), p_326333_ -> new MutableCountAndSize()).increment(p_326437_);
    }

    private void appendFileIO(RecordedEvent p_185463_, List<FileIOStat> p_185464_, String p_185465_) {
        p_185464_.add(new FileIOStat(p_185463_.getDuration(), p_185463_.getString("path"), p_185463_.getLong(p_185465_)));
    }

    private static <T> IoSummary<T> collectIoStats(Duration p_325942_, Map<T, MutableCountAndSize> p_325951_) {
        List $$2 = p_325951_.entrySet().stream().map(p_325661_ -> Pair.of(p_325661_.getKey(), (Object)((MutableCountAndSize)p_325661_.getValue()).toCountAndSize())).toList();
        return new IoSummary(p_325942_, $$2);
    }

    public static final class MutableCountAndSize {
        private long count;
        private long totalSize;

        public void increment(int p_185477_) {
            this.totalSize += (long)p_185477_;
            ++this.count;
        }

        public IoSummary.CountAndSize toCountAndSize() {
            return new IoSummary.CountAndSize(this.count, this.totalSize);
        }
    }
}

