/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.Control;
import net.minecraft.util.parsing.packrat.NamedRule;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Scope;

public interface Term<S> {
    public boolean parse(ParseState<S> var1, Scope var2, Control var3);

    public static <S, T> Term<S> marker(Atom<T> p_335833_, T p_335787_) {
        return new Marker(p_335833_, p_335787_);
    }

    @SafeVarargs
    public static <S> Term<S> sequence(Term<S> ... p_336132_) {
        return new Sequence<S>(p_336132_);
    }

    @SafeVarargs
    public static <S> Term<S> alternative(Term<S> ... p_335455_) {
        return new Alternative<S>(p_335455_);
    }

    public static <S> Term<S> optional(Term<S> p_335471_) {
        return new Maybe<S>(p_335471_);
    }

    public static <S, T> Term<S> repeated(NamedRule<S, T> p_410325_, Atom<List<T>> p_410349_) {
        return Term.repeated(p_410325_, p_410349_, 0);
    }

    public static <S, T> Term<S> repeated(NamedRule<S, T> p_410540_, Atom<List<T>> p_409771_, int p_410812_) {
        return new Repeated<S, T>(p_410540_, p_409771_, p_410812_);
    }

    public static <S, T> Term<S> repeatedWithTrailingSeparator(NamedRule<S, T> p_410572_, Atom<List<T>> p_410697_, Term<S> p_410133_) {
        return Term.repeatedWithTrailingSeparator(p_410572_, p_410697_, p_410133_, 0);
    }

    public static <S, T> Term<S> repeatedWithTrailingSeparator(NamedRule<S, T> p_410722_, Atom<List<T>> p_410003_, Term<S> p_410085_, int p_409982_) {
        return new RepeatedWithSeparator<S, T>(p_410722_, p_410003_, p_410085_, p_409982_, true);
    }

    public static <S, T> Term<S> repeatedWithoutTrailingSeparator(NamedRule<S, T> p_409741_, Atom<List<T>> p_410786_, Term<S> p_410595_) {
        return Term.repeatedWithoutTrailingSeparator(p_409741_, p_410786_, p_410595_, 0);
    }

    public static <S, T> Term<S> repeatedWithoutTrailingSeparator(NamedRule<S, T> p_410243_, Atom<List<T>> p_410799_, Term<S> p_409788_, int p_410232_) {
        return new RepeatedWithSeparator<S, T>(p_410243_, p_410799_, p_409788_, p_410232_, false);
    }

    public static <S> Term<S> positiveLookahead(Term<S> p_410502_) {
        return new LookAhead<S>(p_410502_, true);
    }

    public static <S> Term<S> negativeLookahead(Term<S> p_410778_) {
        return new LookAhead<S>(p_410778_, false);
    }

    public static <S> Term<S> cut() {
        return new Term<S>(){

            @Override
            public boolean parse(ParseState<S> p_335490_, Scope p_335377_, Control p_336074_) {
                p_336074_.cut();
                return true;
            }

            public String toString() {
                return "\u2191";
            }
        };
    }

    public static <S> Term<S> empty() {
        return new Term<S>(){

            @Override
            public boolean parse(ParseState<S> p_335978_, Scope p_335744_, Control p_335881_) {
                return true;
            }

            public String toString() {
                return "\u03b5";
            }
        };
    }

    public static <S> Term<S> fail(final Object p_409759_) {
        return new Term<S>(){

            @Override
            public boolean parse(ParseState<S> p_410580_, Scope p_410090_, Control p_409973_) {
                p_410580_.errorCollector().store(p_410580_.mark(), p_409759_);
                return false;
            }

            public String toString() {
                return "fail";
            }
        };
    }

    public record Marker<S, T>(Atom<T> name, T value) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> p_335600_, Scope p_335485_, Control p_335375_) {
            p_335485_.put(this.name, this.value);
            return true;
        }
    }

    public record Sequence<S>(Term<S>[] elements) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> p_336111_, Scope p_335911_, Control p_336188_) {
            int $$3 = p_336111_.mark();
            for (Term<S> $$4 : this.elements) {
                if ($$4.parse(p_336111_, p_335911_, p_336188_)) continue;
                p_336111_.restore($$3);
                return false;
            }
            return true;
        }
    }

    public record Alternative<S>(Term<S>[] elements) implements Term<S>
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean parse(ParseState<S> p_336147_, Scope p_335902_, Control p_335396_) {
            Control $$3 = p_336147_.acquireControl();
            try {
                int $$4 = p_336147_.mark();
                p_335902_.splitFrame();
                for (Term<S> $$5 : this.elements) {
                    if ($$5.parse(p_336147_, p_335902_, $$3)) {
                        p_335902_.mergeFrame();
                        boolean bl = true;
                        return bl;
                    }
                    p_335902_.clearFrameValues();
                    p_336147_.restore($$4);
                    if ($$3.hasCut()) break;
                }
                p_335902_.popFrame();
                boolean bl = false;
                return bl;
            }
            finally {
                p_336147_.releaseControl();
            }
        }
    }

    public record Maybe<S>(Term<S> term) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> p_335415_, Scope p_335550_, Control p_336000_) {
            int $$3 = p_335415_.mark();
            if (!this.term.parse(p_335415_, p_335550_, p_336000_)) {
                p_335415_.restore($$3);
            }
            return true;
        }
    }

    public record Repeated<S, T>(NamedRule<S, T> element, Atom<List<T>> listName, int minRepetitions) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> p_410665_, Scope p_410752_, Control p_410872_) {
            int $$5;
            int $$3 = p_410665_.mark();
            ArrayList<T> $$4 = new ArrayList<T>(this.minRepetitions);
            while (true) {
                $$5 = p_410665_.mark();
                T $$6 = p_410665_.parse(this.element);
                if ($$6 == null) break;
                $$4.add($$6);
            }
            p_410665_.restore($$5);
            if ($$4.size() < this.minRepetitions) {
                p_410665_.restore($$3);
                return false;
            }
            p_410752_.put(this.listName, $$4);
            return true;
        }
    }

    public record RepeatedWithSeparator<S, T>(NamedRule<S, T> element, Atom<List<T>> listName, Term<S> separator, int minRepetitions, boolean allowTrailingSeparator) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> p_410533_, Scope p_410855_, Control p_410756_) {
            int $$3 = p_410533_.mark();
            ArrayList<T> $$4 = new ArrayList<T>(this.minRepetitions);
            boolean $$5 = true;
            while (true) {
                int $$6 = p_410533_.mark();
                if (!$$5 && !this.separator.parse(p_410533_, p_410855_, p_410756_)) {
                    p_410533_.restore($$6);
                    break;
                }
                int $$7 = p_410533_.mark();
                T $$8 = p_410533_.parse(this.element);
                if ($$8 == null) {
                    if ($$5) {
                        p_410533_.restore($$7);
                        break;
                    }
                    if (this.allowTrailingSeparator) {
                        p_410533_.restore($$7);
                        break;
                    }
                    p_410533_.restore($$3);
                    return false;
                }
                $$4.add($$8);
                $$5 = false;
            }
            if ($$4.size() < this.minRepetitions) {
                p_410533_.restore($$3);
                return false;
            }
            p_410855_.put(this.listName, $$4);
            return true;
        }
    }

    public record LookAhead<S>(Term<S> term, boolean positive) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> p_409679_, Scope p_410389_, Control p_410731_) {
            int $$3 = p_409679_.mark();
            boolean $$4 = this.term.parse(p_409679_.silent(), p_410389_, p_410731_);
            p_409679_.restore($$3);
            return this.positive == $$4;
        }
    }
}

