/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.util.parsing.packrat.ErrorEntry;
import net.minecraft.util.parsing.packrat.SuggestionSupplier;

public interface ErrorCollector<S> {
    public void store(int var1, SuggestionSupplier<S> var2, Object var3);

    default public void store(int p_335680_, Object p_335827_) {
        this.store(p_335680_, SuggestionSupplier.empty(), p_335827_);
    }

    public void finish(int var1);

    public static class LongestOnly<S>
    implements ErrorCollector<S> {
        private MutableErrorEntry<S>[] entries = new MutableErrorEntry[16];
        private int nextErrorEntry;
        private int lastCursor = -1;

        private void discardErrorsFromShorterParse(int p_335634_) {
            if (p_335634_ > this.lastCursor) {
                this.lastCursor = p_335634_;
                this.nextErrorEntry = 0;
            }
        }

        @Override
        public void finish(int p_335534_) {
            this.discardErrorsFromShorterParse(p_335534_);
        }

        @Override
        public void store(int p_335763_, SuggestionSupplier<S> p_336144_, Object p_335736_) {
            this.discardErrorsFromShorterParse(p_335763_);
            if (p_335763_ == this.lastCursor) {
                this.addErrorEntry(p_336144_, p_335736_);
            }
        }

        private void addErrorEntry(SuggestionSupplier<S> p_409930_, Object p_409668_) {
            int $$5;
            MutableErrorEntry<S> $$6;
            int $$2 = this.entries.length;
            if (this.nextErrorEntry >= $$2) {
                int $$3 = Util.growByHalf($$2, this.nextErrorEntry + 1);
                MutableErrorEntry[] $$4 = new MutableErrorEntry[$$3];
                System.arraycopy(this.entries, 0, $$4, 0, $$2);
                this.entries = $$4;
            }
            if (($$6 = this.entries[$$5 = this.nextErrorEntry++]) == null) {
                this.entries[$$5] = $$6 = new MutableErrorEntry();
            }
            $$6.suggestions = p_409930_;
            $$6.reason = p_409668_;
        }

        public List<ErrorEntry<S>> entries() {
            int $$0 = this.nextErrorEntry;
            if ($$0 == 0) {
                return List.of();
            }
            ArrayList<ErrorEntry<S>> $$1 = new ArrayList<ErrorEntry<S>>($$0);
            for (int $$2 = 0; $$2 < $$0; ++$$2) {
                MutableErrorEntry<S> $$3 = this.entries[$$2];
                $$1.add(new ErrorEntry(this.lastCursor, $$3.suggestions, $$3.reason));
            }
            return $$1;
        }

        public int cursor() {
            return this.lastCursor;
        }

        static class MutableErrorEntry<S> {
            SuggestionSupplier<S> suggestions = SuggestionSupplier.empty();
            Object reason = "empty";

            MutableErrorEntry() {
            }
        }
    }

    public static class Nop<S>
    implements ErrorCollector<S> {
        @Override
        public void store(int p_409770_, SuggestionSupplier<S> p_409587_, Object p_410314_) {
        }

        @Override
        public void finish(int p_409839_) {
        }
    }
}

